/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.items;

import com.wenxin2.marioverse.items.LinkerItem;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;

public class WrenchItem
extends LinkerItem {
    private final Tier tier;

    public WrenchItem(Item.Properties properties, Tier tier) {
        super(properties.component(DataComponents.TOOL, (Object)WrenchItem.createToolProperties()), tier);
        this.tier = tier;
    }

    public WrenchItem(Item.Properties properties, Tier tier, Tool toolComponentData) {
        super(properties.component(DataComponents.TOOL, (Object)toolComponentData), tier);
        this.tier = tier;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltip) {
        MutableComponent warpableText = Component.translatable((String)(this.getDescriptionId() + ".tooltip.shift_right_click.binds"));
        if (Screen.hasShiftDown()) {
            list.add((Component)Component.literal((String)""));
            list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.right_click")));
            list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.right_click.gui")));
            list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.shift_right_click")));
            warpableText = warpableText.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.shift_right_click.pipe")));
            if (!((Boolean)ConfigRegistry.DISABLE_WARP_DOORS.get()).booleanValue()) {
                warpableText = warpableText.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.shift_right_click.door")));
            }
            if (!((Boolean)ConfigRegistry.DISABLE_WARP_TRAPDOORS.get()).booleanValue()) {
                warpableText = warpableText.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.shift_right_click.trapdoor")));
            }
            if (!((Boolean)ConfigRegistry.DISABLE_WARP_PAINTINGS.get()).booleanValue()) {
                warpableText = warpableText.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.shift_right_click.painting")));
            }
            list.add((Component)warpableText);
        } else {
            list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip")));
        }
        super.appendHoverText(stack, tooltipContext, list, tooltip);
    }

    public int getEnchantmentValue() {
        return this.tier.getEnchantmentValue();
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairStack) {
        return repairStack.is(Tags.Items.INGOTS_IRON) || super.isValidRepairItem(stack, repairStack);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity livingEntity, LivingEntity hurtEntity) {
        stack.hurtAndBreak(2, hurtEntity, LivingEntity.getSlotForHand((InteractionHand)livingEntity.getUsedItemHand()));
        return true;
    }

    public boolean canAttackBlock(BlockState state, Level world, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(Tool.Rule.overrideSpeed(TagRegistry.WRENCH_EFFICIENT, (float)1.5f)), 1.0f, 2);
    }

    public static ItemAttributeModifiers createAttributes(Tier tier, int attackDamage, float attackSpeed) {
        return WrenchItem.createAttributes(tier, (float)attackDamage, attackSpeed);
    }

    public static ItemAttributeModifiers createAttributes(Tier tier, float attackDamage, float attackSpeed) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)(attackDamage + tier.getAttackDamageBonus()), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }
}

