/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.mixin;

import com.wenxin2.marioverse.blocks.entities.WarpDoorBlockEntity;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DoorBlock.class}, priority=100)
public class DoorBlockMixin
implements EntityBlock {
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return null;
    }

    @Inject(method={"setPlacedBy"}, at={@At(value="TAIL")})
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack, CallbackInfo ci) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        BlockEntity blockEntityAbove = world.getBlockEntity(pos.above());
        BlockEntity blockEntityBelow = world.getBlockEntity(pos.below());
        UUID uuid = UUID.randomUUID();
        if (blockEntity instanceof WarpDoorBlockEntity) {
            WarpDoorBlockEntity doorBE = (WarpDoorBlockEntity)blockEntity;
            CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
            if (data != null && data.copyTag().hasUUID("UUID")) {
                doorBE.setUUID(data.copyTag().getUUID("UUID"));
                doorBE.setChanged();
                if (blockEntityAbove instanceof WarpDoorBlockEntity) {
                    WarpDoorBlockEntity doorBEAbove = (WarpDoorBlockEntity)blockEntityAbove;
                    doorBEAbove.setUUID(data.copyTag().getUUID("UUID"));
                    doorBEAbove.setChanged();
                } else if (blockEntityBelow instanceof WarpDoorBlockEntity) {
                    WarpDoorBlockEntity doorBEBelow = (WarpDoorBlockEntity)blockEntityBelow;
                    doorBEBelow.setUUID(data.copyTag().getUUID("UUID"));
                    doorBEBelow.setChanged();
                }
            } else {
                doorBE.setUUID(uuid);
                doorBE.setChanged();
                if (blockEntityAbove instanceof WarpDoorBlockEntity) {
                    WarpDoorBlockEntity doorBEAbove = (WarpDoorBlockEntity)blockEntityAbove;
                    doorBEAbove.setUUID(uuid);
                    doorBEAbove.setChanged();
                } else if (blockEntityBelow instanceof WarpDoorBlockEntity) {
                    WarpDoorBlockEntity doorBEBelow = (WarpDoorBlockEntity)blockEntityBelow;
                    doorBEBelow.setUUID(uuid);
                    doorBEBelow.setChanged();
                }
            }
            doorBE.onLoad();
        }
    }
}

