/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks;

import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.VoxelShapeUtils;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BridgeStairBlock
extends StairBlock
implements SimpleWaterloggedBlock {
    public Block logBlock;
    protected static final VoxelShape TOP_AABB = Shapes.or((VoxelShape)Block.box((double)1.0, (double)13.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0), Block.box((double)12.0, (double)0.0, (double)0.0, (double)15.0, (double)3.0, (double)16.0)}).optimize();
    protected static final VoxelShape BOTTOM_AABB = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)0.0, (double)4.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0), Block.box((double)12.0, (double)13.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0)}).optimize();
    protected static final VoxelShape TOP_INNER_AABB = Shapes.or((VoxelShape)Block.box((double)1.0, (double)13.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)16.0), Block.box((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)16.0), Block.box((double)0.0, (double)13.0, (double)12.0, (double)1.0, (double)16.0, (double)15.0), Block.box((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0), Block.box((double)0.0, (double)0.0, (double)1.0, (double)12.0, (double)3.0, (double)4.0)}).optimize();
    protected static final VoxelShape BOTTOM_INNER_AABB = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)0.0, (double)4.0, (double)3.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)10.0), Block.box((double)12.0, (double)13.0, (double)0.0, (double)15.0, (double)16.0, (double)15.0), Block.box((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)3.0, (double)4.0), Block.box((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0), Block.box((double)0.0, (double)13.0, (double)12.0, (double)12.0, (double)16.0, (double)15.0)}).optimize();
    protected static final VoxelShape TOP_OUTER_AABB = Shapes.or((VoxelShape)Block.box((double)1.0, (double)13.0, (double)0.0, (double)4.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)10.0), Block.box((double)12.0, (double)0.0, (double)0.0, (double)15.0, (double)3.0, (double)4.0), Block.box((double)4.0, (double)13.0, (double)12.0, (double)16.0, (double)16.0, (double)15.0), Block.box((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0), Block.box((double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)3.0, (double)4.0)}).optimize();
    protected static final VoxelShape BOTTOM_OUTER_AABB = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)16.0), Block.box((double)12.0, (double)13.0, (double)12.0, (double)15.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)0.0, (double)1.0, (double)16.0, (double)3.0, (double)4.0), Block.box((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0), Block.box((double)15.0, (double)13.0, (double)12.0, (double)16.0, (double)16.0, (double)15.0)}).optimize();
    private static final EnumMap<Direction, EnumMap<Half, EnumMap<StairsShape, VoxelShape>>> SHAPES = new EnumMap(Direction.class);

    public BridgeStairBlock(BlockState state, BlockBehaviour.Properties properties) {
        super(state, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)HALF, (Comparable)Half.BOTTOM)).setValue((Property)SHAPE, (Comparable)StairsShape.STRAIGHT)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.logBlock = state.getBlock();
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext ctx) {
        return SHAPES.get(state.getValue((Property)FACING)).get(state.getValue((Property)HALF)).get(state.getValue((Property)SHAPE));
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        EntityCollisionContext context;
        Entity entity;
        VoxelShape shape = this.getShape(state, blockGetter, pos, collisionContext);
        if (collisionContext instanceof EntityCollisionContext && (entity = (context = (EntityCollisionContext)collisionContext).getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            double stepHeight = livingEntity.getAttributeValue(Attributes.STEP_HEIGHT);
            double feetY = livingEntity.getBoundingBox().minY;
            for (AABB box : shape.toAabbs()) {
                double boxTopWorld = (double)pos.getY() + box.maxY;
                double boxHeight = box.maxY - box.minY;
                if (!(boxHeight <= stepHeight + 0.001) || !(feetY + stepHeight >= boxTopWorld - 0.001)) continue;
                return shape;
            }
        }
        return Shapes.empty();
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
        if (itemAbility.equals(ItemAbilities.AXE_STRIP)) {
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
            String path = id.getPath();
            String logName = BuiltInRegistries.BLOCK.getKey((Object)this.logBlock).getPath();
            if (!path.contains("stripped_") && (path.contains("bamboo_bridge_stairs") || path.contains("log_bridge_stairs") || path.contains("stem_bridge_stairs"))) {
                String removeBlockName = logName.replace("_block", "");
                String strippedPath = path.replace(removeBlockName, "stripped_" + removeBlockName);
                ResourceLocation strippedId = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)strippedPath);
                Block strippedBlock = (Block)BuiltInRegistries.BLOCK.get(strippedId);
                if (strippedBlock != Blocks.AIR && strippedId.getPath().contains("stripped_")) {
                    return (BlockState)((BlockState)((BlockState)((BlockState)strippedBlock.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)HALF, (Comparable)((Half)state.getValue((Property)HALF)))).setValue((Property)SHAPE, (Comparable)((StairsShape)state.getValue((Property)SHAPE)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
                }
            }
        }
        return super.getToolModifiedState(state, context, itemAbility, simulate);
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return state.is(TagRegistry.FLAMMABLE_WOODEN_BRIDGE_BLOCKS);
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }

    static {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            EnumMap halfMap = new EnumMap(Half.class);
            for (Half half : Half.values()) {
                EnumMap<StairsShape, VoxelShape> shapeMap = new EnumMap<StairsShape, VoxelShape>(StairsShape.class);
                for (StairsShape stairsShape : StairsShape.values()) {
                    int rotSteps;
                    VoxelShape base = switch (stairsShape) {
                        default -> throw new MatchException(null, null);
                        case StairsShape.STRAIGHT -> {
                            if (half == Half.TOP) {
                                yield TOP_AABB;
                            }
                            yield BOTTOM_AABB;
                        }
                        case StairsShape.INNER_LEFT, StairsShape.INNER_RIGHT -> {
                            if (half == Half.TOP) {
                                yield TOP_INNER_AABB;
                            }
                            yield BOTTOM_INNER_AABB;
                        }
                        case StairsShape.OUTER_LEFT, StairsShape.OUTER_RIGHT -> half == Half.TOP ? TOP_OUTER_AABB : BOTTOM_OUTER_AABB;
                    };
                    switch (dir) {
                        case EAST: {
                            int n = 0;
                            break;
                        }
                        case SOUTH: {
                            int n = 1;
                            break;
                        }
                        case WEST: {
                            int n = 2;
                            break;
                        }
                        default: {
                            int n = rotSteps = 3;
                        }
                    }
                    if (stairsShape == StairsShape.INNER_RIGHT || stairsShape == StairsShape.OUTER_RIGHT) {
                        rotSteps = (rotSteps + 4) % 4;
                    } else if (stairsShape == StairsShape.INNER_LEFT || stairsShape == StairsShape.OUTER_LEFT) {
                        rotSteps = (rotSteps + 3) % 4;
                    }
                    if (half == Half.TOP && stairsShape != StairsShape.STRAIGHT) {
                        rotSteps = (rotSteps + 1) % 4;
                    }
                    int rotation = rotSteps * 90;
                    shapeMap.put(stairsShape, VoxelShapeUtils.rotateShapeAxis(base, Direction.Axis.Y, rotation));
                }
                halfMap.put(half, shapeMap);
            }
            SHAPES.put(dir, halfMap);
        }
    }
}

