/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wenxin2.marioverse.blocks.CoinBlock;
import com.wenxin2.marioverse.blocks.StarCoinBlock;
import com.wenxin2.marioverse.blocks.entities.CheckpointFlagBlockEntity;
import com.wenxin2.marioverse.blocks.states.TripleBlockStates;
import com.wenxin2.marioverse.entities.PiranhaPlantEntity;
import com.wenxin2.marioverse.entities.power_ups.FireFlowerEntity;
import com.wenxin2.marioverse.entities.power_ups.IceFlowerEntity;
import com.wenxin2.marioverse.entities.power_ups.MushroomEntity;
import com.wenxin2.marioverse.entities.power_ups.OneUpMushroomEntity;
import com.wenxin2.marioverse.entities.power_ups.SuperStarEntity;
import com.wenxin2.marioverse.integration.CompatRegistry;
import com.wenxin2.marioverse.items.BasePowerUpItem;
import com.wenxin2.marioverse.items.PiranhaPlantPodItem;
import com.wenxin2.marioverse.network.client_bound.data.AmericaNamePayload;
import com.wenxin2.marioverse.network.client_bound.data.WonderNamePayload;
import com.wenxin2.marioverse.registries.BlockRegistry;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.GameEventRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.sounds.MarioverseSoundTypes;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownExperienceBottle;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ArmorStandItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.EndCrystalItem;
import net.minecraft.world.item.ExperienceBottleItem;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.WindChargeItem;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.SeededContainerLoot;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckpointFlagBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<CheckpointFlagBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DyeColor.CODEC.optionalFieldOf("color").forGetter(flagBlock -> Optional.ofNullable(flagBlock.color)), (App)CheckpointFlagBlock.propertiesCodec()).apply((Applicative)instance, (dyeColor, properties) -> new CheckpointFlagBlock(dyeColor.orElse(null), (BlockBehaviour.Properties)properties)));
    public static final EnumProperty<TripleBlockStates> PART = EnumProperty.create((String)"part", TripleBlockStates.class);
    public static final BooleanProperty CLAIMED = BooleanProperty.create((String)"claimed");
    public static final IntegerProperty ROTATION = BlockStateProperties.ROTATION_16;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final Component UNKNOWN_CONTENTS = Component.translatable((String)"container.marioverse.checkpoint_flag.unknownContents");
    public static final ResourceLocation CONTENTS = ResourceLocation.withDefaultNamespace((String)"contents");
    public static final int MAX = RotationSegment.getMaxSegmentIndex();
    private static final int ROTATIONS = MAX + 1;
    @Nullable
    private final DyeColor color;
    protected static final VoxelShape CHECKPOINT_FLAG_TOP = Shapes.or((VoxelShape)Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)4.0, (double)9.0), (VoxelShape)Block.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0)).optimize();
    protected static final VoxelShape CHECKPOINT_FLAG_MIDDLE = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0).optimize();
    protected static final VoxelShape CHECKPOINT_FLAG_BOTTOM = Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), (VoxelShape)Block.box((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0)).optimize();

    public CheckpointFlagBlock(@Nullable DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CLAIMED, (Comparable)Boolean.FALSE)).setValue(PART, (Comparable)((Object)TripleBlockStates.BOTTOM))).setValue((Property)ROTATION, (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.color = color;
    }

    @NotNull
    public MapCodec<CheckpointFlagBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{CLAIMED, PART, ROTATION, WATERLOGGED});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        if (state.getValue(PART) == TripleBlockStates.TOP) {
            return CHECKPOINT_FLAG_TOP;
        }
        if (state.getValue(PART) == TripleBlockStates.MIDDLE) {
            return CHECKPOINT_FLAG_MIDDLE;
        }
        return CHECKPOINT_FLAG_BOTTOM;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CheckpointFlagBlockEntity(pos, state);
    }

    @NotNull
    public ItemStack getCloneItemStack(LevelReader worldReader, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = worldReader.getBlockEntity(pos);
        if (blockEntity instanceof CheckpointFlagBlockEntity) {
            CheckpointFlagBlockEntity flagBE = (CheckpointFlagBlockEntity)blockEntity;
            ItemStack stack = new ItemStack((ItemLike)this.asItem());
            DataComponentMap.Builder builder = DataComponentMap.builder();
            flagBE.collectImplicitComponents(builder);
            DataComponentMap components = builder.build();
            stack.applyComponents(components);
            return stack;
        }
        return super.getCloneItemStack(worldReader, pos, state);
    }

    public boolean canSurvive(BlockState state, @NotNull LevelReader worldReader, BlockPos pos) {
        Level world;
        return worldReader instanceof Level && this.canPlaceBlock(world = (Level)worldReader, pos) && this.canPlaceBlock(world, pos.above()) && this.canPlaceBlock(world, pos.above(2));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        FluidState fluidState = world.getFluidState(pos);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.is(FluidTags.WATER) && fluidState.getAmount() == 8))).setValue((Property)ROTATION, (Comparable)Integer.valueOf(RotationSegment.convertToSegment((float)context.getRotation())));
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor worldAccessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldAccessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldAccessor));
        }
        return super.updateShape(state, direction, neighborState, worldAccessor, pos, neighborPos);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(world, pos, state, entity, stack);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (entity != null && this.canPlaceBlock(world, pos) && this.canPlaceBlock(world, pos.above()) && this.canPlaceBlock(world, pos.above(2))) {
            world.setBlock(pos.above(), (BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)TripleBlockStates.MIDDLE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos.above()).getType() == Fluids.WATER)), 3);
            world.setBlock(pos.above(2), (BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)TripleBlockStates.TOP))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos.above(2)).getType() == Fluids.WATER)), 3);
        }
        if (blockEntity instanceof CheckpointFlagBlockEntity) {
            CheckpointFlagBlockEntity flagBE = (CheckpointFlagBlockEntity)blockEntity;
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                ItemContainerContents containerContents;
                CheckpointFlagBlockEntity topFlagBE;
                CheckpointFlagBlockEntity middleFlagBE;
                SeededContainerLoot lootTableReference;
                CheckpointFlagBlockEntity topFlagBE2;
                BlockEntity topBlockEntity;
                CheckpointFlagBlockEntity middleFlagBE2;
                BlockEntity middleBlockEntity;
                flagBE.setCustomName(stack.getHoverName());
                flagBE.markUpdated();
                if (flagBE.isWonderFlag()) {
                    flagBE.setWonderFlag(Boolean.TRUE);
                    if (!world.isClientSide()) {
                        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new WonderNamePayload(pos, flagBE.hasWonderFlag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                } else if (flagBE.isAmericanFlag()) {
                    flagBE.setAmericanFlag(Boolean.TRUE);
                    if (!world.isClientSide()) {
                        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new AmericaNamePayload(pos, flagBE.hasAmericanFlag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
                if ((middleBlockEntity = world.getBlockEntity(pos.above())) instanceof CheckpointFlagBlockEntity && (middleFlagBE2 = (CheckpointFlagBlockEntity)middleBlockEntity).getCustomName() == null) {
                    middleFlagBE2.setCustomName(stack.getHoverName());
                    middleFlagBE2.markUpdated();
                    if (middleFlagBE2.isWonderFlag()) {
                        middleFlagBE2.setWonderFlag(Boolean.TRUE);
                        if (!world.isClientSide()) {
                            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new WonderNamePayload(pos.above(), middleFlagBE2.hasWonderFlag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        }
                    } else if (middleFlagBE2.isAmericanFlag()) {
                        middleFlagBE2.setAmericanFlag(Boolean.TRUE);
                        if (!world.isClientSide()) {
                            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new AmericaNamePayload(pos.above(), middleFlagBE2.hasAmericanFlag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        }
                    }
                }
                if ((topBlockEntity = world.getBlockEntity(pos.above(2))) instanceof CheckpointFlagBlockEntity && (topFlagBE2 = (CheckpointFlagBlockEntity)topBlockEntity).getCustomName() == null) {
                    topFlagBE2.setCustomName(stack.getHoverName());
                    topFlagBE2.markUpdated();
                    if (topFlagBE2.isWonderFlag()) {
                        topFlagBE2.setWonderFlag(Boolean.TRUE);
                        if (!world.isClientSide()) {
                            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new WonderNamePayload(pos.above(2), topFlagBE2.hasWonderFlag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        }
                    } else if (topFlagBE2.isAmericanFlag()) {
                        topFlagBE2.setAmericanFlag(Boolean.TRUE);
                        if (!world.isClientSide()) {
                            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new AmericaNamePayload(pos.above(2), topFlagBE2.hasAmericanFlag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        }
                    }
                }
                if (stack.has(DataComponents.CONTAINER_LOOT) && (lootTableReference = (SeededContainerLoot)stack.get(DataComponents.CONTAINER_LOOT)) != null) {
                    flagBE.setLootTable(lootTableReference.lootTable(), lootTableReference.seed());
                    flagBE.markUpdated();
                    if (middleBlockEntity instanceof CheckpointFlagBlockEntity) {
                        middleFlagBE = (CheckpointFlagBlockEntity)middleBlockEntity;
                        middleFlagBE.setLootTable(lootTableReference.lootTable(), lootTableReference.seed());
                        middleFlagBE.markUpdated();
                    }
                    if (topBlockEntity instanceof CheckpointFlagBlockEntity) {
                        topFlagBE = (CheckpointFlagBlockEntity)topBlockEntity;
                        topFlagBE.setLootTable(lootTableReference.lootTable(), lootTableReference.seed());
                        topFlagBE.markUpdated();
                    }
                }
                if (stack.has(DataComponents.CONTAINER) && (containerContents = (ItemContainerContents)stack.get(DataComponents.CONTAINER)) != null) {
                    flagBE.setTheItem(containerContents.copyOne());
                    flagBE.markUpdated();
                    if (middleBlockEntity instanceof CheckpointFlagBlockEntity) {
                        middleFlagBE = (CheckpointFlagBlockEntity)middleBlockEntity;
                        middleFlagBE.setTheItem(containerContents.copyOne());
                        middleFlagBE.markUpdated();
                    }
                    if (topBlockEntity instanceof CheckpointFlagBlockEntity) {
                        topFlagBE = (CheckpointFlagBlockEntity)topBlockEntity;
                        topFlagBE.setTheItem(containerContents.copyOne());
                        topFlagBE.markUpdated();
                    }
                }
            }
        }
    }

    public void destroy(LevelAccessor worldAccessor, BlockPos pos, BlockState state) {
        if (!worldAccessor.isClientSide()) {
            if (state.getValue(PART) == TripleBlockStates.BOTTOM) {
                worldAccessor.destroyBlock(pos.above(), true);
                worldAccessor.destroyBlock(pos.above(2), true);
                worldAccessor.levelEvent(2001, pos.above(), Block.getId((BlockState)worldAccessor.getBlockState(pos.above())));
                worldAccessor.levelEvent(2001, pos.above(2), Block.getId((BlockState)worldAccessor.getBlockState(pos.above(2))));
            } else if (state.getValue(PART) == TripleBlockStates.MIDDLE) {
                worldAccessor.destroyBlock(pos.below(), true);
                worldAccessor.destroyBlock(pos.above(), true);
                worldAccessor.levelEvent(2001, pos.below(), Block.getId((BlockState)worldAccessor.getBlockState(pos.below())));
                worldAccessor.levelEvent(2001, pos.above(), Block.getId((BlockState)worldAccessor.getBlockState(pos.above())));
            } else if (state.getValue(PART) == TripleBlockStates.TOP) {
                worldAccessor.destroyBlock(pos.below(), true);
                worldAccessor.destroyBlock(pos.below(2), true);
                worldAccessor.levelEvent(2001, pos.below(), Block.getId((BlockState)worldAccessor.getBlockState(pos.below())));
                worldAccessor.levelEvent(2001, pos.below(2), Block.getId((BlockState)worldAccessor.getBlockState(pos.below(2))));
            }
        }
        super.destroy(worldAccessor, pos, state);
    }

    @NotNull
    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!(world.isClientSide || !player.isCreative() && player.hasCorrectToolForDrops(state, world, pos))) {
            if (state.getValue(PART) == TripleBlockStates.BOTTOM) {
                world.destroyBlock(pos.above(), false);
                world.destroyBlock(pos.above(2), false);
                this.spawnDestroyParticles(world, player, pos.above(), world.getBlockState(pos.above()));
                this.spawnDestroyParticles(world, player, pos.above(2), world.getBlockState(pos.above(2)));
            } else if (state.getValue(PART) == TripleBlockStates.MIDDLE) {
                world.destroyBlock(pos.below(), false);
                world.destroyBlock(pos.above(), false);
                this.spawnDestroyParticles(world, player, pos.below(), world.getBlockState(pos.below()));
                this.spawnDestroyParticles(world, player, pos.above(), world.getBlockState(pos.above()));
            } else if (state.getValue(PART) == TripleBlockStates.TOP) {
                world.destroyBlock(pos.below(), false);
                world.destroyBlock(pos.below(2), false);
                this.spawnDestroyParticles(world, player, pos.below(), world.getBlockState(pos.below()));
                this.spawnDestroyParticles(world, player, pos.below(2), world.getBlockState(pos.below(2)));
            }
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BlockEntity blockentity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockentity instanceof CheckpointFlagBlockEntity) {
            CheckpointFlagBlockEntity flagBE = (CheckpointFlagBlockEntity)blockentity;
            builder = builder.withDynamicDrop(CONTENTS, stack -> {
                for (int i = 0; i < flagBE.getContainerSize(); ++i) {
                    stack.accept(flagBE.getItem(i));
                }
            });
        }
        return super.getDrops(state, builder);
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(rotation.rotate(((Integer)state.getValue((Property)ROTATION)).intValue(), ROTATIONS)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(mirror.mirror(((Integer)state.getValue((Property)ROTATION)).intValue(), ROTATIONS)));
    }

    protected void tick(BlockState state, ServerLevel serverWorld, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = serverWorld.getBlockEntity(pos);
        if (blockEntity instanceof CheckpointFlagBlockEntity) {
            CheckpointFlagBlockEntity checkpointFlagBE = (CheckpointFlagBlockEntity)blockEntity;
            checkpointFlagBE.stopTriggeredAnim("claim_controller", "claim");
        }
        super.tick(state, serverWorld, pos, random);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack heldItem = player.getItemInHand(hand);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CheckpointFlagBlockEntity) {
            CheckpointFlagBlockEntity flagBE = (CheckpointFlagBlockEntity)blockEntity;
            if (!heldItem.is(TagRegistry.CANNOT_PLACE_IN_CHECKPOINT_FLAGS)) {
                ItemStack blockStack = flagBE.getTheItem();
                if (world.isClientSide) {
                    return ItemInteractionResult.CONSUME;
                }
                if (!heldItem.isEmpty() && (((Boolean)ConfigRegistry.CHECKPOINT_FLAG_ADD_ITEMS.get()).booleanValue() || player.isCreative()) && (blockStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)heldItem, (ItemStack)blockStack) && blockStack.getCount() < blockStack.getMaxStackSize())) {
                    float soundPitch;
                    player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                    ItemStack stackConsumed = stack.consumeAndReturn(1, (LivingEntity)player);
                    if (flagBE.isEmpty()) {
                        soundPitch = (float)stackConsumed.getCount() / (float)stackConsumed.getMaxStackSize();
                        flagBE.setTheItem(stackConsumed);
                        if (state.getValue(PART) == TripleBlockStates.TOP) {
                            CheckpointFlagBlockEntity topFlagBE;
                            BlockEntity blockEntity2 = world.getBlockEntity(pos.below());
                            if (blockEntity2 instanceof CheckpointFlagBlockEntity) {
                                topFlagBE = (CheckpointFlagBlockEntity)blockEntity2;
                                topFlagBE.setTheItem(stackConsumed);
                            }
                            if ((blockEntity2 = world.getBlockEntity(pos.below(2))) instanceof CheckpointFlagBlockEntity) {
                                topFlagBE = (CheckpointFlagBlockEntity)blockEntity2;
                                topFlagBE.setTheItem(stackConsumed);
                            }
                        } else if (state.getValue(PART) == TripleBlockStates.MIDDLE) {
                            CheckpointFlagBlockEntity middleFlagBE;
                            BlockEntity blockEntity3 = world.getBlockEntity(pos.above());
                            if (blockEntity3 instanceof CheckpointFlagBlockEntity) {
                                middleFlagBE = (CheckpointFlagBlockEntity)blockEntity3;
                                middleFlagBE.setTheItem(stackConsumed);
                            }
                            if ((blockEntity3 = world.getBlockEntity(pos.below())) instanceof CheckpointFlagBlockEntity) {
                                middleFlagBE = (CheckpointFlagBlockEntity)blockEntity3;
                                middleFlagBE.setTheItem(stackConsumed);
                            }
                        } else {
                            CheckpointFlagBlockEntity bottomFlagBE;
                            BlockEntity blockEntity4 = world.getBlockEntity(pos.above());
                            if (blockEntity4 instanceof CheckpointFlagBlockEntity) {
                                bottomFlagBE = (CheckpointFlagBlockEntity)blockEntity4;
                                bottomFlagBE.setTheItem(stackConsumed);
                            }
                            if ((blockEntity4 = world.getBlockEntity(pos.above(2))) instanceof CheckpointFlagBlockEntity) {
                                bottomFlagBE = (CheckpointFlagBlockEntity)blockEntity4;
                                bottomFlagBE.setTheItem(stackConsumed);
                            }
                        }
                    } else {
                        soundPitch = (float)blockStack.getCount() / (float)blockStack.getMaxStackSize();
                        blockStack.grow(1);
                    }
                    world.playSound(null, pos, SoundEvents.DECORATED_POT_INSERT, SoundSource.BLOCKS, 1.0f, 0.7f + 0.5f * soundPitch);
                    flagBE.setChanged();
                    world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                    return ItemInteractionResult.SUCCESS;
                }
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hitResult) {
        ItemStack heldItem = player.getItemInHand(player.getUsedItemHand());
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CheckpointFlagBlockEntity) {
            CheckpointFlagBlockEntity flagBE = (CheckpointFlagBlockEntity)blockEntity;
            ItemStack blockStack = flagBE.getTheItem();
            if ((heldItem.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)heldItem, (ItemStack)blockStack)) && (((Boolean)ConfigRegistry.CHECKPOINT_FLAG_REMOVE_ITEMS.get()).booleanValue() || player.isCreative())) {
                world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                ItemStack storedItem = flagBE.getTheItem();
                if (!storedItem.isEmpty()) {
                    boolean itemAdded;
                    if (state.is(BlockTags.GUARDED_BY_PIGLINS)) {
                        PiglinAi.angerNearbyPiglins((Player)player, (boolean)false);
                    }
                    if (!(itemAdded = player.addItem(storedItem.copyWithCount(1)))) {
                        player.drop(storedItem.copyWithCount(1), false);
                    }
                    world.playSound(null, pos, (SoundEvent)SoundRegistry.ITEM_SPAWNS.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    flagBE.splitTheItem(1);
                    flagBE.setChanged();
                    if (state.getValue(PART) == TripleBlockStates.TOP) {
                        CheckpointFlagBlockEntity topFlagBE;
                        BlockEntity blockEntity2 = world.getBlockEntity(pos.below());
                        if (blockEntity2 instanceof CheckpointFlagBlockEntity) {
                            topFlagBE = (CheckpointFlagBlockEntity)blockEntity2;
                            topFlagBE.splitTheItem(1);
                        }
                        if ((blockEntity2 = world.getBlockEntity(pos.below(2))) instanceof CheckpointFlagBlockEntity) {
                            topFlagBE = (CheckpointFlagBlockEntity)blockEntity2;
                            topFlagBE.splitTheItem(1);
                        }
                    } else if (state.getValue(PART) == TripleBlockStates.MIDDLE) {
                        CheckpointFlagBlockEntity middleFlagBE;
                        BlockEntity blockEntity3 = world.getBlockEntity(pos.above());
                        if (blockEntity3 instanceof CheckpointFlagBlockEntity) {
                            middleFlagBE = (CheckpointFlagBlockEntity)blockEntity3;
                            middleFlagBE.splitTheItem(1);
                        }
                        if ((blockEntity3 = world.getBlockEntity(pos.below())) instanceof CheckpointFlagBlockEntity) {
                            middleFlagBE = (CheckpointFlagBlockEntity)blockEntity3;
                            middleFlagBE.splitTheItem(1);
                        }
                    } else {
                        CheckpointFlagBlockEntity bottomFlagBE;
                        BlockEntity blockEntity4 = world.getBlockEntity(pos.above());
                        if (blockEntity4 instanceof CheckpointFlagBlockEntity) {
                            bottomFlagBE = (CheckpointFlagBlockEntity)blockEntity4;
                            bottomFlagBE.splitTheItem(1);
                        }
                        if ((blockEntity4 = world.getBlockEntity(pos.above(2))) instanceof CheckpointFlagBlockEntity) {
                            bottomFlagBE = (CheckpointFlagBlockEntity)blockEntity4;
                            bottomFlagBE.splitTheItem(1);
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        AbilitiesHandler handler;
        BlockPos respawnPos = new BlockPos(pos.getX(), pos.getY(), pos.getZ());
        BlockPos statePos = switch ((TripleBlockStates)((Object)state.getValue(PART))) {
            case TripleBlockStates.TOP -> pos.below(2);
            case TripleBlockStates.MIDDLE -> pos.below();
            default -> pos;
        };
        BlockState statePart = world.getBlockState(statePos);
        if (entity.getType().is(TagRegistry.CAN_CLAIM_CHECKPOINT_FLAGS) && entity instanceof AbilitiesHandler && (handler = (AbilitiesHandler)entity).mv$getCheckpointFlagCooldown() <= 0) {
            ServerPlayer player;
            if (statePart.hasProperty((Property)CLAIMED) && !((Boolean)statePart.getValue((Property)CLAIMED)).booleanValue()) {
                BlockEntity blockEntity = world.getBlockEntity(statePos);
                if (blockEntity instanceof CheckpointFlagBlockEntity) {
                    CheckpointFlagBlockEntity checkpointFlagBE = (CheckpointFlagBlockEntity)blockEntity;
                    checkpointFlagBE.markUpdated();
                    if (!(entity instanceof Player)) {
                        entity.level().broadcastEntityEvent(entity, (byte)112);
                    } else {
                        ParticleUtils.spawnParticlesOnBlockFaces((Level)world, (BlockPos)statePos, (ParticleOptions)((ParticleOptions)ParticleRegistry.GLOWING_STAR.get()), (IntProvider)UniformInt.of((int)1, (int)1));
                    }
                    if (!checkpointFlagBE.isAmericanFlag() && statePart.getBlock() != BlockRegistry.CLASSIC_GOAL_POLE.get()) {
                        checkpointFlagBE.triggerAnim("switch_controller", "switch");
                    }
                    world.scheduleTick(statePos, (Block)this, 40);
                    world.gameEvent(entity, GameEventRegistry.CHECKPOINT_ACTIVATED, statePos);
                    checkpointFlagBE.triggerAnim("claim_controller", "claim");
                }
                world.scheduleTick(statePos, (Block)this, 3);
                world.setBlock(pos, (BlockState)state.setValue((Property)CLAIMED, (Comparable)Boolean.TRUE), 3);
                if (state.getValue(PART) == TripleBlockStates.BOTTOM) {
                    if (world.getBlockState(pos.above()).hasProperty((Property)CLAIMED) && world.getBlockState(pos.above(2)).hasProperty((Property)CLAIMED)) {
                        world.setBlock(pos.above(), (BlockState)world.getBlockState(pos.above()).setValue((Property)CLAIMED, (Comparable)Boolean.TRUE), 3);
                        world.setBlock(pos.above(2), (BlockState)world.getBlockState(pos.above(2)).setValue((Property)CLAIMED, (Comparable)Boolean.TRUE), 3);
                    }
                } else if (state.getValue(PART) == TripleBlockStates.MIDDLE) {
                    if (world.getBlockState(pos.above()).hasProperty((Property)CLAIMED) && world.getBlockState(pos.below()).hasProperty((Property)CLAIMED)) {
                        world.setBlock(pos.above(), (BlockState)world.getBlockState(pos.above()).setValue((Property)CLAIMED, (Comparable)Boolean.TRUE), 3);
                        world.setBlock(pos.below(), (BlockState)world.getBlockState(pos.below()).setValue((Property)CLAIMED, (Comparable)Boolean.TRUE), 3);
                    }
                } else if (world.getBlockState(pos.below()).hasProperty((Property)CLAIMED) && world.getBlockState(pos.below(2)).hasProperty((Property)CLAIMED)) {
                    world.setBlock(pos.below(), (BlockState)world.getBlockState(pos.below()).setValue((Property)CLAIMED, (Comparable)Boolean.TRUE), 3);
                    world.setBlock(pos.below(2), (BlockState)world.getBlockState(pos.below(2)).setValue((Property)CLAIMED, (Comparable)Boolean.TRUE), 3);
                }
                if ((blockEntity = world.getBlockEntity(respawnPos)) instanceof CheckpointFlagBlockEntity) {
                    ItemStack storedItem;
                    CheckpointFlagBlockEntity flagBE = (CheckpointFlagBlockEntity)blockEntity;
                    if (((Boolean)ConfigRegistry.CHECKPOINT_FLAG_CLAIM_USES_ITEMS.get()).booleanValue() && !(storedItem = flagBE.getTheItem()).isEmpty() && entity instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity;
                        CheckpointFlagBlock.spawnFromCheckpointFlag(world, respawnPos, storedItem, livingEntity, true);
                        MarioverseSoundTypes.playSounds(world, respawnPos, storedItem);
                        flagBE.splitTheItem(1);
                    }
                }
            }
            if (entity instanceof ServerPlayer && !pos.equals((Object)(player = (ServerPlayer)entity).getRespawnPosition())) {
                BlockPos playerRespawnPos = player.getRespawnPosition();
                BlockPos newRespawnPos = switch ((TripleBlockStates)((Object)state.getValue(PART))) {
                    case TripleBlockStates.TOP -> respawnPos.below(2);
                    case TripleBlockStates.MIDDLE -> respawnPos.below();
                    default -> respawnPos;
                };
                BlockEntity blockEntity = world.getBlockEntity(newRespawnPos);
                if (blockEntity instanceof CheckpointFlagBlockEntity) {
                    CheckpointFlagBlockEntity checkpointFlagBE = (CheckpointFlagBlockEntity)blockEntity;
                    if (!newRespawnPos.equals((Object)playerRespawnPos)) {
                        world.scheduleTick(newRespawnPos, (Block)this, 40);
                        world.gameEvent(entity, GameEventRegistry.CHECKPOINT_ACTIVATED, statePos);
                        checkpointFlagBE.triggerAnim("claim_controller", "claim");
                        world.playSound(null, newRespawnPos, (SoundEvent)SoundRegistry.CHECKPOINT_FLAG_CLAIMED.get(), SoundSource.BLOCKS);
                        ParticleUtils.spawnParticlesOnBlockFaces((Level)world, (BlockPos)newRespawnPos, (ParticleOptions)((ParticleOptions)ParticleRegistry.GLOWING_STAR.get()), (IntProvider)UniformInt.of((int)1, (int)1));
                        player.setRespawnPosition(world.dimension(), newRespawnPos, player.getYRot(), false, true);
                        handler.mv$setCheckpointFlagCooldown(40);
                        if (world instanceof ServerLevel) {
                            ServerLevel serverWorld = (ServerLevel)world;
                            serverWorld.sendParticles((ParticleOptions)((SimpleParticleType)ParticleRegistry.GLOWING_STAR.get()), (double)newRespawnPos.getX() + 0.5, (double)newRespawnPos.getY() + 0.5, (double)newRespawnPos.getZ() + 0.5, 10, 0.4, 0.5, 0.4, 0.6);
                        }
                    }
                }
            }
        }
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag options) {
        super.appendHoverText(stack, tooltipContext, list, options);
        list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip")));
        if (stack.has(DataComponents.CONTAINER_LOOT)) {
            list.add(UNKNOWN_CONTENTS);
        }
        int i = 0;
        int j = 0;
        for (ItemStack itemstack : ((ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).nonEmptyItems()) {
            ++j;
            if (i > 4) continue;
            ++i;
            list.add((Component)Component.translatable((String)"container.marioverse.checkpoint_flag.itemCount", (Object[])new Object[]{itemstack.getHoverName(), itemstack.getCount()}));
        }
        if (j - i > 0) {
            list.add((Component)Component.translatable((String)"container.marioverse.checkpoint_flag.more", (Object[])new Object[]{j - i}).withStyle(ChatFormatting.ITALIC));
        }
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public static ItemStack getColoredItemStack(@Nullable DyeColor color) {
        return new ItemStack((ItemLike)BlockRegistry.CHECKPOINT_FLAGS.get(color));
    }

    private boolean canPlaceBlock(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        return state.isAir() || state.canBeReplaced() || state.is((Block)this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void spawnFromCheckpointFlag(Level world, BlockPos pos, ItemStack stack, LivingEntity livingEntity, boolean dropItemsAtPos) {
        Item item;
        BlockItem blockItem;
        BlockItem blockItem2;
        Item item2;
        Item item3;
        if (!(world instanceof ServerLevel)) return;
        ServerLevel serverWorld = (ServerLevel)world;
        Item item4 = stack.getItem();
        if (item4 instanceof BasePowerUpItem) {
            BasePowerUpItem powerUpItem = (BasePowerUpItem)item4;
            if (((Boolean)ConfigRegistry.CHECKPOINT_FLAG_APPLIES_POWER_UPS.get()).booleanValue()) {
                CheckpointFlagBlock.spawnPowerUps(world, pos, stack, livingEntity, powerUpItem, dropItemsAtPos);
                return;
            }
        }
        if ((item3 = stack.getItem()) instanceof PiranhaPlantPodItem) {
            PiranhaPlantPodItem pod = (PiranhaPlantPodItem)item3;
            if (((Boolean)ConfigRegistry.CHECKPOINT_FLAG_SPAWNS_MOBS.get()).booleanValue()) {
                EntityType entityType = pod.getType(stack);
                if (entityType.is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                    CheckpointFlagBlock.spawnItem(world, pos, stack, dropItemsAtPos);
                    return;
                }
                Entity entity = entityType.spawn(serverWorld, stack, null, pos, MobSpawnType.SPAWN_EGG, true, false);
                if (entity instanceof PiranhaPlantEntity) {
                    PiranhaPlantEntity piranhaPlant = (PiranhaPlantEntity)entity;
                    piranhaPlant.setAge(-24000);
                    piranhaPlant.setOwner((Entity)livingEntity);
                }
                stack.copyWithCount(1);
                return;
            }
        }
        if ((item2 = stack.getItem()) instanceof SpawnEggItem) {
            SpawnEggItem spawnEgg = (SpawnEggItem)item2;
            if (((Boolean)ConfigRegistry.CHECKPOINT_FLAG_SPAWNS_MOBS.get()).booleanValue() && !(stack.getItem() instanceof BasePowerUpItem)) {
                EntityType entityType = spawnEgg.getType(stack);
                if (entityType.is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                    CheckpointFlagBlock.spawnItem(world, pos, stack, dropItemsAtPos);
                    return;
                }
                Entity entity = entityType.create((Level)serverWorld);
                if (entity != null) {
                    entityType.spawn(serverWorld, stack, null, BlockPos.containing((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), MobSpawnType.SPAWN_EGG, true, false);
                }
                stack.copyWithCount(1);
                return;
            }
        }
        if (stack.getItem() instanceof ArmorStandItem) {
            Consumer consumer = EntityType.createDefaultStackConfig((ServerLevel)serverWorld, (ItemStack)stack, null);
            ArmorStand armorStand = (ArmorStand)EntityType.ARMOR_STAND.create(serverWorld, consumer, pos, MobSpawnType.SPAWN_EGG, true, true);
            if (armorStand != null && !armorStand.getType().is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                armorStand.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                world.addFreshEntity((Entity)armorStand);
                stack.copyWithCount(1);
                return;
            }
            CheckpointFlagBlock.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        Item item5 = stack.getItem();
        if (item5 instanceof MinecartItem) {
            MinecartItem cart = (MinecartItem)item5;
            AbstractMinecart abstractMinecart = AbstractMinecart.createMinecart((ServerLevel)serverWorld, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 1.0), (double)((double)pos.getZ() + 0.5), (AbstractMinecart.Type)cart.type, (ItemStack)stack, null);
            if (!abstractMinecart.getType().is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                abstractMinecart.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                world.addFreshEntity((Entity)abstractMinecart);
                stack.copyWithCount(1);
                return;
            }
            CheckpointFlagBlock.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        Item item6 = stack.getItem();
        if (item6 instanceof BoatItem) {
            ChestBoat chestBoat;
            BoatItem boatItem = (BoatItem)item6;
            Object object = chestBoat = boatItem.hasChest ? new ChestBoat((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5) : new Boat((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
            if (!chestBoat.getType().is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                chestBoat.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                chestBoat.setVariant(boatItem.type);
                world.addFreshEntity((Entity)chestBoat);
                stack.copyWithCount(1);
                return;
            }
            CheckpointFlagBlock.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        Item item7 = stack.getItem();
        if (item7 instanceof BlockItem && (blockItem2 = (BlockItem)item7).getBlock() instanceof TntBlock) {
            PrimedTnt primedTnt = new PrimedTnt((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, null);
            if (!primedTnt.getType().is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                primedTnt.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                world.addFreshEntity((Entity)primedTnt);
                stack.copyWithCount(1);
                serverWorld.gameEvent(null, (Holder)GameEvent.PRIME_FUSE, pos);
                return;
            }
            CheckpointFlagBlock.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        Item item8 = stack.getItem();
        if (item8 instanceof BlockItem && (blockItem = (BlockItem)item8).getBlock() instanceof CoinBlock && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            boolean bl = player.addItem(stack.copyWithCount(1));
            if (blockItem.getBlock() instanceof StarCoinBlock) {
                ServerParticleUtils.spawnParticlesOnBlockFaces((ParticleOptions)ParticleRegistry.COIN_GLINT.get(), serverWorld, pos, (IntProvider)UniformInt.of((int)2, (int)3));
            } else {
                ServerParticleUtils.spawnParticlesOnBlockFaces((ParticleOptions)ParticleRegistry.COIN_GLINT.get(), serverWorld, pos, (IntProvider)UniformInt.of((int)1, (int)1));
            }
            if (bl) return;
            player.drop(stack.copyWithCount(1), false);
            return;
        }
        if (stack.getItem() instanceof WindChargeItem) {
            WindCharge windCharge = new WindCharge((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, new Vec3(0.0, -0.5, 0.0));
            if (!windCharge.getType().is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                windCharge.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                world.addFreshEntity((Entity)windCharge);
                stack.copyWithCount(1);
                return;
            }
            CheckpointFlagBlock.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        if (stack.getItem() instanceof FireChargeItem) {
            SmallFireball smallFireball = new SmallFireball((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, new Vec3(0.0, -0.5, 0.0));
            if (!smallFireball.getType().is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                smallFireball.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                world.addFreshEntity((Entity)smallFireball);
                stack.copyWithCount(1);
                return;
            }
            CheckpointFlagBlock.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        if (stack.getItem() instanceof ThrowablePotionItem) {
            ThrownPotion thrownPotion = new ThrownPotion((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            if (!thrownPotion.getType().is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                thrownPotion.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                thrownPotion.setItem(stack);
                world.addFreshEntity((Entity)thrownPotion);
                stack.copyWithCount(1);
                return;
            }
            CheckpointFlagBlock.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        if (stack.getItem() instanceof ExperienceBottleItem) {
            ThrownExperienceBottle thrownExperienceBottle = new ThrownExperienceBottle((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            if (!thrownExperienceBottle.getType().is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                thrownExperienceBottle.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                thrownExperienceBottle.setItem(stack);
                world.addFreshEntity((Entity)thrownExperienceBottle);
                stack.copyWithCount(1);
                return;
            }
            CheckpointFlagBlock.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        if (stack.getItem() instanceof EndCrystalItem) {
            EndCrystal endCrystal = new EndCrystal((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            if (!endCrystal.getType().is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                endCrystal.setPos((double)pos.getX() + 0.5, (double)((float)pos.getY() - endCrystal.getBbHeight()), (double)pos.getZ() + 0.5);
                endCrystal.setDeltaMovement(new Vec3(0.0, -0.5, 0.0));
                endCrystal.setShowBottom(false);
                world.addFreshEntity((Entity)endCrystal);
                world.gameEvent(null, (Holder)GameEvent.ENTITY_PLACE, pos);
                stack.copyWithCount(1);
                return;
            }
            CheckpointFlagBlock.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        if (stack.getItem() instanceof FireworkRocketItem) {
            FireworkRocketEntity fireworkRocketEntity = new FireworkRocketEntity((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, stack);
            if (!fireworkRocketEntity.getType().is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                fireworkRocketEntity.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                world.addFreshEntity((Entity)fireworkRocketEntity);
                stack.copyWithCount(1);
                return;
            }
            CheckpointFlagBlock.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        if (stack.getItem() instanceof EggItem) {
            ThrownEgg thrownEgg = new ThrownEgg((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            if (!thrownEgg.getType().is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                thrownEgg.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                thrownEgg.setItem(stack);
                world.addFreshEntity((Entity)thrownEgg);
                stack.copyWithCount(1);
                return;
            }
            CheckpointFlagBlock.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        Item item9 = stack.getItem();
        if (item9 instanceof BucketItem) {
            BucketItem bucket = (BucketItem)item9;
            if (bucket.content != Fluids.EMPTY && ((Boolean)ConfigRegistry.CHECKPOINT_FLAG_BUCKET_TWEAKS.get()).booleanValue()) {
                if (bucket.content.isSame((Fluid)Fluids.WATER)) {
                    if (bucket.emptyContents(null, world, pos, null, stack)) {
                        bucket.checkExtraContent(null, world, stack, pos);
                    }
                    CheckpointFlagBlock.spawnItem(world, pos, new ItemStack((ItemLike)Items.BUCKET), dropItemsAtPos);
                    return;
                }
                if (!world.getBlockState(pos.above(3)).canBeReplaced()) {
                    if (world.getBlockState(pos.above(3)).canBeReplaced()) return;
                    CheckpointFlagBlock.spawnItem(world, pos, stack, dropItemsAtPos);
                    return;
                }
                if (bucket.emptyContents(null, world, pos.above(3), null, stack)) {
                    bucket.checkExtraContent(null, world, stack, pos.above(3));
                }
                CheckpointFlagBlock.spawnItem(world, pos.above(3), new ItemStack((ItemLike)Items.BUCKET), dropItemsAtPos);
                return;
            }
        }
        if ((item = stack.getItem()) instanceof SolidBucketItem) {
            SolidBucketItem bucket = (SolidBucketItem)item;
            if (((Boolean)ConfigRegistry.CHECKPOINT_FLAG_BUCKET_TWEAKS.get()).booleanValue()) {
                if (!world.getBlockState(pos.above(3)).canBeReplaced()) {
                    CheckpointFlagBlock.spawnItem(world, pos, stack, dropItemsAtPos);
                    return;
                }
                if (bucket.emptyContents(null, world, pos.above(3), null, stack)) {
                    bucket.checkExtraContent(null, world, stack, pos.above(3));
                }
                CheckpointFlagBlock.spawnItem(world, pos.above(3), new ItemStack((ItemLike)Items.BUCKET), dropItemsAtPos);
                return;
            }
        }
        if (stack.getItem() == CompatRegistry.HAT_STAND_ITEM.get()) {
            Entity entity = CompatRegistry.HAT_STAND.get().create((Level)serverWorld);
            if (entity != null && !entity.getType().is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                entity.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                world.addFreshEntity(entity);
                stack.copyWithCount(1);
                return;
            }
            CheckpointFlagBlock.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        if (stack.getItem() == CompatRegistry.CANNONBALL_ITEM.get()) {
            Entity entity = CompatRegistry.CANNONBALL.get().create((Level)serverWorld);
            if (entity != null && !entity.getType().is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                entity.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                entity.setDeltaMovement(new Vec3(world.random.triangle(0.0, 0.3), world.random.triangle(0.5, 0.3), world.random.triangle(0.0, 0.3)));
                world.addFreshEntity(entity);
                stack.copyWithCount(1);
                return;
            }
            CheckpointFlagBlock.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        if (stack.getItem() == CompatRegistry.BOMB_ITEM.get()) {
            Entity entity = CompatRegistry.BOMB.get().create((Level)serverWorld);
            if (entity != null && !entity.getType().is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                entity.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                entity.setDeltaMovement(new Vec3(world.random.triangle(0.0, 0.2), world.random.triangle(0.5, 0.2), world.random.triangle(0.0, 0.2)));
                world.addFreshEntity(entity);
                stack.copyWithCount(1);
                return;
            }
            CheckpointFlagBlock.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        if (stack.getItem() == CompatRegistry.BOMB_BLUE_ITEM.get()) {
            Entity entity = CompatRegistry.BOMB.get().create((Level)serverWorld);
            if (entity != null && !entity.getType().is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                CompoundTag nbt = new CompoundTag();
                entity.save(nbt);
                nbt.putInt("Type", 1);
                entity.load(nbt);
                entity.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                entity.setDeltaMovement(new Vec3(0.0, -0.5, 0.0));
                world.addFreshEntity(entity);
                stack.copyWithCount(1);
                return;
            }
            CheckpointFlagBlock.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        if (stack.getItem() == CompatRegistry.BOMB_SPIKY_ITEM.get()) {
            Entity entity = CompatRegistry.BOMB.get().create((Level)serverWorld);
            if (entity != null && !entity.getType().is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                CompoundTag nbt = new CompoundTag();
                entity.save(nbt);
                nbt.putInt("Type", 2);
                entity.load(nbt);
                entity.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                entity.setDeltaMovement(new Vec3(0.0, -0.5, 0.0));
                world.addFreshEntity(entity);
                stack.copyWithCount(1);
                return;
            }
            CheckpointFlagBlock.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        if (stack.getItem() == CompatRegistry.CONFETTI_POPPER_ITEM.get()) {
            Creeper creeper = (Creeper)EntityType.CREEPER.create((Level)serverWorld);
            if (creeper != null) {
                CompoundTag nbt = new CompoundTag();
                creeper.save(nbt);
                nbt.putBoolean("Party", true);
                nbt.putInt("Fuse", 0);
                creeper.setNoAi(true);
                creeper.ignite();
                creeper.setInvisible(true);
                creeper.setSilent(true);
                creeper.load(nbt);
                creeper.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                world.addFreshEntity((Entity)creeper);
            }
            world.gameEvent(null, (Holder)GameEvent.EXPLODE, pos);
            return;
        }
        if (stack.getItem() != CompatRegistry.ICE_BOMB_ITEM.get()) {
            CheckpointFlagBlock.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        Entity entity = CompatRegistry.ICE_BOMB.get().create((Level)serverWorld);
        if (entity != null && !entity.getType().is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
            entity.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            world.addFreshEntity(entity);
            stack.copyWithCount(1);
            return;
        }
        CheckpointFlagBlock.spawnItem(world, pos, stack, dropItemsAtPos);
    }

    public static void spawnItem(Level world, BlockPos pos, ItemStack stack, boolean dropItemsAtPos) {
        if (dropItemsAtPos) {
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, stack.copyWithCount(1));
            world.addFreshEntity((Entity)itemEntity);
        } else if (world.getBlockState(pos.above()).canBeReplaced() || world.getFluidState(pos.above()).is(FluidTags.WATER) || !world.getBlockState(pos.below()).canBeReplaced() && !world.getFluidState(pos.below()).is(FluidTags.WATER)) {
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, stack.copyWithCount(1));
            world.addFreshEntity((Entity)itemEntity);
        } else {
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() - 0.5, (double)pos.getZ() + 0.5, stack.copyWithCount(1));
            world.addFreshEntity((Entity)itemEntity);
        }
    }

    public static void spawnPowerUps(Level world, BlockPos pos, ItemStack stack, LivingEntity entity, BasePowerUpItem powerUpItem, boolean dropItemsAtPos) {
        EntityType entityType = powerUpItem.getType(stack);
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (!entityType.is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                Entity spawnedEntity = entityType.create((Level)serverWorld);
                if (spawnedEntity != null && entity instanceof AbilitiesHandler) {
                    AbilitiesHandler handler = (AbilitiesHandler)entity;
                    if (stack.getItem() == ItemRegistry.SUPER_MUSHROOM.get() && spawnedEntity instanceof MushroomEntity) {
                        MushroomEntity powerUp = (MushroomEntity)spawnedEntity;
                        handler.applyMushroomPowerUp(world, entity, powerUp, ((Double)ConfigRegistry.SUPER_MUSHROOM_HEALTH_HEALED.get()).floatValue());
                    } else if (stack.getItem() == ItemRegistry.ONE_UP_MUSHROOM.get() && spawnedEntity instanceof OneUpMushroomEntity) {
                        OneUpMushroomEntity powerUp = (OneUpMushroomEntity)spawnedEntity;
                        handler.applyOneUpMushroomPowerUp(world, stack, entity, powerUp);
                    } else if (stack.getItem() == ItemRegistry.FIRE_FLOWER.get() && spawnedEntity instanceof FireFlowerEntity) {
                        FireFlowerEntity powerUp = (FireFlowerEntity)spawnedEntity;
                        handler.applyFireFlowerPowerUp(world, entity, powerUp);
                    } else if (stack.getItem() == ItemRegistry.ICE_FLOWER.get() && spawnedEntity instanceof IceFlowerEntity) {
                        IceFlowerEntity powerUp = (IceFlowerEntity)spawnedEntity;
                        handler.applyIceFlowerPowerUp(world, entity, powerUp);
                    } else if (stack.getItem() == ItemRegistry.SUPER_STAR.get() && spawnedEntity instanceof SuperStarEntity) {
                        SuperStarEntity powerUp = (SuperStarEntity)spawnedEntity;
                        handler.applySuperStarPowerUp(world, entity, powerUp);
                    } else {
                        entityType.spawn(serverWorld, stack, null, BlockPos.containing((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), MobSpawnType.SPAWN_EGG, true, false);
                    }
                }
                stack.copyWithCount(1);
            } else {
                CheckpointFlagBlock.spawnItem(world, pos, stack, dropItemsAtPos);
            }
        }
    }
}

