/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks;

import com.mojang.serialization.MapCodec;
import com.wenxin2.marioverse.blocks.PanelBlock;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DamageSourceRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.jetbrains.annotations.NotNull;

public class SpikePanelBlock
extends PanelBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<SpikePanelBlock> CODEC = SpikePanelBlock.simpleCodec(SpikePanelBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty SPIKES = BooleanProperty.create((String)"spikes");

    @Override
    @NotNull
    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public SpikePanelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACE, (Comparable)AttachFace.FLOOR)).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)SPIKES, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{FACE, FACING, POWERED, SPIKES, WATERLOGGED});
    }

    protected void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!world.isClientSide && ((Boolean)state.getValue((Property)SPIKES)).booleanValue() && !entity.getType().is(TagRegistry.SPIKE_PANEL_IMMUNE) && !(entity instanceof ItemEntity)) {
            entity.hurt(DamageSourceRegistry.spiked(entity), ((Double)ConfigRegistry.SPIKE_PANEL_DAMAGE.get()).floatValue());
        }
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos posNeighbor, boolean b) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            this.checkAndFlip(state, serverWorld, pos);
        }
        super.neighborChanged(state, world, pos, block, posNeighbor, b);
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader worldReader, BlockPos pos) {
        return true;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState neighborState, boolean b) {
        if (neighborState.getBlock() != state.getBlock() && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            this.checkAndFlip(state, serverWorld, pos);
        }
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return (Boolean)world.getBlockState(pos).getValue((Property)SPIKES) != false ? 15 : 0;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType computationType) {
        return false;
    }

    public boolean isPossibleToRespawnInThis(BlockState state) {
        return false;
    }

    public void checkAndFlip(BlockState state, ServerLevel serverWorld, BlockPos pos) {
        boolean hasNeighborSignal = serverWorld.hasNeighborSignal(pos);
        BlockState newState = state;
        if (hasNeighborSignal != (Boolean)state.getValue((Property)POWERED)) {
            if (!((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                newState = (BlockState)state.cycle((Property)SPIKES);
                serverWorld.playSound(null, pos, (Boolean)newState.getValue((Property)SPIKES) != false ? (SoundEvent)SoundRegistry.SPIKES_EXTEND.get() : (SoundEvent)SoundRegistry.SPIKES_RETRACT.get(), SoundSource.BLOCKS);
            }
            serverWorld.setBlock(pos, (BlockState)newState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(hasNeighborSignal)), 3);
        }
    }
}

