/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.client;

import com.wenxin2.marioverse.blocks.entities.WarpPipeBlockEntity;
import com.wenxin2.marioverse.client.TexturedSlider;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class WaterSpoutSlider
extends TexturedSlider {
    public WaterSpoutSlider(int x, int y, int width, int height, Component prefix, Component suffix, double minValue, double maxValue, double currentValue, double stepSize, int precision, boolean drawString) {
        super(x, y, width, height, prefix, suffix, minValue, maxValue, currentValue, stepSize, precision, drawString);
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        guiGraphics.blitWithBorder(SLIDER_LOCATION, this.getX(), this.getY(), 0, this.getTextureY(), this.width, this.height, 200, 24, 2, 3, 2, 2);
        if (player != null && this.requiresCreativeWaterSpout(player)) {
            guiGraphics.blitWithBorder(SLIDER_LOCATION, this.getX() + (int)(this.value * (double)(this.width - 12)), this.getY(), 0, 96, 12, this.height, 200, 24, 2, 3, 3, 3);
        } else if (player != null && this.waxDisablesWaterSpouts(minecraft)) {
            guiGraphics.blitWithBorder(SLIDER_LOCATION, this.getX() + (int)(this.value * (double)(this.width - 12)), this.getY(), 0, 96, 12, this.height, 200, 24, 2, 3, 3, 3);
        } else {
            guiGraphics.blitWithBorder(SLIDER_LOCATION, this.getX() + (int)(this.value * (double)(this.width - 12)), this.getY(), 0, this.getHandleTextureY(), 12, this.height, 200, 24, 2, 3, 3, 3);
        }
        this.renderScrollingString(guiGraphics, minecraft.font, 2, this.getFGColor() | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }

    public boolean requiresCreativeWaterSpout(LocalPlayer player) {
        return !player.isCreative() && (Boolean)ConfigRegistry.CREATIVE_WATER_SPOUT.get() != false;
    }

    public boolean waxDisablesWaterSpouts(Minecraft minecraft) {
        BlockPos pos;
        BlockEntity blockEntity;
        if (minecraft.player != null && minecraft.hitResult != null && minecraft.level != null && minecraft.hitResult.getType() == HitResult.Type.BLOCK && (blockEntity = minecraft.level.getBlockEntity(pos = ((BlockHitResult)minecraft.hitResult).getBlockPos())) instanceof WarpPipeBlockEntity) {
            WarpPipeBlockEntity pipeBlockEntity = (WarpPipeBlockEntity)blockEntity;
            return pipeBlockEntity.isWaxed() && (Boolean)ConfigRegistry.WAX_DISABLES_WATER_SPOUTS.get() != false;
        }
        return false;
    }
}

