/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.client.renderers.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.wenxin2.marioverse.client.models.entities.BooModel;
import com.wenxin2.marioverse.entities.BooEntity;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;
import software.bernie.geckolib.util.Color;

public class BooRenderer
extends GeoEntityRenderer<BooEntity> {
    private static final String HELMET = "armorBipedHead";
    private static final String LEFT_ARM = "bipedLeftArm";
    private static final String RIGHT_ARM = "bipedRightArm";
    protected ItemStack mainHandItem;
    protected ItemStack offhandItem;
    private float lastAlpha = 1.0f;

    public BooRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new BooModel());
        this.shadowRadius = 0.6f;
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)this));
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<BooEntity>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getArmorItemForBone(GeoBone bone, BooEntity animatable) {
                return switch (bone.getName()) {
                    case BooRenderer.HELMET -> animatable.getItemBySlot(EquipmentSlot.HEAD);
                    default -> null;
                };
            }

            @NotNull
            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, BooEntity animatable) {
                return switch (bone.getName()) {
                    case BooRenderer.HELMET -> EquipmentSlot.HEAD;
                    case BooRenderer.RIGHT_ARM -> {
                        if (!animatable.isLeftHanded()) {
                            yield EquipmentSlot.MAINHAND;
                        }
                        yield EquipmentSlot.OFFHAND;
                    }
                    case BooRenderer.LEFT_ARM -> {
                        if (animatable.isLeftHanded()) {
                            yield EquipmentSlot.OFFHAND;
                        }
                        yield EquipmentSlot.MAINHAND;
                    }
                    default -> super.getEquipmentSlotForBone(bone, stack, (LivingEntity)animatable);
                };
            }

            @NotNull
            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, BooEntity animatable, HumanoidModel<?> baseModel) {
                return switch (bone.getName()) {
                    case BooRenderer.HELMET -> baseModel.head;
                    case BooRenderer.LEFT_ARM -> baseModel.leftArm;
                    case BooRenderer.RIGHT_ARM -> baseModel.rightArm;
                    default -> super.getModelPartForBone(bone, slot, stack, (LivingEntity)animatable, baseModel);
                };
            }

            protected void renderSkullAsArmor(PoseStack poseStack, GeoBone bone, ItemStack stack, AbstractSkullBlock skullBlock, MultiBufferSource bufferSource, int packedLight) {
                poseStack.scale(1.2f, 1.2f, 1.2f);
                poseStack.translate(0.0f, -0.2f, 0.0f);
                super.renderSkullAsArmor(poseStack, bone, stack, skullBlock, bufferSource, packedLight);
            }
        });
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<BooEntity>((GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, BooEntity animatable) {
                return switch (bone.getName()) {
                    case BooRenderer.HELMET -> {
                        BlockItem blockItem;
                        Item var6_5;
                        if (!(animatable.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof ArmorItem || (var6_5 = animatable.getItemBySlot(EquipmentSlot.HEAD).getItem()) instanceof BlockItem && (blockItem = (BlockItem)var6_5).getBlock() instanceof SkullBlock)) {
                            yield animatable.getItemBySlot(EquipmentSlot.HEAD);
                        }
                        yield ItemStack.EMPTY;
                    }
                    case BooRenderer.LEFT_ARM -> {
                        if (animatable.isLeftHanded()) {
                            yield BooRenderer.this.mainHandItem;
                        }
                        yield BooRenderer.this.offhandItem;
                    }
                    case BooRenderer.RIGHT_ARM -> {
                        if (animatable.isLeftHanded()) {
                            yield BooRenderer.this.offhandItem;
                        }
                        yield BooRenderer.this.mainHandItem;
                    }
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, BooEntity animatable) {
                return switch (bone.getName()) {
                    case BooRenderer.HELMET -> ItemDisplayContext.HEAD;
                    case BooRenderer.LEFT_ARM, BooRenderer.RIGHT_ARM -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, BooEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                if (stack == BooRenderer.this.mainHandItem) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                    poseStack.translate(0.1, -0.05, -0.325);
                    if (stack.getItem() instanceof ShieldItem) {
                        poseStack.translate(0.02, 0.0, -0.125);
                    }
                } else if (stack == BooRenderer.this.offhandItem) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                    poseStack.translate(-0.1, -0.05, -0.325);
                    if (stack.getItem() instanceof ShieldItem) {
                        poseStack.translate(0.02, 0.0, 0.4);
                        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    }
                }
                if (stack.getItem() instanceof BlockItem) {
                    poseStack.scale(0.875f, 0.875f, 0.875f);
                    poseStack.translate(0.0f, 0.2f, 0.0f);
                } else {
                    poseStack.translate(0.0f, 0.2f, 0.0f);
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    public void preRender(PoseStack poseStack, BooEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        this.mainHandItem = animatable.getMainHandItem();
        this.offhandItem = animatable.getOffhandItem();
    }

    public Color getRenderColor(BooEntity animatable, float partialTick, int packedLight) {
        float blockLight = animatable.level().getBrightness(LightLayer.BLOCK, animatable.blockPosition());
        float sensitivity = ((Integer)ConfigRegistry.BOO_LIGHT_SENSITIVITY.get()).intValue();
        float targetAlpha = Mth.clamp((float)(blockLight / sensitivity), (float)0.8f, (float)1.0f);
        this.lastAlpha += (targetAlpha - this.lastAlpha) * 0.4f;
        return Color.ofRGBA((float)1.0f, (float)1.0f, (float)1.0f, (float)this.lastAlpha);
    }

    protected float getDeathMaxRotation(BooEntity animatable) {
        if (animatable.getLastDamageSource() != null && animatable.getLastDamageSource().is(DamageTypes.GENERIC)) {
            return 0.0f;
        }
        return super.getDeathMaxRotation((Entity)animatable);
    }
}

