/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.data;

import com.google.common.collect.ImmutableMap;
import com.wenxin2.marioverse.data.BlockFamilyExtended;
import com.wenxin2.marioverse.registries.BlockRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;

public class RecipeUtils
extends RecipeProvider {
    public static final Map<BlockFamilyExtended.Variant, BiFunction<ItemLike, ItemLike, RecipeBuilder>> SHAPE_BUILDERS = ImmutableMap.builder().put((Object)BlockFamilyExtended.Variant.BUTTON, (outputItem, inputItem) -> RecipeUtils.buttonBuilder((ItemLike)outputItem, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputItem}))).put((Object)BlockFamilyExtended.Variant.BRICKS, (outputItem, inputItem) -> RecipeUtils.twoByTwoBuilder(4, outputItem, RecipeCategory.BUILDING_BLOCKS, Ingredient.of((ItemLike[])new ItemLike[]{inputItem}))).put((Object)BlockFamilyExtended.Variant.BRIDGE, (outputItem, inputItem) -> RecipeUtils.bridgeBuilder(6, outputItem, Ingredient.of((ItemLike[])new ItemLike[]{inputItem}))).put((Object)BlockFamilyExtended.Variant.BRIDGE_STAIRS, (outputItem, inputItem) -> RecipeUtils.bridgeStairBuilder(6, outputItem, Ingredient.of((ItemLike[])new ItemLike[]{inputItem}))).put((Object)BlockFamilyExtended.Variant.CHISELED, (outputItem, inputItem) -> RecipeUtils.chiseledBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputItem}))).put((Object)BlockFamilyExtended.Variant.CUSTOM_FENCE, (outputItem, inputItem) -> RecipeUtils.fenceBuilder((ItemLike)outputItem, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputItem}))).put((Object)BlockFamilyExtended.Variant.CUSTOM_FENCE_GATE, (outputItem, inputItem) -> RecipeUtils.fenceGateBuilder((ItemLike)outputItem, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputItem}))).put((Object)BlockFamilyExtended.Variant.CUT, (outputItem, inputItem) -> RecipeUtils.cutBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputItem}))).put((Object)BlockFamilyExtended.Variant.DOOR, (outputItem, inputItem) -> RecipeUtils.doorBuilder((ItemLike)outputItem, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputItem}))).put((Object)BlockFamilyExtended.Variant.FENCE, (outputItem, inputItem) -> RecipeUtils.fenceBuilder((ItemLike)outputItem, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputItem}))).put((Object)BlockFamilyExtended.Variant.FENCE_GATE, (outputItem, inputItem) -> RecipeUtils.fenceGateBuilder((ItemLike)outputItem, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputItem}))).put((Object)BlockFamilyExtended.Variant.PEDESTAL, (outputItem, inputItem) -> RecipeUtils.pedestalBuilder(5, outputItem, Ingredient.of((ItemLike[])new ItemLike[]{inputItem}))).put((Object)BlockFamilyExtended.Variant.POLISHED, (outputItem, inputItem) -> RecipeUtils.polishedBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputItem}))).put((Object)BlockFamilyExtended.Variant.PRESSURE_PLATE, (outputItem, inputItem) -> RecipeUtils.pressurePlateBuilder((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)outputItem, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputItem}))).put((Object)BlockFamilyExtended.Variant.QUESTION_BLOCK, (outputItem, inputItem) -> RecipeUtils.questionBlockBuilder(1, outputItem, Ingredient.of((ItemLike[])new ItemLike[]{inputItem}))).put((Object)BlockFamilyExtended.Variant.QUESTION_PANEL, (outputItem, inputItem) -> RecipeUtils.questionPanelBuilder(4, outputItem, Ingredient.of((ItemLike[])new ItemLike[]{inputItem}))).put((Object)BlockFamilyExtended.Variant.SIGN, (outputItem, inputItem) -> RecipeUtils.signBuilder((ItemLike)outputItem, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputItem}))).put((Object)BlockFamilyExtended.Variant.SLAB, (outputItem, inputItem) -> RecipeUtils.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputItem}))).put((Object)BlockFamilyExtended.Variant.STAIRS, (outputItem, inputItem) -> RecipeUtils.stairBuilder((ItemLike)outputItem, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputItem}))).put((Object)BlockFamilyExtended.Variant.STORAGE_BRICKS, (outputItem, inputItem) -> RecipeUtils.storageBrickBuilder(4, outputItem, Ingredient.of((ItemLike[])new ItemLike[]{inputItem}))).put((Object)BlockFamilyExtended.Variant.TRAPDOOR, (outputItem, inputItem) -> RecipeUtils.trapdoorBuilder((ItemLike)outputItem, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputItem}))).put((Object)BlockFamilyExtended.Variant.WALL, (outputItem, inputItem) -> RecipeUtils.wallBuilder((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)outputItem, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputItem}))).build();
    public static final Map<BlockFamilyExtended.Variant, BiFunction<ItemLike, TagKey<Item>, RecipeBuilder>> SHAPE_TAG_BUILDERS = ImmutableMap.builder().put((Object)BlockFamilyExtended.Variant.QUESTION_BLOCK_TAG, (outputItem, inputItemTag) -> RecipeUtils.questionBlockTagBuilder(1, outputItem, (TagKey<Item>)inputItemTag)).build();
    public static final Map<BlockFamilyExtended.Variant, Integer> STONECUTTING_OUTPUTS = Map.of(BlockFamilyExtended.Variant.BRICKS, 1, BlockFamilyExtended.Variant.CHISELED, 1, BlockFamilyExtended.Variant.CUT, 1, BlockFamilyExtended.Variant.PEDESTAL, 1, BlockFamilyExtended.Variant.POLISHED, 1, BlockFamilyExtended.Variant.SLAB, 2, BlockFamilyExtended.Variant.SMASHABLE_BLOCKS, 1, BlockFamilyExtended.Variant.STAIRS, 1, BlockFamilyExtended.Variant.WALL, 1);

    public RecipeUtils(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, provider);
    }

    public static RecipeBuilder twoByTwoBuilder(int outputAmt, ItemLike outputItem, RecipeCategory category, Ingredient inputItem) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('#'), inputItem).pattern("##").pattern("##");
    }

    public static RecipeBuilder bridgeBuilder(int outputAmt, ItemLike outputItem, Ingredient inputItem) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('#'), inputItem).define(Character.valueOf('S'), Tags.Items.STRINGS).pattern("#S#").unlockedBy("has_string", RecipeUtils.has((TagKey)Tags.Items.STRINGS)).group("marioverse:bridges");
    }

    public static RecipeBuilder bridgeStairBuilder(int outputAmt, ItemLike outputItem, Ingredient inputItem) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('#'), inputItem).define(Character.valueOf('S'), Tags.Items.STRINGS).pattern("  #").pattern(" S ").pattern("#  ").unlockedBy("has_string", RecipeUtils.has((TagKey)Tags.Items.STRINGS)).group("marioverse:bridge_stairs");
    }

    public static RecipeBuilder pedestalBuilder(int outputAmt, ItemLike outputItem, Ingredient inputItem) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('#'), inputItem).pattern("# #").pattern("###").group("marioverse:brick_pedestals");
    }

    public static RecipeBuilder questionBlockBuilder(int outputAmt, ItemLike outputItem, Ingredient inputItem) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)outputAmt).requires(inputItem).requires(Tags.Items.CHESTS_WOODEN).unlockedBy("has_chest", RecipeUtils.has((TagKey)Tags.Items.CHESTS_WOODEN)).group("marioverse:question_blocks");
    }

    public static RecipeBuilder questionBlockTagBuilder(int outputAmt, ItemLike outputItem, TagKey<Item> inputItemTag) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)outputAmt).requires(inputItemTag).requires(Tags.Items.CHESTS_WOODEN).unlockedBy("has_chest", RecipeUtils.has((TagKey)Tags.Items.CHESTS_WOODEN)).group("marioverse:question_blocks");
    }

    public static RecipeBuilder questionPanelBuilder(int outputAmt, ItemLike outputItem, Ingredient inputItem) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)outputAmt).requires(inputItem).requires(Tags.Items.DUSTS_REDSTONE).unlockedBy("has_redstone_dust", RecipeUtils.has((TagKey)Tags.Items.DUSTS_REDSTONE)).group("marioverse:question_panels");
    }

    public static RecipeBuilder storageBrickBuilder(int outputAmt, ItemLike outputItem, Ingredient inputItem) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('B'), inputItem).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).pattern(" B ").pattern("BCB").pattern(" B ").unlockedBy("has_chest", RecipeUtils.has((TagKey)Tags.Items.CHESTS_WOODEN)).group("marioverse:storage_bricks");
    }

    public void oneByTwoRecipe(int outputAmt, ItemLike outputItem, RecipeCategory category, ItemLike inputItem, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('#'), inputItem).pattern("##").unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).group("marioverse:" + RecipeUtils.getSimpleRecipeName((ItemLike)outputItem)).save(output);
    }

    public void oneByThreeRecipe(int outputAmt, ItemLike outputItem, RecipeCategory category, ItemLike inputItem, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('#'), inputItem).pattern("###").unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).group("marioverse:" + RecipeUtils.getSimpleRecipeName((ItemLike)outputItem)).save(output);
    }

    public void twoByOneRecipe(int outputAmt, String groupName, ItemLike outputItem, RecipeCategory category, Object input1, Object input2, boolean uniqueFileName, RecipeOutput output) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)outputItem, (int)outputAmt).pattern("A").pattern("B").group("marioverse:" + groupName);
        this.defineIngredient(builder, 'A', input1);
        this.defineIngredient(builder, 'B', input2);
        builder.unlockedBy(this.getUnlockName(input1), this.unlockCriterion(input1));
        builder.unlockedBy(this.getUnlockName(input2), this.unlockCriterion(input2));
        if (uniqueFileName && input1 instanceof ItemLike) {
            ItemLike itemLike = (ItemLike)input1;
            builder.save(output, "marioverse:" + RecipeUtils.getConversionRecipeName((ItemLike)outputItem, (ItemLike)itemLike));
        } else {
            builder.save(output);
        }
    }

    public void twoByTwoRecipe(int outputAmt, ItemLike outputItem, RecipeCategory category, ItemLike inputItem, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('#'), inputItem).pattern("##").pattern("##").unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).group("marioverse:" + RecipeUtils.getSimpleRecipeName((ItemLike)outputItem)).save(output);
    }

    public void twoByThreeRecipe(int outputAmt, ItemLike outputItem, RecipeCategory category, ItemLike inputItem, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('#'), inputItem).pattern("###").pattern("###").unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).group("marioverse:" + RecipeUtils.getSimpleRecipeName((ItemLike)outputItem)).save(output);
    }

    public void plusRecipe(int outputAmt, String groupName, ItemLike outputItem, Object input1, Object input2, boolean uniqueFileName, RecipeOutput output) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)outputAmt).pattern(" B ").pattern("BCB").pattern(" B ").group("marioverse:" + groupName);
        this.defineIngredient(builder, 'B', input1);
        this.defineIngredient(builder, 'C', input2);
        builder.unlockedBy(this.getUnlockName(input1), this.unlockCriterion(input1));
        builder.unlockedBy(this.getUnlockName(input2), this.unlockCriterion(input2));
        if (uniqueFileName && input1 instanceof ItemLike) {
            ItemLike itemLike = (ItemLike)input1;
            builder.save(output, "marioverse:" + RecipeUtils.getConversionRecipeName((ItemLike)outputItem, (ItemLike)itemLike));
        } else {
            builder.save(output);
        }
    }

    public void bootsRecipe(int outputAmt, String groupName, ItemLike outputItem, ItemLike inputItem, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('#'), inputItem).pattern("# #").pattern("# #").unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).group("marioverse:" + groupName).save(output);
    }

    public void checkpointFlagRecipe(int outputAmt, ItemLike outputItem, TagKey<Item> inputItemTag, TagKey<Item> inputItemTag2, ItemLike inputItem, ItemLike inputItem2, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('G'), inputItemTag).define(Character.valueOf('I'), inputItemTag2).define(Character.valueOf('W'), inputItem).define(Character.valueOf('S'), inputItem2).pattern(" G").pattern("WI").pattern(" S").unlockedBy("has_gold_ingot", RecipeUtils.has(inputItemTag)).unlockedBy("has_iron_ingot", RecipeUtils.has(inputItemTag2)).unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem2), RecipeUtils.has((ItemLike)inputItem2)).group("marioverse:checkpoint_flags").save(output);
    }

    public void checkeredRecipe(int outputAmt, String groupName, ItemLike outputItem, Object input1, Object input2, boolean uniqueFileName, RecipeOutput output) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)outputAmt).pattern("XY").pattern("YX").group("marioverse:" + groupName);
        this.defineIngredient(builder, 'X', input1);
        this.defineIngredient(builder, 'Y', input2);
        builder.unlockedBy(this.getUnlockName(input1), this.unlockCriterion(input1));
        builder.unlockedBy(this.getUnlockName(input2), this.unlockCriterion(input2));
        if (uniqueFileName && input1 instanceof ItemLike) {
            ItemLike itemLike = (ItemLike)input1;
            builder.save(output, "marioverse:" + RecipeUtils.getConversionRecipeName((ItemLike)outputItem, (ItemLike)itemLike));
        } else {
            builder.save(output);
        }
    }

    public void chestplateRecipe(int outputAmt, String groupName, ItemLike outputItem, ItemLike inputItem, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('#'), inputItem).pattern("# #").pattern("###").pattern("###").unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).group("marioverse:" + groupName).save(output);
    }

    public void classicCheckpointFlagRecipe(int outputAmt, ItemLike outputItem, TagKey<Item> inputItemTag, ItemLike inputItem, ItemLike inputItem2, ItemLike inputItem3, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('M'), inputItem).define(Character.valueOf('W'), inputItem2).define(Character.valueOf('G'), inputItemTag).define(Character.valueOf('S'), inputItem3).pattern("MG").pattern("WG").pattern(" S").unlockedBy("has_gold_ingot", RecipeUtils.has(inputItemTag)).unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem2), RecipeUtils.has((ItemLike)inputItem2)).unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem3), RecipeUtils.has((ItemLike)inputItem3)).group("marioverse:checkpoint_flags").save(output);
    }

    public void classicGoalPoleRecipe(int outputAmt, ItemLike outputItem, TagKey<Item> inputItemTag, TagKey<Item> inputItemTag2, ItemLike inputItem, ItemLike inputItem2, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('B'), inputItem2).define(Character.valueOf('D'), inputItemTag2).define(Character.valueOf('G'), inputItemTag).define(Character.valueOf('W'), inputItem).pattern("DG").pattern("WB").pattern(" B").unlockedBy("has_gold_ingot", RecipeUtils.has(inputItemTag)).unlockedBy("has_dye", RecipeUtils.has(inputItemTag2)).unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem2), RecipeUtils.has((ItemLike)inputItem2)).unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).group("marioverse:goal_poles").save(output);
    }

    public void coinRecipe(int outputAmt, ItemLike outputItem, TagKey<Item> inputItemTag, TagKey<Item> inputItemTag2, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('I'), inputItemTag).define(Character.valueOf('N'), inputItemTag2).pattern(" N ").pattern("NIN").pattern(" N ").unlockedBy("has_ingot", RecipeUtils.has(inputItemTag)).unlockedBy("has_nugget", RecipeUtils.has(inputItemTag2)).group("marioverse:" + RecipeUtils.getSimpleRecipeName((ItemLike)outputItem)).save(output);
    }

    public void fireShirtRecipe(int outputAmt, ItemLike outputItem, ItemLike inputItem, ItemLike inputItem2, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('W'), inputItem).define(Character.valueOf('R'), inputItem2).pattern("W W").pattern("RRR").pattern("RRR").unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).group("marioverse:fire_costume").save(output);
    }

    public void fireShoesRecipe(int outputAmt, ItemLike outputItem, ItemLike inputItem, TagKey<Item> inputItemTag, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('W'), inputItem).define(Character.valueOf('L'), inputItemTag).pattern("W W").pattern("L L").unlockedBy("has_leather", RecipeUtils.has(inputItemTag)).unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).group("marioverse:fire_costume").save(output);
    }

    public void goalPoleRecipe(int outputAmt, ItemLike outputItem, TagKey<Item> inputItemTag, TagKey<Item> inputItemTag2, ItemLike inputItem, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('G'), inputItemTag).define(Character.valueOf('I'), inputItemTag2).define(Character.valueOf('W'), inputItem).pattern(" G").pattern("WI").pattern(" I").unlockedBy("has_gold_ingot", RecipeUtils.has(inputItemTag)).unlockedBy("has_iron_ingot", RecipeUtils.has(inputItemTag2)).unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).group("marioverse:goal_poles").save(output);
    }

    public void helmetRecipe(int outputAmt, String groupName, ItemLike outputItem, ItemLike inputItem, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('#'), inputItem).pattern("###").pattern("# #").unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).group("marioverse:" + groupName).save(output);
    }

    public void leggingsRecipe(int outputAmt, String groupName, ItemLike outputItem, ItemLike inputItem, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('#'), inputItem).pattern("###").pattern("# #").pattern("# #").unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).group("marioverse:" + groupName).save(output);
    }

    public void pedestalRecipe(int outputAmt, ItemLike outputItem, ItemLike inputItem, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('B'), inputItem).pattern("B B").pattern("BBB").unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).group("marioverse:brick_pedestals").save(output);
    }

    public void spikePanelRecipe(int outputAmt, String groupName, ItemLike outputItem, Object input1, Object input2, Object input3, boolean uniqueFileName, RecipeOutput output) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)outputAmt).pattern(" N ").pattern("NIN").pattern("PPP").group("marioverse:" + groupName);
        this.defineIngredient(builder, 'N', input1);
        this.defineIngredient(builder, 'I', input2);
        this.defineIngredient(builder, 'P', input3);
        builder.unlockedBy(this.getUnlockName(input1), this.unlockCriterion(input1));
        builder.unlockedBy(this.getUnlockName(input2), this.unlockCriterion(input2));
        builder.unlockedBy(this.getUnlockName(input3), this.unlockCriterion(input3));
        if (uniqueFileName && input1 instanceof ItemLike) {
            ItemLike itemLike = (ItemLike)input1;
            builder.save(output, "marioverse:" + RecipeUtils.getConversionRecipeName((ItemLike)outputItem, (ItemLike)itemLike));
        } else {
            builder.save(output);
        }
    }

    public void smithingTemplateRecipe(int outputAmt, ItemLike outputItem, ItemLike templateItem, ItemLike inputItem, TagKey<Item> inputItemTag, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('T'), templateItem).define(Character.valueOf('W'), inputItem).define(Character.valueOf('L'), inputItemTag).pattern("LTL").pattern("LWL").pattern("LLL").unlockedBy(RecipeUtils.getHasName((ItemLike)templateItem), RecipeUtils.has((ItemLike)templateItem)).unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).unlockedBy("has_leather", RecipeUtils.has(inputItemTag)).group("marioverse:mario_costume_templates").save(output);
    }

    public void smithingTemplateRecipe(int outputAmt, ItemLike outputItem, ItemLike templateItem, TagKey<Item> inputItemTag, TagKey<Item> inputItemTag2, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('T'), templateItem).define(Character.valueOf('I'), inputItemTag).define(Character.valueOf('L'), inputItemTag2).pattern("LTL").pattern("LIL").pattern("LLL").unlockedBy(RecipeUtils.getHasName((ItemLike)templateItem), RecipeUtils.has((ItemLike)templateItem)).unlockedBy("has_ice", RecipeUtils.has(inputItemTag)).unlockedBy("has_leather", RecipeUtils.has(inputItemTag)).group("marioverse:mario_costume_templates").save(output);
    }

    public void stairRecipe(int outputAmt, ItemLike outputItem, ItemLike inputItem, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('#'), inputItem).pattern("#  ").pattern("## ").pattern("###").unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).group("marioverse:" + RecipeUtils.getSimpleRecipeName((ItemLike)outputItem)).save(output);
    }

    public void storageBrickRecipe(int outputAmt, ItemLike outputItem, ItemLike inputItem, TagKey<Item> inputItemTag, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('B'), inputItem).define(Character.valueOf('C'), inputItemTag).pattern(" B ").pattern("BCB").pattern(" B ").unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).unlockedBy("has_chest", RecipeUtils.has(inputItemTag)).group("marioverse:storage_bricks").save(output);
    }

    public void warpDisruptorRecipe(int outputAmt, ItemLike outputItem, ItemLike inputItem, TagKey<Item> inputItemTag, TagKey<Item> inputItemTag2, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('E'), inputItem).define(Character.valueOf('G'), inputItemTag).define(Character.valueOf('S'), inputItemTag2).pattern("  E").pattern(" G ").pattern("S  ").unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).unlockedBy("has_gold_ingot", RecipeUtils.has(inputItemTag)).unlockedBy("has_stick", RecipeUtils.has(inputItemTag2)).group("marioverse:" + RecipeUtils.getSimpleRecipeName((ItemLike)outputItem)).save(output);
    }

    public void warpPipeRecipe(int outputAmt, ItemLike outputItem, TagKey<Item> inputItemTag, TagKey<Item> inputItemTag2, TagKey<Item> inputItemTag3, TagKey<Item> inputItemTag4, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('I'), inputItemTag).define(Character.valueOf('D'), inputItemTag2).define(Character.valueOf('G'), inputItemTag3).define(Character.valueOf('E'), inputItemTag4).pattern("IDI").pattern("IGI").pattern("IEI").unlockedBy("has_copper_ingot", RecipeUtils.has(inputItemTag)).unlockedBy("has_dye", RecipeUtils.has(inputItemTag2)).unlockedBy("has_diamond", RecipeUtils.has(inputItemTag3)).unlockedBy("has_ender_pearl", RecipeUtils.has(inputItemTag4)).group("marioverse:warp_pipes").save(output);
    }

    public void wrenchRecipe(int outputAmt, ItemLike outputItem, TagKey<Item> inputItemTag, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('I'), inputItemTag).pattern("I I").pattern(" I ").pattern(" I ").unlockedBy("has_iron_ingot", RecipeUtils.has(inputItemTag)).group("marioverse:" + RecipeUtils.getSimpleRecipeName((ItemLike)outputItem)).save(output);
    }

    public void dyeItemRecipe(int outputAmt, String groupName, ItemLike outputItem, RecipeCategory category, Object input1, Object input2, RecipeOutput output) {
        TagKey tag;
        TagKey itemLike;
        ItemLike itemLike2;
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)outputItem, (int)outputAmt).group("marioverse:" + groupName);
        builder.unlockedBy(this.getUnlockName(input1), this.unlockCriterion(input1));
        builder.unlockedBy(this.getUnlockName(input2), this.unlockCriterion(input2));
        if (input1 instanceof ItemLike) {
            itemLike2 = (ItemLike)input1;
            builder.requires(itemLike2);
        } else if (input1 instanceof TagKey && (itemLike = (TagKey)input1).registry() == Registries.ITEM) {
            tag = itemLike;
            builder.requires(tag);
        }
        if (input2 instanceof ItemLike) {
            itemLike2 = (ItemLike)input2;
            builder.requires(itemLike2);
        } else if (input2 instanceof TagKey && (itemLike = (TagKey)input2).registry() == Registries.ITEM) {
            tag = itemLike;
            builder.requires(tag);
        }
        builder.save(output, "marioverse:" + RecipeUtils.getItemName((ItemLike)outputItem) + "_from_dye");
    }

    public void questionBlockRecipe(int outputAmt, ItemLike outputItem, ItemLike inputItem, TagKey<Item> itemTag, RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)outputAmt).requires(inputItem).requires(itemTag).unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).unlockedBy("has_chest", RecipeUtils.has(itemTag)).group("marioverse:question_blocks").save(output);
    }

    public void singleItemRecipe(int outputAmt, ItemLike outputItem, RecipeCategory category, ItemLike inputItem, RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)outputItem, (int)outputAmt).requires(inputItem).unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).group("marioverse:" + RecipeUtils.getSimpleRecipeName((ItemLike)outputItem)).save(output);
    }

    public void twoItemRecipe(int outputAmt, String groupName, ItemLike outputItem, RecipeCategory category, ItemLike inputItem, ItemLike inputItem2, RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)outputItem, (int)outputAmt).requires(inputItem).requires(inputItem2).unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem2), RecipeUtils.has((ItemLike)inputItem2)).group("marioverse:" + groupName).save(output, "marioverse:" + RecipeUtils.getConversionRecipeName((ItemLike)outputItem, (ItemLike)inputItem2));
    }

    public void twoItemTagRecipe(int outputAmt, String groupName, String recipeName, ItemLike outputItem, RecipeCategory category, TagKey<Item> itemTag, TagKey<Item> itemTag2, RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)outputItem, (int)outputAmt).requires(itemTag).requires(itemTag2).unlockedBy("has_tag_item", RecipeUtils.has(itemTag)).unlockedBy("has_tag_item2", RecipeUtils.has(itemTag2)).group("marioverse:" + groupName).save(output, "marioverse:" + RecipeUtils.getSimpleRecipeName((ItemLike)outputItem) + recipeName);
    }

    public void waxedBlockRecipe(int outputAmt, ItemLike outputItem, ItemLike inputItem, ItemLike inputItem2, RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)outputAmt).requires(inputItem).requires(inputItem2).unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem2), RecipeUtils.has((ItemLike)inputItem2)).group("marioverse:" + RecipeUtils.getSimpleRecipeName((ItemLike)outputItem)).save(output, "marioverse:" + RecipeUtils.getConversionRecipeName((ItemLike)outputItem, (ItemLike)inputItem2));
    }

    protected void stonecutting(int outputAmt, ItemLike outputItem, RecipeCategory category, ItemLike inputItem, RecipeOutput output) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputItem}), (RecipeCategory)category, (ItemLike)outputItem, (int)outputAmt).unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).save(output, "marioverse:" + RecipeUtils.getSimpleRecipeName((ItemLike)outputItem) + "_stonecutting");
    }

    protected void stonecuttingFromBase(int outputAmt, ItemLike outputItem, RecipeCategory category, ItemLike inputItem, RecipeOutput output) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputItem}), (RecipeCategory)category, (ItemLike)outputItem, (int)outputAmt).unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).save(output, "marioverse:" + RecipeUtils.getConversionRecipeName((ItemLike)outputItem, (ItemLike)inputItem) + "_stonecutting");
    }

    protected void smeltingRecipe(int cookingTime, float xp, ItemLike outputItem, RecipeCategory category, ItemLike inputItem, RecipeOutput output) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputItem}), (RecipeCategory)category, (ItemLike)outputItem, (float)xp, (int)cookingTime).unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).save(output, "marioverse:" + RecipeUtils.getSimpleRecipeName((ItemLike)outputItem) + "_smelting");
    }

    protected static void smeltingResultFromBase(RecipeOutput output, ItemLike outputItem, ItemLike inputItem) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputItem}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (float)0.1f, (int)200).unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).save(output, "marioverse:" + RecipeUtils.getSimpleRecipeName((ItemLike)outputItem) + "_smelting");
    }

    protected static void generateRecipes(RecipeOutput output, BlockFamilyExtended family, FeatureFlagSet set) {
        family.getVariants().forEach((variant, block) -> {
            if (block == BlockRegistry.POLISHED_DEEP_FUNGAL_STONE.get() || block == BlockRegistry.POLISHED_FUNGAL_STONE.get()) {
                return;
            }
            if (block.requiredFeatures().isSubsetOf(set)) {
                BiFunction<ItemLike, ItemLike, RecipeBuilder> recipeFunction = SHAPE_BUILDERS.get(variant);
                Block itemlike = RecipeUtils.getBaseBlock(family, variant);
                if (variant == BlockFamilyExtended.Variant.CHISELED && !family.getVariants().containsKey((Object)BlockFamilyExtended.Variant.SLAB)) {
                    itemlike = family.getBaseBlock();
                }
                if (recipeFunction != null) {
                    RecipeBuilder recipeBuilder = recipeFunction.apply((ItemLike)block, (ItemLike)itemlike);
                    family.getRecipeGroupPrefix().ifPresent(string -> recipeBuilder.group(string + (String)(variant == BlockFamilyExtended.Variant.CUT ? "" : "_" + variant.getRecipeGroup())));
                    Block finalItemlike = itemlike;
                    recipeBuilder.unlockedBy(family.getRecipeUnlockedBy().orElseGet(() -> RecipeUtils.lambda$generateRecipes$24((ItemLike)finalItemlike)), RecipeUtils.has((ItemLike)itemlike));
                    recipeBuilder.save(output);
                }
                BiFunction<ItemLike, TagKey<Item>, RecipeBuilder> recipeTagFunction = SHAPE_TAG_BUILDERS.get(variant);
                TagKey<Item> itemTag = TagRegistry.POLISHED_CALCITE_ITEMS;
                if (recipeTagFunction != null) {
                    RecipeBuilder recipeBuilder = recipeTagFunction.apply((ItemLike)block, itemTag);
                    family.getRecipeGroupPrefix().ifPresent(string -> recipeBuilder.group(string + (String)(variant == BlockFamilyExtended.Variant.CUT ? "" : "_" + variant.getRecipeGroup())));
                    Block finalItemlike = itemlike;
                    recipeBuilder.unlockedBy(family.getRecipeUnlockedBy().orElseGet(() -> RecipeUtils.lambda$generateRecipes$26((ItemLike)finalItemlike)), RecipeUtils.has(itemTag));
                    recipeBuilder.save(output);
                }
                if (variant == BlockFamilyExtended.Variant.CRACKED) {
                    RecipeUtils.smeltingResultFromBase(output, (ItemLike)block, (ItemLike)itemlike);
                }
            }
        });
    }

    protected static Block getBaseBlock(BlockFamilyExtended family, BlockFamilyExtended.Variant variant) {
        if (variant == BlockFamilyExtended.Variant.CHISELED) {
            if (!family.getVariants().containsKey((Object)BlockFamilyExtended.Variant.SLAB)) {
                return null;
            }
            return family.get(BlockFamilyExtended.Variant.SLAB);
        }
        return family.getBaseBlock();
    }

    protected void generateStonecuttingRecipes(RecipeOutput output, BlockFamilyExtended family, FeatureFlagSet featureFlags) {
        family.getVariants().forEach((variant, block) -> {
            if (block == BlockRegistry.POLISHED_DEEP_FUNGAL_STONE.get() || block == BlockRegistry.POLISHED_FUNGAL_STONE.get()) {
                return;
            }
            if (block.requiredFeatures().isSubsetOf(featureFlags)) {
                Block baseBlock = variant == BlockFamilyExtended.Variant.CHISELED ? family.getBaseBlock() : RecipeUtils.getBaseBlock(family, variant);
                int outputAmount = STONECUTTING_OUTPUTS.getOrDefault(variant, 1);
                if (baseBlock != null && variant != BlockFamilyExtended.Variant.BRIDGE && variant != BlockFamilyExtended.Variant.BUTTON && variant != BlockFamilyExtended.Variant.DOOR && variant != BlockFamilyExtended.Variant.INVISIBLE_QUESTION_BLOCK && variant != BlockFamilyExtended.Variant.PRESSURE_PLATE && variant != BlockFamilyExtended.Variant.QUESTION_BLOCK && variant != BlockFamilyExtended.Variant.QUESTION_BLOCK_TAG && variant != BlockFamilyExtended.Variant.QUESTION_PANEL && variant != BlockFamilyExtended.Variant.STORAGE_BRICKS) {
                    SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{baseBlock}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block, (int)outputAmount).unlockedBy(RecipeUtils.getHasName((ItemLike)baseBlock), RecipeUtils.has((ItemLike)baseBlock)).save(output, "marioverse:" + RecipeUtils.getSimpleRecipeName((ItemLike)block) + "_stonecutting");
                }
            }
        });
    }

    protected void generateStonecuttingFromBaseRecipes(RecipeOutput output, BlockFamilyExtended family, ItemLike inputItem, FeatureFlagSet featureFlags) {
        family.getVariants().forEach((variant, block) -> {
            if (block.requiredFeatures().isSubsetOf(featureFlags)) {
                Block baseBlock = variant == BlockFamilyExtended.Variant.CHISELED ? family.getBaseBlock() : RecipeUtils.getBaseBlock(family, variant);
                int outputAmount = STONECUTTING_OUTPUTS.getOrDefault(variant, 1);
                if (baseBlock != null && variant != BlockFamilyExtended.Variant.BRIDGE && variant != BlockFamilyExtended.Variant.BUTTON && variant != BlockFamilyExtended.Variant.DOOR && variant != BlockFamilyExtended.Variant.INVISIBLE_QUESTION_BLOCK && variant != BlockFamilyExtended.Variant.PRESSURE_PLATE && variant != BlockFamilyExtended.Variant.QUESTION_BLOCK && variant != BlockFamilyExtended.Variant.QUESTION_BLOCK_TAG && variant != BlockFamilyExtended.Variant.QUESTION_PANEL && variant != BlockFamilyExtended.Variant.STORAGE_BRICKS) {
                    SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputItem}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block, (int)outputAmount).unlockedBy(RecipeUtils.getHasName((ItemLike)baseBlock), RecipeUtils.has((ItemLike)baseBlock)).save(output, "marioverse:" + RecipeUtils.getConversionRecipeName((ItemLike)block, (ItemLike)inputItem) + "_stonecutting");
                }
            }
        });
    }

    protected static void costumeSmithing(Item outputItem, RecipeCategory category, Item templateItem, Item armorItem, Item inputItem, RecipeOutput output) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{templateItem}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{armorItem}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputItem}), (RecipeCategory)category, (Item)outputItem).unlocks(RecipeUtils.getHasName((ItemLike)armorItem), RecipeUtils.has((ItemLike)armorItem)).save(output, "marioverse:" + RecipeUtils.getItemName((ItemLike)outputItem) + "_smithing");
    }

    protected static void costumeSmithing(Item outputItem, RecipeCategory category, Item templateItem, Item armorItem, TagKey<Item> inputItemTag, RecipeOutput output) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{templateItem}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{armorItem}), (Ingredient)Ingredient.of(inputItemTag), (RecipeCategory)category, (Item)outputItem).unlocks(RecipeUtils.getHasName((ItemLike)armorItem), RecipeUtils.has((ItemLike)armorItem)).save(output, "marioverse:" + RecipeUtils.getItemName((ItemLike)outputItem) + "_smithing");
    }

    protected static void costumeSmithing(Item outputItem, RecipeCategory category, Item templateItem, TagKey<Item> armorItemTag, Item inputItem, RecipeOutput output) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{templateItem}), (Ingredient)Ingredient.of(armorItemTag), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputItem}), (RecipeCategory)category, (Item)outputItem).unlocks("has_armor", RecipeUtils.has(armorItemTag)).save(output, "marioverse:" + RecipeUtils.getItemName((ItemLike)outputItem) + "_smithing");
    }

    private void defineIngredient(ShapedRecipeBuilder builder, char symbol, Object ingredient) {
        TagKey tag;
        if (ingredient instanceof ItemLike) {
            ItemLike item = (ItemLike)ingredient;
            builder.define(Character.valueOf(symbol), item);
        } else if (ingredient instanceof TagKey && (tag = (TagKey)ingredient).registry() == Registries.ITEM) {
            builder.define(Character.valueOf(symbol), tag);
        } else {
            throw new IllegalArgumentException("Unsupported ingredient type: " + String.valueOf(ingredient));
        }
    }

    private String getUnlockName(Object ingredient) {
        if (ingredient instanceof ItemLike) {
            ItemLike item = (ItemLike)ingredient;
            return RecipeUtils.getHasName((ItemLike)item);
        }
        if (ingredient instanceof TagKey) {
            TagKey tag = (TagKey)ingredient;
            return "has_" + tag.location().getPath();
        }
        throw new IllegalArgumentException("Unsupported ingredient type: " + String.valueOf(ingredient));
    }

    private Criterion<?> unlockCriterion(Object ingredient) {
        TagKey raw;
        if (ingredient instanceof ItemLike) {
            ItemLike item = (ItemLike)ingredient;
            return RecipeProvider.has((ItemLike)item);
        }
        if (ingredient instanceof TagKey && (raw = (TagKey)ingredient).registry() == Registries.ITEM) {
            TagKey tag = raw;
            return RecipeProvider.has((TagKey)tag);
        }
        throw new IllegalArgumentException("Unsupported ingredient: " + String.valueOf(ingredient));
    }

    private static /* synthetic */ String lambda$generateRecipes$26(ItemLike finalItemlike) {
        return RecipeUtils.getHasName((ItemLike)finalItemlike);
    }

    private static /* synthetic */ String lambda$generateRecipes$24(ItemLike finalItemlike) {
        return RecipeUtils.getHasName((ItemLike)finalItemlike);
    }
}

