/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.datagen;

import com.wenxin2.marioverse.data.BlockFamilyExtended;
import com.wenxin2.marioverse.registries.BlockFamilyRegistry;
import com.wenxin2.marioverse.registries.BlockRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class ItemModelGen
extends ItemModelProvider {
    public ItemModelGen(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "marioverse", existingFileHelper);
    }

    protected void registerModels() {
        this.genInvisibleQuestionBlockVariants();
        this.genStorageBrickVariants();
        this.basicItem(BlockRegistry.COIN.asItem());
        this.basicItem(BlockRegistry.IRON_SPIKE.asItem());
        this.basicItem(BlockRegistry.SPIKE_PANEL.asItem());
        this.largeItem(BlockRegistry.STAR_COIN.asItem());
        this.basicItem((Item)ItemRegistry.BOO_SPAWN_EGG.get());
        this.basicItem((Item)ItemRegistry.BOWSER_BANNER_PATTERN.get());
        this.basicItem((Item)ItemRegistry.BOWSER_POTTERY_SHERD.get());
        this.basicItem((Item)ItemRegistry.DASH_MUSHROOM.get());
        this.basicItem((Item)ItemRegistry.DRY_BONES_SPAWN_EGG.get());
        this.basicItem((Item)ItemRegistry.FIRE_COSTUME_SMITHING_TEMPLATE.get());
        this.basicItem((Item)ItemRegistry.FIRE_FLOWER.get());
        this.basicItem((Item)ItemRegistry.FIRE_GOOMBA_SPAWN_EGG.get());
        this.basicItem((Item)ItemRegistry.GOLDEN_KOOPA_SHOES.get());
        this.basicItem((Item)ItemRegistry.GOLD_KOOPA_SHELL.get());
        this.basicItem((Item)ItemRegistry.GOLD_KOOPA_TROOPA_SPAWN_EGG.get());
        this.basicItem((Item)ItemRegistry.GOOMBA_SPAWN_EGG.get());
        this.basicItem((Item)ItemRegistry.GREEN_KOOPA_SHELL.get());
        this.basicItem((Item)ItemRegistry.GREEN_KOOPA_SHOES.get());
        this.basicItem((Item)ItemRegistry.GREEN_KOOPA_TROOPA_SPAWN_EGG.get());
        this.basicItem((Item)ItemRegistry.HEFTY_GOOMBA_SPAWN_EGG.get());
        this.basicItem((Item)ItemRegistry.ICE_COSTUME_SMITHING_TEMPLATE.get());
        this.basicItem((Item)ItemRegistry.ICE_FLOWER.get());
        this.basicItem((Item)ItemRegistry.LUIGI_COSTUME_SMITHING_TEMPLATE.get());
        this.basicItem((Item)ItemRegistry.LUIGI_HAT.get());
        this.basicItem((Item)ItemRegistry.LUIGI_PANTS.get());
        this.basicItem((Item)ItemRegistry.LUIGI_SHIRT.get());
        this.basicItem((Item)ItemRegistry.LUIGI_SHOES.get());
        this.basicItem((Item)ItemRegistry.LUIGI_FIRE_HAT.get());
        this.basicItem((Item)ItemRegistry.LUIGI_FIRE_PANTS.get());
        this.basicItem((Item)ItemRegistry.LUIGI_FIRE_SHIRT.get());
        this.basicItem((Item)ItemRegistry.LUIGI_FIRE_SHOES.get());
        this.basicItem((Item)ItemRegistry.LUIGI_ICE_HAT.get());
        this.basicItem((Item)ItemRegistry.LUIGI_ICE_PANTS.get());
        this.basicItem((Item)ItemRegistry.LUIGI_ICE_SHIRT.get());
        this.basicItem((Item)ItemRegistry.LUIGI_ICE_SHOES.get());
        this.basicItem((Item)ItemRegistry.MARIO_COSTUME_SMITHING_TEMPLATE.get());
        this.basicItem((Item)ItemRegistry.MARIO_FIRE_HAT.get());
        this.basicItem((Item)ItemRegistry.MARIO_FIRE_PANTS.get());
        this.basicItem((Item)ItemRegistry.MARIO_FIRE_SHIRT.get());
        this.basicItem((Item)ItemRegistry.MARIO_FIRE_SHOES.get());
        this.basicItem((Item)ItemRegistry.MARIO_HAT.get());
        this.basicItem((Item)ItemRegistry.MARIO_ICE_HAT.get());
        this.basicItem((Item)ItemRegistry.MARIO_ICE_PANTS.get());
        this.basicItem((Item)ItemRegistry.MARIO_ICE_SHIRT.get());
        this.basicItem((Item)ItemRegistry.MARIO_ICE_SHOES.get());
        this.basicItem((Item)ItemRegistry.MARIO_PANTS.get());
        this.basicItem((Item)ItemRegistry.MARIO_SHIRT.get());
        this.basicItem((Item)ItemRegistry.MARIO_SHOES.get());
        this.basicItem((Item)ItemRegistry.MEGA_GOOMBA_SPAWN_EGG.get());
        this.basicItem((Item)ItemRegistry.MINI_GOOMBA_SPAWN_EGG.get());
        this.basicItem((Item)ItemRegistry.ONE_UP_MUSHROOM.get());
        this.basicItem((Item)ItemRegistry.PEACH_BODICE.get());
        this.basicItem((Item)ItemRegistry.PEACH_COSTUME_SMITHING_TEMPLATE.get());
        this.basicItem((Item)ItemRegistry.PEACH_CROWN.get());
        this.basicItem((Item)ItemRegistry.PEACH_DRESS.get());
        this.basicItem((Item)ItemRegistry.PEACH_FIRE_BODICE.get());
        this.basicItem((Item)ItemRegistry.PEACH_FIRE_DRESS.get());
        this.basicItem((Item)ItemRegistry.PEACH_FIRE_SHOES.get());
        this.basicItem((Item)ItemRegistry.PEACH_ICE_BODICE.get());
        this.basicItem((Item)ItemRegistry.PEACH_ICE_DRESS.get());
        this.basicItem((Item)ItemRegistry.PEACH_ICE_SHOES.get());
        this.basicItem((Item)ItemRegistry.PEACH_SHOES.get());
        this.basicItem((Item)ItemRegistry.PIRANHA_PLANT_POD.get());
        this.basicItem((Item)ItemRegistry.PIRANHA_PLANT_SPAWN_EGG.get());
        this.basicItem((Item)ItemRegistry.PLUMBER_BANNER_PATTERN.get());
        this.basicItem((Item)ItemRegistry.PLUMBER_POTTERY_SHERD.get());
        this.basicItem((Item)ItemRegistry.RED_KOOPA_SHELL.get());
        this.basicItem((Item)ItemRegistry.RED_KOOPA_SHOES.get());
        this.basicItem((Item)ItemRegistry.RED_KOOPA_TROOPA_SPAWN_EGG.get());
        this.basicItem((Item)ItemRegistry.SPLUNKIN_SPAWN_EGG.get());
        this.basicItem((Item)ItemRegistry.SUPER_MUSHROOM.get());
        this.basicItem((Item)ItemRegistry.SUPER_STAR.get());
        this.basicItem((Item)ItemRegistry.WHITE_KOOPA_SHOES.get());
        this.handheldItem(BlockRegistry.CLASSIC_CHECKPOINT_FLAG.asItem());
        this.handheldItem(BlockRegistry.CLASSIC_GOAL_POLE.asItem());
        this.handheldItem((Item)ItemRegistry.WRENCH.get());
        this.handheldItem((Item)ItemRegistry.WARP_DISRUPTOR.get());
        for (Map.Entry<DyeColor, DeferredBlock<Block>> entry : BlockRegistry.CHECKPOINT_FLAGS.entrySet()) {
            this.handheldItem(entry.getValue().asItem());
        }
        for (Map.Entry<DyeColor, DeferredBlock<Block>> entry : BlockRegistry.GOAL_POLES.entrySet()) {
            this.handheldItem(entry.getValue().asItem());
        }
    }

    public ItemModelBuilder largeItem(Item item) {
        return this.largeItem(Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item)));
    }

    public ItemModelBuilder largeItem(ResourceLocation item) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("marioverse:item/template_large_dropped_item"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)item.getNamespace(), (String)("item/" + item.getPath())));
    }

    public void storageBrickModel(String modelName, ResourceLocation mainTexture, ResourceLocation overlayTexture) {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(modelName)).parent((ModelFile)this.getExistingFile(this.modLoc("block/template_storage_bricks")))).texture("all", mainTexture)).texture("overlay", overlayTexture);
    }

    public void cubeBottomTopModel(String modelName, ResourceLocation sideTexture, ResourceLocation topTexture) {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(modelName)).parent((ModelFile)this.getExistingFile(this.mcLoc("minecraft:block/cube_bottom_top")))).texture("bottom", topTexture)).texture("side", sideTexture)).texture("top", topTexture);
    }

    public void invisibleQuestionBlockModel(String modelName, ResourceLocation mainTexture) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(modelName)).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", mainTexture);
    }

    public void spawnEggItem(Item item, String parentModelPath) {
        ((ItemModelBuilder)this.getBuilder(Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item)).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)parentModelPath)));
    }

    private void genInvisibleQuestionBlockVariants() {
        BlockFamilyRegistry.getAllExtendedFamilies().forEach(blockFamily -> blockFamily.getVariants().forEach((variant, block) -> {
            BlockFamilyExtended.Variant questionBlock = BlockFamilyExtended.Variant.INVISIBLE_QUESTION_BLOCK;
            if (variant == questionBlock) {
                String blockName = BuiltInRegistries.BLOCK.getKey(block).getPath();
                if (blockName.startsWith("invisible_waxed_")) {
                    String removeWaxedName = blockName.replace("waxed_", "");
                    ResourceLocation mainTexture = this.modLoc("block/" + removeWaxedName);
                    this.invisibleQuestionBlockModel(blockName, mainTexture);
                } else {
                    ResourceLocation mainTexture = this.modLoc("block/" + blockName);
                    this.invisibleQuestionBlockModel(blockName, mainTexture);
                }
            }
        }));
    }

    private void genStorageBrickVariants() {
        BlockFamilyRegistry.getAllExtendedFamilies().forEach(blockFamily -> blockFamily.getVariants().forEach((variant, block) -> {
            BlockFamilyExtended.Variant storageBrick = BlockFamilyExtended.Variant.STORAGE_BRICKS;
            if (variant == storageBrick) {
                String blockName = BuiltInRegistries.BLOCK.getKey(block).getPath();
                String removeStorageName = blockName.replace("storage_", "");
                String questionBlockName = removeStorageName.replace("block", "question_block").replace("bricks", "question_bricks").replace("cut_copper", "copper_question_block").replace("dark_prismarine", "dark_prismarine_question_block").replace("tiles", "question_tiles");
                if (block == BlockFamilyRegistry.BRICKS.get(storageBrick) || block == BlockFamilyRegistry.CUT_COPPER.get(storageBrick) || block == BlockFamilyRegistry.DARK_PRISMARINE.get(storageBrick) || block == BlockFamilyRegistry.DEEPSLATE_BRICKS.get(storageBrick) || block == BlockFamilyRegistry.DEEPSLATE_TILES.get(storageBrick) || block == BlockFamilyRegistry.END_STONE_BRICKS.get(storageBrick) || block == BlockFamilyRegistry.EXPOSED_CUT_COPPER.get(storageBrick) || block == BlockFamilyRegistry.MOSSY_STONE_BRICKS.get(storageBrick) || block == BlockFamilyRegistry.MUD_BRICKS.get(storageBrick) || block == BlockFamilyRegistry.NETHER_BRICKS.get(storageBrick) || block == BlockFamilyRegistry.OXIDIZED_CUT_COPPER.get(storageBrick) || block == BlockFamilyRegistry.PRISMARINE_BRICKS.get(storageBrick) || block == BlockFamilyRegistry.PURPUR_BLOCK.get(storageBrick) || block == BlockFamilyRegistry.QUARTZ_BRICKS.get(storageBrick) || block == BlockFamilyRegistry.RED_NETHER_BRICKS.get(storageBrick) || block == BlockFamilyRegistry.STONE_BRICKS.get(storageBrick) || block == BlockFamilyRegistry.TUFF_BRICKS.get(storageBrick) || block == BlockFamilyRegistry.WEATHERED_CUT_COPPER.get(storageBrick)) {
                    ResourceLocation mainTexture = this.mcLoc("minecraft:block/" + removeStorageName);
                    ResourceLocation overlayTexture = this.modLoc("block/" + questionBlockName + "_overlay");
                    this.storageBrickModel(blockName, mainTexture, overlayTexture);
                } else if (removeStorageName.startsWith("waxed_")) {
                    String unWaxedName = blockName.replace("waxed_", "");
                    removeStorageName = unWaxedName.replace("storage_", "");
                    questionBlockName = removeStorageName.replace("cut_copper", "copper_question_block");
                    ResourceLocation mainTexture = this.mcLoc("minecraft:block/" + removeStorageName);
                    ResourceLocation overlayTexture = this.modLoc("block/" + questionBlockName + "_overlay");
                    this.storageBrickModel(blockName, mainTexture, overlayTexture);
                } else if (questionBlockName.startsWith("blackstone_")) {
                    String crackedBlockName = removeStorageName.replace("blackstone_", "polished_blackstone_");
                    ResourceLocation mainTexture = this.mcLoc("minecraft:block/" + crackedBlockName);
                    ResourceLocation overlayTexture = this.modLoc("block/" + questionBlockName + "_overlay");
                    this.storageBrickModel(blockName, mainTexture, overlayTexture);
                } else {
                    ResourceLocation sideTexture = this.modLoc("block/" + blockName);
                    ResourceLocation topTexture = this.modLoc("block/" + removeStorageName);
                    this.cubeBottomTopModel(blockName, sideTexture, topTexture);
                }
            }
        }));
    }
}

