/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities;

import com.google.common.base.MoreObjects;
import com.wenxin2.marioverse.entities.KoopaTroopaEntity;
import com.wenxin2.marioverse.entities.projectiles.BouncingIceBallProjectile;
import com.wenxin2.marioverse.registries.AttributesRegistry;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DamageSourceRegistry;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import java.util.Iterator;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class IceCubeEntity
extends VehicleEntity
implements GeoEntity,
TraceableEntity {
    private static final EntityDataAccessor<CompoundTag> FROZEN_DATA = SynchedEntityData.defineId(IceCubeEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private CompoundTag frozenEntityData;
    private Entity displayEntity;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;
    private boolean leftOwner;
    private float entityHeight = 1.0f;
    private float entityWidth = 1.0f;
    private float height = 1.0f;
    private float previousFallDistance = 0.0f;
    private float width = 1.0f;
    public int entityFrozenCooldown;
    public int frozenCooldown;
    public int ticksInAir;

    public IceCubeEntity(EntityType<? extends IceCubeEntity> type, Level world) {
        super(type, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FROZEN_DATA, (Object)new CompoundTag());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.put("FrozenData", (Tag)((CompoundTag)this.entityData.get(FROZEN_DATA)).copy());
        tag.putFloat("FrozenEntityHeight", this.entityHeight);
        tag.putFloat("FrozenEntityWidth", this.entityWidth);
        tag.putFloat("Height", this.height);
        tag.putFloat("Width", this.width);
        tag.putInt("FrozenCooldown", this.getFrozenCooldown());
        tag.putInt("EntityFrozenCooldown", this.getEntityFrozenCooldown());
        tag.putInt("TicksInAir", this.getTicksInAir());
        if (this.frozenEntityData != null) {
            tag.put("FrozenEntityData", (Tag)this.frozenEntityData);
        }
        if (this.ownerUUID != null) {
            tag.putUUID("OwnerUUID", this.ownerUUID);
        }
        if (this.leftOwner) {
            tag.putBoolean("LeftOwner", true);
        }
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.leftOwner = tag.getBoolean("LeftOwner");
        this.frozenCooldown = tag.getInt("FrozenCooldown");
        this.setEntityFrozenCooldown(tag.getInt("EntityFrozenCooldown"));
        this.setTicksInAir(tag.getInt("TicksInAir"));
        if (tag.contains("FrozenEntityWidth") && tag.contains("FrozenEntityHeight")) {
            this.entityWidth = tag.getFloat("FrozenEntityWidth");
            this.entityHeight = tag.getFloat("FrozenEntityHeight");
        }
        if (tag.contains("Width") && tag.contains("Height")) {
            this.width = tag.getFloat("Width");
            this.height = tag.getFloat("Height");
        }
        if (tag.contains("FrozenData", 10)) {
            this.entityData.set(FROZEN_DATA, (Object)tag.getCompound("FrozenData"));
        }
        if (tag.contains("FrozenEntityData", 10)) {
            this.frozenEntityData = tag.getCompound("FrozenEntityData");
        }
        if (tag.hasUUID("OwnerUUID")) {
            this.ownerUUID = tag.getUUID("OwnerUUID");
            this.cachedOwner = null;
        }
        this.reapplyPosition();
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        Entity entity = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, serverEntity, entity == null ? 0 : entity.getId());
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        Entity entity = this.level().getEntity(packet.getData());
        if (entity != null) {
            this.setOwner(entity);
        }
    }

    public void tick() {
        super.tick();
        Level world = this.level();
        BlockPos pos = this.blockPosition();
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        if (this.getPersistentData().contains("EntityFrozenCooldown")) {
            if (this.getEntityFrozenCooldown() > 0) {
                this.setEntityFrozenCooldown(this.getEntityFrozenCooldown() - 1);
            }
            if (this.getEntityFrozenCooldown() == 0) {
                this.shatterIceCube(false, false, (Entity)this);
            }
        }
        if (this.getTicksInAir() > 0) {
            this.setTicksInAir(this.getTicksInAir() - 1);
        }
        if (this.getDeltaMovement().horizontalDistance() > 0.1) {
            this.spawnSnowParticles();
        }
        if (this.frozenEntityData != null) {
            float height = this.frozenEntityData.getFloat("Height") * 1.55f;
            float width = this.frozenEntityData.getFloat("Width") * 1.55f;
            this.setSize(width, height);
        }
        this.gravityWaterPhysics();
        this.collideWithWall(world, pos);
        this.collideWithEntity();
    }

    @NotNull
    protected Item getDropItem() {
        return ItemStack.EMPTY.getItem();
    }

    public boolean isPickable() {
        return true;
    }

    @Nullable
    public ItemStack getPickedResult(@NotNull HitResult target) {
        if (this.displayEntity != null) {
            ItemStack pickedResult;
            Entity entityInstance = this.displayEntity.getType().create(this.level());
            SpawnEggItem spawnEggItem = SpawnEggItem.byId((EntityType)this.displayEntity.getType());
            if (spawnEggItem != null) {
                return new ItemStack((ItemLike)spawnEggItem);
            }
            if (entityInstance != null && (pickedResult = entityInstance.getPickedResult(target)) != null && !pickedResult.isEmpty()) {
                return pickedResult;
            }
        }
        return super.getPickedResult(target);
    }

    public boolean hurt(DamageSource source, float damage) {
        Mob mob;
        LivingEntity entity;
        Level world = this.level();
        BlockPos posBelow = this.blockPosition().below();
        BlockState stateBelow = world.getBlockState(posBelow);
        if (this.level().isClientSide || this.isRemoved()) {
            return true;
        }
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (source.getDirectEntity() instanceof BouncingIceBallProjectile && this.getType().is(TagRegistry.ICE_BALL_IMMUNE)) {
            return false;
        }
        Entity entity2 = source.getEntity();
        if (entity2 instanceof LivingEntity && (entity = (LivingEntity)entity2).getMainHandItem().is(ItemTags.PICKAXES)) {
            this.shatterIceCube(false, false, (Entity)this);
            return true;
        }
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.markHurt();
        this.setDamage(this.getDamage() + damage * 10.0f);
        this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, source.getEntity());
        this.setOwner(source.getEntity());
        float friction = stateBelow.getFriction((LevelReader)world, posBelow, (Entity)this);
        double slideSpeed = (double)friction > 0.6 ? 0.1 + (double)friction / 1.5 : 0.5;
        Vec3 slideDirection = Vec3.ZERO;
        if (source.getEntity() != null) {
            Vec3 attackerPos = source.getEntity().position();
            Vec3 hitPos = this.position();
            Vec3 slideDirRaw = hitPos.subtract(attackerPos).normalize();
            slideDirection = new Vec3(slideDirRaw.x, 0.0, slideDirRaw.z).normalize();
        } else if (source.getDirectEntity() != null) {
            slideDirection = source.getDirectEntity().getDeltaMovement().normalize();
        }
        Vec3 movement = slideDirection.scale(slideSpeed);
        Entity entity3 = this.displayEntity;
        if (entity3 instanceof Mob && !(mob = (Mob)entity3).isNoAi()) {
            this.setDeltaMovement(movement);
        } else if (!(this.displayEntity instanceof Mob)) {
            this.setDeltaMovement(movement);
        }
        return true;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean isPushable() {
        return true;
    }

    public void push(Entity entity) {
        double d1;
        double d0;
        double d2;
        if (!(entity instanceof IceCubeEntity) && !entity.noPhysics && !this.noPhysics && (d2 = Mth.absMax((double)(d0 = entity.getX() - this.getX()), (double)(d1 = entity.getZ() - this.getZ()))) >= (double)0.01f) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (!this.isVehicle() && this.isPushable()) {
                this.push(-d0, 0.0, -d1);
            }
            if (!entity.isVehicle() && entity.isPushable()) {
                entity.push(d0, 0.0, d1);
            }
        }
    }

    protected double getDefaultGravity() {
        return 0.06;
    }

    public boolean isNoGravity() {
        return false;
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity riderEntity) {
        return true;
    }

    protected boolean canRide(Entity riderEntity) {
        return true;
    }

    protected void positionRider(Entity riderEntity, Entity.MoveFunction moveFunction) {
        if (this.isAlive()) {
            moveFunction.accept(riderEntity, this.getX(), this.getY(), this.getZ());
        } else {
            super.positionRider(riderEntity, moveFunction);
        }
        if (riderEntity instanceof Player) {
            Player player = (Player)riderEntity;
            player.setYRot(this.getYRot());
            player.yRotO = this.getYRot();
        }
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean canControlVehicle() {
        return false;
    }

    @NotNull
    protected AABB makeBoundingBox() {
        if (this.frozenEntityData != null) {
            float height = this.frozenEntityData.getFloat("Height") * 1.55f;
            float width = this.frozenEntityData.getFloat("Width") * 1.55f;
            return new AABB(this.position().subtract((double)(width / 2.0f), 0.0, (double)(width / 2.0f)), this.position().add((double)(width / 2.0f), (double)height, (double)(width / 2.0f)));
        }
        return super.makeBoundingBox();
    }

    public void setOwner(@javax.annotation.Nullable Entity p_37263_) {
        if (p_37263_ != null) {
            this.ownerUUID = p_37263_.getUUID();
            this.cachedOwner = p_37263_;
        }
    }

    @Nullable
    public Entity getOwner() {
        Level level;
        if (this.cachedOwner != null && !this.cachedOwner.isRemoved()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            this.cachedOwner = serverlevel.getEntity(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public void restoreFrom(Entity entity) {
        super.restoreFrom(entity);
        if (entity instanceof IceCubeEntity) {
            IceCubeEntity iceCube = (IceCubeEntity)entity;
            this.cachedOwner = iceCube.cachedOwner;
        }
    }

    protected boolean ownedBy(Entity entity) {
        return entity.getUUID().equals(this.ownerUUID);
    }

    public Entity getEffectSource() {
        return (Entity)MoreObjects.firstNonNull((Object)this.getOwner(), (Object)((Object)this));
    }

    private boolean checkLeftOwner() {
        Entity entity = this.getOwner();
        if (entity != null) {
            for (Entity entity1 : this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), mob -> !mob.isSpectator() && mob.isPickable())) {
                if (entity1.getRootVehicle() != entity.getRootVehicle()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean deflect(@Nullable Entity entity, @Nullable Entity ownerEntity, boolean deflect) {
        if (!this.level().isClientSide) {
            this.setOwner(ownerEntity);
            this.onDeflection(entity, deflect);
        }
        return true;
    }

    protected void onDeflection(@Nullable Entity entity, boolean deflect) {
        Vec3 motion = this.getDeltaMovement();
        this.setDeltaMovement(new Vec3(-motion.x, motion.y, -motion.z));
    }

    public void setFrozenEntity(Entity entity, int ticksFrozen) {
        if (entity != null) {
            float scale = 1.0f;
            float heightScale = 1.0f;
            float widthScale = 1.0f;
            this.frozenEntityData = new CompoundTag();
            entity.save(this.frozenEntityData);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                AttributeInstance scaleAttribute = living.getAttribute(Attributes.SCALE);
                AttributeInstance heightScaleAttribute = living.getAttribute(AttributesRegistry.HEIGHT_SCALE);
                AttributeInstance widthScaleAttribute = living.getAttribute(AttributesRegistry.WIDTH_SCALE);
                if (scaleAttribute != null) {
                    scale = (float)scaleAttribute.getValue();
                }
                if (heightScaleAttribute != null) {
                    heightScale = (float)heightScaleAttribute.getValue();
                }
                if (widthScaleAttribute != null) {
                    widthScale = (float)widthScaleAttribute.getValue();
                }
            }
            this.frozenEntityData.putString("id", EntityType.getKey((EntityType)entity.getType()).toString());
            this.frozenEntityData.putFloat("BodyRotation", entity.getYRot());
            this.frozenEntityData.putFloat("HeadRotation", entity.getYHeadRot());
            this.frozenEntityData.putFloat("Pitch", entity.getXRot());
            this.frozenEntityData.putFloat("Height", entity.getBbHeight());
            this.frozenEntityData.putFloat("Width", entity.getBbWidth());
            this.frozenEntityData.putFloat("Scale", scale);
            this.frozenEntityData.putFloat("HeightScale", heightScale);
            this.frozenEntityData.putFloat("WidthScale", widthScale);
            if (entity instanceof KoopaTroopaEntity) {
                KoopaTroopaEntity koopa = (KoopaTroopaEntity)entity;
                koopa.hide(koopa.isHiding());
            }
            this.setSize(entity.getBbWidth() * scale * widthScale * 1.55f, entity.getBbHeight() * scale * heightScale * 1.55f);
            if (!(entity instanceof Player)) {
                entity.discard();
            }
            this.setEntityFrozenCooldown(ticksFrozen);
            this.entityData.set(FROZEN_DATA, (Object)this.frozenEntityData);
        }
    }

    @Nullable
    public Entity getPlayer(Level world) {
        Iterator iterator;
        CompoundTag tag = (CompoundTag)this.entityData.get(FROZEN_DATA);
        if (tag.isEmpty() && (iterator = world.players().iterator()).hasNext()) {
            Player player = (Player)iterator.next();
            return player;
        }
        return null;
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(Level world) {
        CompoundTag tag = (CompoundTag)this.entityData.get(FROZEN_DATA);
        if (tag.isEmpty()) {
            return null;
        }
        if (this.displayEntity == null) {
            if (!tag.contains("id", 8)) {
                return null;
            }
            this.displayEntity = EntityType.loadEntityRecursive((CompoundTag)tag, (Level)world, Function.identity());
            if (this.displayEntity != null) {
                Entity entity;
                if (tag.contains("BodyRotation")) {
                    this.displayEntity.setYBodyRot(tag.getFloat("BodyRotation"));
                }
                if (tag.contains("BodyRotation")) {
                    this.displayEntity.setYRot(tag.getFloat("BodyRotation"));
                }
                if (tag.contains("HeadRotation")) {
                    this.displayEntity.setYHeadRot(tag.getFloat("HeadRotation"));
                }
                if (tag.contains("Pitch")) {
                    this.displayEntity.setXRot(tag.getFloat("Pitch"));
                }
                if ((entity = this.displayEntity) instanceof LivingEntity) {
                    LivingEntity entity2 = (LivingEntity)entity;
                    entity2.hurtDuration = 0;
                    entity2.hurtTime = 0;
                    if (tag.contains("Scale")) {
                        float scale = tag.getFloat("Scale");
                        entity2.setBoundingBox(entity2.getBoundingBox().inflate((double)scale - 1.0));
                        entity2.getPersistentData().putFloat("Scale", scale);
                    }
                    if (tag.contains("HeightScale")) {
                        float scale = tag.getFloat("HeightScale");
                        entity2.setBoundingBox(entity2.getBoundingBox().inflate((double)scale - 1.0));
                        entity2.getPersistentData().putFloat("HeightScale", scale);
                    }
                    if (tag.contains("WidthScale")) {
                        float scale = tag.getFloat("WidthScale");
                        entity2.setBoundingBox(entity2.getBoundingBox().inflate((double)scale - 1.0));
                        entity2.getPersistentData().putFloat("WidthScale", scale);
                    }
                }
            }
        }
        return this.displayEntity;
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.displayEntity == null) {
            this.displayEntity = this.getOrCreateDisplayEntity(this.level());
        }
    }

    public void setSize(float width, float height) {
        this.height = height;
        this.width = width;
        this.setBoundingBox(new AABB(this.getX() - (double)(width / 2.0f), this.getY(), this.getZ() - (double)(width / 2.0f), this.getX() + (double)(width / 2.0f), this.getY() + (double)height, this.getZ() + (double)(width / 2.0f)));
    }

    public Vec2 getSize() {
        return new Vec2(this.width, this.height);
    }

    public CompoundTag getFrozenEntityData() {
        return this.frozenEntityData;
    }

    public void shatterIceCube(boolean applyFallDamage, boolean applyCollisionDamage, Entity attackingEntity) {
        ServerLevel serverWorld;
        Entity entity;
        Level level;
        float scale = 1.0f;
        float heightScale = 1.0f;
        float widthScale = 1.0f;
        if (this.frozenEntityData != null && (level = this.level()) instanceof ServerLevel && (entity = EntityType.loadEntityRecursive((CompoundTag)this.frozenEntityData, (Level)(serverWorld = (ServerLevel)level), e -> {
            e.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
            return e;
        })) != null) {
            serverWorld.addFreshEntity(entity);
            if (entity instanceof LivingEntity) {
                float damageAmount;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (applyFallDamage) {
                    damageAmount = Math.max(0.0f, this.fallDistance - (float)livingEntity.getMaxFallDistance());
                    livingEntity.hurt(this.level().damageSources().fall(), damageAmount);
                    livingEntity.hurtDuration = 10;
                    livingEntity.hurtTime = 10;
                    livingEntity.hurtMarked = true;
                }
                if (applyCollisionDamage && !livingEntity.getType().is(TagRegistry.ICE_CUBE_SHATTER_CANNOT_DAMAGE)) {
                    float f = damageAmount = livingEntity.getType().is(TagRegistry.ICE_CUBE_SHATTER_CAN_INSTAKILL) ? Float.MAX_VALUE : ((Double)ConfigRegistry.ICE_CUBE_DAMAGE.get()).floatValue();
                    if (this.getOwner() != null) {
                        livingEntity.hurt(DamageSourceRegistry.iceCubeCrushed((Entity)livingEntity, this.getOwner()), damageAmount);
                    } else {
                        livingEntity.hurt(DamageSourceRegistry.iceCubeCrushed((Entity)livingEntity, attackingEntity), damageAmount);
                    }
                    livingEntity.hurtDuration = 10;
                    livingEntity.hurtTime = 10;
                    livingEntity.hurtMarked = true;
                }
            }
            entity.setIsInPowderSnow(true);
            if (entity.canFreeze()) {
                entity.setTicksFrozen(((Integer)ConfigRegistry.ICE_CUBE_FREEZE_DURATION.get()).intValue());
            }
            this.level().playSound(entity, this.blockPosition(), SoundEvents.GLASS_BREAK, SoundSource.AMBIENT, 1.0f, 1.0f);
            this.level().gameEvent(entity, (Holder)GameEvent.BLOCK_DESTROY, this.blockPosition());
            if (entity.getPersistentData().contains("Scale")) {
                scale = entity.getPersistentData().getFloat("Scale");
            }
            if (entity.getPersistentData().contains("HeightScale")) {
                heightScale = entity.getPersistentData().getFloat("HeightScale");
            }
            if (entity.getPersistentData().contains("WidthScale")) {
                widthScale = entity.getPersistentData().getFloat("WidthScale");
            }
            float height = entity.getBbHeight() * scale * heightScale;
            float width = entity.getBbWidth() * scale * widthScale;
            if (entity.getBbHeight() >= entity.getBbWidth() * 3.0f) {
                width *= 2.0f;
            }
            float scaleFactor = height * width * 1.2f;
            int numParticles = (int)(scaleFactor * 10.0f);
            for (int i = 0; i < numParticles; ++i) {
                ServerParticleUtils.spawnEntityBreakParticles((ParticleOptions)ParticleRegistry.ICE_CUBE_SHATTER.get(), serverWorld, entity, height * 1.55f, width * 1.55f);
            }
        }
        if ((level = this.getControllingPassenger()) instanceof AbilitiesHandler) {
            AbilitiesHandler handler = (AbilitiesHandler)level;
            handler.mv$setFreezeImmunityCooldown(20);
        }
        this.ejectPassengers();
        this.discard();
        this.setRemoved(Entity.RemovalReason.DISCARDED);
    }

    private void collideWithWall(Level world, BlockPos pos) {
        if (!world.isClientSide) {
            BlockState hitState;
            BlockPos checkPos;
            AABB boundingBox = this.getBoundingBox();
            for (Direction direction : Direction.values()) {
                if (!direction.getAxis().isHorizontal() || this.getDeltaMovement().y != 0.0 || !(this.getDeltaMovement().horizontalDistance() > 0.0)) continue;
                for (BlockPos hitPos : BlockPos.betweenClosed((int)Mth.floor((double)boundingBox.minX), (int)Mth.floor((double)boundingBox.minY), (int)Mth.floor((double)boundingBox.minZ), (int)Mth.floor((double)boundingBox.maxX), (int)Mth.floor((double)boundingBox.maxY), (int)Mth.floor((double)boundingBox.maxZ))) {
                    checkPos = hitPos.relative(direction);
                    hitState = world.getBlockState(checkPos);
                    if (!hitState.isSolid()) continue;
                    this.shatterIceCube(false, true, (Entity)this);
                    return;
                }
            }
            for (Direction direction : Direction.values()) {
                for (BlockPos hitPos : BlockPos.betweenClosed((int)Mth.floor((double)boundingBox.minX), (int)Mth.floor((double)boundingBox.minY), (int)Mth.floor((double)boundingBox.minZ), (int)Mth.floor((double)boundingBox.maxX), (int)Mth.floor((double)boundingBox.maxY), (int)Mth.floor((double)boundingBox.maxZ))) {
                    checkPos = hitPos.relative(direction);
                    hitState = world.getBlockState(checkPos);
                    if (hitState.is(BlockTags.FIRE) || hitState.getFluidState().is(FluidTags.LAVA) || hitState.is(BlockTags.CAMPFIRES) && hitState.hasProperty((Property)BlockStateProperties.LIT) && ((Boolean)hitState.getValue((Property)BlockStateProperties.LIT)).booleanValue() || this.isOnFire()) {
                        if (hitState.is(BlockTags.FIRE)) {
                            world.setBlock(checkPos, Blocks.AIR.defaultBlockState(), 3);
                            if (!world.isClientSide()) {
                                world.levelEvent(null, 1009, checkPos, 0);
                            }
                        }
                        this.shatterIceCube(false, false, (Entity)this);
                    }
                    if (!hitState.hasProperty((Property)BlockStateProperties.LIT) || !((Boolean)hitState.getValue((Property)BlockStateProperties.LIT)).booleanValue()) continue;
                    hitState.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false));
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void collideWithEntity() {
        collisionBox = this.getBoundingBox().inflate(0.01, 0.0, 0.01);
        collisionBoxNoInflation = this.getBoundingBox();
        collidingEntities = this.level().getEntities((Entity)this, collisionBox);
        collidingEntitiesNoInflation = this.level().getEntities((Entity)this, collisionBoxNoInflation);
        for (Entity entity : collidingEntities) {
            block10: {
                if (!(this.getDeltaMovement().horizontalDistance() > 0.0)) break block10;
                if (!(entity instanceof IceCubeEntity)) ** GOTO lbl-1000
                otherIceCube = (IceCubeEntity)entity;
                if (this.getDeltaMovement().horizontalDistance() >= 0.2 || this.getDeltaMovement().horizontalDistance() <= -0.2) {
                    this.shatterIceCube(false, true, (Entity)this);
                    otherIceCube.shatterIceCube(false, true, (Entity)this);
                } else if (entity instanceof LivingEntity) {
                    livingEntity = (LivingEntity)entity;
                    if ((this.getDeltaMovement().horizontalDistance() >= 0.5 || this.getDeltaMovement().horizontalDistance() <= -0.5) && !livingEntity.getType().is(TagRegistry.ICE_CUBE_COLLISION_CANNOT_DAMAGE)) {
                        shield = livingEntity.getUseItem();
                        toIceCube = this.position().subtract(livingEntity.position()).normalize();
                        look = livingEntity.getLookAngle().normalize();
                        dot = toIceCube.dot(look);
                        if (livingEntity.isBlocking() && dot > 0.25) {
                            this.deflect(entity, (Entity)livingEntity, true);
                            shield.hurtAndBreak(1, livingEntity, LivingEntity.getSlotForHand((InteractionHand)livingEntity.getUsedItemHand()));
                            this.level().playSound(null, this.blockPosition(), SoundEvents.SHIELD_BLOCK, SoundSource.NEUTRAL, 1.0f, 1.0f);
                            continue;
                        }
                        if (this.getOwner() != null) {
                            livingEntity.hurt(DamageSourceRegistry.iceCubeCrushed((Entity)livingEntity, this.getOwner()), ((Double)ConfigRegistry.ICE_CUBE_DAMAGE.get()).floatValue());
                        } else {
                            livingEntity.hurt(DamageSourceRegistry.iceCubeCrushed((Entity)livingEntity, (Entity)this), ((Double)ConfigRegistry.ICE_CUBE_DAMAGE.get()).floatValue());
                        }
                    }
                }
            }
            if (!(entity instanceof AbstractArrow)) continue;
            arrow = (AbstractArrow)entity;
            this.shatterIceCube(false, false, (Entity)this);
            if (arrow.isOnFire()) {
                arrow.extinguishFire();
            }
            if (!(arrow instanceof SpectralArrow)) continue;
            this.setGlowingTag(true);
        }
        for (Entity entity : collidingEntitiesNoInflation) {
            entity.extinguishFire();
            if (!(entity instanceof Player) || (player = (Player)entity).isCreative()) continue;
            entity.setIsInPowderSnow(true);
            if (!player.canFreeze()) continue;
            entity.setTicksFrozen(((Integer)ConfigRegistry.ICE_CUBE_FREEZE_DURATION.get()).intValue());
        }
    }

    private boolean isOnSolidGround() {
        BlockPos posBelow = this.blockPosition().below();
        return this.level().getBlockState(posBelow).isSolidRender((BlockGetter)this.level(), posBelow);
    }

    private void gravityWaterPhysics() {
        boolean isRising;
        Vec3 velocity = this.getDeltaMovement();
        Vec3 vecPos = this.position();
        float entityHeight = this.getBbHeight();
        if (this.displayEntity != null) {
            entityHeight = this.displayEntity.getBbHeight();
        }
        AABB aabb = this.getBoundingBox();
        if (this.displayEntity != null) {
            aabb = this.displayEntity.getBoundingBox();
        }
        double entityTop = aabb.maxY + (double)entityHeight;
        boolean isUnderwater = false;
        double waterLevel = 0.0;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int x = Mth.floor((double)aabb.minX); x < Mth.ceil((double)aabb.maxX); ++x) {
            for (int y = Mth.floor((double)aabb.minY); y < Mth.ceil((double)entityTop); ++y) {
                for (int z = Mth.floor((double)aabb.minZ); z < Mth.ceil((double)aabb.maxZ); ++z) {
                    blockPos.set(x, y, z);
                    FluidState fluidState = this.level().getFluidState((BlockPos)blockPos);
                    if (fluidState.isEmpty()) continue;
                    double fluidHeight = fluidState.getHeight((BlockGetter)this.level(), (BlockPos)blockPos);
                    if (!(entityTop < (waterLevel = Math.max(waterLevel, (double)blockPos.getY() + fluidHeight)))) continue;
                    isUnderwater = true;
                }
            }
        }
        BlockState stateAbove = this.level().getBlockState(BlockPos.containing((double)vecPos.x, (double)(vecPos.y + (double)entityHeight), (double)vecPos.z));
        boolean isAirAbove = stateAbove.isAir();
        double waterDrag = 0.9;
        boolean isSinking = vecPos.y + (double)entityHeight / 3.0 >= waterLevel;
        boolean bl = isRising = vecPos.y + (double)entityHeight / 2.0 >= waterLevel;
        if (!this.isOnSolidGround() && this.fallDistance > this.previousFallDistance) {
            this.previousFallDistance = this.fallDistance;
        }
        if (this.isOnSolidGround() && this.previousFallDistance > 3.0f) {
            this.shatterIceCube(true, false, (Entity)this);
            this.previousFallDistance = 0.0f;
        }
        if (this.isInWaterOrBubble() && isAirAbove && !isRising && !isUnderwater) {
            this.setDeltaMovement(velocity.x * waterDrag, 0.01, velocity.z * waterDrag);
        } else if (this.isInWaterOrBubble() && isAirAbove && isRising && isSinking && !isUnderwater) {
            this.setDeltaMovement(velocity.x * waterDrag, -0.01, velocity.z * waterDrag);
        } else if (isUnderwater && !isRising) {
            this.setDeltaMovement(velocity.x * waterDrag, 0.03, velocity.z * waterDrag);
        } else if (!(this.isOnSolidGround() || this.isInWaterOrBubble() || this.level().isClientSide())) {
            if (this.getTicksInAir() == 0) {
                Mob mob;
                Entity entity = this.displayEntity;
                if (entity instanceof Mob && !(mob = (Mob)entity).isNoAi()) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, -this.getDefaultGravity(), 0.0));
                } else if (!(this.displayEntity instanceof Mob)) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, -this.getDefaultGravity(), 0.0));
                }
            } else {
                this.setDeltaMovement(0.0, 0.0, 0.0);
            }
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    protected void spawnSnowParticles() {
        BlockPos posLegacy = this.getOnPosLegacy();
        BlockState state = this.level().getBlockState(posLegacy);
        if (!state.addRunningEffects(this.level(), posLegacy, (Entity)this) && state.getRenderShape() != RenderShape.INVISIBLE) {
            Vec3 vec3 = this.getDeltaMovement();
            BlockPos pos = this.blockPosition();
            double x = this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getSize().x;
            double z = this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getSize().x;
            if (pos.getX() != posLegacy.getX()) {
                x = Mth.clamp((double)x, (double)posLegacy.getX(), (double)((double)posLegacy.getX() + 1.0));
            }
            if (pos.getZ() != posLegacy.getZ()) {
                z = Mth.clamp((double)z, (double)posLegacy.getZ(), (double)((double)posLegacy.getZ() + 1.0));
            }
            if (!this.isInWaterOrBubble()) {
                this.level().addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, x, this.getY() + 0.1, z, vec3.x * -2.0, 0.0, vec3.z * -2.0);
                this.level().addParticle((ParticleOptions)ParticleRegistry.ICE_CUBE_SHATTER.get(), x, this.getY() + 0.1, z, vec3.x * -2.0, 0.0, vec3.z * -2.0);
            }
            this.level().addParticle((ParticleOptions)ParticleRegistry.ICE_STAR.get(), x, this.getY() + 0.1, z, vec3.x * -4.0, 1.5, vec3.z * -4.0);
        }
    }

    public int getFrozenCooldown() {
        return this.frozenCooldown;
    }

    public void setFrozenCooldown(int frozenCooldown) {
        this.frozenCooldown = frozenCooldown;
    }

    public int getEntityFrozenCooldown() {
        return this.getPersistentData().getInt("EntityFrozenCooldown");
    }

    public void setEntityFrozenCooldown(int entityFrozenCooldown) {
        this.getPersistentData().putInt("EntityFrozenCooldown", entityFrozenCooldown);
    }

    public int getTicksInAir() {
        return this.ticksInAir;
    }

    public void setTicksInAir(int ticksInAir) {
        this.ticksInAir = ticksInAir;
    }
}

