/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities.ai.goals;

import com.wenxin2.marioverse.entities.BooEntity;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class FreezeWhenLookedAt
extends Goal {
    private final Mob mob;
    @Nullable
    private LivingEntity target;
    private final TagKey<EntityType<?>> entityTag;
    private static final double MAX_DISTANCE_SQR = 256.0;
    private static final double FOV_ANGLE = 160.0;

    public FreezeWhenLookedAt(Mob mob, TagKey<EntityType<?>> entityTag) {
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        this.entityTag = entityTag;
        this.mob = mob;
    }

    public boolean canUse() {
        this.target = this.mob.getTarget();
        if (this.target == null) {
            return false;
        }
        if (this.target.getType().is(this.entityTag)) {
            Vec3 toMob;
            Vec3 posEye = this.target.getEyePosition();
            Vec3 posMob = this.mob.position();
            double distance = posEye.distanceToSqr(posMob);
            Vec3 targetView = this.target.getViewVector(1.0f).normalize();
            double dot = targetView.dot(toMob = this.mob.position().subtract(posEye).normalize());
            return dot > Math.cos(Math.toRadians(80.0)) && distance <= 256.0;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public void start() {
        this.mob.getNavigation().stop();
        this.mob.setDeltaMovement(Vec3.ZERO);
        this.mob.setSpeed(0.0f);
        this.mob.getLookControl().setLookAt(this.mob.getX(), this.mob.getY(), this.mob.getZ());
        this.mob.setYHeadRot(this.mob.getYRot());
        this.mob.yBodyRot = this.mob.getYRot();
        if (this.mob instanceof BooEntity) {
            this.mob.setData(DataAttachmentRegistry.IS_HIDING.get(), (Object)true);
            this.mob.playSound((SoundEvent)SoundRegistry.BOO_HIDE.get(), 1.0f, 1.0f);
        }
    }

    public void tick() {
        if (this.target != null) {
            this.mob.getLookControl().setLookAt(this.target.getX(), this.target.getEyeY(), this.target.getZ());
        }
    }

    public void stop() {
        this.target = null;
        if (this.mob instanceof BooEntity) {
            this.mob.setData(DataAttachmentRegistry.IS_HIDING.get(), (Object)false);
        }
    }
}

