/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities.ai.goals;

import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class NearestAttackableTagGoal
extends TargetGoal {
    protected final int randomInterval;
    @Nullable
    protected LivingEntity target;
    protected TargetingConditions targetConditions;
    private final TagKey<EntityType<?>> entityTag;

    public NearestAttackableTagGoal(Mob mob, TagKey<EntityType<?>> entityTag, boolean mustSee) {
        this(mob, entityTag, 10, mustSee, false, null);
    }

    public NearestAttackableTagGoal(Mob mob, TagKey<EntityType<?>> entityTag, int randomInterval, boolean mustSee, boolean mustReach, @Nullable Predicate<LivingEntity> selector) {
        super(mob, mustSee, mustReach);
        this.randomInterval = NearestAttackableTagGoal.reducedTickDelay((int)randomInterval);
        this.entityTag = entityTag;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        this.targetConditions = TargetingConditions.forCombat().range(this.getFollowDistance()).selector(selector);
    }

    public boolean canUse() {
        Player player;
        if (this.randomInterval > 0 && this.mob.getRandom().nextInt(this.randomInterval) != 0 || ((Boolean)this.mob.getData(DataAttachmentRegistry.IS_HIDING.get())).booleanValue()) {
            return false;
        }
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player && (player = (Player)livingEntity).isCreative()) {
            return false;
        }
        this.findTarget();
        return this.target != null;
    }

    public boolean canContinueToUse() {
        if (this.target == null) {
            return false;
        }
        if (!this.target.isAlive()) {
            return false;
        }
        if (!this.target.getType().is(this.entityTag)) {
            return false;
        }
        double distanceSq = this.mob.distanceToSqr((Entity)this.target);
        return distanceSq <= this.getFollowDistance() * this.getFollowDistance();
    }

    protected AABB getTargetSearchArea(double followDistance) {
        return this.mob.getBoundingBox().inflate(followDistance, 8.0, followDistance);
    }

    protected void findTarget() {
        List potentialTargets;
        if (!(this.target != null && this.target.isAlive() && this.target.getType().is(this.entityTag) || (potentialTargets = this.mob.level().getEntitiesOfClass(LivingEntity.class, this.getTargetSearchArea(this.getFollowDistance()), entity -> entity.getType().is(this.entityTag))).isEmpty())) {
            this.target = this.mob.level().getNearestEntity(potentialTargets, this.targetConditions, (LivingEntity)this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ());
        }
    }

    public void start() {
        this.mob.setTarget(this.target);
        this.mob.setData(DataAttachmentRegistry.IS_ATTACKING.get(), (Object)true);
        super.start();
    }

    public void stop() {
        this.mob.setData(DataAttachmentRegistry.IS_ATTACKING.get(), (Object)false);
    }

    public void setTarget(@Nullable LivingEntity target) {
        this.target = target;
    }
}

