/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.event_handlers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.wenxin2.marioverse.blocks.ClearWarpPipeBlock;
import com.wenxin2.marioverse.client.renderers.SuperStarRenderType;
import com.wenxin2.marioverse.registries.BlockRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.sounds.FadeInAndOutSoundInstance;
import com.wenxin2.marioverse.sounds.FadingSoundInstance;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="marioverse", value={Dist.CLIENT})
public class ClientEventHandlers {
    public static final Map<UUID, FadeInAndOutSoundInstance> ACTIVE_PIPE_SOUNDS = new HashMap<UUID, FadeInAndOutSoundInstance>();
    private static final ResourceLocation OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/misc/splunkin_pumpkin_blur.png");

    @SubscribeEvent
    public static void registerShaders(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"super_star_shader"), DefaultVertexFormat.POSITION_TEX_COLOR), shader -> {
            SuperStarRenderType.SUPER_STAR_SHADER = shader;
        });
    }

    @SubscribeEvent
    public static void onClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            public void renderHelmetOverlay(ItemStack stack, Player player, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
                ClientEventHandlers.renderCustomOverlay(guiGraphics, OVERLAY, 1.0f);
            }
        }, new Item[]{((Block)BlockRegistry.SPLUNKIN_CARVED_PUMPKIN.get()).asItem()});
    }

    @SubscribeEvent
    public static void onEntityRemoved(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        UUID uuid = entity.getUUID();
        if (!(event.getLevel() instanceof ClientLevel)) {
            return;
        }
        if (ACTIVE_PIPE_SOUNDS.get(uuid) != null) {
            ACTIVE_PIPE_SOUNDS.get(uuid).startFadeOut();
            entity.setData(DataAttachmentRegistry.PLAYED_INSIDE_PIPE_SOUND, (Object)false);
        }
    }

    @SubscribeEvent
    public static void postEntityTick(EntityTickEvent.Post event) {
        boolean isEntrance;
        Entity entity = event.getEntity();
        UUID uuid = entity.getUUID();
        Level world = entity.level();
        BlockPos pos = entity.blockPosition();
        BlockState state = world.getBlockState(pos);
        boolean inClearPipe = state.getBlock() instanceof ClearWarpPipeBlock;
        boolean bl = isEntrance = state.hasProperty((Property)ClearWarpPipeBlock.ENTRANCE) && (Boolean)state.getValue((Property)ClearWarpPipeBlock.ENTRANCE) != false;
        if (!(entity.level() instanceof ClientLevel)) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (((Boolean)entity.getData(DataAttachmentRegistry.HAS_SUPER_STAR)).booleanValue() && !((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_SUPER_STAR_THEME)).booleanValue()) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)new FadingSoundInstance(livingEntity, (SoundEvent)SoundRegistry.SUPER_STAR_THEME.get(), SoundSource.AMBIENT, entity.getRandom(), ((Integer)entity.getData(DataAttachmentRegistry.SUPER_STAR_COOLDOWN)).intValue(), 100.0f));
                entity.setData(DataAttachmentRegistry.PLAYED_SUPER_STAR_THEME, (Object)true);
            }
        }
        if (((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_EXIT_PIPE_SOUND)).booleanValue() && !((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_ENTER_PIPE_SOUND)).booleanValue() && inClearPipe && isEntrance) {
            entity.playSound((SoundEvent)SoundRegistry.CLEAR_PIPE_ENTER.get(), 1.0f, 1.0f);
            entity.setData(DataAttachmentRegistry.PLAYED_ENTER_PIPE_SOUND, (Object)true);
            entity.setData(DataAttachmentRegistry.PLAYED_EXIT_PIPE_SOUND, (Object)false);
        }
        if (((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_ENTER_PIPE_SOUND)).booleanValue() && !((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_EXIT_PIPE_SOUND)).booleanValue() && !inClearPipe) {
            entity.playSound((SoundEvent)SoundRegistry.CLEAR_PIPE_EXIT.get(), 1.0f, 1.0f);
            entity.setData(DataAttachmentRegistry.PLAYED_EXIT_PIPE_SOUND, (Object)true);
            entity.setData(DataAttachmentRegistry.PLAYED_ENTER_PIPE_SOUND, (Object)false);
        }
        if (((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_ENTER_PIPE_SOUND)).booleanValue() && !((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_EXIT_PIPE_SOUND)).booleanValue() && !((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_INSIDE_PIPE_SOUND)).booleanValue() && inClearPipe) {
            FadeInAndOutSoundInstance insideSound = new FadeInAndOutSoundInstance(entity, (SoundEvent)SoundRegistry.CLEAR_PIPE_INSIDE.get(), SoundSource.BLOCKS, 20.0f, 10.0f);
            ACTIVE_PIPE_SOUNDS.put(uuid, insideSound);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)insideSound);
            entity.setData(DataAttachmentRegistry.PLAYED_INSIDE_PIPE_SOUND, (Object)true);
        }
        if (((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_INSIDE_PIPE_SOUND)).booleanValue() && !inClearPipe) {
            FadeInAndOutSoundInstance active = ACTIVE_PIPE_SOUNDS.get(uuid);
            if (active != null) {
                active.startFadeOut();
            }
            ACTIVE_PIPE_SOUNDS.remove(uuid);
            entity.setData(DataAttachmentRegistry.PLAYED_INSIDE_PIPE_SOUND, (Object)false);
        }
    }

    private static void renderCustomOverlay(GuiGraphics guiGraphics, ResourceLocation texture, float alpha) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        guiGraphics.blit(texture, 0, 0, -90, 0.0f, 0.0f, guiGraphics.guiWidth(), guiGraphics.guiHeight(), guiGraphics.guiWidth(), guiGraphics.guiHeight());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

