/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.mixin;

import com.wenxin2.marioverse.registries.ItemRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.DecoratedPotPattern;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DecoratedPotPatterns.class})
public class DecoratedPotPatternsMixin {
    @Unique
    private static final ResourceKey<DecoratedPotPattern> MV$BOWSER = DecoratedPotPatternsMixin.mv$create("bowser");
    @Unique
    private static final ResourceKey<DecoratedPotPattern> MV$PLUMBER = DecoratedPotPatternsMixin.mv$create("plumber");

    @Inject(method={"getPatternFromItem"}, at={@At(value="TAIL")}, cancellable=true)
    private static void getResourceKey(Item item, CallbackInfoReturnable<ResourceKey<DecoratedPotPattern>> cir) {
        if (cir.getReturnValue() == null) {
            if (item == ItemRegistry.BOWSER_POTTERY_SHERD.get()) {
                cir.setReturnValue(MV$BOWSER);
            }
            if (item == ItemRegistry.PLUMBER_POTTERY_SHERD.get()) {
                cir.setReturnValue(MV$PLUMBER);
            }
        }
    }

    @Inject(method={"bootstrap"}, at={@At(value="TAIL")})
    private static void bootstrap(Registry<DecoratedPotPattern> registry, CallbackInfoReturnable<DecoratedPotPattern> cir) {
        DecoratedPotPatternsMixin.mv$register(registry, MV$BOWSER, "bowser_pottery_pattern");
        DecoratedPotPatternsMixin.mv$register(registry, MV$PLUMBER, "plumber_pottery_pattern");
    }

    @Unique
    private static ResourceKey<DecoratedPotPattern> mv$create(String name) {
        return ResourceKey.create((ResourceKey)Registries.DECORATED_POT_PATTERN, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)name));
    }

    @Unique
    private static void mv$register(Registry<DecoratedPotPattern> registry, ResourceKey<DecoratedPotPattern> pattern, String name) {
        Registry.register(registry, pattern, (Object)new DecoratedPotPattern(ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)name)));
    }
}

