/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.mixin;

import com.wenxin2.marioverse.blocks.CheckpointFlagBlock;
import com.wenxin2.marioverse.blocks.states.TripleBlockStates;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import com.wenxin2.marioverse.utils.BlockWarpPlayerHandler;
import com.wenxin2.marioverse.utils.EntityWarpPlayerHandler;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public class ServerPlayerMixin
implements BlockWarpPlayerHandler,
EntityWarpPlayerHandler,
AbilitiesHandler {
    @Unique
    private boolean mv$hasFireFlower;
    @Unique
    private boolean mv$hasIceFlower;
    @Unique
    private boolean mv$hasMegaMushroom;
    @Unique
    private boolean mv$hasSuperMushroom;
    @Unique
    private boolean mv$hasDashMushroomBoost;
    @Unique
    private boolean mv$hasSuperMushroomOverride;
    @Unique
    private boolean mv$preventWarp;
    @Unique
    private int mv$checkpointFlagCooldown;
    @Unique
    private int mv$consecutiveBounces;
    @Unique
    private int mv$fireballCooldown;
    @Unique
    private int mv$fireballCount;
    @Unique
    private int mv$freezeImmunityCooldown;
    @Unique
    private int mv$frozenCooldown;
    @Unique
    private int mv$iceBallCooldown;
    @Unique
    private int mv$iceBallCount;
    @Unique
    private int mv$oneUpsRewarded;
    @Unique
    private int mv$preventWarpCooldown;
    @Unique
    private int mv$warpCooldown;

    @Override
    public boolean mv$getBlockWarpTeleportConfig() {
        return (Boolean)ConfigRegistry.TELEPORT_PLAYERS.get();
    }

    @Override
    public boolean mv$getEntityWarpTeleportConfig() {
        return (Boolean)ConfigRegistry.TELEPORT_PLAYERS.get();
    }

    @Inject(method={"findRespawnAndUseSpawnBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private static void findRespawnAndUseSpawnBlock(ServerLevel world, BlockPos pos, float angle, boolean forced, boolean anchor, CallbackInfoReturnable<Optional<ServerPlayer.RespawnPosAngle>> cir) {
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof CheckpointFlagBlock) {
            Vec3 spawnPos = state.getValue(CheckpointFlagBlock.PART) == TripleBlockStates.TOP ? Vec3.atBottomCenterOf((Vec3i)pos.below(2)) : (state.getValue(CheckpointFlagBlock.PART) == TripleBlockStates.MIDDLE ? Vec3.atBottomCenterOf((Vec3i)pos.below()) : Vec3.atBottomCenterOf((Vec3i)pos));
            cir.setReturnValue(Optional.of(new ServerPlayer.RespawnPosAngle(spawnPos, angle)));
        }
    }

    @Override
    public void mv$clearAllPowerUps() {
        this.mv$setFireFlower(false);
        this.mv$setIceFlower(false);
    }

    @Override
    public boolean mv$hasSuperMushroom() {
        return this.mv$hasSuperMushroom;
    }

    @Override
    public void mv$setSuperMushroom(boolean hasSuperMushroom) {
        this.mv$hasSuperMushroom = hasSuperMushroom;
    }

    @Override
    public boolean mv$hasSuperMushroomOverride() {
        return this.mv$hasSuperMushroomOverride;
    }

    @Override
    public void mv$setMushroomOverride(boolean hasSuperMushroomOverride) {
        this.mv$hasSuperMushroomOverride = hasSuperMushroomOverride;
    }

    @Override
    public boolean mv$hasDashMushroomBoost() {
        return this.mv$hasDashMushroomBoost;
    }

    @Override
    public void mv$setDashMushroomBoost(boolean hasDashMushroomBoost) {
        this.mv$hasDashMushroomBoost = hasDashMushroomBoost;
    }

    @Override
    public boolean mv$hasMegaMushroom() {
        return this.mv$hasMegaMushroom;
    }

    @Override
    public void mv$setMegaMushroom(boolean hasMegaMushroom) {
        this.mv$hasMegaMushroom = hasMegaMushroom;
    }

    @Override
    public boolean mv$hasFireFlower() {
        return this.mv$hasFireFlower;
    }

    @Override
    public void mv$setFireFlower(boolean hasFireFlower) {
        this.mv$hasFireFlower = hasFireFlower;
    }

    @Override
    public boolean mv$hasIceFlower() {
        return this.mv$hasIceFlower;
    }

    @Override
    public void mv$setIceFlower(boolean hasIceFlower) {
        this.mv$hasIceFlower = hasIceFlower;
    }

    @Override
    public int mv$getFireballCooldown() {
        return this.mv$fireballCooldown;
    }

    @Override
    public void mv$setFireballCooldown(int fireballCooldown) {
        this.mv$fireballCooldown = fireballCooldown;
    }

    @Override
    public int mv$getFireballCount() {
        return this.mv$fireballCount;
    }

    @Override
    public void mv$setFireballCount(int fireballCount) {
        this.mv$fireballCount = fireballCount;
    }

    @Override
    public int mv$getIceBallCooldown() {
        return this.mv$iceBallCooldown;
    }

    @Override
    public void mv$setIceBallCooldown(int iceBallCooldown) {
        this.mv$iceBallCooldown = iceBallCooldown;
    }

    @Override
    public int mv$getIceBallCount() {
        return this.mv$iceBallCount;
    }

    @Override
    public void mv$setIceBallCount(int iceBallCount) {
        this.mv$iceBallCount = iceBallCount;
    }

    @Override
    public int mv$getConsecutiveBounces() {
        return this.mv$consecutiveBounces;
    }

    @Override
    public void mv$setConsecutiveBounces(int consecutiveBounces) {
        this.mv$consecutiveBounces = consecutiveBounces;
    }

    @Override
    public int mv$getOneUpsRewarded() {
        return this.mv$oneUpsRewarded;
    }

    @Override
    public void mv$setOneUpsRewarded(int oneUpsRewarded) {
        this.mv$oneUpsRewarded = oneUpsRewarded;
    }

    @Override
    public boolean mv$doPreventWarp() {
        return this.mv$preventWarp;
    }

    @Override
    public void mv$setPreventWarp(boolean preventWarp) {
        this.mv$preventWarp = preventWarp;
    }

    @Override
    public int mv$getPreventWarpCooldown() {
        return this.mv$preventWarpCooldown;
    }

    @Override
    public void mv$setPreventWarpCooldown(int preventWarpCooldown) {
        this.mv$preventWarpCooldown = preventWarpCooldown;
    }

    @Override
    public int mv$getWarpCooldown() {
        return this.mv$warpCooldown;
    }

    @Override
    public void mv$setWarpCooldown(int warpCooldown) {
        this.mv$warpCooldown = warpCooldown;
    }

    @Override
    public int mv$getCheckpointFlagCooldown() {
        return this.mv$checkpointFlagCooldown;
    }

    @Override
    public void mv$setCheckpointFlagCooldown(int checkpointFlagCooldown) {
        this.mv$checkpointFlagCooldown = checkpointFlagCooldown;
    }

    @Override
    public int mv$getFreezeImmunityCooldown() {
        return this.mv$freezeImmunityCooldown;
    }

    @Override
    public void mv$setFreezeImmunityCooldown(int freezeImmunityCooldown) {
        this.mv$freezeImmunityCooldown = freezeImmunityCooldown;
    }

    @Override
    public int mv$getFrozenCooldown() {
        return this.mv$frozenCooldown;
    }

    @Override
    public void mv$setFrozenCooldown(int frozenCooldown) {
        this.mv$frozenCooldown = frozenCooldown;
    }
}

