/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.utils;

import com.wenxin2.marioverse.blocks.WarpPipeBlock;
import com.wenxin2.marioverse.blocks.entities.BaseWarpBlockEntity;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.BlockWarpEntityHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public interface BlockWarpPlayerHandler
extends BlockWarpEntityHandler {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    default public void enterWarpDoor(Entity entity, Level world, BlockPos pos, BlockPos warpPos, BaseWarpBlockEntity warpBE) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.mv$getBlockWarpTeleportConfig() || player.getType().is(TagRegistry.CANNOT_WARP) || this.mv$doPreventWarp()) {
                this.displayNoTeleportMessage(player, world.getBlockState(pos));
                return;
            }
        }
        BlockWarpEntityHandler.super.enterWarpDoor(entity, world, pos, warpPos, warpBE);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    default public void enterWarpPipe(Entity entity, Level world, BlockPos pos, BlockPos warpPos, BaseWarpBlockEntity warpBE) {
        BlockState state = world.getBlockState(pos);
        double entityX = entity.getX();
        double entityY = entity.getY();
        double entityZ = entity.getZ();
        int blockX = pos.getX();
        int blockY = pos.getY();
        int blockZ = pos.getZ();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.mv$getBlockWarpTeleportConfig() || entity.getType().is(TagRegistry.CANNOT_WARP) || this.mv$doPreventWarp()) {
                if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.UP && entity.isShiftKeyDown() && entityY + (double)entity.getBbHeight() >= (double)(blockY - 1) && entityX < (double)(blockX + 1) && entityX > (double)blockX && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                    this.displayNoTeleportMessage(player, state);
                }
                if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.NORTH && !entity.isShiftKeyDown() && entity.getMotionDirection() == Direction.SOUTH && entityX < (double)(blockX + 1) && entityX > (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ < (double)blockZ) {
                    this.displayNoTeleportMessage(player, state);
                }
                if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.SOUTH && !entity.isShiftKeyDown() && entity.getMotionDirection() == Direction.NORTH && entityX < (double)(blockX + 1) && entityX > (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ > (double)blockZ + 0.25) {
                    this.displayNoTeleportMessage(player, state);
                }
                if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.EAST && !entity.isShiftKeyDown() && entity.getMotionDirection() == Direction.WEST && entityX > (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                    this.displayNoTeleportMessage(player, state);
                }
                if (state.getValue((Property)WarpPipeBlock.FACING) != Direction.WEST) return;
                if (entity.isShiftKeyDown()) return;
                if (entity.getMotionDirection() != Direction.EAST) return;
                if (!(entityX < (double)blockX)) return;
                if (!(entityY >= (double)blockY)) return;
                if (!(entityY < (double)blockY + 0.75)) return;
                if (!(entityZ < (double)(blockZ + 1))) return;
                if (!(entityZ > (double)blockZ)) return;
                this.displayNoTeleportMessage(player, state);
                return;
            }
        }
        BlockWarpEntityHandler.super.enterWarpPipe(entity, world, pos, warpPos, warpBE);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    default public void enterWarpPipeAbove(Entity entity, Level world, BlockPos pos, BlockPos warpPos, BaseWarpBlockEntity warpBE) {
        BlockState stateAboveEntity = world.getBlockState(pos.above(Math.round(entity.getBbHeight())));
        double entityX = entity.getX();
        double entityZ = entity.getZ();
        int blockX = pos.getX();
        int blockY = pos.getY();
        int blockZ = pos.getZ();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.mv$getBlockWarpTeleportConfig() || entity.getType().is(TagRegistry.CANNOT_WARP) || this.mv$doPreventWarp()) {
                if (stateAboveEntity.getValue((Property)WarpPipeBlock.FACING) != Direction.DOWN) return;
                if (entity.getBlockY() >= blockY) return;
                if (!(entityX < (double)(blockX + 1))) return;
                if (!(entityX > (double)blockX)) return;
                if (!(entityZ < (double)(blockZ + 1))) return;
                if (!(entityZ > (double)blockZ)) return;
                this.displayNoTeleportMessage(player, stateAboveEntity);
                return;
            }
        }
        BlockWarpEntityHandler.super.enterWarpPipeAbove(entity, world, pos, warpPos, warpBE);
    }

    private void displayNoTeleportMessage(Player player, BlockState state) {
        if (!this.mv$getBlockWarpTeleportConfig() || player.getType().is(TagRegistry.CANNOT_WARP)) {
            if (state.getBlock() instanceof WarpPipeBlock) {
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.pipes_cannot_teleport_players"), true);
            } else if (state.getBlock() instanceof DoorBlock) {
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.doors_cannot_teleport_players"), true);
            } else if (state.getBlock() instanceof TrapDoorBlock) {
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.trapdoors_cannot_teleport_players"), true);
            }
        }
        if (this.mv$doPreventWarp()) {
            player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.warp_disrupted_player"), true);
        }
    }
}

