/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.utils;

import com.wenxin2.marioverse.entities.WarpLinkableEntity;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.EntityWarpEntityHandler;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public interface EntityWarpPlayerHandler
extends EntityWarpEntityHandler {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    default public void enterWarpPainting(Entity entity, Level world, WarpLinkableEntity warpLinkableEntity, Entity warpEntity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.mv$getEntityWarpTeleportConfig() || player.getType().is(TagRegistry.CANNOT_WARP) || this.mv$doPreventWarp()) {
                this.displayNoTeleportMessage(player, warpEntity);
                return;
            }
        }
        EntityWarpEntityHandler.super.enterWarpPainting(entity, world, warpLinkableEntity, warpEntity);
    }

    private void displayNoTeleportMessage(Player player, Entity warpEntity) {
        if (warpEntity instanceof Painting && (!this.mv$getEntityWarpTeleportConfig() || player.getType().is(TagRegistry.CANNOT_WARP))) {
            player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.paintings_cannot_teleport_players"), true);
        }
        if (this.mv$doPreventWarp()) {
            player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.warp_disrupted_player"), true);
        }
    }
}

