/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks;

import com.wenxin2.marioverse.blocks.BaseEntityDirectionalBlock;
import com.wenxin2.marioverse.blocks.entities.PottedPiranhaPlantBlockEntity;
import com.wenxin2.marioverse.entities.PiranhaPlantEntity;
import com.wenxin2.marioverse.registries.BlockEntityRegistry;
import com.wenxin2.marioverse.registries.DamageTypeRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PottedPiranhaPlantBlock
extends FlowerPotBlock
implements EntityBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;

    public PottedPiranhaPlantBlock(@Nullable Supplier<FlowerPotBlock> emptyPot, Supplier<? extends Block> block, BlockBehaviour.Properties properties) {
        super(emptyPot, block, properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.X));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AXIS});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PottedPiranhaPlantBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return BaseEntityDirectionalBlock.createTickerHelper(type, (BlockEntityType)BlockEntityRegistry.POTTED_PIRANHA_PLANT_BLOCK_ENTITY.get(), PottedPiranhaPlantBlockEntity::tick);
    }

    @NotNull
    public ItemStack getCloneItemStack(LevelReader worldReader, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ItemRegistry.PIRANHA_PLANT_POD.get());
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.getPotted() != Blocks.AIR) {
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
            ItemStack stack = new ItemStack((ItemLike)ItemRegistry.PIRANHA_PLANT_POD.get());
            if (!player.addItem(stack)) {
                player.drop(stack, false);
            }
            world.setBlock(pos, Blocks.FLOWER_POT.defaultBlockState(), 3);
            world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    protected void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        super.entityInside(state, world, pos, entity);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof PottedPiranhaPlantBlockEntity) {
            PottedPiranhaPlantBlockEntity blockEntity2 = (PottedPiranhaPlantBlockEntity)blockEntity;
            if (entity instanceof LivingEntity) {
                if (blockEntity2.attackCooldown > 0) {
                    return;
                }
                if (entity instanceof PiranhaPlantEntity || entity.isSpectator()) {
                    return;
                }
                if (blockEntity2.getOwner() != null && blockEntity2.getOwner().getUUID().equals(entity.getUUID())) {
                    return;
                }
                if (blockEntity2.getOwner() != null && entity.getTeam() != null && blockEntity2.getOwner().getTeam() != null && entity.getTeam() == blockEntity2.getOwner().getTeam()) {
                    return;
                }
                if (blockEntity2.getOwner() != null && !(entity instanceof Monster) && !entity.getType().is(TagRegistry.PIRANHA_PLANT_CAN_ATTACK) || blockEntity2.getOwner() == null && !entity.getType().is(TagRegistry.PIRANHA_PLANT_CAN_ATTACK)) {
                    return;
                }
                float attackDamage = 2.0f;
                if (blockEntity2.getOwner() != null) {
                    entity.hurt(DamageTypeRegistry.piranhaChomp(entity, blockEntity2.getOwner()), attackDamage);
                } else {
                    entity.hurt(world.damageSources().source(DamageTypeRegistry.PIRANHA_CHOMP), attackDamage);
                }
                if (entity instanceof NeutralMob) {
                    NeutralMob neutralMob = (NeutralMob)entity;
                    Entity entity2 = blockEntity2.getOwner();
                    if (entity2 instanceof LivingEntity) {
                        LivingEntity ownerEntity = (LivingEntity)entity2;
                        neutralMob.isAngryAt(ownerEntity);
                        neutralMob.setTarget(ownerEntity);
                        neutralMob.setPersistentAngerTarget(ownerEntity.getUUID());
                    }
                }
                blockEntity2.attackCooldown = 20;
                blockEntity2.triggerAnim("bite_controller", "bite");
                world.playSound(null, pos, (SoundEvent)SoundRegistry.PIRANHA_PLANT_CHOMP.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
        }
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return switch ((Direction.Axis)state.getValue(AXIS)) {
                    case Direction.Axis.X -> (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    case Direction.Axis.Z -> (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    default -> state;
                };
            }
        }
        return state;
    }
}

