/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks;

import com.mojang.serialization.MapCodec;
import com.wenxin2.marioverse.blocks.CheckpointFlagBlock;
import com.wenxin2.marioverse.blocks.CoinBlock;
import com.wenxin2.marioverse.blocks.StarCoinBlock;
import com.wenxin2.marioverse.blocks.WeatheringCopperQuestionBlock;
import com.wenxin2.marioverse.blocks.entities.CheckpointFlagBlockEntity;
import com.wenxin2.marioverse.blocks.entities.QuestionBlockEntity;
import com.wenxin2.marioverse.blocks.states.TripleBlockStates;
import com.wenxin2.marioverse.entities.PiranhaPlantEntity;
import com.wenxin2.marioverse.integration.CompatRegistry;
import com.wenxin2.marioverse.items.BasePowerUpItem;
import com.wenxin2.marioverse.items.DashMushroomItem;
import com.wenxin2.marioverse.items.PiranhaPlantPodItem;
import com.wenxin2.marioverse.network.client_bound.data.AmericaNamePayload;
import com.wenxin2.marioverse.network.client_bound.data.WonderNamePayload;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownExperienceBottle;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ArmorStandItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.EndCrystalItem;
import net.minecraft.world.item.ExperienceBottleItem;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.WindChargeItem;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.SeededContainerLoot;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuestionBlock
extends BaseEntityBlock {
    public static final MapCodec<QuestionBlock> CODEC = QuestionBlock.simpleCodec(QuestionBlock::new);
    public static final BooleanProperty EMPTY = BooleanProperty.create((String)"empty");

    public QuestionBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)EMPTY, (Comparable)Boolean.TRUE));
    }

    @NotNull
    protected MapCodec<? extends QuestionBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{EMPTY});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new QuestionBlockEntity(pos, state);
    }

    @NotNull
    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState oldState, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        boolean isUnwaxing;
        boolean isOxidizing = WeatheringCopper.getNext((Block)oldState.getBlock()).isPresent();
        boolean isScraping = WeatheringCopper.getPrevious((Block)oldState.getBlock()).isPresent();
        boolean bl = isUnwaxing = HoneycombItem.getWaxed((BlockState)newState).isPresent() && HoneycombItem.getWaxed((BlockState)oldState).isEmpty();
        if (!(newState.getBlock() instanceof WeatheringCopperQuestionBlock) && !(newState.getBlock() instanceof QuestionBlock) && (blockEntity = world.getBlockEntity(pos)) instanceof QuestionBlockEntity) {
            QuestionBlockEntity questionBlock = (QuestionBlockEntity)blockEntity;
            Containers.dropContents((Level)world, (BlockPos)pos, (Container)questionBlock);
        }
        if (!isOxidizing && !isScraping && !isUnwaxing || newState.canBeReplaced()) {
            super.onRemove(oldState, world, pos, newState, isMoving);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)EMPTY, (Comparable)Boolean.TRUE);
    }

    protected void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighborPos, boolean notify) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof QuestionBlockEntity) {
            QuestionBlockEntity questionBE = (QuestionBlockEntity)blockEntity;
            if (((Boolean)ConfigRegistry.REDSTONE_OPENS_QUESTION.get()).booleanValue()) {
                boolean isPowered = world.hasNeighborSignal(pos);
                if (isPowered && !((Boolean)state.getValue((Property)EMPTY)).booleanValue() && !questionBE.isLastPowered()) {
                    ItemStack storedItem = questionBE.getTheItem();
                    if (!storedItem.isEmpty()) {
                        if (!world.isClientSide) {
                            this.spawnFromQuestionBlock(world, pos, storedItem, null, Boolean.FALSE, Boolean.TRUE);
                        }
                        QuestionBlock.playSounds(world, pos, storedItem);
                        questionBE.splitTheItem(1);
                        questionBE.setChanged();
                    }
                    if (storedItem.isEmpty()) {
                        world.setBlock(pos, (BlockState)state.setValue((Property)EMPTY, (Comparable)Boolean.TRUE), 3);
                    }
                    if (questionBE.getLootTable() != null) {
                        world.setBlock(pos, (BlockState)state.setValue((Property)EMPTY, (Comparable)Boolean.FALSE), 3);
                    }
                }
                questionBE.setLastPowered(isPowered);
            }
        }
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack heldItem = player.getItemInHand(hand);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof QuestionBlockEntity) {
            QuestionBlockEntity questionBE = (QuestionBlockEntity)blockEntity;
            if (!heldItem.is(TagRegistry.CANNOT_PLACE_IN_QUESTION_BLOCKS)) {
                ItemStack blockStack = questionBE.getTheItem();
                if (world.isClientSide) {
                    return ItemInteractionResult.CONSUME;
                }
                if (!heldItem.isEmpty() && (((Boolean)ConfigRegistry.QUESTION_ADD_ITEMS.get()).booleanValue() || player.isCreative()) && (blockStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)heldItem, (ItemStack)blockStack) && blockStack.getCount() < blockStack.getMaxStackSize())) {
                    float f;
                    player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                    ItemStack itemstack = stack.consumeAndReturn(1, (LivingEntity)player);
                    if (questionBE.isEmpty()) {
                        questionBE.setTheItem(itemstack);
                        f = (float)itemstack.getCount() / (float)itemstack.getMaxStackSize();
                    } else {
                        blockStack.grow(1);
                        f = (float)blockStack.getCount() / (float)blockStack.getMaxStackSize();
                    }
                    world.playSound(null, pos, SoundEvents.DECORATED_POT_INSERT, SoundSource.BLOCKS, 1.0f, 0.7f + 0.5f * f);
                    world.setBlock(pos, (BlockState)state.setValue((Property)EMPTY, (Comparable)Boolean.FALSE), 3);
                    questionBE.setChanged();
                    world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                    return ItemInteractionResult.SUCCESS;
                }
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hitResult) {
        ItemStack heldItem = player.getItemInHand(player.getUsedItemHand());
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof QuestionBlockEntity) {
            QuestionBlockEntity questionBE = (QuestionBlockEntity)blockEntity;
            ItemStack blockStack = questionBE.getTheItem();
            if (!(!heldItem.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)heldItem, (ItemStack)blockStack) || !((Boolean)ConfigRegistry.QUESTION_REMOVE_ITEMS.get()).booleanValue() && !player.isCreative() || ((Boolean)state.getValue((Property)EMPTY)).booleanValue())) {
                world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                ItemStack storedItem = questionBE.getTheItem();
                if (!storedItem.isEmpty()) {
                    if (!world.isClientSide) {
                        this.spawnFromQuestionBlock(world, pos, storedItem, null, Boolean.FALSE, Boolean.TRUE);
                    }
                    if (state.is(BlockTags.GUARDED_BY_PIGLINS)) {
                        PiglinAi.angerNearbyPiglins((Player)player, (boolean)false);
                    }
                    QuestionBlock.playSounds(world, pos, storedItem);
                    questionBE.splitTheItem(1);
                    questionBE.setChanged();
                }
                if (storedItem.isEmpty()) {
                    world.setBlock(pos, (BlockState)state.setValue((Property)EMPTY, (Comparable)Boolean.TRUE), 3);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void spawnFromQuestionBlock(Level world, BlockPos pos, ItemStack stack, Entity entityHitBlock, boolean dropItemsAtPos, boolean applyUpMotion) {
        BlockItem blockItem;
        Block block;
        Item item;
        Item item2;
        BlockItem blockItem2;
        BlockItem blockItem3;
        Item item3;
        Item item4;
        if (!(world instanceof ServerLevel)) return;
        ServerLevel serverWorld = (ServerLevel)world;
        Item item5 = stack.getItem();
        if (item5 instanceof BasePowerUpItem) {
            BasePowerUpItem powerUpItem = (BasePowerUpItem)item5;
            if (((Boolean)ConfigRegistry.QUESTION_SPAWNS_POWER_UPS.get()).booleanValue()) {
                EntityType entityType = powerUpItem.getType(stack);
                if (entityType.is(TagRegistry.QUESTION_BLOCK_CANNOT_SPAWN)) {
                    this.spawnItem(world, pos, stack, dropItemsAtPos);
                    return;
                }
                if (world.getBlockState(pos.above()).canBeReplaced() || world.getFluidState(pos.above()).is(FluidTags.WATER) || !world.getBlockState(pos.below()).canBeReplaced() && !world.getFluidState(pos.below()).is(FluidTags.WATER)) {
                    Entity entity = entityType.spawn((ServerLevel)world, stack, null, pos.above(1), MobSpawnType.SPAWN_EGG, true, false);
                    if (entity != null && applyUpMotion) {
                        if (!entity.getType().is(TagRegistry.HAS_NO_DELTA_MOVEMENT)) {
                            entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, 0.3, 0.0));
                        }
                        entity.move(MoverType.SELF, entity.getDeltaMovement());
                    }
                } else {
                    Entity entity = entityType.create((Level)serverWorld);
                    if (entity != null) {
                        entityType.spawn(serverWorld, stack, null, BlockPos.containing((double)pos.getX(), (double)((float)pos.getY() - entity.getBbHeight()), (double)pos.getZ()), MobSpawnType.SPAWN_EGG, true, false);
                    }
                }
                stack.copyWithCount(1);
                return;
            }
        }
        if ((item4 = stack.getItem()) instanceof PiranhaPlantPodItem) {
            PiranhaPlantPodItem pod = (PiranhaPlantPodItem)item4;
            if (((Boolean)ConfigRegistry.QUESTION_SPAWNS_MOBS.get()).booleanValue()) {
                EntityType entityType = pod.getType(stack);
                if (entityType.is(TagRegistry.QUESTION_BLOCK_CANNOT_SPAWN)) {
                    this.spawnItem(world, pos, stack, dropItemsAtPos);
                    return;
                }
                Entity entity = entityType.spawn(serverWorld, stack, null, pos, MobSpawnType.SPAWN_EGG, true, false);
                if (entity instanceof PiranhaPlantEntity) {
                    PiranhaPlantEntity piranhaPlant = (PiranhaPlantEntity)entity;
                    piranhaPlant.setAge(-24000);
                    piranhaPlant.setOwner(entityHitBlock);
                }
                stack.copyWithCount(1);
                return;
            }
        }
        if ((item3 = stack.getItem()) instanceof SpawnEggItem) {
            SpawnEggItem spawnEgg = (SpawnEggItem)item3;
            if (((Boolean)ConfigRegistry.QUESTION_SPAWNS_MOBS.get()).booleanValue() && !(stack.getItem() instanceof BasePowerUpItem)) {
                EntityType entityType = spawnEgg.getType(stack);
                if (entityType.is(TagRegistry.QUESTION_BLOCK_CANNOT_SPAWN)) {
                    this.spawnItem(world, pos, stack, dropItemsAtPos);
                    return;
                }
                if (world.getBlockState(pos.above()).canBeReplaced() || world.getFluidState(pos.above()).is(FluidTags.WATER) || !world.getBlockState(pos.below()).canBeReplaced() && !world.getFluidState(pos.below()).is(FluidTags.WATER)) {
                    Entity entity = entityType.spawn((ServerLevel)world, stack, null, pos.above(1), MobSpawnType.SPAWN_EGG, true, false);
                    if (entity != null && applyUpMotion) {
                        if (!entity.getType().is(TagRegistry.HAS_NO_DELTA_MOVEMENT)) {
                            entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, 0.3, 0.0));
                        }
                        entity.move(MoverType.SELF, entity.getDeltaMovement());
                    }
                } else {
                    Entity entity = entityType.create((Level)serverWorld);
                    if (entity != null) {
                        entityType.spawn(serverWorld, stack, null, BlockPos.containing((double)pos.getX(), (double)((float)pos.getY() - entity.getBbHeight()), (double)pos.getZ()), MobSpawnType.SPAWN_EGG, true, false);
                    }
                }
                stack.copyWithCount(1);
                return;
            }
        }
        if (stack.getItem() instanceof ArmorStandItem) {
            Consumer consumer = EntityType.createDefaultStackConfig((ServerLevel)serverWorld, (ItemStack)stack, null);
            ArmorStand armorStand = (ArmorStand)EntityType.ARMOR_STAND.create(serverWorld, consumer, pos, MobSpawnType.SPAWN_EGG, true, true);
            if (armorStand != null && !armorStand.getType().is(TagRegistry.QUESTION_BLOCK_CANNOT_SPAWN)) {
                if (world.getBlockState(pos.above()).canBeReplaced() || world.getFluidState(pos.above()).is(FluidTags.WATER) || !world.getBlockState(pos.below()).canBeReplaced() && !world.getFluidState(pos.below()).is(FluidTags.WATER)) {
                    armorStand.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
                } else {
                    armorStand.setPos((double)pos.getX() + 0.5, (double)((float)pos.getY() - armorStand.getType().getHeight()), (double)pos.getZ() + 0.5);
                }
                world.addFreshEntity((Entity)armorStand);
                stack.copyWithCount(1);
                return;
            }
            this.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        Item item6 = stack.getItem();
        if (item6 instanceof MinecartItem) {
            MinecartItem cart = (MinecartItem)item6;
            AbstractMinecart abstractMinecart = AbstractMinecart.createMinecart((ServerLevel)serverWorld, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 1.0), (double)((double)pos.getZ() + 0.5), (AbstractMinecart.Type)cart.type, (ItemStack)stack, null);
            if (abstractMinecart.getType().is(TagRegistry.QUESTION_BLOCK_CANNOT_SPAWN)) {
                this.spawnItem(world, pos, stack, dropItemsAtPos);
                return;
            }
            if (world.getBlockState(pos.above()).canBeReplaced() || world.getFluidState(pos.above()).is(FluidTags.WATER) || !world.getBlockState(pos.below()).canBeReplaced() && !world.getFluidState(pos.below()).is(FluidTags.WATER)) {
                abstractMinecart.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
            } else {
                abstractMinecart.setPos((double)pos.getX() + 0.5, (double)((float)pos.getY() - abstractMinecart.getBbHeight()), (double)pos.getZ() + 0.5);
            }
            world.addFreshEntity((Entity)abstractMinecart);
            stack.copyWithCount(1);
            return;
        }
        Item item7 = stack.getItem();
        if (item7 instanceof BoatItem) {
            ChestBoat chestBoat;
            BoatItem boatItem = (BoatItem)item7;
            Object object = chestBoat = boatItem.hasChest ? new ChestBoat((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5) : new Boat((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
            if (chestBoat.getType().is(TagRegistry.QUESTION_BLOCK_CANNOT_SPAWN)) {
                this.spawnItem(world, pos, stack, dropItemsAtPos);
                return;
            }
            if (world.getBlockState(pos.above()).canBeReplaced() || world.getFluidState(pos.above()).is(FluidTags.WATER) || !world.getBlockState(pos.below()).canBeReplaced() && !world.getFluidState(pos.below()).is(FluidTags.WATER)) {
                chestBoat.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
            } else {
                chestBoat.setPos((double)pos.getX() + 0.5, (double)((float)pos.getY() - chestBoat.getBbHeight()), (double)pos.getZ() + 0.5);
            }
            chestBoat.setVariant(boatItem.type);
            world.addFreshEntity((Entity)chestBoat);
            stack.copyWithCount(1);
            return;
        }
        Item item8 = stack.getItem();
        if (item8 instanceof BlockItem && (blockItem3 = (BlockItem)item8).getBlock() instanceof TntBlock) {
            PrimedTnt primedTnt = new PrimedTnt((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, null);
            if (primedTnt.getType().is(TagRegistry.QUESTION_BLOCK_CANNOT_SPAWN)) {
                this.spawnItem(world, pos, stack, dropItemsAtPos);
                return;
            }
            if (world.getBlockState(pos.above()).canBeReplaced() || world.getFluidState(pos.above()).is(FluidTags.WATER) || !world.getBlockState(pos.below()).canBeReplaced() && !world.getFluidState(pos.below()).is(FluidTags.WATER)) {
                primedTnt.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
            } else {
                primedTnt.setPos((double)pos.getX() + 0.5, (double)((float)pos.getY() - primedTnt.getBbHeight()), (double)pos.getZ() + 0.5);
            }
            world.addFreshEntity((Entity)primedTnt);
            stack.copyWithCount(1);
            serverWorld.gameEvent(null, (Holder)GameEvent.PRIME_FUSE, pos);
            return;
        }
        Item item9 = stack.getItem();
        if (item9 instanceof BlockItem && (blockItem2 = (BlockItem)item9).getBlock() instanceof CoinBlock && entityHitBlock instanceof Player) {
            Player player = (Player)entityHitBlock;
            boolean bl = player.addItem(stack.copyWithCount(1));
            if (blockItem2.getBlock() instanceof StarCoinBlock) {
                ServerParticleUtils.spawnParticlesOnBlockFaces((ParticleOptions)ParticleRegistry.COIN_GLINT.get(), serverWorld, pos, (IntProvider)UniformInt.of((int)4, (int)6));
            } else {
                ServerParticleUtils.spawnParticlesOnBlockFaces((ParticleOptions)ParticleRegistry.COIN_GLINT.get(), serverWorld, pos, (IntProvider)UniformInt.of((int)2, (int)3));
            }
            if (bl) return;
            player.drop(stack.copyWithCount(1), false);
            return;
        }
        if (stack.getItem() instanceof WindChargeItem) {
            WindCharge windCharge = new WindCharge((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, new Vec3(0.0, -0.5, 0.0));
            if (windCharge.getType().is(TagRegistry.QUESTION_BLOCK_CANNOT_SPAWN)) {
                this.spawnItem(world, pos, stack, dropItemsAtPos);
                return;
            }
            if (world.getBlockState(pos.above()).canBeReplaced() || world.getFluidState(pos.above()).is(FluidTags.WATER) || !world.getBlockState(pos.below()).canBeReplaced() && !world.getFluidState(pos.below()).is(FluidTags.WATER)) {
                windCharge.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
            } else {
                windCharge.setPos((double)pos.getX() + 0.5, (double)((float)pos.getY() - windCharge.getBbHeight()), (double)pos.getZ() + 0.5);
            }
            world.addFreshEntity((Entity)windCharge);
            stack.copyWithCount(1);
            return;
        }
        if (stack.getItem() instanceof FireChargeItem) {
            SmallFireball smallFireball = new SmallFireball((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, new Vec3(0.0, -0.5, 0.0));
            if (smallFireball.getType().is(TagRegistry.QUESTION_BLOCK_CANNOT_SPAWN)) {
                this.spawnItem(world, pos, stack, dropItemsAtPos);
                return;
            }
            if (world.getBlockState(pos.above()).canBeReplaced() || world.getFluidState(pos.above()).is(FluidTags.WATER) || !world.getBlockState(pos.below()).canBeReplaced() && !world.getFluidState(pos.below()).is(FluidTags.WATER)) {
                smallFireball.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
            } else {
                smallFireball.setPos((double)pos.getX() + 0.5, (double)((float)pos.getY() - smallFireball.getBbHeight()), (double)pos.getZ() + 0.5);
            }
            world.addFreshEntity((Entity)smallFireball);
            stack.copyWithCount(1);
            return;
        }
        if (stack.getItem() instanceof ThrowablePotionItem) {
            ThrownPotion thrownPotion = new ThrownPotion((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            if (thrownPotion.getType().is(TagRegistry.QUESTION_BLOCK_CANNOT_SPAWN)) {
                this.spawnItem(world, pos, stack, dropItemsAtPos);
                return;
            }
            if (world.getBlockState(pos.above()).canBeReplaced() || world.getFluidState(pos.above()).is(FluidTags.WATER) || !world.getBlockState(pos.below()).canBeReplaced() && !world.getFluidState(pos.below()).is(FluidTags.WATER)) {
                thrownPotion.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
            } else {
                thrownPotion.setPos((double)pos.getX() + 0.5, (double)((float)pos.getY() - thrownPotion.getBbHeight()), (double)pos.getZ() + 0.5);
            }
            thrownPotion.setItem(stack);
            world.addFreshEntity((Entity)thrownPotion);
            stack.copyWithCount(1);
            return;
        }
        if (stack.getItem() instanceof ExperienceBottleItem) {
            ThrownExperienceBottle thrownExperienceBottle = new ThrownExperienceBottle((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            if (thrownExperienceBottle.getType().is(TagRegistry.QUESTION_BLOCK_CANNOT_SPAWN)) {
                this.spawnItem(world, pos, stack, dropItemsAtPos);
                return;
            }
            if (world.getBlockState(pos.above()).canBeReplaced() || world.getFluidState(pos.above()).is(FluidTags.WATER) || !world.getBlockState(pos.below()).canBeReplaced() && !world.getFluidState(pos.below()).is(FluidTags.WATER)) {
                thrownExperienceBottle.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
            } else {
                thrownExperienceBottle.setPos((double)pos.getX() + 0.5, (double)((float)pos.getY() - thrownExperienceBottle.getBbHeight()), (double)pos.getZ() + 0.5);
            }
            thrownExperienceBottle.setItem(stack);
            world.addFreshEntity((Entity)thrownExperienceBottle);
            stack.copyWithCount(1);
            return;
        }
        if (stack.getItem() instanceof EndCrystalItem) {
            EndCrystal endCrystal = new EndCrystal((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            if (endCrystal.getType().is(TagRegistry.QUESTION_BLOCK_CANNOT_SPAWN)) {
                this.spawnItem(world, pos, stack, dropItemsAtPos);
                return;
            }
            if (world.getBlockState(pos.above()).canBeReplaced() || world.getFluidState(pos.above()).is(FluidTags.WATER) || !world.getBlockState(pos.below()).canBeReplaced() && !world.getFluidState(pos.below()).is(FluidTags.WATER)) {
                endCrystal.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
            } else {
                endCrystal.setPos((double)pos.getX() + 0.5, (double)((float)pos.getY() - endCrystal.getBbHeight()), (double)pos.getZ() + 0.5);
                endCrystal.setDeltaMovement(new Vec3(0.0, -0.5, 0.0));
            }
            endCrystal.setShowBottom(false);
            world.addFreshEntity((Entity)endCrystal);
            world.gameEvent(null, (Holder)GameEvent.ENTITY_PLACE, pos);
            stack.copyWithCount(1);
            return;
        }
        if (stack.getItem() instanceof FireworkRocketItem) {
            FireworkRocketEntity fireworkRocketEntity = new FireworkRocketEntity((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, stack);
            if (fireworkRocketEntity.getType().is(TagRegistry.QUESTION_BLOCK_CANNOT_SPAWN)) {
                this.spawnItem(world, pos, stack, dropItemsAtPos);
                return;
            }
            if (world.getBlockState(pos.above()).canBeReplaced() || world.getFluidState(pos.above()).is(FluidTags.WATER) || !world.getBlockState(pos.below()).canBeReplaced() && !world.getFluidState(pos.below()).is(FluidTags.WATER)) {
                fireworkRocketEntity.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
            } else {
                fireworkRocketEntity.setPos((double)pos.getX() + 0.5, (double)((float)pos.getY() - fireworkRocketEntity.getBbHeight()), (double)pos.getZ() + 0.5);
            }
            world.addFreshEntity((Entity)fireworkRocketEntity);
            stack.copyWithCount(1);
            return;
        }
        if (stack.getItem() instanceof EggItem) {
            ThrownEgg thrownEgg = new ThrownEgg((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            if (thrownEgg.getType().is(TagRegistry.QUESTION_BLOCK_CANNOT_SPAWN)) {
                this.spawnItem(world, pos, stack, dropItemsAtPos);
                return;
            }
            if (world.getBlockState(pos.above()).canBeReplaced() || world.getFluidState(pos.above()).is(FluidTags.WATER) || !world.getBlockState(pos.below()).canBeReplaced() && !world.getFluidState(pos.below()).is(FluidTags.WATER)) {
                thrownEgg.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
            } else {
                thrownEgg.setPos((double)pos.getX() + 0.5, (double)((float)pos.getY() - thrownEgg.getBbHeight()), (double)pos.getZ() + 0.5);
            }
            thrownEgg.setItem(stack);
            world.addFreshEntity((Entity)thrownEgg);
            stack.copyWithCount(1);
            return;
        }
        Item item10 = stack.getItem();
        if (item10 instanceof BucketItem) {
            BucketItem bucket = (BucketItem)item10;
            if (bucket.content != Fluids.EMPTY && ((Boolean)ConfigRegistry.QUESTION_BUCKET_TWEAKS.get()).booleanValue()) {
                if (world.getBlockState(pos.above()).canBeReplaced()) {
                    if (bucket.emptyContents(null, world, pos.above(), null, stack)) {
                        bucket.checkExtraContent(null, world, stack, pos.above());
                    }
                    this.spawnItem(world, pos.above(), new ItemStack((ItemLike)Items.BUCKET), dropItemsAtPos);
                    return;
                }
                if (!world.getBlockState(pos.below()).canBeReplaced()) {
                    if (world.getBlockState(pos.below()).canBeReplaced()) return;
                    this.spawnItem(world, pos.below(), stack, dropItemsAtPos);
                    return;
                }
                if (bucket.emptyContents(null, world, pos.below(), null, stack)) {
                    bucket.checkExtraContent(null, world, stack, pos.below());
                }
                this.spawnItem(world, pos.below(), new ItemStack((ItemLike)Items.BUCKET), dropItemsAtPos);
                return;
            }
        }
        if ((item2 = stack.getItem()) instanceof SolidBucketItem) {
            SolidBucketItem bucket = (SolidBucketItem)item2;
            if (((Boolean)ConfigRegistry.QUESTION_BUCKET_TWEAKS.get()).booleanValue()) {
                if (world.getBlockState(pos.above()).canBeReplaced()) {
                    if (bucket.emptyContents(null, world, pos.above(), null, stack)) {
                        bucket.checkExtraContent(null, world, stack, pos.above());
                    }
                    this.spawnItem(world, pos.above(), new ItemStack((ItemLike)Items.BUCKET), dropItemsAtPos);
                    return;
                }
                if (!world.getBlockState(pos.below()).canBeReplaced()) {
                    this.spawnItem(world, pos.below(), stack, dropItemsAtPos);
                    return;
                }
                if (bucket.emptyContents(null, world, pos.below(), null, stack)) {
                    bucket.checkExtraContent(null, world, stack, pos.below());
                }
                this.spawnItem(world, pos.below(), new ItemStack((ItemLike)Items.BUCKET), dropItemsAtPos);
                return;
            }
        }
        if ((item = stack.getItem()) instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof CheckpointFlagBlock) {
            CheckpointFlagBlock block2 = (CheckpointFlagBlock)block;
            int n = world.random.nextInt(17);
            if (world.getBlockState(pos.above()).canBeReplaced() && world.getBlockState(pos.above(2)).canBeReplaced() && world.getBlockState(pos.above(3)).canBeReplaced()) {
                world.setBlock(pos.above(), (BlockState)((BlockState)block2.defaultBlockState().setValue((Property)CheckpointFlagBlock.ROTATION, (Comparable)Integer.valueOf(n))).setValue((Property)CheckpointFlagBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos.above()).is(FluidTags.WATER))), 3);
                world.setBlock(pos.above(2), (BlockState)((BlockState)block2.defaultBlockState().setValue(CheckpointFlagBlock.PART, (Comparable)((Object)TripleBlockStates.MIDDLE))).setValue((Property)CheckpointFlagBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos.above(2)).is(FluidTags.WATER))), 3);
                world.setBlock(pos.above(3), (BlockState)((BlockState)block2.defaultBlockState().setValue(CheckpointFlagBlock.PART, (Comparable)((Object)TripleBlockStates.TOP))).setValue((Property)CheckpointFlagBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos.above(3)).is(FluidTags.WATER))), 3);
                CheckpointFlagBlockEntity flagBE = (CheckpointFlagBlockEntity)world.getBlockEntity(pos.above());
                QuestionBlock.checkpointFlagNBT(world, pos.above(), stack, Direction.UP, flagBE, entityHitBlock);
                return;
            }
            if (world.getBlockState(pos.below()).canBeReplaced() && world.getBlockState(pos.below(2)).canBeReplaced() && world.getBlockState(pos.below(3)).canBeReplaced()) {
                world.setBlock(pos.below(3), (BlockState)((BlockState)block2.defaultBlockState().setValue((Property)CheckpointFlagBlock.ROTATION, (Comparable)Integer.valueOf(n))).setValue((Property)CheckpointFlagBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos.below(3)).is(FluidTags.WATER))), 3);
                world.setBlock(pos.below(2), (BlockState)((BlockState)block2.defaultBlockState().setValue(CheckpointFlagBlock.PART, (Comparable)((Object)TripleBlockStates.MIDDLE))).setValue((Property)CheckpointFlagBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos.below(2)).is(FluidTags.WATER))), 3);
                world.setBlock(pos.below(), (BlockState)((BlockState)block2.defaultBlockState().setValue(CheckpointFlagBlock.PART, (Comparable)((Object)TripleBlockStates.TOP))).setValue((Property)CheckpointFlagBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos.below()).is(FluidTags.WATER))), 3);
                CheckpointFlagBlockEntity flagBE = (CheckpointFlagBlockEntity)world.getBlockEntity(pos.below());
                QuestionBlock.checkpointFlagNBT(world, pos.below(), stack, Direction.DOWN, flagBE, entityHitBlock);
                return;
            }
            this.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        if (stack.getItem() == CompatRegistry.HAT_STAND_ITEM.get()) {
            Entity entity = CompatRegistry.HAT_STAND.get().create((Level)serverWorld);
            if (entity != null && !entity.getType().is(TagRegistry.QUESTION_BLOCK_CANNOT_SPAWN)) {
                if (world.getBlockState(pos.above()).canBeReplaced() || world.getFluidState(pos.above()).is(FluidTags.WATER) || !world.getBlockState(pos.below()).canBeReplaced() && !world.getFluidState(pos.below()).is(FluidTags.WATER)) {
                    entity.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
                } else {
                    entity.setPos((double)pos.getX() + 0.5, (double)((float)pos.getY() - entity.getBbHeight()), (double)pos.getZ() + 0.5);
                }
                world.addFreshEntity(entity);
                stack.copyWithCount(1);
                return;
            }
            this.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        if (stack.getItem() == CompatRegistry.CANNONBALL_ITEM.get()) {
            Entity entity = CompatRegistry.CANNONBALL.get().create((Level)serverWorld);
            if (entity != null && !entity.getType().is(TagRegistry.QUESTION_BLOCK_CANNOT_SPAWN)) {
                if (world.getBlockState(pos.above()).canBeReplaced() || world.getFluidState(pos.above()).is(FluidTags.WATER) || !world.getBlockState(pos.below()).canBeReplaced() && !world.getFluidState(pos.below()).is(FluidTags.WATER)) {
                    entity.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
                    entity.setDeltaMovement(new Vec3(world.random.triangle(0.0, 0.3), world.random.triangle(0.5, 0.3), world.random.triangle(0.0, 0.3)));
                } else {
                    entity.setPos((double)pos.getX() + 0.5, (double)((float)pos.getY() - entity.getBbHeight()), (double)pos.getZ() + 0.5);
                    entity.setDeltaMovement(new Vec3(0.0, -0.5, 0.0));
                }
                world.addFreshEntity(entity);
                stack.copyWithCount(1);
                return;
            }
            this.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        if (stack.getItem() == CompatRegistry.BOMB_ITEM.get()) {
            Entity entity = CompatRegistry.BOMB.get().create((Level)serverWorld);
            if (entity != null && !entity.getType().is(TagRegistry.QUESTION_BLOCK_CANNOT_SPAWN)) {
                if (world.getBlockState(pos.above()).canBeReplaced() || world.getFluidState(pos.above()).is(FluidTags.WATER) || !world.getBlockState(pos.below()).canBeReplaced() && !world.getFluidState(pos.below()).is(FluidTags.WATER)) {
                    entity.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
                    entity.setDeltaMovement(new Vec3(world.random.triangle(0.0, 0.2), world.random.triangle(0.5, 0.2), world.random.triangle(0.0, 0.2)));
                } else {
                    entity.setPos((double)pos.getX() + 0.5, (double)((float)pos.getY() - entity.getBbHeight()), (double)pos.getZ() + 0.5);
                    entity.setDeltaMovement(new Vec3(0.0, -0.5, 0.0));
                }
                world.addFreshEntity(entity);
                stack.copyWithCount(1);
                return;
            }
            this.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        if (stack.getItem() == CompatRegistry.BOMB_BLUE_ITEM.get()) {
            Entity entity = CompatRegistry.BOMB.get().create((Level)serverWorld);
            if (entity != null && !entity.getType().is(TagRegistry.QUESTION_BLOCK_CANNOT_SPAWN)) {
                CompoundTag nbt = new CompoundTag();
                entity.save(nbt);
                nbt.putInt("Type", 1);
                entity.load(nbt);
                if (world.getBlockState(pos.above()).canBeReplaced() || world.getFluidState(pos.above()).is(FluidTags.WATER) || !world.getBlockState(pos.below()).canBeReplaced() && !world.getFluidState(pos.below()).is(FluidTags.WATER)) {
                    entity.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
                    entity.setDeltaMovement(new Vec3(world.random.triangle(0.0, 0.2), world.random.triangle(0.5, 0.2), world.random.triangle(0.0, 0.2)));
                } else {
                    entity.setPos((double)pos.getX() + 0.5, (double)((float)pos.getY() - entity.getBbHeight()), (double)pos.getZ() + 0.5);
                    entity.setDeltaMovement(new Vec3(0.0, -0.5, 0.0));
                }
                world.addFreshEntity(entity);
                stack.copyWithCount(1);
                return;
            }
            this.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        if (stack.getItem() == CompatRegistry.BOMB_SPIKY_ITEM.get()) {
            Entity entity = CompatRegistry.BOMB.get().create((Level)serverWorld);
            if (entity != null && !entity.getType().is(TagRegistry.QUESTION_BLOCK_CANNOT_SPAWN)) {
                CompoundTag nbt = new CompoundTag();
                entity.save(nbt);
                nbt.putInt("Type", 2);
                entity.load(nbt);
                if (world.getBlockState(pos.above()).canBeReplaced() || world.getFluidState(pos.above()).is(FluidTags.WATER) || !world.getBlockState(pos.below()).canBeReplaced() && !world.getFluidState(pos.below()).is(FluidTags.WATER)) {
                    entity.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
                    entity.setDeltaMovement(new Vec3(world.random.triangle(0.0, 0.2), world.random.triangle(0.5, 0.2), world.random.triangle(0.0, 0.2)));
                } else {
                    entity.setPos((double)pos.getX() + 0.5, (double)((float)pos.getY() - entity.getBbHeight()), (double)pos.getZ() + 0.5);
                    entity.setDeltaMovement(new Vec3(0.0, -0.5, 0.0));
                }
                world.addFreshEntity(entity);
                stack.copyWithCount(1);
                return;
            }
            this.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        if (stack.getItem() == CompatRegistry.CONFETTI_POPPER_ITEM.get()) {
            Creeper creeper = (Creeper)EntityType.CREEPER.create((Level)serverWorld);
            if (creeper != null) {
                CompoundTag nbt = new CompoundTag();
                creeper.save(nbt);
                nbt.putBoolean("Party", true);
                nbt.putInt("Fuse", 0);
                creeper.setNoAi(true);
                creeper.ignite();
                creeper.setInvisible(true);
                creeper.setSilent(true);
                creeper.load(nbt);
                if (world.getBlockState(pos.above()).canBeReplaced() || world.getFluidState(pos.above()).is(FluidTags.WATER) || !world.getBlockState(pos.below()).canBeReplaced() && !world.getFluidState(pos.below()).is(FluidTags.WATER)) {
                    creeper.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                } else {
                    creeper.setPos((double)pos.getX() + 0.5, (double)((float)pos.getY() - creeper.getBbHeight()), (double)pos.getZ() + 0.5);
                }
                world.addFreshEntity((Entity)creeper);
            }
            world.gameEvent(null, (Holder)GameEvent.EXPLODE, pos);
            return;
        }
        if (stack.getItem() != CompatRegistry.ICE_BOMB_ITEM.get()) {
            this.spawnItem(world, pos, stack, dropItemsAtPos);
            return;
        }
        Entity entity = CompatRegistry.ICE_BOMB.get().create((Level)serverWorld);
        if (entity != null && !entity.getType().is(TagRegistry.QUESTION_BLOCK_CANNOT_SPAWN)) {
            if (world.getBlockState(pos.above()).canBeReplaced() || world.getFluidState(pos.above()).is(FluidTags.WATER) || !world.getBlockState(pos.below()).canBeReplaced() && !world.getFluidState(pos.below()).is(FluidTags.WATER)) {
                entity.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
                entity.setDeltaMovement(new Vec3(world.random.triangle(0.0, 0.2), world.random.triangle(0.5, 0.2), world.random.triangle(0.0, 0.2)));
            } else {
                entity.setPos((double)pos.getX() + 0.5, (double)((float)pos.getY() - entity.getBbHeight()), (double)pos.getZ() + 0.5);
            }
            world.addFreshEntity(entity);
            stack.copyWithCount(1);
            return;
        }
        this.spawnItem(world, pos, stack, dropItemsAtPos);
    }

    private static void checkpointFlagNBT(Level world, BlockPos pos, ItemStack stack, Direction direction, CheckpointFlagBlockEntity flagBE, Entity entityHitBlock) {
        ItemContainerContents containerContents;
        CheckpointFlagBlockEntity topFlagBE;
        BlockEntity topBlockEntity;
        CheckpointFlagBlockEntity middleFlagBE;
        BlockEntity middleBlockEntity;
        SeededContainerLoot lootTableReference;
        if (stack.has(DataComponents.CUSTOM_NAME)) {
            CheckpointFlagBlockEntity topFlagBE2;
            BlockEntity topBlockEntity2;
            CheckpointFlagBlockEntity middleFlagBE2;
            BlockEntity middleBlockEntity2;
            flagBE.setCustomName(stack.getHoverName());
            flagBE.markUpdated();
            if (flagBE.isWonderFlag()) {
                flagBE.setWonderFlag(Boolean.TRUE);
                if (!world.isClientSide()) {
                    PacketDistributor.sendToAllPlayers((CustomPacketPayload)new WonderNamePayload(pos, flagBE.hasWonderFlag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            } else if (flagBE.isAmericanFlag()) {
                flagBE.setAmericanFlag(Boolean.TRUE);
                if (!world.isClientSide()) {
                    PacketDistributor.sendToAllPlayers((CustomPacketPayload)new AmericaNamePayload(pos, flagBE.hasAmericanFlag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            if ((middleBlockEntity2 = world.getBlockEntity(pos.relative(direction))) instanceof CheckpointFlagBlockEntity && (middleFlagBE2 = (CheckpointFlagBlockEntity)middleBlockEntity2).getCustomName() == null) {
                middleFlagBE2.setCustomName(stack.getHoverName());
                middleFlagBE2.markUpdated();
                if (middleFlagBE2.isWonderFlag()) {
                    middleFlagBE2.setWonderFlag(Boolean.TRUE);
                    if (!world.isClientSide()) {
                        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new WonderNamePayload(pos.relative(direction), middleFlagBE2.hasWonderFlag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                } else if (middleFlagBE2.isAmericanFlag()) {
                    middleFlagBE2.setAmericanFlag(Boolean.TRUE);
                    if (!world.isClientSide()) {
                        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new AmericaNamePayload(pos.relative(direction), middleFlagBE2.hasAmericanFlag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
            }
            if ((topBlockEntity2 = world.getBlockEntity(pos.relative(direction, 2))) instanceof CheckpointFlagBlockEntity && (topFlagBE2 = (CheckpointFlagBlockEntity)topBlockEntity2).getCustomName() == null) {
                topFlagBE2.setCustomName(stack.getHoverName());
                topFlagBE2.markUpdated();
                if (topFlagBE2.isWonderFlag()) {
                    topFlagBE2.setWonderFlag(Boolean.TRUE);
                    if (!world.isClientSide()) {
                        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new WonderNamePayload(pos.relative(direction, 2), topFlagBE2.hasWonderFlag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                } else if (topFlagBE2.isAmericanFlag()) {
                    topFlagBE2.setAmericanFlag(Boolean.TRUE);
                    if (!world.isClientSide()) {
                        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new AmericaNamePayload(pos.relative(direction, 2), topFlagBE2.hasAmericanFlag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
            }
        }
        if (stack.has(DataComponents.CONTAINER_LOOT) && (lootTableReference = (SeededContainerLoot)stack.get(DataComponents.CONTAINER_LOOT)) != null) {
            flagBE.setLootTable(lootTableReference.lootTable(), lootTableReference.seed());
            flagBE.markUpdated();
            middleBlockEntity = world.getBlockEntity(pos.relative(direction));
            if (middleBlockEntity instanceof CheckpointFlagBlockEntity) {
                middleFlagBE = (CheckpointFlagBlockEntity)middleBlockEntity;
                middleFlagBE.setLootTable(lootTableReference.lootTable(), lootTableReference.seed());
                middleFlagBE.markUpdated();
            }
            if ((topBlockEntity = world.getBlockEntity(pos.relative(direction, 2))) instanceof CheckpointFlagBlockEntity) {
                topFlagBE = (CheckpointFlagBlockEntity)topBlockEntity;
                topFlagBE.setLootTable(lootTableReference.lootTable(), lootTableReference.seed());
                topFlagBE.markUpdated();
            }
        }
        if (stack.has(DataComponents.CONTAINER) && (containerContents = (ItemContainerContents)stack.get(DataComponents.CONTAINER)) != null) {
            flagBE.setTheItem(containerContents.copyOne());
            flagBE.markUpdated();
            middleBlockEntity = world.getBlockEntity(pos.relative(direction));
            if (middleBlockEntity instanceof CheckpointFlagBlockEntity) {
                middleFlagBE = (CheckpointFlagBlockEntity)middleBlockEntity;
                middleFlagBE.setTheItem(containerContents.copyOne());
                middleFlagBE.markUpdated();
            }
            if ((topBlockEntity = world.getBlockEntity(pos.relative(direction, 2))) instanceof CheckpointFlagBlockEntity) {
                topFlagBE = (CheckpointFlagBlockEntity)topBlockEntity;
                topFlagBE.setTheItem(containerContents.copyOne());
                topFlagBE.markUpdated();
            }
        }
    }

    public void spawnItem(Level world, BlockPos pos, ItemStack stack, boolean dropItemsAtPos) {
        if (dropItemsAtPos) {
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, stack.copyWithCount(1));
            world.addFreshEntity((Entity)itemEntity);
        } else if (world.getBlockState(pos.above()).canBeReplaced() || world.getFluidState(pos.above()).is(FluidTags.WATER) || !world.getBlockState(pos.below()).canBeReplaced() && !world.getFluidState(pos.below()).is(FluidTags.WATER)) {
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, stack.copyWithCount(1));
            world.addFreshEntity((Entity)itemEntity);
        } else {
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() - 0.5, (double)pos.getZ() + 0.5, stack.copyWithCount(1));
            world.addFreshEntity((Entity)itemEntity);
        }
    }

    public static void playSounds(Level world, BlockPos pos, ItemStack stack) {
        BlockItem blockItem;
        Item item = stack.getItem();
        if (item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof StarCoinBlock) {
            world.playSound(null, pos, (SoundEvent)SoundRegistry.STAR_COIN_PICKUP.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            BlockItem blockItem2;
            item = stack.getItem();
            if (item instanceof BlockItem && (blockItem2 = (BlockItem)item).getBlock() instanceof CoinBlock) {
                world.playSound(null, pos, (SoundEvent)SoundRegistry.COIN_PICKUP.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                BlockItem blockItem3;
                item = stack.getItem();
                if (item instanceof BlockItem && (blockItem3 = (BlockItem)item).getBlock() instanceof TntBlock) {
                    world.playSound(null, pos, SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() instanceof ArmorStandItem) {
                    world.playSound(null, pos, SoundEvents.ARMOR_STAND_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() instanceof BasePowerUpItem || stack.getItem() instanceof DashMushroomItem) {
                    world.playSound(null, pos, (SoundEvent)SoundRegistry.POWER_UP_SPAWNS.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() instanceof BoatItem) {
                    world.playSound(null, pos, SoundEvents.BOAT_PADDLE_WATER, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() instanceof EggItem) {
                    world.playSound(null, pos, SoundEvents.EGG_THROW, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() instanceof ExperienceBottleItem) {
                    world.playSound(null, pos, SoundEvents.EXPERIENCE_BOTTLE_THROW, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() instanceof FireChargeItem) {
                    world.playSound(null, pos, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() instanceof LingeringPotionItem) {
                    world.playSound(null, pos, SoundEvents.LINGERING_POTION_THROW, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() instanceof MinecartItem) {
                    world.playSound(null, pos, SoundEvents.MINECART_RIDING, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() instanceof PotionItem) {
                    world.playSound(null, pos, SoundEvents.SPLASH_POTION_THROW, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() instanceof SpawnEggItem) {
                    world.playSound(null, pos, (SoundEvent)SoundRegistry.MOB_SPAWNS.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() instanceof WindChargeItem) {
                    world.playSound(null, pos, SoundEvents.WIND_CHARGE_THROW, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() == CompatRegistry.BOMB_ITEM.get() || stack.getItem() == CompatRegistry.BOMB_BLUE_ITEM.get() || stack.getItem() == CompatRegistry.BOMB_SPIKY_ITEM.get()) {
                    world.playSound(null, pos, CompatRegistry.BOMB_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() == CompatRegistry.CANNONBALL_ITEM.get()) {
                    world.playSound(null, pos, CompatRegistry.CANNON_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() == CompatRegistry.CONFETTI_POPPER_ITEM.get()) {
                    world.playSound(null, pos, CompatRegistry.CONFETTI_POPPER_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() == CompatRegistry.HAT_STAND_ITEM.get()) {
                    world.playSound(null, pos, SoundEvents.ARMOR_STAND_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (stack.getItem() == CompatRegistry.ICE_BOMB_ITEM.get()) {
                    world.playSound(null, pos, CompatRegistry.ICE_BOMB_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    world.playSound(null, pos, (SoundEvent)SoundRegistry.ITEM_SPAWNS.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
        }
    }
}

