/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks.entities;

import com.wenxin2.marioverse.blocks.GoalPoleBlock;
import com.wenxin2.marioverse.network.client_bound.data.AmericaNamePayload;
import com.wenxin2.marioverse.network.client_bound.data.WonderNamePayload;
import com.wenxin2.marioverse.registries.BlockEntityRegistry;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GoalPoleBlockEntity
extends BlockEntity
implements GeoBlockEntity,
Nameable {
    protected static final RawAnimation APPEAR = RawAnimation.begin().thenPlayAndHold("animation.goal_pole.appear");
    protected static final RawAnimation DISAPPEAR = RawAnimation.begin().thenPlayAndHold("animation.goal_pole.disappear");
    public static final RawAnimation SWITCH = RawAnimation.begin().thenPlayAndHold("animation.goal_pole.switch");
    protected static final RawAnimation WINDY_CALM = RawAnimation.begin().thenLoop("animation.goal_pole.windy_calm");
    protected static final RawAnimation WINDY_RAIN = RawAnimation.begin().thenLoop("animation.goal_pole.windy_rain");
    protected static final RawAnimation WINDY_THUNDER = RawAnimation.begin().thenLoop("animation.goal_pole.windy_thunder");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final Component DEFAULT_NAME = Component.translatable((String)"menu.marioverse.goal_pole");
    public static final String CUSTOM_NAME = "CustomName";
    @Nullable
    public Component name;
    private boolean playedAppearAnim;
    private boolean playedDisappearAnim;
    private boolean renderWonderFlag;
    private boolean renderAmericanFlag;

    public GoalPoleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.GOAL_POLE_BLOCK_ENTITY.get(), pos, state);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "appear_controller", 5, state -> PlayState.STOP).triggerableAnim("appear", APPEAR));
        controllers.add(new AnimationController((GeoAnimatable)this, "disappear_controller", 5, state -> PlayState.STOP).triggerableAnim("disappear", DISAPPEAR));
        controllers.add(new AnimationController((GeoAnimatable)this, "switch_controller", 5, state -> PlayState.STOP).triggerableAnim("switch", SWITCH));
        controllers.add(new AnimationController((GeoAnimatable)this, "windy_controller", 5, this::windyController));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected <E extends GeoAnimatable> PlayState windyController(AnimationState<E> event) {
        if (this.getLevel() != null && this.getLevel().canSeeSky(this.getBlockPos())) {
            Level world = this.getLevel();
            if (world.isThundering()) {
                event.setAndContinue(WINDY_THUNDER);
            } else if (world.isRaining()) {
                event.setAndContinue(WINDY_RAIN);
            } else {
                event.setAndContinue(WINDY_CALM);
            }
        } else {
            event.setAndContinue(WINDY_CALM);
        }
        return PlayState.CONTINUE;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean("playedAppearAnim", this.playedAppearAnim);
        tag.putBoolean("playedDisappearAnim", this.playedDisappearAnim);
        tag.putBoolean("renderWonderFlag", this.renderWonderFlag);
        tag.putBoolean("renderAmericanFlag", this.renderAmericanFlag);
        if (this.name != null) {
            tag.putString(CUSTOM_NAME, Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)provider));
            if (this.isWonderFlag() && this.level != null && !this.level.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new WonderNamePayload(this.getBlockPos(), this.hasWonderFlag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (this.isAmericanFlag() && this.level != null && !this.level.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new AmericaNamePayload(this.getBlockPos(), this.hasAmericanFlag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.playedAppearAnim = tag.getBoolean("playedAppearAnim");
        this.playedDisappearAnim = tag.getBoolean("playedDisappearAnim");
        this.renderWonderFlag = tag.getBoolean("renderWonderFlag");
        this.renderAmericanFlag = tag.getBoolean("renderAmericanFlag");
        if (tag.contains(CUSTOM_NAME, 8)) {
            this.name = GoalPoleBlockEntity.parseCustomNameSafe((String)tag.getString(CUSTOM_NAME), (HolderLookup.Provider)provider);
            if (this.level != null && !this.level.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new AmericaNamePayload(this.getBlockPos(), this.hasAmericanFlag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new WonderNamePayload(this.getBlockPos(), this.hasWonderFlag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public void markUpdated() {
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void markUpdatedClients() {
        this.setChanged();
        if (this.level != null && this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.name = (Component)input.get(DataComponents.CUSTOM_NAME);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(DataComponents.CUSTOM_NAME, (Object)this.name);
    }

    public void setCustomName(Component name) {
        this.name = name;
        this.markUpdated();
    }

    @NotNull
    public Component getDisplayName() {
        return this.getName();
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    public Component getCustomName(Component name) {
        this.name = name;
        return this.name;
    }

    @NotNull
    public Component getName() {
        return this.name != null ? this.name : DEFAULT_NAME;
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove(CUSTOM_NAME);
    }

    public boolean playedAppearAnim() {
        return this.playedAppearAnim;
    }

    public boolean playedDisappearAnim() {
        return this.playedDisappearAnim;
    }

    public void setPlayedAppearAnim(boolean playedAppearAnim) {
        this.playedAppearAnim = playedAppearAnim;
        this.markUpdated();
    }

    public void setPlayedDisappearAnim(boolean playedDisappearAnim) {
        this.playedDisappearAnim = playedDisappearAnim;
        this.markUpdated();
    }

    public void updateConnectedAppearFlags(Level world, BlockPos pos, boolean playedAnimation) {
        BlockPos posAbove = pos.above();
        while (world.getBlockState(posAbove).getBlock() instanceof GoalPoleBlock && ((Boolean)world.getBlockState(posAbove).getValue((Property)GoalPoleBlock.LOWERED)).booleanValue()) {
            this.setPlayedAppearAnim(playedAnimation);
            this.markUpdated();
            posAbove = posAbove.above();
        }
        BlockPos posBelow = pos.below();
        while (world.getBlockState(posBelow).getBlock() instanceof GoalPoleBlock && ((Boolean)world.getBlockState(posBelow).getValue((Property)GoalPoleBlock.LOWERED)).booleanValue()) {
            this.setPlayedAppearAnim(playedAnimation);
            this.markUpdated();
            posBelow = posBelow.below();
        }
    }

    public void updateConnectedDisappearFlags(Level world, BlockPos pos, boolean playedAnimation) {
        BlockPos posAbove = pos.above();
        while (world.getBlockState(posAbove).getBlock() instanceof GoalPoleBlock && ((Boolean)world.getBlockState(posAbove).getValue((Property)GoalPoleBlock.LOWERED)).booleanValue()) {
            this.setPlayedDisappearAnim(playedAnimation);
            this.markUpdated();
            posAbove = posAbove.above();
        }
        BlockPos posBelow = pos.below();
        while (world.getBlockState(posBelow).getBlock() instanceof GoalPoleBlock && ((Boolean)world.getBlockState(posBelow).getValue((Property)GoalPoleBlock.LOWERED)).booleanValue()) {
            this.setPlayedDisappearAnim(playedAnimation);
            this.markUpdated();
            posBelow = posBelow.below();
        }
    }

    public boolean isAmericanFlag() {
        return this.getName().getString().toLowerCase(Locale.ROOT).equals("america") || this.getName().getString().toLowerCase(Locale.ROOT).equals("america flag") || this.getName().getString().toLowerCase(Locale.ROOT).equals("usa") || this.getName().getString().toLowerCase(Locale.ROOT).equals("usa flag") || this.getName().getString().toLowerCase(Locale.ROOT).equals("united states of america") || this.getName().getString().toLowerCase(Locale.ROOT).equals("united states") || this.getName().getString().toLowerCase(Locale.ROOT).equals("united states flag");
    }

    public boolean isWonderFlag() {
        return this.getName().getString().toLowerCase(Locale.ROOT).equals("wonder") || this.getName().getString().toLowerCase(Locale.ROOT).equals("wonder flag") || this.getName().getString().toLowerCase(Locale.ROOT).equals("flower") || this.getName().getString().toLowerCase(Locale.ROOT).equals("flower flag");
    }

    public void setWonderFlag(boolean hasWonderFlag) {
        this.renderWonderFlag = hasWonderFlag;
    }

    public boolean hasWonderFlag() {
        return this.renderWonderFlag;
    }

    public void setAmericanFlag(boolean hasAmericanFlag) {
        this.renderAmericanFlag = hasAmericanFlag;
    }

    public boolean hasAmericanFlag() {
        return this.renderAmericanFlag;
    }
}

