/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks.entities;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.wenxin2.marioverse.blocks.ClearWarpPipeBlock;
import com.wenxin2.marioverse.blocks.PipeBubblesBlock;
import com.wenxin2.marioverse.blocks.QuestionBlock;
import com.wenxin2.marioverse.blocks.WarpPipeBlock;
import com.wenxin2.marioverse.blocks.WaterSpoutBlock;
import com.wenxin2.marioverse.blocks.entities.BaseWarpBlockEntity;
import com.wenxin2.marioverse.blocks.entities.PipeText;
import com.wenxin2.marioverse.integration.CompatRegistry;
import com.wenxin2.marioverse.inventory.WarpPipeMenu;
import com.wenxin2.marioverse.registries.BlockEntityRegistry;
import com.wenxin2.marioverse.registries.BlockRegistry;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DataComponentRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.BlockWarpEntityHandler;
import com.wenxin2.marioverse.world.PipeSpawner;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownExperienceBottle;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ArmorStandItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.EndCrystalItem;
import net.minecraft.world.item.ExperienceBottleItem;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.WindChargeItem;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.ContainerSingleItem;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class WarpPipeBlockEntity
extends BaseWarpBlockEntity
implements MenuProvider,
Nameable,
Spawner,
ContainerSingleItem.BlockContainerSingleItem {
    public static final Map<Integer, Boolean> teleportedEntities = new HashMap<Integer, Boolean>();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Component DEFAULT_NAME = Component.translatable((String)"menu.marioverse.warp_pipe");
    private static final int MAX_TEXT_LINE_WIDTH = 78;
    private static final int TEXT_LINE_HEIGHT = 10;
    public PipeText pipeText = this.createDefaultPipeText();
    public static final String SPOUT_HEIGHT = "SpoutHeight";
    public static final String BUBBLES_DISTANCE = "BubblesDistance";
    public static final String DISPLAY_TEXT_NORTH = "displayTextNorth";
    public static final String DISPLAY_TEXT_SOUTH = "displayTextSouth";
    public static final String DISPLAY_TEXT_EAST = "displayTextEast";
    public static final String DISPLAY_TEXT_WEST = "displayTextWest";
    public static final String DISPLAY_TEXT_ABOVE = "displayTextAbove";
    public static final String DISPLAY_TEXT_BELOW = "displayTextBelow";
    public static final String CUSTOM_NAME = "CustomName";
    public static final String PIPE_NAME = "PipeName";
    @Nullable
    public Component name;
    public Component pipeName;
    private LockCode lockKey = LockCode.NO_LOCK;
    private ItemStack spawnItemStack = ItemStack.EMPTY;
    public int spoutHeight = 4;
    public int bubblesDistance = 3;
    public int spawnItemDelay = 20;
    public boolean displayTextNorth;
    public boolean displayTextSouth;
    public boolean displayTextEast;
    public boolean displayTextWest;
    public boolean displayTextAbove;
    public boolean displayTextBelow;
    private final PipeSpawner spawner = new PipeSpawner(){

        public void broadcastEvent(Level world, BlockPos pos, int eventId) {
            WarpPipeBlock block;
            DeferredBlock<Block> deferredBlock;
            Block block2 = world.getBlockState(pos).getBlock();
            if (block2 instanceof WarpPipeBlock && (deferredBlock = BlockRegistry.WARP_PIPES.get((block = (WarpPipeBlock)block2).getColor())) != null) {
                world.blockEvent(pos, (Block)deferredBlock.get(), eventId, 0);
            }
        }

        @Override
        public void setNextSpawnData(@Nullable Level world, BlockPos pos, SpawnData data) {
            super.setNextSpawnData(world, pos, data);
            if (world != null) {
                BlockState blockstate = world.getBlockState(pos);
                world.sendBlockUpdated(pos, blockstate, blockstate, 4);
            }
        }

        public Either<BlockEntity, Entity> getOwner() {
            return Either.left((Object)((Object)WarpPipeBlockEntity.this));
        }
    };

    public WarpPipeBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntityRegistry.WARP_PIPE_BLOCK_ENTITY.get(), pos, state);
    }

    public boolean isValidBlockState(BlockState state) {
        return this.getType().isValid(state) || state.getBlock() instanceof WarpPipeBlock;
    }

    public WarpPipeBlockEntity(BlockEntityType<?> tileEntity, BlockPos pos, BlockState state) {
        super(tileEntity, pos, state);
        this.displayTextNorth = Boolean.TRUE;
        this.displayTextSouth = Boolean.TRUE;
        this.displayTextEast = Boolean.TRUE;
        this.displayTextWest = Boolean.TRUE;
        this.displayTextAbove = Boolean.TRUE;
        this.displayTextBelow = Boolean.TRUE;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.lockKey.addToTag(tag);
        this.spawner.save(tag);
        tag.putShort("SpawnItemDelay", (short)this.spawnItemDelay);
        tag.putInt(BUBBLES_DISTANCE, this.bubblesDistance);
        tag.putInt(SPOUT_HEIGHT, this.spoutHeight);
        tag.putBoolean(DISPLAY_TEXT_NORTH, this.displayTextNorth);
        tag.putBoolean(DISPLAY_TEXT_SOUTH, this.displayTextSouth);
        tag.putBoolean(DISPLAY_TEXT_EAST, this.displayTextEast);
        tag.putBoolean(DISPLAY_TEXT_WEST, this.displayTextWest);
        tag.putBoolean(DISPLAY_TEXT_ABOVE, this.displayTextAbove);
        tag.putBoolean(DISPLAY_TEXT_BELOW, this.displayTextBelow);
        if (this.name != null) {
            tag.putString(CUSTOM_NAME, Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)provider));
        }
        if (this.pipeName != null) {
            tag.putString(PIPE_NAME, Component.Serializer.toJson((Component)this.pipeName, (HolderLookup.Provider)provider));
        }
        if (!this.spawnItemStack.isEmpty()) {
            tag.put("SpawnItem", this.spawnItemStack.save(provider));
        }
        PipeText.DIRECT_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.pipeText).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(pipeName -> tag.put(PIPE_NAME, pipeName));
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.lockKey = LockCode.fromTag((CompoundTag)tag);
        this.spawner.load(this.level, this.worldPosition, tag);
        this.spawnItemDelay = tag.getShort("SpawnItemDelay");
        this.spoutHeight = tag.getInt(SPOUT_HEIGHT);
        this.bubblesDistance = tag.getInt(BUBBLES_DISTANCE);
        this.displayTextNorth = tag.getBoolean(DISPLAY_TEXT_NORTH);
        this.displayTextSouth = tag.getBoolean(DISPLAY_TEXT_SOUTH);
        this.displayTextEast = tag.getBoolean(DISPLAY_TEXT_EAST);
        this.displayTextWest = tag.getBoolean(DISPLAY_TEXT_WEST);
        this.displayTextAbove = tag.getBoolean(DISPLAY_TEXT_ABOVE);
        this.displayTextBelow = tag.getBoolean(DISPLAY_TEXT_BELOW);
        if (tag.contains(CUSTOM_NAME, 8)) {
            this.name = WarpPipeBlockEntity.parseCustomNameSafe((String)tag.getString(CUSTOM_NAME), (HolderLookup.Provider)provider);
        }
        if (tag.contains(PIPE_NAME, 8)) {
            this.pipeName = WarpPipeBlockEntity.parseCustomNameSafe((String)tag.getString(PIPE_NAME), (HolderLookup.Provider)provider);
        }
        this.spawnItemStack = tag.contains("SpawnItem", 10) ? ItemStack.parse((HolderLookup.Provider)provider, (Tag)tag.getCompound("SpawnItem")).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
        if (tag.contains(PIPE_NAME)) {
            PipeText.DIRECT_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound(PIPE_NAME)).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(text -> {
                this.pipeText = this.loadLines((PipeText)text);
            });
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        ItemContainerContents contents = (ItemContainerContents)input.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        this.name = (Component)input.get(DataComponents.CUSTOM_NAME);
        this.pipeName = (Component)input.get(DataComponentRegistry.PIPE_NAME);
        this.spawnItemStack = contents.copyOne();
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(DataComponents.CUSTOM_NAME, (Object)this.name);
        builder.set(DataComponentRegistry.PIPE_NAME, (Object)this.pipeName);
        if (!this.spawnItemStack.isEmpty()) {
            builder.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(List.of(this.spawnItemStack)));
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = this.saveCustomOnly(provider);
        tag.remove("SpawnPotentials");
        return tag;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        if (this.level != null) {
            return new WarpPipeMenu(id, inventory, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.getBlockPos()));
        }
        return null;
    }

    public int getContainerSize() {
        return 1;
    }

    @NotNull
    public BlockEntity getContainerBlockEntity() {
        return this;
    }

    public void setTheItem(ItemStack stack) {
        this.spawnItemStack = stack;
    }

    @NotNull
    public ItemStack getTheItem() {
        return this.spawnItemStack;
    }

    @NotNull
    public ItemStack splitTheItem(int splitAmt) {
        ItemStack itemstack = this.spawnItemStack.split(splitAmt);
        if (this.spawnItemStack.isEmpty()) {
            this.spawnItemStack = ItemStack.EMPTY;
        }
        return itemstack;
    }

    public static void clientTick(Level world, BlockPos pos, BlockState state, WarpPipeBlockEntity warpPipeBE) {
        warpPipeBE.spawner.clientTick(world, pos);
    }

    public static void serverTick(Level world, BlockPos pos, BlockState state, WarpPipeBlockEntity warpPipeBE) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            warpPipeBE.spawner.serverTick(serverWorld, pos);
        }
        if (state.hasProperty((Property)WarpPipeBlock.CLOSED) && !((Boolean)state.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue()) {
            if (warpPipeBE.spawnItemDelay > 0 && !warpPipeBE.getTheItem().isEmpty()) {
                --warpPipeBE.spawnItemDelay;
            } else if (!warpPipeBE.getTheItem().isEmpty()) {
                ItemStack stack = warpPipeBE.getTheItem().copyWithCount(1);
                warpPipeBE.spawnFromWarpPipe(world, pos, stack);
                QuestionBlock.playSounds(world, pos, stack);
                warpPipeBE.spawnItemDelay = 180;
            }
        }
    }

    public boolean triggerEvent(int id, int type) {
        return this.level != null ? this.spawner.onEventTriggered(this.level, id) : super.triggerEvent(id, type);
    }

    public boolean onlyOpCanSetNbt() {
        return true;
    }

    public void setEntityId(@NotNull EntityType<?> entityType, RandomSource random) {
        this.spawner.setEntityId(entityType, this.level, random, this.worldPosition);
        this.setChanged();
    }

    public BaseSpawner getSpawner() {
        return this.spawner;
    }

    public void setCustomName(Component name) {
        this.name = name;
        this.markUpdated();
        this.getUpdatePacket();
    }

    public void setPipeName(Component name) {
        this.pipeName = name;
        this.pipeText.setMessage(0, name);
        this.markUpdated();
        this.getUpdatePacket();
    }

    @NotNull
    public Component getDisplayName() {
        return this.getName();
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    public Component getCustomName(Component name) {
        this.name = name;
        return this.name;
    }

    @NotNull
    public Component getName() {
        return !this.pipeText.getMessage(0, false).contains((Component)Component.empty()) ? this.pipeText.getMessage(0, false) : (this.name != null ? this.name : DEFAULT_NAME);
    }

    protected PipeText createDefaultPipeText() {
        return new PipeText();
    }

    public int getTextLineHeight() {
        return 10;
    }

    public int getMaxTextLineWidth() {
        return 78;
    }

    public PipeText getPipeText() {
        return this.pipeText;
    }

    public Component getPipeNameComponent() {
        return !this.pipeText.getMessage(0, false).contains((Component)Component.empty()) ? this.pipeText.getMessage(0, false) : (this.name != null ? this.name : DEFAULT_NAME);
    }

    public boolean updateText(UnaryOperator<PipeText> text) {
        PipeText pipeText = this.getPipeText();
        this.markUpdated();
        this.getUpdatePacket();
        return this.setText((PipeText)text.apply(pipeText));
    }

    public boolean setText(PipeText text) {
        if (text != this.pipeText) {
            this.pipeText = text;
            this.markUpdated();
            this.getUpdatePacket();
            return true;
        }
        return false;
    }

    public boolean hasTextNorth() {
        return this.displayTextNorth;
    }

    public boolean hasTextSouth() {
        return this.displayTextSouth;
    }

    public boolean hasTextEast() {
        return this.displayTextEast;
    }

    public boolean hasTextWest() {
        return this.displayTextWest;
    }

    public boolean hasTextAbove() {
        return this.displayTextAbove;
    }

    public boolean hasTextBelow() {
        return this.displayTextBelow;
    }

    public void setTextNorth(boolean displayTextNorth) {
        if (this.displayTextNorth != displayTextNorth) {
            this.displayTextNorth = displayTextNorth;
            this.markUpdated();
            this.getUpdatePacket();
        }
    }

    public void setTextSouth(boolean displayTextSouth) {
        if (this.displayTextSouth != displayTextSouth) {
            this.displayTextSouth = displayTextSouth;
            this.markUpdated();
            this.getUpdatePacket();
        }
    }

    public void setTextEast(boolean displayTextEast) {
        if (this.displayTextEast != displayTextEast) {
            this.displayTextEast = displayTextEast;
            this.markUpdated();
            this.getUpdatePacket();
        }
    }

    public void setTextWest(boolean displayTextWest) {
        if (this.displayTextWest != displayTextWest) {
            this.displayTextWest = displayTextWest;
            this.markUpdated();
            this.getUpdatePacket();
        }
    }

    public void setTextAbove(boolean displayTextAbove) {
        if (this.displayTextAbove != displayTextAbove) {
            this.displayTextAbove = displayTextAbove;
            this.markUpdated();
            this.getUpdatePacket();
        }
    }

    public void setTextBelow(boolean displayTextBelow) {
        if (this.displayTextBelow != displayTextBelow) {
            this.displayTextBelow = displayTextBelow;
            this.markUpdated();
            this.getUpdatePacket();
        }
    }

    @Override
    public void markUpdated() {
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    private static CommandSourceStack createCommandSourceStack(@Nullable Player player, Level world, BlockPos pos) {
        String s = player == null ? "Pipe" : player.getName().getString();
        MutableComponent component = player == null ? Component.literal((String)"Pipe") : player.getDisplayName();
        return new CommandSourceStack(CommandSource.NULL, Vec3.atCenterOf((Vec3i)pos), Vec2.ZERO, (ServerLevel)world, 2, s, (Component)component, world.getServer(), (Entity)player);
    }

    private PipeText loadLines(PipeText text) {
        for (int i = 0; i < 1; ++i) {
            Component message = this.loadLine(text.getMessage(i, false));
            Component filteredMessage = this.loadLine(text.getMessage(i, true));
            text = text.setMessage(i, message, filteredMessage);
        }
        return text;
    }

    private Component loadLine(Component text) {
        Level world = this.level;
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            try {
                return ComponentUtils.updateForEntity((CommandSourceStack)WarpPipeBlockEntity.createCommandSourceStack(null, (Level)serverWorld, this.worldPosition), (Component)text, null, (int)0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return text;
    }

    public void closePipe(ServerPlayer player) {
        if (this.level != null && player.containerMenu instanceof WarpPipeMenu) {
            BlockState state = this.level.getBlockState(((WarpPipeMenu)player.containerMenu).getBlockPos());
            BlockPos menuPos = ((WarpPipeMenu)player.containerMenu).getBlockPos();
            if (((Boolean)state.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue()) {
                this.level.setBlock(menuPos, (BlockState)state.setValue((Property)WarpPipeBlock.CLOSED, (Comparable)Boolean.FALSE), 3);
                this.playSound(this.level, menuPos, (SoundEvent)SoundRegistry.PIPE_OPENS.get(), SoundSource.BLOCKS, 1.0f, 0.15f);
            } else {
                if (this.level.getBlockState(menuPos.above()).getBlock() instanceof WaterSpoutBlock) {
                    this.level.destroyBlock(menuPos.above(), false);
                }
                this.level.setBlock(menuPos, (BlockState)state.setValue((Property)WarpPipeBlock.CLOSED, (Comparable)Boolean.TRUE), 0);
                this.playSound(this.level, menuPos, (SoundEvent)SoundRegistry.PIPE_CLOSES.get(), SoundSource.BLOCKS, 1.0f, 0.5f);
            }
        }
    }

    public void toggleWaterSpout(ServerPlayer player) {
        if (this.level != null && player.containerMenu instanceof WarpPipeMenu) {
            BlockState state = this.level.getBlockState(((WarpPipeMenu)player.containerMenu).getBlockPos());
            BlockPos menuPos = ((WarpPipeMenu)player.containerMenu).getBlockPos();
            if (((Boolean)state.getValue((Property)WarpPipeBlock.WATER_SPOUT)).booleanValue()) {
                this.level.setBlock(menuPos, (BlockState)state.setValue((Property)WarpPipeBlock.WATER_SPOUT, (Comparable)Boolean.FALSE), 3);
                this.level.scheduleTick(menuPos, state.getBlock(), 3);
                this.playSound(this.level, menuPos, (SoundEvent)SoundRegistry.WATER_SPOUT_BREAK.get(), SoundSource.BLOCKS, 1.0f, 0.15f);
            } else {
                this.level.setBlock(menuPos, (BlockState)state.setValue((Property)WarpPipeBlock.WATER_SPOUT, (Comparable)Boolean.TRUE), 3);
                this.level.scheduleTick(menuPos, state.getBlock(), 3);
                this.playSound(this.level, menuPos, (SoundEvent)SoundRegistry.WATER_SPOUT_PLACE.get(), SoundSource.BLOCKS, 1.0f, 0.5f);
            }
        }
    }

    public void waterSpoutHeight(ServerPlayer player, int spoutHeight) {
        if (this.level != null && this.getUpdatePacket() != null && player.containerMenu instanceof WarpPipeMenu && this.level.getBlockState(this.getBlockPos()).getBlock() instanceof WarpPipeBlock) {
            this.setSpoutHeight(spoutHeight);
        }
    }

    public void setSpoutHeight(int spoutHeight) {
        BlockPos pos;
        BlockEntity blockEntity;
        Level world = this.level;
        if (world != null && (blockEntity = world.getBlockEntity(pos = this.getBlockPos())) instanceof WarpPipeBlockEntity) {
            WarpPipeBlockEntity pipeBlockEntity = (WarpPipeBlockEntity)blockEntity;
            if (world.getBlockState(pos.above()).getBlock() instanceof WaterSpoutBlock) {
                world.destroyBlock(pos.above(), false);
            }
            this.spoutHeight = spoutHeight;
            pipeBlockEntity.setChanged();
        }
    }

    public int getSpoutHeight() {
        return this.spoutHeight;
    }

    public void bubblesDistance(ServerPlayer player, int bubblesDistance) {
        if (this.level != null && this.getUpdatePacket() != null && player.containerMenu instanceof WarpPipeMenu && this.level.getBlockState(this.getBlockPos()).getBlock() instanceof WarpPipeBlock) {
            this.setBubblesDistance(bubblesDistance);
        }
    }

    public void setBubblesDistance(int bubblesDistance) {
        Level world = this.level;
        if (world != null) {
            BlockPos pos = this.getBlockPos();
            BlockState state = world.getBlockState(pos);
            BlockState stateAbove = world.getBlockState(pos.above());
            BlockState stateBelow = world.getBlockState(pos.below());
            BlockState stateNorth = world.getBlockState(pos.north());
            BlockState stateSouth = world.getBlockState(pos.south());
            BlockState stateEast = world.getBlockState(pos.east());
            BlockState stateWest = world.getBlockState(pos.west());
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof WarpPipeBlockEntity) {
                WarpPipeBlockEntity pipeBlockEntity = (WarpPipeBlockEntity)blockEntity;
                if (stateAbove.getBlock() instanceof PipeBubblesBlock && state.getValue((Property)WarpPipeBlock.FACING) == Direction.UP) {
                    world.destroyBlock(pos.above(), false);
                }
                if (stateBelow.getBlock() instanceof PipeBubblesBlock && state.getValue((Property)WarpPipeBlock.FACING) == Direction.DOWN) {
                    world.destroyBlock(pos.below(), false);
                }
                if (stateNorth.getBlock() instanceof PipeBubblesBlock && state.getValue((Property)WarpPipeBlock.FACING) == Direction.NORTH) {
                    world.destroyBlock(pos.north(), false);
                }
                if (stateSouth.getBlock() instanceof PipeBubblesBlock && state.getValue((Property)WarpPipeBlock.FACING) == Direction.SOUTH) {
                    world.destroyBlock(pos.south(), false);
                }
                if (stateEast.getBlock() instanceof PipeBubblesBlock && state.getValue((Property)WarpPipeBlock.FACING) == Direction.EAST) {
                    world.destroyBlock(pos.east(), false);
                }
                if (stateWest.getBlock() instanceof PipeBubblesBlock && state.getValue((Property)WarpPipeBlock.FACING) == Direction.WEST) {
                    world.destroyBlock(pos.west(), false);
                }
                this.bubblesDistance = bubblesDistance;
                pipeBlockEntity.setChanged();
            }
        }
    }

    public int getBubblesDistance() {
        return this.bubblesDistance;
    }

    public void togglePipeBubbles(ServerPlayer player) {
        if (this.level != null && player.containerMenu instanceof WarpPipeMenu) {
            BlockState state = this.level.getBlockState(((WarpPipeMenu)player.containerMenu).getBlockPos());
            BlockPos menuPos = ((WarpPipeMenu)player.containerMenu).getBlockPos();
            if (((Boolean)state.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue()) {
                this.level.setBlock(menuPos, (BlockState)state.setValue((Property)WarpPipeBlock.BUBBLES, (Comparable)Boolean.FALSE), 3);
                this.level.scheduleTick(menuPos, state.getBlock(), 3);
                this.playSound(this.level, menuPos, SoundEvents.BUBBLE_COLUMN_BUBBLE_POP, SoundSource.BLOCKS, 1.0f, 0.15f);
            } else {
                this.level.setBlock(menuPos, (BlockState)state.setValue((Property)WarpPipeBlock.BUBBLES, (Comparable)Boolean.TRUE), 3);
                this.level.scheduleTick(menuPos, state.getBlock(), 3);
                this.playSound(this.level, menuPos, SoundEvents.BUBBLE_COLUMN_UPWARDS_AMBIENT, SoundSource.BLOCKS, 1.0f, 0.5f);
            }
        }
    }

    public static void markEntityTeleported(Entity entity) {
        if (entity != null) {
            teleportedEntities.put(entity.getId(), true);
        }
    }

    public static void warp(Entity entity, BlockPos warpPos, Level world, BlockState state) {
        BlockWarpEntityHandler handler;
        LivingEntity passengerEntity = entity.getControllingPassenger();
        if (entity instanceof BlockWarpEntityHandler && !(handler = (BlockWarpEntityHandler)entity).mv$doPreventWarp()) {
            Player player;
            Player player2;
            if (state.getBlock() instanceof ClearWarpPipeBlock && !((Boolean)state.getValue((Property)WarpPipeBlock.ENTRANCE)).booleanValue()) {
                handler.mv$setWarpCooldown((Integer)ConfigRegistry.WARP_PIPE_COOLDOWN.get());
                if (entity instanceof Player) {
                    player2 = (Player)entity;
                    entity.teleportTo((double)warpPos.getX() + 0.5, (double)warpPos.getY() - 1.0, (double)warpPos.getZ() + 0.5);
                    world.broadcastEntityEvent(entity, (byte)120);
                    if (((Boolean)ConfigRegistry.BLINDNESS_EFFECT.get()).booleanValue() && !world.isClientSide()) {
                        player2.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 1, 0));
                    }
                } else {
                    entity.teleportTo((double)warpPos.getX() + 0.5, (double)warpPos.getY() - 1.0, (double)warpPos.getZ() + 0.5);
                    world.broadcastEntityEvent(entity, (byte)120);
                    if (passengerEntity instanceof Player) {
                        player = (Player)passengerEntity;
                        if (((Boolean)ConfigRegistry.BLINDNESS_EFFECT.get()).booleanValue() && !world.isClientSide()) {
                            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 1, 0));
                        }
                        entity.unRide();
                    }
                }
            }
            if (world.getBlockState(warpPos).getValue((Property)DirectionalBlock.FACING) == Direction.UP && ((Boolean)state.getValue((Property)WarpPipeBlock.ENTRANCE)).booleanValue()) {
                handler.mv$setWarpCooldown((Integer)ConfigRegistry.WARP_PIPE_COOLDOWN.get());
                if (entity instanceof Player) {
                    player2 = (Player)entity;
                    entity.teleportTo((double)warpPos.getX() + 0.5, (double)warpPos.getY() + 1.0, (double)warpPos.getZ() + 0.5);
                    world.broadcastEntityEvent(entity, (byte)120);
                    if (((Boolean)ConfigRegistry.BLINDNESS_EFFECT.get()).booleanValue() && !world.isClientSide()) {
                        player2.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 20, 0, true, false));
                    }
                } else {
                    entity.teleportTo((double)warpPos.getX() + 0.5, (double)warpPos.getY() + 1.0, (double)warpPos.getZ() + 0.5);
                    world.broadcastEntityEvent(entity, (byte)120);
                    if (passengerEntity instanceof Player) {
                        player = (Player)passengerEntity;
                        if (((Boolean)ConfigRegistry.BLINDNESS_EFFECT.get()).booleanValue() && !world.isClientSide()) {
                            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 20, 0, true, false));
                        }
                        entity.unRide();
                    }
                }
            }
            if (world.getBlockState(warpPos).getValue((Property)DirectionalBlock.FACING) == Direction.DOWN && ((Boolean)state.getValue((Property)WarpPipeBlock.ENTRANCE)).booleanValue()) {
                handler.mv$setWarpCooldown((Integer)ConfigRegistry.WARP_PIPE_COOLDOWN.get());
                if (entity instanceof Player) {
                    player2 = (Player)entity;
                    entity.teleportTo((double)warpPos.getX() + 0.5, (double)((float)warpPos.getY() - entity.getBbHeight()), (double)warpPos.getZ() + 0.5);
                    world.broadcastEntityEvent(entity, (byte)120);
                    if (((Boolean)ConfigRegistry.BLINDNESS_EFFECT.get()).booleanValue() && !world.isClientSide()) {
                        player2.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 20, 0, true, false));
                    }
                } else {
                    entity.teleportTo((double)warpPos.getX() + 0.5, (double)((float)warpPos.getY() - entity.getBbHeight()), (double)warpPos.getZ() + 0.5);
                    world.broadcastEntityEvent(entity, (byte)120);
                    if (passengerEntity instanceof Player) {
                        player = (Player)passengerEntity;
                        if (((Boolean)ConfigRegistry.BLINDNESS_EFFECT.get()).booleanValue() && !world.isClientSide()) {
                            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 20, 0, true, false));
                        }
                        entity.unRide();
                    }
                }
            }
            if (world.getBlockState(warpPos).getValue((Property)DirectionalBlock.FACING) == Direction.NORTH && ((Boolean)state.getValue((Property)WarpPipeBlock.ENTRANCE)).booleanValue()) {
                handler.mv$setWarpCooldown((Integer)ConfigRegistry.WARP_PIPE_COOLDOWN.get());
                if (entity instanceof Player) {
                    player2 = (Player)entity;
                    entity.teleportTo((double)warpPos.getX() + 0.5, (double)warpPos.getY(), (double)((float)warpPos.getZ() - entity.getBbWidth()));
                    world.broadcastEntityEvent(entity, (byte)120);
                    if (((Boolean)ConfigRegistry.BLINDNESS_EFFECT.get()).booleanValue() && !world.isClientSide()) {
                        player2.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 20, 0, true, false));
                    }
                } else {
                    entity.teleportTo((double)warpPos.getX() + 0.5, (double)warpPos.getY(), (double)((float)warpPos.getZ() - entity.getBbWidth()));
                    world.broadcastEntityEvent(entity, (byte)120);
                    if (passengerEntity instanceof Player) {
                        player = (Player)passengerEntity;
                        if (((Boolean)ConfigRegistry.BLINDNESS_EFFECT.get()).booleanValue() && !world.isClientSide()) {
                            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 20, 0, true, false));
                        }
                        entity.unRide();
                    }
                }
            }
            if (world.getBlockState(warpPos).getValue((Property)DirectionalBlock.FACING) == Direction.SOUTH && ((Boolean)state.getValue((Property)WarpPipeBlock.ENTRANCE)).booleanValue()) {
                handler.mv$setWarpCooldown((Integer)ConfigRegistry.WARP_PIPE_COOLDOWN.get());
                if (entity instanceof Player) {
                    player2 = (Player)entity;
                    entity.teleportTo((double)warpPos.getX() + 0.5, (double)warpPos.getY(), (double)((float)warpPos.getZ() + entity.getBbWidth()) + 1.0);
                    world.broadcastEntityEvent(entity, (byte)120);
                    if (((Boolean)ConfigRegistry.BLINDNESS_EFFECT.get()).booleanValue() && !world.isClientSide()) {
                        player2.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 20, 0, true, false));
                    }
                } else {
                    entity.teleportTo((double)warpPos.getX() + 0.5, (double)warpPos.getY(), (double)((float)warpPos.getZ() + entity.getBbWidth()) + 1.0);
                    world.broadcastEntityEvent(entity, (byte)120);
                    if (passengerEntity instanceof Player) {
                        player = (Player)passengerEntity;
                        if (((Boolean)ConfigRegistry.BLINDNESS_EFFECT.get()).booleanValue() && !world.isClientSide()) {
                            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 20, 0, true, false));
                        }
                        entity.unRide();
                    }
                }
            }
            if (world.getBlockState(warpPos).getValue((Property)DirectionalBlock.FACING) == Direction.EAST && ((Boolean)state.getValue((Property)WarpPipeBlock.ENTRANCE)).booleanValue()) {
                handler.mv$setWarpCooldown((Integer)ConfigRegistry.WARP_PIPE_COOLDOWN.get());
                if (entity instanceof Player) {
                    player2 = (Player)entity;
                    entity.teleportTo((double)((float)warpPos.getX() + entity.getBbWidth()) + 1.0, (double)warpPos.getY(), (double)warpPos.getZ() + 0.5);
                    world.broadcastEntityEvent(entity, (byte)120);
                    if (((Boolean)ConfigRegistry.BLINDNESS_EFFECT.get()).booleanValue() && !world.isClientSide()) {
                        player2.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 20, 0, true, false));
                    }
                } else {
                    entity.teleportTo((double)((float)warpPos.getX() + entity.getBbWidth()) + 1.0, (double)warpPos.getY(), (double)warpPos.getZ() + 0.5);
                    world.broadcastEntityEvent(entity, (byte)120);
                    if (passengerEntity instanceof Player) {
                        player = (Player)passengerEntity;
                        if (((Boolean)ConfigRegistry.BLINDNESS_EFFECT.get()).booleanValue() && !world.isClientSide()) {
                            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 20, 0, true, false));
                        }
                        entity.unRide();
                    }
                }
            }
            if (world.getBlockState(warpPos).getValue((Property)DirectionalBlock.FACING) == Direction.WEST && ((Boolean)state.getValue((Property)WarpPipeBlock.ENTRANCE)).booleanValue()) {
                handler.mv$setWarpCooldown((Integer)ConfigRegistry.WARP_PIPE_COOLDOWN.get());
                if (entity instanceof Player) {
                    player2 = (Player)entity;
                    entity.teleportTo((double)((float)warpPos.getX() - entity.getBbWidth()), (double)warpPos.getY(), (double)warpPos.getZ() + 0.5);
                    world.broadcastEntityEvent(entity, (byte)120);
                    if (((Boolean)ConfigRegistry.BLINDNESS_EFFECT.get()).booleanValue() && !world.isClientSide()) {
                        player2.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 20, 0, true, false));
                    }
                } else {
                    entity.teleportTo((double)((float)warpPos.getX() - entity.getBbWidth()), (double)warpPos.getY(), (double)warpPos.getZ() + 0.5);
                    world.broadcastEntityEvent(entity, (byte)120);
                    if (passengerEntity instanceof Player) {
                        player = (Player)passengerEntity;
                        if (((Boolean)ConfigRegistry.BLINDNESS_EFFECT.get()).booleanValue() && !world.isClientSide()) {
                            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 20, 0, true, false));
                        }
                        entity.unRide();
                    }
                }
            }
        }
        WarpPipeBlockEntity.markEntityTeleported(entity);
        world.gameEvent((Holder)GameEvent.TELEPORT, warpPos, GameEvent.Context.of((Entity)entity));
        world.playSound(null, warpPos, (SoundEvent)SoundRegistry.PIPE_WARPS.get(), SoundSource.BLOCKS);
    }

    public void sendData() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            serverWorld.getChunkSource().blockChanged(this.getBlockPos());
        }
    }

    public void spawnFromWarpPipe(Level world, BlockPos pos, ItemStack stack) {
        Direction facing = world.getBlockState(pos).getOptionalValue((Property)BlockStateProperties.FACING).orElse(Direction.UP);
        BlockPos spawnPos = world.getBlockState(pos).hasProperty((Property)BlockStateProperties.FACING) ? pos.relative(facing) : pos.above();
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            this.spawnItemEntity(world, stack, serverWorld, spawnPos);
        }
    }

    private void spawnItemEntity(Level world, ItemStack stack, ServerLevel serverWorld, BlockPos spawnPos) {
        if (stack.getItem() instanceof ArmorStandItem) {
            Consumer consumer = EntityType.createDefaultStackConfig((ServerLevel)serverWorld, (ItemStack)stack, null);
            ArmorStand armorStand = (ArmorStand)EntityType.ARMOR_STAND.create(serverWorld, consumer, spawnPos, MobSpawnType.SPAWN_EGG, true, true);
            if (armorStand != null && !armorStand.getType().is(TagRegistry.WARP_PIPE_CANNOT_SPAWN)) {
                if (!world.getEntitiesOfClass(ArmorStand.class, new AABB(spawnPos)).isEmpty()) {
                    return;
                }
                armorStand.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                world.addFreshEntity((Entity)armorStand);
                stack.copyWithCount(1);
            } else {
                this.spawnItem(world, spawnPos, stack);
            }
        } else {
            Item consumer = stack.getItem();
            if (consumer instanceof MinecartItem) {
                MinecartItem cart = (MinecartItem)consumer;
                abstractMinecart = AbstractMinecart.createMinecart((ServerLevel)serverWorld, (double)((double)spawnPos.getX() + 0.5), (double)((double)spawnPos.getY() + 1.0), (double)((double)spawnPos.getZ() + 0.5), (AbstractMinecart.Type)cart.type, (ItemStack)stack, null);
                if (!abstractMinecart.getType().is(TagRegistry.WARP_PIPE_CANNOT_SPAWN)) {
                    if (!world.getEntitiesOfClass(AbstractMinecart.class, new AABB(spawnPos)).isEmpty()) {
                        return;
                    }
                    abstractMinecart.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                    world.addFreshEntity((Entity)abstractMinecart);
                    stack.copyWithCount(1);
                } else {
                    this.spawnItem(world, spawnPos, stack);
                }
            } else {
                abstractMinecart = stack.getItem();
                if (abstractMinecart instanceof BoatItem) {
                    BoatItem boatItem = (BoatItem)abstractMinecart;
                    Object object = boat = boatItem.hasChest ? new ChestBoat((Level)serverWorld, (double)spawnPos.getX() + 0.5, (double)spawnPos.getY() + 1.0, (double)spawnPos.getZ() + 0.5) : new Boat((Level)serverWorld, (double)spawnPos.getX() + 0.5, (double)spawnPos.getY() + 1.0, (double)spawnPos.getZ() + 0.5);
                    if (!boat.getType().is(TagRegistry.WARP_PIPE_CANNOT_SPAWN)) {
                        if (!world.getEntitiesOfClass(Boat.class, new AABB(spawnPos)).isEmpty()) {
                            return;
                        }
                        boat.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                        boat.setVariant(boatItem.type);
                        world.addFreshEntity((Entity)boat);
                        stack.copyWithCount(1);
                    } else {
                        this.spawnItem(world, spawnPos, stack);
                    }
                } else {
                    BlockItem blockItem;
                    boat = stack.getItem();
                    if (boat instanceof BlockItem && (blockItem = (BlockItem)boat).getBlock() instanceof TntBlock) {
                        PrimedTnt primedtnt = new PrimedTnt((Level)serverWorld, (double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, null);
                        if (!primedtnt.getType().is(TagRegistry.WARP_PIPE_CANNOT_SPAWN)) {
                            primedtnt.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                            world.addFreshEntity((Entity)primedtnt);
                            stack.copyWithCount(1);
                            serverWorld.gameEvent(null, (Holder)GameEvent.PRIME_FUSE, spawnPos);
                        } else {
                            this.spawnItem(world, spawnPos, stack);
                        }
                    } else if (stack.getItem() instanceof WindChargeItem) {
                        WindCharge windCharge = new WindCharge((Level)serverWorld, (double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, new Vec3(0.0, -1.0, 0.0));
                        if (!windCharge.getType().is(TagRegistry.WARP_PIPE_CANNOT_SPAWN)) {
                            windCharge.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                            world.addFreshEntity((Entity)windCharge);
                            stack.copyWithCount(1);
                        } else {
                            this.spawnItem(world, spawnPos, stack);
                        }
                    } else if (stack.getItem() instanceof FireChargeItem) {
                        SmallFireball fireball = new SmallFireball((Level)serverWorld, (double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, new Vec3(0.0, -0.5, 0.0));
                        if (!fireball.getType().is(TagRegistry.WARP_PIPE_CANNOT_SPAWN)) {
                            fireball.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                            world.addFreshEntity((Entity)fireball);
                            stack.copyWithCount(1);
                        } else {
                            this.spawnItem(world, spawnPos, stack);
                        }
                    } else if (stack.getItem() instanceof ThrowablePotionItem) {
                        ThrownPotion potion = new ThrownPotion((Level)serverWorld, (double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                        if (!potion.getType().is(TagRegistry.WARP_PIPE_CANNOT_SPAWN)) {
                            potion.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                            potion.setItem(stack);
                            world.addFreshEntity((Entity)potion);
                            stack.copyWithCount(1);
                        } else {
                            this.spawnItem(world, spawnPos, stack);
                        }
                    } else if (stack.getItem() instanceof ExperienceBottleItem) {
                        ThrownExperienceBottle xpBottle = new ThrownExperienceBottle((Level)serverWorld, (double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                        if (!xpBottle.getType().is(TagRegistry.WARP_PIPE_CANNOT_SPAWN)) {
                            xpBottle.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                            xpBottle.setItem(stack);
                            world.addFreshEntity((Entity)xpBottle);
                            stack.copyWithCount(1);
                        } else {
                            this.spawnItem(world, spawnPos, stack);
                        }
                    } else if (stack.getItem() instanceof EndCrystalItem) {
                        EndCrystal endCrystal = new EndCrystal((Level)serverWorld, (double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                        if (!endCrystal.getType().is(TagRegistry.WARP_PIPE_CANNOT_SPAWN)) {
                            endCrystal.setPos((double)spawnPos.getX() + 0.5, (double)((float)spawnPos.getY() - endCrystal.getBbHeight()), (double)spawnPos.getZ() + 0.5);
                            endCrystal.setDeltaMovement(new Vec3(0.0, -1.0, 0.0));
                            endCrystal.setShowBottom(false);
                            world.addFreshEntity((Entity)endCrystal);
                            world.gameEvent(null, (Holder)GameEvent.ENTITY_PLACE, spawnPos);
                            stack.copyWithCount(1);
                        } else {
                            this.spawnItem(world, spawnPos, stack);
                        }
                    } else if (stack.getItem() instanceof FireworkRocketItem) {
                        FireworkRocketEntity firework = new FireworkRocketEntity((Level)serverWorld, (double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, stack);
                        if (!firework.getType().is(TagRegistry.WARP_PIPE_CANNOT_SPAWN)) {
                            firework.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                            world.addFreshEntity((Entity)firework);
                            stack.copyWithCount(1);
                        } else {
                            this.spawnItem(world, spawnPos, stack);
                        }
                    } else if (stack.getItem() instanceof EggItem) {
                        ThrownEgg egg = new ThrownEgg((Level)serverWorld, (double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                        if (!egg.getType().is(TagRegistry.WARP_PIPE_CANNOT_SPAWN)) {
                            egg.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                            egg.setItem(stack);
                            world.addFreshEntity((Entity)egg);
                            stack.copyWithCount(1);
                        } else {
                            this.spawnItem(world, spawnPos, stack);
                        }
                    } else if (stack.getItem() == CompatRegistry.HAT_STAND_ITEM.get()) {
                        entity = CompatRegistry.HAT_STAND.get().create((Level)serverWorld);
                        if (entity != null && !entity.getType().is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                            entity.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                            world.addFreshEntity(entity);
                            stack.copyWithCount(1);
                        } else {
                            this.spawnItem(world, spawnPos, stack);
                        }
                    } else if (stack.getItem() == CompatRegistry.CANNONBALL_ITEM.get()) {
                        entity = CompatRegistry.CANNONBALL.get().create((Level)serverWorld);
                        if (entity != null && !entity.getType().is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                            entity.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                            entity.setDeltaMovement(new Vec3(world.random.triangle(0.0, 0.3), world.random.triangle(0.5, 0.3), world.random.triangle(0.0, 0.3)));
                            world.addFreshEntity(entity);
                            stack.copyWithCount(1);
                        } else {
                            this.spawnItem(world, spawnPos, stack);
                        }
                    } else if (stack.getItem() == CompatRegistry.BOMB_ITEM.get()) {
                        entity = CompatRegistry.BOMB.get().create((Level)serverWorld);
                        if (entity != null && !entity.getType().is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                            entity.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                            entity.setDeltaMovement(new Vec3(world.random.triangle(0.0, 0.2), world.random.triangle(0.5, 0.2), world.random.triangle(0.0, 0.2)));
                            world.addFreshEntity(entity);
                            stack.copyWithCount(1);
                        } else {
                            this.spawnItem(world, spawnPos, stack);
                        }
                    } else if (stack.getItem() == CompatRegistry.BOMB_BLUE_ITEM.get()) {
                        entity = CompatRegistry.BOMB.get().create((Level)serverWorld);
                        if (entity != null && !entity.getType().is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                            CompoundTag nbt = new CompoundTag();
                            entity.save(nbt);
                            nbt.putInt("Type", 1);
                            entity.load(nbt);
                            entity.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                            entity.setDeltaMovement(new Vec3(0.0, -0.5, 0.0));
                            world.addFreshEntity(entity);
                            stack.copyWithCount(1);
                        } else {
                            this.spawnItem(world, spawnPos, stack);
                        }
                    } else if (stack.getItem() == CompatRegistry.BOMB_SPIKY_ITEM.get()) {
                        entity = CompatRegistry.BOMB.get().create((Level)serverWorld);
                        if (entity != null && !entity.getType().is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                            CompoundTag nbt = new CompoundTag();
                            entity.save(nbt);
                            nbt.putInt("Type", 2);
                            entity.load(nbt);
                            entity.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                            entity.setDeltaMovement(new Vec3(0.0, -0.5, 0.0));
                            world.addFreshEntity(entity);
                            stack.copyWithCount(1);
                        } else {
                            this.spawnItem(world, spawnPos, stack);
                        }
                    } else if (stack.getItem() == CompatRegistry.CONFETTI_POPPER_ITEM.get()) {
                        entity = (Creeper)EntityType.CREEPER.create((Level)serverWorld);
                        if (entity != null) {
                            CompoundTag nbt = new CompoundTag();
                            entity.save(nbt);
                            nbt.putBoolean("Party", true);
                            nbt.putInt("Fuse", 0);
                            entity.setNoAi(true);
                            entity.ignite();
                            entity.setInvisible(true);
                            entity.setSilent(true);
                            entity.load(nbt);
                            entity.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                            world.addFreshEntity(entity);
                        }
                        world.gameEvent(null, (Holder)GameEvent.EXPLODE, spawnPos);
                    } else if (stack.getItem() == CompatRegistry.ICE_BOMB_ITEM.get()) {
                        entity = CompatRegistry.ICE_BOMB.get().create((Level)serverWorld);
                        if (entity != null && !entity.getType().is(TagRegistry.CHECKPOINT_FLAG_CANNOT_SPAWN)) {
                            entity.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                            world.addFreshEntity(entity);
                            stack.copyWithCount(1);
                        } else {
                            this.spawnItem(world, spawnPos, stack);
                        }
                    } else {
                        this.spawnItem(world, spawnPos, stack);
                    }
                }
            }
        }
    }

    public void spawnItem(Level world, BlockPos pos, ItemStack stack) {
        double y;
        double x;
        Direction facing = world.getBlockState(pos).getOptionalValue((Property)BlockStateProperties.FACING).orElse(Direction.UP);
        double entityWidth = 0.125;
        double entityHeight = 0.25;
        BlockPos spawnPos = pos.relative(facing);
        double z = switch (facing) {
            default -> {
                x = (double)spawnPos.getX() + 0.5;
                y = (double)spawnPos.getY() - 1.0;
                yield (double)spawnPos.getZ() + 0.5;
            }
            case Direction.DOWN -> {
                x = (double)spawnPos.getX() + 0.5;
                y = (double)spawnPos.getY() - 1.0 - entityHeight - 0.1;
                yield (double)spawnPos.getZ() + 0.5;
            }
            case Direction.NORTH -> {
                x = (double)spawnPos.getX() + 0.5;
                y = (double)spawnPos.getY() - 1.0;
                yield (double)spawnPos.getZ() - entityWidth - 0.1;
            }
            case Direction.SOUTH -> {
                x = (double)spawnPos.getX() + 0.5;
                y = (double)spawnPos.getY() - 1.0;
                yield (double)spawnPos.getZ() + entityWidth + 0.1;
            }
            case Direction.WEST -> {
                x = (double)spawnPos.getX() - entityWidth - 0.1;
                y = (double)spawnPos.getY() - 1.0;
                yield (double)spawnPos.getZ() + 0.5;
            }
            case Direction.EAST -> {
                x = (double)spawnPos.getX() + entityWidth + 0.1;
                y = (double)spawnPos.getY() - 1.0;
                yield (double)spawnPos.getZ() + 0.5;
            }
        };
        double baseSpeed = 0.2;
        Vec3 velocity = switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> new Vec3(world.random.triangle(0.0, 0.2), world.random.triangle(0.5, 0.2), -baseSpeed);
            case Direction.SOUTH -> new Vec3(world.random.triangle(0.0, 0.2), world.random.triangle(0.5, 0.2), baseSpeed);
            case Direction.EAST -> new Vec3(baseSpeed, world.random.triangle(0.5, 0.2), world.random.triangle(0.0, 0.2));
            case Direction.WEST -> new Vec3(-baseSpeed, world.random.triangle(0.5, 0.2), world.random.triangle(0.0, 0.2));
            case Direction.UP -> new Vec3(world.random.triangle(0.0, 0.2), baseSpeed, world.random.triangle(0.0, 0.2));
            case Direction.DOWN -> new Vec3(0.0, -baseSpeed, 0.0);
        };
        ItemEntity itemEntity = new ItemEntity(world, x, y, z, stack);
        itemEntity.setDeltaMovement(velocity);
        world.addFreshEntity((Entity)itemEntity);
    }
}

