/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.utils;

import com.wenxin2.marioverse.entities.power_ups.AbstractPowerUpEntity;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.data.SlotTypeLoader;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface CostumeHandler {
    default public boolean mv$hasMarioCostume(LivingEntity entity) {
        if (entity.getItemBySlot(EquipmentSlot.HEAD).is(TagRegistry.MARIO_COSTUMES) && entity.getItemBySlot(EquipmentSlot.CHEST).is(TagRegistry.MARIO_COSTUMES) && entity.getItemBySlot(EquipmentSlot.LEGS).is(TagRegistry.MARIO_COSTUMES) && entity.getItemBySlot(EquipmentSlot.FEET).is(TagRegistry.MARIO_COSTUMES)) {
            return true;
        }
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)entity);
        if (capability != null) {
            AccessoriesContainer containerHat = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_hat"));
            AccessoriesContainer containerShirt = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_shirt"));
            AccessoriesContainer containerPants = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_pants"));
            AccessoriesContainer containerShoes = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_shoes"));
            if (containerHat != null && containerShirt != null && containerPants != null && containerShoes != null) {
                ItemStack stackHat = containerHat.getAccessories().getItem(0);
                ItemStack stackShirt = containerShirt.getAccessories().getItem(0);
                ItemStack stackPants = containerPants.getAccessories().getItem(0);
                ItemStack stackShoes = containerShoes.getAccessories().getItem(0);
                return stackHat.is(TagRegistry.MARIO_COSTUMES) && stackShirt.is(TagRegistry.MARIO_COSTUMES) && stackPants.is(TagRegistry.MARIO_COSTUMES) && stackShoes.is(TagRegistry.MARIO_COSTUMES);
            }
        }
        return false;
    }

    default public boolean mv$hasLuigiCostume(LivingEntity entity) {
        if (entity.getItemBySlot(EquipmentSlot.HEAD).is(TagRegistry.LUIGI_COSTUMES) && entity.getItemBySlot(EquipmentSlot.CHEST).is(TagRegistry.LUIGI_COSTUMES) && entity.getItemBySlot(EquipmentSlot.LEGS).is(TagRegistry.LUIGI_COSTUMES) && entity.getItemBySlot(EquipmentSlot.FEET).is(TagRegistry.LUIGI_COSTUMES)) {
            return true;
        }
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)entity);
        if (capability != null) {
            AccessoriesContainer containerHat = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_hat"));
            AccessoriesContainer containerShirt = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_shirt"));
            AccessoriesContainer containerPants = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_pants"));
            AccessoriesContainer containerShoes = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_shoes"));
            if (containerHat != null && containerShirt != null && containerPants != null && containerShoes != null) {
                ItemStack stackHat = containerHat.getAccessories().getItem(0);
                ItemStack stackShirt = containerShirt.getAccessories().getItem(0);
                ItemStack stackPants = containerPants.getAccessories().getItem(0);
                ItemStack stackShoes = containerShoes.getAccessories().getItem(0);
                return stackHat.is(TagRegistry.LUIGI_COSTUMES) && stackShirt.is(TagRegistry.LUIGI_COSTUMES) && stackPants.is(TagRegistry.LUIGI_COSTUMES) && stackShoes.is(TagRegistry.LUIGI_COSTUMES);
            }
        }
        return false;
    }

    default public boolean mv$hasPeachCostume(LivingEntity entity) {
        if (entity.getItemBySlot(EquipmentSlot.HEAD).is(TagRegistry.PEACH_COSTUMES) && entity.getItemBySlot(EquipmentSlot.CHEST).is(TagRegistry.PEACH_COSTUMES) && entity.getItemBySlot(EquipmentSlot.LEGS).is(TagRegistry.PEACH_COSTUMES) && entity.getItemBySlot(EquipmentSlot.FEET).is(TagRegistry.PEACH_COSTUMES)) {
            return true;
        }
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)entity);
        if (capability != null) {
            AccessoriesContainer containerHat = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_hat"));
            AccessoriesContainer containerShirt = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_shirt"));
            AccessoriesContainer containerPants = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_pants"));
            AccessoriesContainer containerShoes = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_shoes"));
            if (containerHat != null && containerShirt != null && containerPants != null && containerShoes != null) {
                ItemStack stackHat = containerHat.getAccessories().getItem(0);
                ItemStack stackShirt = containerShirt.getAccessories().getItem(0);
                ItemStack stackPants = containerPants.getAccessories().getItem(0);
                ItemStack stackShoes = containerShoes.getAccessories().getItem(0);
                return stackHat.is(TagRegistry.PEACH_COSTUMES) && stackShirt.is(TagRegistry.PEACH_COSTUMES) && stackPants.is(TagRegistry.PEACH_COSTUMES) && stackShoes.is(TagRegistry.PEACH_COSTUMES);
            }
        }
        return false;
    }

    default public void applyCostumeChange(LivingEntity entity, AbstractPowerUpEntity powerUp) {
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)entity);
        if (capability != null) {
            if (entity instanceof Player && ((Boolean)ConfigRegistry.EQUIP_COSTUMES_PLAYERS.get()).booleanValue()) {
                this.updateCostume(entity, powerUp, capability);
            } else if (!(entity instanceof Player) && ((Boolean)ConfigRegistry.EQUIP_COSTUMES_MOBS.get()).booleanValue()) {
                this.updateCostume(entity, powerUp, capability);
            }
        }
    }

    default public void updateCostume(LivingEntity entity, AbstractPowerUpEntity powerUp, AccessoriesCapability capability) {
        ItemStack stack;
        AccessoriesContainer containerHat = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_hat"));
        AccessoriesContainer containerShirt = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_shirt"));
        AccessoriesContainer containerPants = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_pants"));
        AccessoriesContainer containerShoes = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_shoes"));
        int randomIndex = (int)(Math.random() * (double)powerUp.getPowerUpHatItems().size());
        if (entity.getType().is(TagRegistry.EQUIP_COSTUMES_IN_ARMOR_SLOTS)) {
            block6: for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (!slot.isArmor()) continue;
                ItemStack currentStack = entity.getItemBySlot(slot);
                switch (slot) {
                    case HEAD: {
                        ItemStack stackArmor = entity.getItemBySlot(EquipmentSlot.HEAD);
                        ItemStack newStack = powerUp.getPowerUpHatItems().get(randomIndex);
                        if (!stackArmor.isEmpty() && !stackArmor.is(TagRegistry.COSTUMES)) continue block6;
                        this.equipCostumesInArmorSlots(entity, powerUp, slot, stackArmor, powerUp.getPowerUpHatItems(), newStack, currentStack);
                        continue block6;
                    }
                    case CHEST: {
                        ItemStack stackArmor = entity.getItemBySlot(EquipmentSlot.CHEST);
                        ItemStack newStack = powerUp.getPowerUpShirtItems().get(randomIndex);
                        if (!stackArmor.isEmpty() && !stackArmor.is(TagRegistry.COSTUMES)) continue block6;
                        this.equipCostumesInArmorSlots(entity, powerUp, slot, stackArmor, powerUp.getPowerUpShirtItems(), newStack, currentStack);
                        continue block6;
                    }
                    case LEGS: {
                        ItemStack stackArmor = entity.getItemBySlot(EquipmentSlot.LEGS);
                        ItemStack newStack = powerUp.getPowerUpPantsItems().get(randomIndex);
                        if (!stackArmor.isEmpty() && !stackArmor.is(TagRegistry.COSTUMES)) continue block6;
                        this.equipCostumesInArmorSlots(entity, powerUp, slot, stackArmor, powerUp.getPowerUpPantsItems(), newStack, currentStack);
                        continue block6;
                    }
                    case FEET: {
                        ItemStack stackArmor = entity.getItemBySlot(EquipmentSlot.FEET);
                        ItemStack newStack = powerUp.getPowerUpShoesItems().get(randomIndex);
                        if (!stackArmor.isEmpty() && !stackArmor.is(TagRegistry.COSTUMES)) continue block6;
                        this.equipCostumesInArmorSlots(entity, powerUp, slot, stackArmor, powerUp.getPowerUpShoesItems(), newStack, currentStack);
                    }
                }
            }
        }
        if (containerHat != null && !containerHat.getAccessories().getItem(0).is(powerUp.getPowerUpCostumeTag())) {
            stack = containerHat.getAccessories().getItem(0);
            ItemStack stackArmor = !(entity instanceof Player) ? entity.getItemBySlot(EquipmentSlot.HEAD) : stack;
            ItemStack newStack = !(entity instanceof Player) ? powerUp.getPowerUpHatItems().get(randomIndex) : stack;
            for (ItemStack item : powerUp.getPowerUpHatItems()) {
                newStack = this.equipCostumesInAccessorySlots(powerUp, item, stackArmor, newStack, stack);
            }
            newStack.applyComponents(stack.getComponents());
            containerHat.getAccessories().setItem(0, newStack);
        }
        if (containerShirt != null && !containerShirt.getAccessories().getItem(0).is(powerUp.getPowerUpCostumeTag())) {
            stack = containerShirt.getAccessories().getItem(0);
            ItemStack stackArmor = !(entity instanceof Player) ? entity.getItemBySlot(EquipmentSlot.BODY) : stack;
            ItemStack newStack = !(entity instanceof Player) ? powerUp.getPowerUpShirtItems().get(randomIndex) : stack;
            for (ItemStack item : powerUp.getPowerUpShirtItems()) {
                newStack = this.equipCostumesInAccessorySlots(powerUp, item, stackArmor, newStack, stack);
            }
            newStack.applyComponents(stack.getComponents());
            containerShirt.getAccessories().setItem(0, newStack);
        }
        if (containerPants != null && !containerPants.getAccessories().getItem(0).is(powerUp.getPowerUpCostumeTag())) {
            stack = containerPants.getAccessories().getItem(0);
            ItemStack stackArmor = !(entity instanceof Player) ? entity.getItemBySlot(EquipmentSlot.LEGS) : stack;
            ItemStack newStack = !(entity instanceof Player) ? powerUp.getPowerUpPantsItems().get(randomIndex) : stack;
            for (ItemStack item : powerUp.getPowerUpPantsItems()) {
                newStack = this.equipCostumesInAccessorySlots(powerUp, item, stackArmor, newStack, stack);
            }
            newStack.applyComponents(stack.getComponents());
            containerPants.getAccessories().setItem(0, newStack);
        }
        if (containerShoes != null && !containerShoes.getAccessories().getItem(0).is(powerUp.getPowerUpCostumeTag())) {
            stack = containerShoes.getAccessories().getItem(0);
            ItemStack stackArmor = !(entity instanceof Player) ? entity.getItemBySlot(EquipmentSlot.FEET) : stack;
            ItemStack newStack = !(entity instanceof Player) ? powerUp.getPowerUpShoesItems().get(randomIndex) : stack;
            for (ItemStack item : powerUp.getPowerUpShoesItems()) {
                newStack = this.equipCostumesInAccessorySlots(powerUp, item, stackArmor, newStack, stack);
            }
            newStack.applyComponents(stack.getComponents());
            containerShoes.getAccessories().setItem(0, newStack);
        }
    }

    default public ItemStack equipCostumesInAccessorySlots(AbstractPowerUpEntity powerUp, ItemStack item, ItemStack stackArmor, ItemStack newStack, ItemStack stack) {
        if (stackArmor.is(TagRegistry.MARIO_COSTUMES) && item.is(TagRegistry.MARIO_COSTUMES)) {
            if (item.is(powerUp.getPowerUpCostumeTag())) {
                newStack = item.copy();
            }
        } else if (stackArmor.is(TagRegistry.LUIGI_COSTUMES) && item.is(TagRegistry.LUIGI_COSTUMES)) {
            if (item.is(powerUp.getPowerUpCostumeTag())) {
                newStack = item.copy();
            }
        } else if (stackArmor.is(TagRegistry.PEACH_COSTUMES) && item.is(TagRegistry.PEACH_COSTUMES)) {
            if (item.is(powerUp.getPowerUpCostumeTag())) {
                newStack = item.copy();
            }
        } else if (stack.is(TagRegistry.MARIO_COSTUMES) && item.is(TagRegistry.MARIO_COSTUMES)) {
            if (item.is(powerUp.getPowerUpCostumeTag())) {
                newStack = item.copy();
            }
        } else if (stack.is(TagRegistry.LUIGI_COSTUMES) && item.is(TagRegistry.LUIGI_COSTUMES)) {
            if (item.is(powerUp.getPowerUpCostumeTag())) {
                newStack = item.copy();
            }
        } else if (stack.is(TagRegistry.PEACH_COSTUMES) && item.is(TagRegistry.PEACH_COSTUMES) && item.is(powerUp.getPowerUpCostumeTag())) {
            newStack = item.copy();
        }
        return newStack;
    }

    default public void equipCostumesInArmorSlots(LivingEntity entity, AbstractPowerUpEntity powerUp, EquipmentSlot slot, ItemStack stackArmor, List<ItemStack> costumeList, ItemStack newStack, ItemStack currentStack) {
        if (stackArmor.isEmpty() || stackArmor.is(TagRegistry.COSTUMES)) {
            for (ItemStack item : costumeList) {
                if (stackArmor.is(TagRegistry.MARIO_COSTUMES) && item.is(TagRegistry.MARIO_COSTUMES)) {
                    if (!item.is(powerUp.getPowerUpCostumeTag())) continue;
                    newStack = item.copy();
                    continue;
                }
                if (stackArmor.is(TagRegistry.LUIGI_COSTUMES) && item.is(TagRegistry.LUIGI_COSTUMES)) {
                    if (!item.is(powerUp.getPowerUpCostumeTag())) continue;
                    newStack = item.copy();
                    continue;
                }
                if (!stackArmor.is(TagRegistry.PEACH_COSTUMES) || !item.is(TagRegistry.PEACH_COSTUMES) || !item.is(powerUp.getPowerUpCostumeTag())) continue;
                newStack = item.copy();
            }
            newStack.applyComponents(currentStack.getComponents());
            entity.setItemSlot(slot, newStack);
        }
    }
}

