/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks;

import com.wenxin2.marioverse.blocks.GoalPoleBlock;
import com.wenxin2.marioverse.registries.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BrickPedestalBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");
    protected static final VoxelShape BRICK_PEDESTAL_COLUMN = Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape[])new VoxelShape[0]).optimize();
    protected static final VoxelShape BRICK_PEDESTAL_TOP = Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Block.box((double)13.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)6.0), Block.box((double)13.0, (double)12.0, (double)10.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)12.0, (double)10.0, (double)3.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)12.0, (double)0.0, (double)3.0, (double)16.0, (double)6.0), Block.box((double)3.0, (double)12.0, (double)13.0, (double)6.0, (double)16.0, (double)16.0), Block.box((double)3.0, (double)12.0, (double)0.0, (double)6.0, (double)16.0, (double)3.0), Block.box((double)10.0, (double)12.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0), Block.box((double)10.0, (double)12.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0)}).optimize();
    protected static final VoxelShape FUNGAL_BRICK_PEDESTAL_TOP = Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Block.box((double)13.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)6.0), Block.box((double)13.0, (double)12.0, (double)10.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)12.0, (double)10.0, (double)3.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)12.0, (double)0.0, (double)3.0, (double)16.0, (double)6.0), Block.box((double)3.0, (double)12.0, (double)13.0, (double)6.0, (double)16.0, (double)16.0), Block.box((double)3.0, (double)12.0, (double)0.0, (double)6.0, (double)16.0, (double)3.0), Block.box((double)10.0, (double)12.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0), Block.box((double)10.0, (double)12.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0)}).optimize();

    public BrickPedestalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)TOP, (Comparable)Boolean.TRUE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{TOP, WATERLOGGED});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)TOP)).booleanValue()) {
            if (state.getBlock() == BlockRegistry.POLISHED_FUNGAL_BRICK_PEDESTAL.get() || state.getBlock() == BlockRegistry.POLISHED_DEEP_FUNGAL_BRICK_PEDESTAL.get()) {
                return FUNGAL_BRICK_PEDESTAL_TOP;
            }
            return BRICK_PEDESTAL_TOP;
        }
        return BRICK_PEDESTAL_COLUMN;
    }

    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        FluidState fluidState = placeContext.getLevel().getFluidState(placeContext.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.is(FluidTags.WATER) && fluidState.getAmount() == 8));
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor worldAccessor, BlockPos pos, BlockPos neighborPos) {
        Block blockAbove = worldAccessor.getBlockState(pos.above()).getBlock();
        if (!worldAccessor.isClientSide()) {
            if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                worldAccessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldAccessor));
            }
            if (!(blockAbove instanceof BrickPedestalBlock)) {
                return (BlockState)state.setValue((Property)TOP, (Comparable)Boolean.TRUE);
            }
            return (BlockState)state.setValue((Property)TOP, (Comparable)Boolean.FALSE);
        }
        return Blocks.AIR.defaultBlockState();
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        BlockState stateAbove = world.getBlockState(pos.above());
        if (stateAbove.getBlock() instanceof GoalPoleBlock) {
            if (((Boolean)stateAbove.getValue((Property)GoalPoleBlock.LOWERED)).booleanValue()) {
                return this.calculateFlagPoleLoweredHeight(world, pos.above());
            }
            return super.getAnalogOutputSignal(state, world, pos);
        }
        return super.getAnalogOutputSignal(state, world, pos);
    }

    private int calculateFlagPoleLoweredHeight(Level world, BlockPos pos) {
        int height = 0;
        BlockPos checkPos = pos;
        while (world.getBlockState(checkPos).getBlock() instanceof GoalPoleBlock && ((Boolean)world.getBlockState(checkPos).getValue((Property)GoalPoleBlock.LOWERED)).booleanValue() && height <= 15) {
            ++height;
            checkPos = checkPos.above();
        }
        return height;
    }
}

