/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.wenxin2.marioverse.blocks.PipeBubblesBlock;
import com.wenxin2.marioverse.blocks.WarpPipeBlock;
import com.wenxin2.marioverse.blocks.WaterSpoutBlock;
import com.wenxin2.marioverse.blocks.entities.WarpPipeBlockEntity;
import com.wenxin2.marioverse.registries.AttributesRegistry;
import com.wenxin2.marioverse.registries.BlockRegistry;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClearWarpPipeBlock
extends WarpPipeBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty ENTRANCE = WarpPipeBlock.ENTRANCE;
    public static final BooleanProperty CLOSED = WarpPipeBlock.CLOSED;
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)((Map)Util.make((Object)Maps.newEnumMap(Direction.class), enumMap -> {
        enumMap.put(Direction.UP, UP);
        enumMap.put(Direction.DOWN, DOWN);
        enumMap.put(Direction.NORTH, NORTH);
        enumMap.put(Direction.EAST, EAST);
        enumMap.put(Direction.SOUTH, SOUTH);
        enumMap.put(Direction.WEST, WEST);
    })));
    public static final VoxelShape PIPE_UP = Shapes.or((VoxelShape)Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]).optimize();
    public static final VoxelShape PIPE_NORTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), (VoxelShape[])new VoxelShape[0]).optimize();
    public static final VoxelShape PIPE_SOUTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]).optimize();
    public static final VoxelShape PIPE_EAST = Shapes.or((VoxelShape)Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]).optimize();
    public static final VoxelShape PIPE_WEST = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]).optimize();
    public static final VoxelShape PIPE_DOWN = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[0]).optimize();
    public static final VoxelShape PIPE_FACING_UP = Shapes.or((VoxelShape)Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]).optimize();
    public static final VoxelShape PIPE_FACING_NORTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), (VoxelShape[])new VoxelShape[0]).optimize();
    public static final VoxelShape PIPE_FACING_SOUTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]).optimize();
    public static final VoxelShape PIPE_FACING_EAST = Shapes.or((VoxelShape)Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]).optimize();
    public static final VoxelShape PIPE_FACING_WEST = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]).optimize();
    public static final VoxelShape PIPE_FACING_DOWN = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[0]).optimize();
    public static final VoxelShape PIPE_ALL = Shapes.or((VoxelShape)Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), (VoxelShape[])new VoxelShape[0]).optimize();

    public ClearWarpPipeBlock(@Nullable DyeColor color, BlockBehaviour.Properties properties) {
        super(color, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)ENTRANCE, (Comparable)Boolean.TRUE)).setValue((Property)CLOSED, (Comparable)Boolean.FALSE)).setValue((Property)POWERED, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)WATER_SPOUT, (Comparable)Boolean.FALSE)).setValue((Property)UP, (Comparable)Boolean.FALSE)).setValue((Property)NORTH, (Comparable)Boolean.FALSE)).setValue((Property)SOUTH, (Comparable)Boolean.FALSE)).setValue((Property)EAST, (Comparable)Boolean.FALSE)).setValue((Property)WEST, (Comparable)Boolean.FALSE)).setValue((Property)DOWN, (Comparable)Boolean.FALSE));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{BUBBLES, CLOSED, ENTRANCE, FACING, POWERED, WATER_SPOUT, WATERLOGGED, UP, DOWN, NORTH, SOUTH, EAST, WEST});
    }

    public VoxelShape voxelShape(BlockState state) {
        VoxelShape shape = Shapes.empty();
        VoxelShape shapeDown = Shapes.empty();
        if (state.getValue((Property)FACING) == Direction.DOWN && ((Boolean)state.getValue((Property)ENTRANCE)).booleanValue() && !((Boolean)state.getValue((Property)CLOSED)).booleanValue()) {
            if (!(((Boolean)state.getValue((Property)DOWN)).booleanValue() || ((Boolean)state.getValue((Property)ENTRANCE)).booleanValue() && state.getValue((Property)FACING) == Direction.DOWN)) {
                shapeDown = Shapes.or((VoxelShape)shapeDown, (VoxelShape)PIPE_FACING_DOWN);
            }
            if (!((Boolean)state.getValue((Property)UP)).booleanValue()) {
                shapeDown = Shapes.or((VoxelShape)shapeDown, (VoxelShape)PIPE_FACING_UP);
            }
            if (!((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
                shapeDown = Shapes.or((VoxelShape)shapeDown, (VoxelShape)PIPE_FACING_NORTH);
            }
            if (!((Boolean)state.getValue((Property)EAST)).booleanValue()) {
                shapeDown = Shapes.or((VoxelShape)shapeDown, (VoxelShape)PIPE_FACING_EAST);
            }
            if (!((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
                shapeDown = Shapes.or((VoxelShape)shapeDown, (VoxelShape)PIPE_FACING_SOUTH);
            }
            if (!((Boolean)state.getValue((Property)WEST)).booleanValue()) {
                shapeDown = Shapes.or((VoxelShape)shapeDown, (VoxelShape)PIPE_FACING_WEST);
            } else {
                Shapes.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
            }
            return shapeDown.optimize();
        }
        if (state.getValue((Property)FACING) != Direction.DOWN || !((Boolean)state.getValue((Property)ENTRANCE)).booleanValue() || ((Boolean)state.getValue((Property)CLOSED)).booleanValue()) {
            if (!(((Boolean)state.getValue((Property)DOWN)).booleanValue() || ((Boolean)state.getValue((Property)ENTRANCE)).booleanValue() && state.getValue((Property)FACING) == Direction.DOWN)) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)PIPE_DOWN);
            }
            if (!(((Boolean)state.getValue((Property)UP)).booleanValue() || ((Boolean)state.getValue((Property)ENTRANCE)).booleanValue() && state.getValue((Property)FACING) == Direction.UP)) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)PIPE_UP);
            }
            if (!(((Boolean)state.getValue((Property)NORTH)).booleanValue() || ((Boolean)state.getValue((Property)ENTRANCE)).booleanValue() && state.getValue((Property)FACING) == Direction.NORTH)) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)PIPE_NORTH);
            }
            if (!(((Boolean)state.getValue((Property)EAST)).booleanValue() || ((Boolean)state.getValue((Property)ENTRANCE)).booleanValue() && state.getValue((Property)FACING) == Direction.EAST)) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)PIPE_EAST);
            }
            if (!(((Boolean)state.getValue((Property)SOUTH)).booleanValue() || ((Boolean)state.getValue((Property)ENTRANCE)).booleanValue() && state.getValue((Property)FACING) == Direction.SOUTH)) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)PIPE_SOUTH);
            }
            if (!(((Boolean)state.getValue((Property)WEST)).booleanValue() || ((Boolean)state.getValue((Property)ENTRANCE)).booleanValue() && state.getValue((Property)FACING) == Direction.WEST)) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)PIPE_WEST);
            }
        }
        if (((Boolean)state.getValue((Property)ENTRANCE)).booleanValue()) {
            if (((Boolean)state.getValue((Property)CLOSED)).booleanValue() && state.getValue((Property)FACING) == Direction.UP) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)PIPE_UP);
            }
            if (((Boolean)state.getValue((Property)CLOSED)).booleanValue() && state.getValue((Property)FACING) == Direction.DOWN) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)PIPE_DOWN);
            }
            if (((Boolean)state.getValue((Property)CLOSED)).booleanValue() && state.getValue((Property)FACING) == Direction.NORTH) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)PIPE_NORTH);
            }
            if (((Boolean)state.getValue((Property)CLOSED)).booleanValue() && state.getValue((Property)FACING) == Direction.SOUTH) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)PIPE_SOUTH);
            }
            if (((Boolean)state.getValue((Property)CLOSED)).booleanValue() && state.getValue((Property)FACING) == Direction.EAST) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)PIPE_EAST);
            }
            if (((Boolean)state.getValue((Property)CLOSED)).booleanValue() && state.getValue((Property)FACING) == Direction.WEST) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)PIPE_WEST);
            }
        }
        return shape.optimize();
    }

    public VoxelShape noCollisionShape(BlockState state, CollisionContext context) {
        Entity entity;
        VoxelShape shape = Shapes.box((double)8.0, (double)8.0, (double)8.0, (double)8.00001, (double)8.00001, (double)8.00001);
        if (context instanceof EntityCollisionContext && (entity = ((EntityCollisionContext)context).getEntity()) instanceof Player) {
            Player player = (Player)entity;
            if (!((Boolean)state.getValue((Property)CLOSED)).booleanValue()) {
                if (((Boolean)state.getValue((Property)UP) != false && (Boolean)state.getValue((Property)NORTH) != false && (Boolean)state.getValue((Property)SOUTH) != false && (Boolean)state.getValue((Property)EAST) != false && (Boolean)state.getValue((Property)WEST) != false && (Boolean)state.getValue((Property)ENTRANCE) != false && state.getValue((Property)FACING) == Direction.DOWN || (Boolean)state.getValue((Property)DOWN) != false && (Boolean)state.getValue((Property)NORTH) != false && (Boolean)state.getValue((Property)SOUTH) != false && (Boolean)state.getValue((Property)EAST) != false && (Boolean)state.getValue((Property)WEST) != false && (Boolean)state.getValue((Property)ENTRANCE) != false && state.getValue((Property)FACING) == Direction.UP || (Boolean)state.getValue((Property)UP) != false && (Boolean)state.getValue((Property)DOWN) != false && (Boolean)state.getValue((Property)SOUTH) != false && (Boolean)state.getValue((Property)EAST) != false && (Boolean)state.getValue((Property)WEST) != false && (Boolean)state.getValue((Property)ENTRANCE) != false && state.getValue((Property)FACING) == Direction.NORTH || (Boolean)state.getValue((Property)UP) != false && (Boolean)state.getValue((Property)DOWN) != false && (Boolean)state.getValue((Property)NORTH) != false && (Boolean)state.getValue((Property)EAST) != false && (Boolean)state.getValue((Property)WEST) != false && (Boolean)state.getValue((Property)ENTRANCE) != false && state.getValue((Property)FACING) == Direction.SOUTH || (Boolean)state.getValue((Property)UP) != false && (Boolean)state.getValue((Property)DOWN) != false && (Boolean)state.getValue((Property)NORTH) != false && (Boolean)state.getValue((Property)SOUTH) != false && (Boolean)state.getValue((Property)WEST) != false && (Boolean)state.getValue((Property)ENTRANCE) != false && state.getValue((Property)FACING) == Direction.EAST || ((Boolean)state.getValue((Property)UP)).booleanValue() && ((Boolean)state.getValue((Property)DOWN)).booleanValue() && ((Boolean)state.getValue((Property)NORTH)).booleanValue() && ((Boolean)state.getValue((Property)SOUTH)).booleanValue() && ((Boolean)state.getValue((Property)EAST)).booleanValue() && ((Boolean)state.getValue((Property)ENTRANCE)).booleanValue() && state.getValue((Property)FACING) == Direction.WEST) && (player.isCreative() && ((Boolean)ConfigRegistry.DEBUG_SELECTION_BOX_CREATIVE.get()).booleanValue() || ((Boolean)ConfigRegistry.DEBUG_SELECTION_BOX.get()).booleanValue() || player.getItemInHand(player.getUsedItemHand()).getItem() instanceof BucketItem || player.getItemInHand(player.getUsedItemHand()).getItem() instanceof DiggerItem || player.getItemInHand(player.getUsedItemHand()).is(TagRegistry.CAN_SELECT_CLEAR_WARP_PIPES) || player.getItemInHand(player.getUsedItemHand()).getItem() == ((Block)BlockRegistry.CLEAR_WARP_PIPE.get()).asItem())) {
                    shape = Shapes.or((VoxelShape)shape, (VoxelShape)PIPE_ALL);
                }
                if (player.getItemInHand(player.getUsedItemHand()).is(TagRegistry.CAN_SELECT_CLEAR_WARP_PIPES) || player.getItemInHand(player.getUsedItemHand()).getItem() == ((Block)BlockRegistry.CLEAR_WARP_PIPE.get()).asItem()) {
                    shape = Shapes.block();
                }
            }
            if (!((Boolean)state.getValue((Property)ENTRANCE)).booleanValue() && ((Boolean)state.getValue((Property)UP)).booleanValue() && ((Boolean)state.getValue((Property)DOWN)).booleanValue() && ((Boolean)state.getValue((Property)NORTH)).booleanValue() && ((Boolean)state.getValue((Property)SOUTH)).booleanValue() && ((Boolean)state.getValue((Property)EAST)).booleanValue() && ((Boolean)state.getValue((Property)WEST)).booleanValue() && (player.isCreative() && ((Boolean)ConfigRegistry.DEBUG_SELECTION_BOX_CREATIVE.get()).booleanValue() || ((Boolean)ConfigRegistry.DEBUG_SELECTION_BOX.get()).booleanValue() || player.getItemInHand(player.getUsedItemHand()).getItem() instanceof BucketItem || player.getItemInHand(player.getUsedItemHand()).getItem() instanceof DiggerItem || player.getItemInHand(player.getUsedItemHand()).is(TagRegistry.CAN_SELECT_CLEAR_WARP_PIPES) || player.getItemInHand(player.getUsedItemHand()).getItem() == ((Block)BlockRegistry.CLEAR_WARP_PIPE.get()).asItem())) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)PIPE_ALL);
            }
        }
        return shape.optimize();
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        VoxelShape shape = Shapes.or((VoxelShape)this.voxelShape(state), (VoxelShape)this.noCollisionShape(state, context));
        return shape.optimize();
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return this.voxelShape(state);
    }

    public VoxelShape getBlockSupportShape(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return this.voxelShape(state);
    }

    public boolean isPathfindable(BlockState state, PathComputationType pathType) {
        return false;
    }

    @Override
    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hitResult) {
        ItemStack heldItem = player.getItemInHand(player.getUsedItemHand());
        double entityX = player.getX();
        double entityY = player.getY();
        double entityZ = player.getZ();
        double height = player.getBbHeight();
        int blockX = pos.getX();
        int blockY = pos.getY();
        int blockZ = pos.getZ();
        if (((Boolean)state.getValue((Property)ENTRANCE)).booleanValue() && heldItem.isEmpty()) {
            boolean yPosCheck;
            Direction facing = (Direction)state.getValue((Property)FACING);
            boolean bl = yPosCheck = entityY + height >= (double)blockY && entityY - height < (double)blockY + 0.75;
            if (facing == Direction.UP && entityY + height >= (double)(blockY - 1) && entityX < (double)(blockX + 1) && entityX > (double)blockX && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                player.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.25, (double)pos.getZ() + 0.5);
                return InteractionResult.SUCCESS;
            }
            if (facing == Direction.DOWN && entityY + height <= (double)blockY && entityX < (double)(blockX + 1) && entityX > (double)blockX && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                player.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.25, (double)pos.getZ() + 0.5);
                return InteractionResult.SUCCESS;
            }
            if (facing == Direction.NORTH && entityX < (double)(blockX + 1) && entityX > (double)blockX && yPosCheck && entityZ < (double)blockZ) {
                player.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.25, (double)pos.getZ() + 0.5);
                return InteractionResult.SUCCESS;
            }
            if (facing == Direction.SOUTH && entityX < (double)(blockX + 1) && entityX > (double)blockX && yPosCheck && entityZ > (double)blockZ + 0.25) {
                player.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.25, (double)pos.getZ() + 0.5);
                player.setSwimming(true);
                return InteractionResult.SUCCESS;
            }
            if (facing == Direction.EAST && entityX > (double)blockX && yPosCheck && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                player.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.25, (double)pos.getZ() + 0.5);
                player.setSwimming(true);
                return InteractionResult.SUCCESS;
            }
            if (facing == Direction.WEST && entityX < (double)blockX && yPosCheck && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                player.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.25, (double)pos.getZ() + 0.5);
                player.setSwimming(true);
                return InteractionResult.SUCCESS;
            }
            return super.useWithoutItem(state, world, pos, player, hitResult);
        }
        return super.useWithoutItem(state, world, pos, player, hitResult);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        FluidState fluidState = placeContext.getLevel().getFluidState(placeContext.getClickedPos());
        Direction direction = placeContext.getClickedFace();
        Level blockGetter = placeContext.getLevel();
        BlockPos pos = placeContext.getClickedPos();
        BlockPos posAbove = pos.above();
        BlockPos posBelow = pos.below();
        BlockPos posNorth = pos.north();
        BlockPos posSouth = pos.south();
        BlockPos posEast = pos.east();
        BlockPos posWest = pos.west();
        BlockState stateAbove = blockGetter.getBlockState(posAbove);
        BlockState stateBelow = blockGetter.getBlockState(posBelow);
        BlockState stateNorth = blockGetter.getBlockState(posNorth);
        BlockState stateSouth = blockGetter.getBlockState(posSouth);
        BlockState stateEast = blockGetter.getBlockState(posEast);
        BlockState stateWest = blockGetter.getBlockState(posWest);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)UP, (Comparable)Boolean.valueOf(this.connectsTo(stateAbove)))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(this.connectsTo(stateBelow)))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo(stateNorth)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo(stateSouth)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo(stateEast)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo(stateWest)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.is(FluidTags.WATER) && fluidState.getAmount() == 8));
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
            }
        }
        return super.rotate(state, rotation);
    }

    @Override
    public BlockState mirror(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)FACING)))).setValue((Property)ENTRANCE, (Comparable)Boolean.valueOf(false));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)FACING)))).setValue((Property)ENTRANCE, (Comparable)Boolean.valueOf(false));
            }
        }
        return super.mirror(state, mirror);
    }

    public boolean connectsTo(BlockState state) {
        Block block = state.getBlock();
        return block instanceof ClearWarpPipeBlock;
    }

    public float getShadeBrightness(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return true;
    }

    public boolean skipRendering(BlockState state, BlockState neighborState, Direction direction) {
        if (((Boolean)state.getValue((Property)CLOSED)).booleanValue() && (((Boolean)state.getValue((Property)UP)).booleanValue() || ((Boolean)state.getValue((Property)DOWN)).booleanValue() || ((Boolean)state.getValue((Property)NORTH)).booleanValue() || ((Boolean)state.getValue((Property)SOUTH)).booleanValue() || ((Boolean)state.getValue((Property)EAST)).booleanValue() || ((Boolean)state.getValue((Property)WEST)).booleanValue())) {
            return neighborState.is((Block)this) && (Boolean)neighborState.getValue((Property)CLOSED) != false || super.skipRendering(state, neighborState, direction);
        }
        return false;
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor worldAccessor, BlockPos pos, BlockPos posNeighbor) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos posRelative = pos.relative(facing);
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && !((Boolean)state.getValue((Property)CLOSED)).booleanValue()) {
            worldAccessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldAccessor));
        }
        return (BlockState)((BlockState)state.setValue((Property)ENTRANCE, (Comparable)Boolean.valueOf(worldAccessor.getBlockState(posRelative).getBlock() != this))).setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(this.connectsTo(neighborState)));
    }

    @Override
    public void tick(BlockState state, ServerLevel serverWorld, BlockPos pos, RandomSource random) {
        WarpPipeBlockEntity pipeBlockEntity = (WarpPipeBlockEntity)serverWorld.getBlockEntity(pos);
        if (((Boolean)state.getValue((Property)WATER_SPOUT)).booleanValue() && pipeBlockEntity != null && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            WaterSpoutBlock.repeatColumnUp((LevelAccessor)serverWorld, pos.above(), state, pipeBlockEntity.spoutHeight);
            serverWorld.scheduleTick(pos, (Block)this, 3);
        }
        if (((Boolean)state.getValue((Property)BUBBLES)).booleanValue() && state.getValue((Property)FACING) == Direction.UP && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && pipeBlockEntity != null) {
            PipeBubblesBlock.repeatColumnUp((LevelAccessor)serverWorld, pos.above(), state, pipeBlockEntity.bubblesDistance);
            serverWorld.scheduleTick(pos, (Block)this, 3);
        } else if (((Boolean)state.getValue((Property)BUBBLES)).booleanValue() && state.getValue((Property)FACING) == Direction.DOWN && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && pipeBlockEntity != null) {
            PipeBubblesBlock.repeatColumnDown((LevelAccessor)serverWorld, pos.below(), state, pipeBlockEntity.bubblesDistance);
            serverWorld.scheduleTick(pos, (Block)this, 3);
        } else if (((Boolean)state.getValue((Property)BUBBLES)).booleanValue() && state.getValue((Property)FACING) == Direction.NORTH && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && pipeBlockEntity != null) {
            PipeBubblesBlock.repeatColumnNorth((LevelAccessor)serverWorld, pos.north(), state, pipeBlockEntity.bubblesDistance);
            serverWorld.scheduleTick(pos, (Block)this, 3);
        } else if (((Boolean)state.getValue((Property)BUBBLES)).booleanValue() && state.getValue((Property)FACING) == Direction.SOUTH && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && pipeBlockEntity != null) {
            PipeBubblesBlock.repeatColumnSouth((LevelAccessor)serverWorld, pos.south(), state, pipeBlockEntity.bubblesDistance);
            serverWorld.scheduleTick(pos, (Block)this, 3);
        } else if (((Boolean)state.getValue((Property)BUBBLES)).booleanValue() && state.getValue((Property)FACING) == Direction.EAST && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && pipeBlockEntity != null) {
            PipeBubblesBlock.repeatColumnEast((LevelAccessor)serverWorld, pos.east(), state, pipeBlockEntity.bubblesDistance);
            serverWorld.scheduleTick(pos, (Block)this, 3);
        } else if (((Boolean)state.getValue((Property)BUBBLES)).booleanValue() && state.getValue((Property)FACING) == Direction.WEST && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && pipeBlockEntity != null) {
            PipeBubblesBlock.repeatColumnWest((LevelAccessor)serverWorld, pos.west(), state, pipeBlockEntity.bubblesDistance);
            serverWorld.scheduleTick(pos, (Block)this, 3);
        }
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (!entity.isShiftKeyDown() && ((Boolean)ConfigRegistry.ALLOW_FAST_TRAVEL.get()).booleanValue() && !entity.getType().is(TagRegistry.CANNOT_QUICK_TRAVEL)) {
            if (facing == Direction.UP || facing == Direction.DOWN) {
                if (((Boolean)state.getValue((Property)NORTH)).booleanValue() || ((Boolean)state.getValue((Property)SOUTH)).booleanValue() || ((Boolean)state.getValue((Property)EAST)).booleanValue() || ((Boolean)state.getValue((Property)WEST)).booleanValue()) {
                    entity.setSwimming(true);
                }
            } else {
                entity.setSwimming(true);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.spawnTrailParticles(world, livingEntity);
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                Direction moveDirection = this.getDirectionFromLook((Entity)player);
                this.movePlayerInPipe((Entity)player, moveDirection);
            } else {
                this.moveEntityInPipe(entity);
            }
            super.entityInside(state, world, pos, entity);
        }
    }

    protected void spawnTrailParticles(Level world, LivingEntity entity) {
        BlockPos posLegacy = entity.getOnPosLegacy();
        BlockState state = world.getBlockState(posLegacy);
        float scale = (float)entity.getAttributeValue(Attributes.SCALE);
        float widthScale = (float)entity.getAttributeValue(AttributesRegistry.WIDTH_SCALE);
        if (!state.addRunningEffects(world, posLegacy, (Entity)entity) && state.getRenderShape() != RenderShape.INVISIBLE) {
            Vec3 vec3 = entity.getDeltaMovement();
            BlockPos pos = entity.blockPosition();
            double x = entity.getX() + (entity.getRandom().nextDouble() - 0.5) * (double)scale * (double)widthScale;
            double z = entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * (double)scale * (double)widthScale;
            if (pos.getX() != posLegacy.getX()) {
                x = Mth.clamp((double)x, (double)posLegacy.getX(), (double)((double)posLegacy.getX() + 1.0));
            }
            if (pos.getZ() != posLegacy.getZ()) {
                z = Mth.clamp((double)z, (double)posLegacy.getZ(), (double)((double)posLegacy.getZ() + 1.0));
            }
            world.addParticle((ParticleOptions)ParticleTypes.EFFECT, x, entity.getY(), z, vec3.x * -4.0, 1.5, vec3.z * -4.0);
        }
    }

    private void moveEntityInPipe(Entity entity) {
        Vec3 lookVec = entity.getLookAngle();
        Vec3 moveVec = entity.getDeltaMovement();
        double d0 = Math.min(1.5, moveVec.y + 0.1);
        double speed = 1.25;
        double verticalSpeed = 1.15;
        if (entity instanceof LivingEntity && !entity.isShiftKeyDown()) {
            Vec3 movement = new Vec3(lookVec.x * speed, moveVec.y * verticalSpeed, lookVec.z * speed);
            entity.setDeltaMovement(movement.x, movement.y, movement.z);
            if (moveVec.y > 0.0 || moveVec.y < 0.0) {
                entity.setDeltaMovement(moveVec.x, d0, moveVec.z);
            }
        } else if (!entity.isShiftKeyDown()) {
            Vec3 movement = new Vec3(moveVec.x * speed, moveVec.y * verticalSpeed, moveVec.z * speed);
            entity.setDeltaMovement(movement.x, movement.y, movement.z);
            if (moveVec.y > 0.0 || moveVec.y < 0.0) {
                entity.setDeltaMovement(moveVec.x, d0, moveVec.z);
            }
        }
        entity.resetFallDistance();
    }

    public void movePlayerInPipe(Entity entity, Direction direction) {
        Vec3 motion = switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> new Vec3(0.0, 0.0, -0.75);
            case Direction.SOUTH -> new Vec3(0.0, 0.0, 0.75);
            case Direction.WEST -> new Vec3(-0.75, 0.0, 0.0);
            case Direction.EAST -> new Vec3(0.75, 0.0, 0.0);
            case Direction.UP -> new Vec3(0.0, 0.6, 0.0);
            case Direction.DOWN -> new Vec3(0.0, -0.25, 0.0);
        };
        entity.setDeltaMovement(motion);
        entity.resetFallDistance();
    }

    private Direction getDirectionFromLook(Entity entity) {
        Vec3 lookVec = entity.getLookAngle().normalize();
        Direction bestDirection = null;
        double bestDot = -1.0;
        for (Direction dir : Direction.values()) {
            Vec3 pipeVec = Vec3.atLowerCornerOf((Vec3i)dir.getNormal()).normalize();
            double dotProduct = lookVec.dot(pipeVec);
            if (!(dotProduct > bestDot)) continue;
            bestDot = dotProduct;
            bestDirection = dir;
        }
        return bestDirection;
    }
}

