/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks;

import com.wenxin2.marioverse.blocks.ClearWarpPipeBlock;
import com.wenxin2.marioverse.blocks.WarpPipeBlock;
import com.wenxin2.marioverse.blocks.entities.WarpPipeBlockEntity;
import com.wenxin2.marioverse.registries.BlockRegistry;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PipeBubblesBlock
extends BubbleColumnBlock
implements BucketPickup {
    public static final BooleanProperty DRAG_DOWN = BlockStateProperties.DRAG;
    public static final DirectionProperty FACING = BlockStateProperties.FACING;

    public PipeBubblesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)DRAG_DOWN, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{DRAG_DOWN, FACING});
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        Player player;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = ((EntityCollisionContext)context).getEntity()) instanceof Player && (player = (Player)entity).hasPermissions(1) && player.isCreative() && ((Boolean)ConfigRegistry.DEBUG_PIPE_BUBBLES_SELECTION_BOX.get()).booleanValue()) {
            return Shapes.block();
        }
        return Shapes.box((double)8.0, (double)8.0, (double)8.0, (double)8.00001, (double)8.00001, (double)8.00001);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor worldAccessor, BlockPos pos, BlockPos neighborPos) {
        BlockState stateAbove = worldAccessor.getBlockState(pos.above());
        BlockState stateBelow = worldAccessor.getBlockState(pos.below());
        BlockState stateNorth = worldAccessor.getBlockState(pos.north());
        BlockState stateSouth = worldAccessor.getBlockState(pos.south());
        BlockState stateEast = worldAccessor.getBlockState(pos.east());
        BlockState stateWest = worldAccessor.getBlockState(pos.west());
        if (stateBelow.getBlock() instanceof WarpPipeBlock && ((Boolean)stateBelow.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue()) {
            worldAccessor.destroyBlock(pos, true);
            return Blocks.WATER.defaultBlockState();
        }
        if (state.getValue((Property)FACING) == Direction.UP && stateBelow.getBlock() instanceof ClearWarpPipeBlock && (((Boolean)stateBelow.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateBelow.getValue((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue() || !((Boolean)stateBelow.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue())) {
            worldAccessor.destroyBlock(pos, true);
            return Blocks.WATER.defaultBlockState();
        }
        if (state.getValue((Property)FACING) == Direction.DOWN && stateAbove.getBlock() instanceof ClearWarpPipeBlock && (((Boolean)stateAbove.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateAbove.getValue((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue() || !((Boolean)stateAbove.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue())) {
            worldAccessor.destroyBlock(pos, true);
            return Blocks.WATER.defaultBlockState();
        }
        if (state.getValue((Property)FACING) == Direction.NORTH && stateSouth.getBlock() instanceof ClearWarpPipeBlock && (((Boolean)stateSouth.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateSouth.getValue((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue() || !((Boolean)stateSouth.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue())) {
            worldAccessor.destroyBlock(pos, true);
            return Blocks.WATER.defaultBlockState();
        }
        if (state.getValue((Property)FACING) == Direction.SOUTH && stateNorth.getBlock() instanceof ClearWarpPipeBlock && (((Boolean)stateNorth.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateNorth.getValue((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue() || !((Boolean)stateNorth.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue())) {
            worldAccessor.destroyBlock(pos, true);
            return Blocks.WATER.defaultBlockState();
        }
        if (state.getValue((Property)FACING) == Direction.EAST && stateWest.getBlock() instanceof ClearWarpPipeBlock && (((Boolean)stateWest.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateWest.getValue((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue() || !((Boolean)stateWest.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue())) {
            worldAccessor.destroyBlock(pos, true);
            return Blocks.WATER.defaultBlockState();
        }
        if (state.getValue((Property)FACING) == Direction.WEST && stateEast.getBlock() instanceof ClearWarpPipeBlock && (((Boolean)stateEast.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateEast.getValue((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue() || !((Boolean)stateEast.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue())) {
            worldAccessor.destroyBlock(pos, true);
            return Blocks.WATER.defaultBlockState();
        }
        if (state.getValue((Property)FACING) == Direction.UP && (!(stateBelow.getBlock() instanceof WarpPipeBlock) && !(stateBelow.getBlock() instanceof PipeBubblesBlock) || stateBelow.getBlock() instanceof WarpPipeBlock && (((Boolean)stateBelow.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateBelow.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue()))) {
            worldAccessor.destroyBlock(pos, true);
            return Blocks.WATER.defaultBlockState();
        }
        if (state.getValue((Property)FACING) == Direction.DOWN && (!(stateAbove.getBlock() instanceof WarpPipeBlock) && !(stateAbove.getBlock() instanceof PipeBubblesBlock) || stateAbove.getBlock() instanceof WarpPipeBlock && (((Boolean)stateAbove.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateAbove.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue()))) {
            worldAccessor.destroyBlock(pos, true);
            return Blocks.WATER.defaultBlockState();
        }
        if (state.getValue((Property)FACING) == Direction.NORTH && (!(stateSouth.getBlock() instanceof WarpPipeBlock) && !(stateSouth.getBlock() instanceof PipeBubblesBlock) || stateSouth.getBlock() instanceof WarpPipeBlock && (((Boolean)stateSouth.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateSouth.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue()))) {
            worldAccessor.destroyBlock(pos, true);
            return Blocks.WATER.defaultBlockState();
        }
        if (state.getValue((Property)FACING) == Direction.SOUTH && (!(stateNorth.getBlock() instanceof WarpPipeBlock) && !(stateNorth.getBlock() instanceof PipeBubblesBlock) || stateNorth.getBlock() instanceof WarpPipeBlock && (((Boolean)stateNorth.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateNorth.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue()))) {
            worldAccessor.destroyBlock(pos, true);
            return Blocks.WATER.defaultBlockState();
        }
        if (state.getValue((Property)FACING) == Direction.EAST && (!(stateWest.getBlock() instanceof WarpPipeBlock) && !(stateWest.getBlock() instanceof PipeBubblesBlock) || stateWest.getBlock() instanceof WarpPipeBlock && (((Boolean)stateWest.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateWest.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue()))) {
            worldAccessor.destroyBlock(pos, true);
            return Blocks.WATER.defaultBlockState();
        }
        if (state.getValue((Property)FACING) == Direction.WEST && (!(stateEast.getBlock() instanceof WarpPipeBlock) && !(stateEast.getBlock() instanceof PipeBubblesBlock) || stateEast.getBlock() instanceof WarpPipeBlock && (((Boolean)stateEast.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateEast.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue()))) {
            worldAccessor.destroyBlock(pos, true);
            return Blocks.WATER.defaultBlockState();
        }
        if (!state.canSurvive((LevelReader)worldAccessor, pos) && !neighborState.is((Block)BlockRegistry.PIPE_BUBBLES.get()) && PipeBubblesBlock.canExistIn(worldAccessor, pos)) {
            worldAccessor.scheduleTick(pos, (Block)this, 3);
        }
        worldAccessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldAccessor));
        return super.updateShape(state, direction, neighborState, worldAccessor, pos, neighborPos);
    }

    public boolean canSurvive(BlockState state, LevelReader worldReader, BlockPos pos) {
        BlockState stateAbove = worldReader.getBlockState(pos.above());
        BlockState stateBelow = worldReader.getBlockState(pos.below());
        BlockState stateNorth = worldReader.getBlockState(pos.below());
        BlockState stateSouth = worldReader.getBlockState(pos.below());
        BlockState stateEast = worldReader.getBlockState(pos.below());
        BlockState stateWest = worldReader.getBlockState(pos.below());
        if (state.getValue((Property)FACING) == Direction.UP && stateBelow.is((Block)BlockRegistry.PIPE_BUBBLES.get())) {
            return true;
        }
        if (state.getValue((Property)FACING) == Direction.DOWN && stateAbove.is((Block)BlockRegistry.PIPE_BUBBLES.get())) {
            return true;
        }
        if (state.getValue((Property)FACING) == Direction.NORTH && stateSouth.is((Block)BlockRegistry.PIPE_BUBBLES.get())) {
            return true;
        }
        if (state.getValue((Property)FACING) == Direction.SOUTH && stateNorth.is((Block)BlockRegistry.PIPE_BUBBLES.get())) {
            return true;
        }
        if (state.getValue((Property)FACING) == Direction.EAST && stateWest.is((Block)BlockRegistry.PIPE_BUBBLES.get())) {
            return true;
        }
        if (state.getValue((Property)FACING) == Direction.WEST && stateEast.is((Block)BlockRegistry.PIPE_BUBBLES.get())) {
            return true;
        }
        if (state.getValue((Property)FACING) == Direction.UP && stateBelow.getBlock() instanceof WarpPipeBlock && !((Boolean)stateBelow.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateBelow.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue() && !(stateBelow.getBlock() instanceof ClearWarpPipeBlock)) {
            return true;
        }
        if (state.getValue((Property)FACING) == Direction.DOWN && stateAbove.getBlock() instanceof WarpPipeBlock && !((Boolean)stateAbove.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateAbove.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue() && !(stateAbove.getBlock() instanceof ClearWarpPipeBlock)) {
            return true;
        }
        if (state.getValue((Property)FACING) == Direction.NORTH && stateSouth.getBlock() instanceof WarpPipeBlock && !((Boolean)stateSouth.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateSouth.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue() && !(stateSouth.getBlock() instanceof ClearWarpPipeBlock)) {
            return true;
        }
        if (state.getValue((Property)FACING) == Direction.SOUTH && stateNorth.getBlock() instanceof WarpPipeBlock && !((Boolean)stateNorth.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateNorth.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue() && !(stateNorth.getBlock() instanceof ClearWarpPipeBlock)) {
            return true;
        }
        if (state.getValue((Property)FACING) == Direction.EAST && stateWest.getBlock() instanceof WarpPipeBlock && !((Boolean)stateWest.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateWest.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue() && !(stateWest.getBlock() instanceof ClearWarpPipeBlock)) {
            return true;
        }
        if (state.getValue((Property)FACING) == Direction.WEST && stateEast.getBlock() instanceof WarpPipeBlock && !((Boolean)stateEast.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateEast.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue() && !(stateEast.getBlock() instanceof ClearWarpPipeBlock)) {
            return true;
        }
        if (state.getValue((Property)FACING) == Direction.UP && stateBelow.getBlock() instanceof ClearWarpPipeBlock && !((Boolean)stateBelow.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateBelow.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue() && ((Boolean)stateBelow.getValue((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue()) {
            return true;
        }
        if (state.getValue((Property)FACING) == Direction.DOWN && stateAbove.getBlock() instanceof ClearWarpPipeBlock && !((Boolean)stateAbove.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateAbove.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue() && ((Boolean)stateAbove.getValue((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue()) {
            return true;
        }
        if (state.getValue((Property)FACING) == Direction.NORTH && stateSouth.getBlock() instanceof ClearWarpPipeBlock && !((Boolean)stateSouth.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateSouth.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue() && ((Boolean)stateSouth.getValue((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue()) {
            return true;
        }
        if (state.getValue((Property)FACING) == Direction.SOUTH && stateNorth.getBlock() instanceof ClearWarpPipeBlock && !((Boolean)stateNorth.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateNorth.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue() && ((Boolean)stateNorth.getValue((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue()) {
            return true;
        }
        if (state.getValue((Property)FACING) == Direction.EAST && stateWest.getBlock() instanceof ClearWarpPipeBlock && !((Boolean)stateWest.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateWest.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue() && ((Boolean)stateWest.getValue((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue()) {
            return true;
        }
        return state.getValue((Property)FACING) == Direction.WEST && stateEast.getBlock() instanceof ClearWarpPipeBlock && (Boolean)stateEast.getValue((Property)WarpPipeBlock.CLOSED) == false && (Boolean)stateEast.getValue((Property)WarpPipeBlock.BUBBLES) != false && (Boolean)stateEast.getValue((Property)ClearWarpPipeBlock.WATERLOGGED) != false;
    }

    public static boolean canExistIn(LevelAccessor worldAccessor, BlockPos pos) {
        return worldAccessor.getBlockState(pos).is((Block)BlockRegistry.PIPE_BUBBLES.get()) || worldAccessor.getBlockState(pos).is(Blocks.WATER) && worldAccessor.getBlockState(pos).getFluidState().isSource();
    }

    public static BlockState setBlockState(BlockState state, LevelAccessor worldAccessor, BlockPos pos) {
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            posMutable.setWithOffset((Vec3i)pos, direction);
        }
        if (state.is((Block)BlockRegistry.PIPE_BUBBLES.get())) {
            return state;
        }
        if (state.getBlock() instanceof WarpPipeBlock && !((Boolean)state.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)state.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue()) {
            return (BlockState)((BlockState)((Block)BlockRegistry.PIPE_BUBBLES.get()).defaultBlockState().setValue((Property)DRAG_DOWN, (Comparable)Boolean.FALSE)).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)));
        }
        return Blocks.WATER.defaultBlockState();
    }

    public void addParticles(Level world, ParticleOptions particleOptions, double xPos, double yPos, double zPos, int amt, double xMotion, double yMotion, double zMotion, double speed) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.sendParticles(particleOptions, xPos, yPos, zPos, amt, xMotion, yMotion, zMotion, speed);
        }
    }

    public void addAlwaysVisibleParticles(Level world, ParticleOptions particleOptions, double xPos, double yPos, double zPos, double xMotion, double yMotion, double zMotion) {
        if (world.isClientSide) {
            world.addAlwaysVisibleParticle(particleOptions, xPos, yPos, zPos, xMotion, yMotion, zMotion);
        }
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        double x = pos.getX();
        double y = pos.getY();
        double z = pos.getZ();
        if (((Boolean)state.getValue((Property)DRAG_DOWN)).booleanValue() || state.getValue((Property)FACING) == Direction.DOWN) {
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.CURRENT_DOWN, x + 0.5, y + 0.8, z, 0.0, -1.0, 0.0);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.BUBBLE, x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), 0.0, -1.5, 0.0);
            if (random.nextInt(200) == 0) {
                world.playLocalSound(x, y, z, SoundEvents.BUBBLE_COLUMN_WHIRLPOOL_AMBIENT, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
        } else if (state.getValue((Property)FACING) == Direction.UP) {
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.BUBBLE, x + 0.5, y, z + 0.5, 0.0, 1.0, 0.0);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.BUBBLE, x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), 0.0, 1.0, 0.0);
        } else if (state.getValue((Property)FACING) == Direction.NORTH) {
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.BUBBLE, x + 0.5, y, z + 0.5, 0.0, 0.04, -1.5);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.BUBBLE, x + 0.5, y, z + 0.5, 0.0, 0.04, -1.5);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.BUBBLE, x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), 0.0, 0.04, -1.5);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.BUBBLE, x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), 0.0, 0.04, -1.5);
        } else if (state.getValue((Property)FACING) == Direction.SOUTH) {
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.BUBBLE, x + 0.5, y, z + 0.5, 0.0, 0.04, 1.5);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.BUBBLE, x + 0.5, y, z + 0.5, 0.0, 0.04, 1.5);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.BUBBLE, x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), 0.0, 0.04, 1.5);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.BUBBLE, x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), 0.0, 0.04, 1.5);
        } else if (state.getValue((Property)FACING) == Direction.EAST) {
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.BUBBLE, x + 0.5, y, z + 0.5, 1.5, 0.04, 0.0);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.BUBBLE, x + 0.5, y, z + 0.5, 1.5, 0.04, 0.0);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.BUBBLE, x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), 1.5, 0.04, 0.0);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.BUBBLE, x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), 1.5, 0.04, 0.0);
        } else if (state.getValue((Property)FACING) == Direction.WEST) {
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.BUBBLE, x + 0.5, y, z + 0.5, -1.5, 0.04, 0.0);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.BUBBLE, x + 0.5, y, z + 0.5, -1.5, 0.04, 0.0);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.BUBBLE, x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), -1.5, 0.04, 0.0);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.BUBBLE, x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), -1.5, 0.04, 0.0);
        }
        if (random.nextInt(200) == 0) {
            world.playLocalSound(x, y, z, SoundEvents.BUBBLE_COLUMN_UPWARDS_AMBIENT, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
        }
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        BlockState stateAbove = world.getBlockState(pos.above());
        if (stateAbove.isAir() && state.getValue((Property)FACING) == Direction.UP) {
            if (entity instanceof Boat) {
                Boat boat = (Boat)entity;
                boat.onAboveBubbleCol(Boolean.FALSE.booleanValue());
            } else {
                this.onAboveUpBubbleCol((Boolean)state.getValue((Property)DRAG_DOWN), entity);
            }
            if (!world.isClientSide) {
                serverWorld = (ServerLevel)world;
                for (i = 0; i < 2; ++i) {
                    this.addParticles((Level)serverWorld, (ParticleOptions)ParticleTypes.SPLASH, (double)pos.getX() + world.random.nextDouble(), pos.getY() + 1, (double)pos.getZ() + world.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                    this.addParticles((Level)serverWorld, (ParticleOptions)ParticleTypes.BUBBLE, (double)pos.getX() + world.random.nextDouble(), pos.getY() + 1, (double)pos.getZ() + world.random.nextDouble(), 1, 0.0, 0.01, 0.0, 0.2);
                }
            }
        } else if (state.getValue((Property)FACING) == Direction.UP) {
            this.onInsideUpBubbleColumn((Boolean)state.getValue((Property)DRAG_DOWN), entity);
            if (!world.isClientSide) {
                serverWorld = (ServerLevel)world;
                for (i = 0; i < 2; ++i) {
                    this.addParticles((Level)serverWorld, (ParticleOptions)ParticleTypes.SPLASH, (double)pos.getX() + world.random.nextDouble(), pos.getY() + 1, (double)pos.getZ() + world.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                    this.addParticles((Level)serverWorld, (ParticleOptions)ParticleTypes.BUBBLE, (double)pos.getX() + world.random.nextDouble(), pos.getY() + 1, (double)pos.getZ() + world.random.nextDouble(), 1, 0.0, 0.01, 0.0, 0.2);
                }
            }
        } else if (state.getValue((Property)FACING) == Direction.DOWN) {
            this.onInsideDownBubbleColumn((Boolean)state.getValue((Property)DRAG_DOWN), entity);
        } else if (state.getValue((Property)FACING) == Direction.NORTH) {
            this.onInsideNorthBubbleColumn((Boolean)state.getValue((Property)DRAG_DOWN), entity);
        } else if (state.getValue((Property)FACING) == Direction.SOUTH) {
            this.onInsideSouthBubbleColumn((Boolean)state.getValue((Property)DRAG_DOWN), entity);
        } else if (state.getValue((Property)FACING) == Direction.EAST) {
            this.onInsideEastBubbleColumn((Boolean)state.getValue((Property)DRAG_DOWN), entity);
        } else if (state.getValue((Property)FACING) == Direction.WEST) {
            this.onInsideWestBubbleColumn((Boolean)state.getValue((Property)DRAG_DOWN), entity);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!world.isClientSide && livingEntity.canDrownInFluidType(Fluids.WATER.getFluidType())) {
                int refillAmount = 1;
                int newAir = Math.min(livingEntity.getAirSupply() + refillAmount, livingEntity.getMaxAirSupply());
                livingEntity.setAirSupply(newAir);
            }
        }
    }

    public void onAboveUpBubbleCol(boolean isDragDown, Entity entity) {
        Vec3 vec3 = entity.getDeltaMovement();
        double d0 = isDragDown ? Math.max(-0.9, vec3.y - 0.03) : Math.min(1.8, vec3.y + 0.1);
        entity.setDeltaMovement(vec3.x, d0, vec3.z);
    }

    public void onInsideUpBubbleColumn(boolean isDragDown, Entity entity) {
        Vec3 vec3 = entity.getDeltaMovement();
        double d0 = isDragDown ? Math.max(-0.3, vec3.y - 0.03) : Math.min(0.5, vec3.y + 0.04);
        entity.setDeltaMovement(vec3.x, d0, vec3.z);
        entity.resetFallDistance();
    }

    public void onInsideDownBubbleColumn(boolean isDragDown, Entity entity) {
        Vec3 vec3 = entity.getDeltaMovement();
        double d0 = isDragDown ? Math.max(0.3, vec3.y + 0.03) : Math.min(-0.5, vec3.y - 0.04);
        entity.setDeltaMovement(vec3.x, d0, vec3.z);
        entity.resetFallDistance();
    }

    public void onInsideNorthBubbleColumn(boolean isDragDown, Entity entity) {
        Vec3 vec3 = entity.getDeltaMovement();
        double d0 = isDragDown ? Math.max(0.3, vec3.z + 0.03) : Math.min(-0.5, vec3.z - 0.04);
        entity.setDeltaMovement(vec3.x, vec3.y, d0);
        entity.resetFallDistance();
    }

    public void onInsideSouthBubbleColumn(boolean isDragDown, Entity entity) {
        Vec3 vec3 = entity.getDeltaMovement();
        double d0 = isDragDown ? Math.max(-0.3, vec3.z - 0.03) : Math.min(0.5, vec3.z + 0.04);
        entity.setDeltaMovement(vec3.x, vec3.y, d0);
        entity.resetFallDistance();
    }

    public void onInsideEastBubbleColumn(boolean isDragDown, Entity entity) {
        Vec3 vec3 = entity.getDeltaMovement();
        double d0 = isDragDown ? Math.max(-0.3, vec3.x - 0.03) : Math.min(0.5, vec3.x + 0.04);
        entity.setDeltaMovement(d0, vec3.y, vec3.z);
        entity.resetFallDistance();
    }

    public void onInsideWestBubbleColumn(boolean isDragDown, Entity entity) {
        Vec3 vec3 = entity.getDeltaMovement();
        double d0 = isDragDown ? Math.max(0.3, vec3.x + 0.03) : Math.min(-0.5, vec3.x - 0.04);
        entity.setDeltaMovement(d0, vec3.y, vec3.z);
        entity.resetFallDistance();
    }

    public void tick(BlockState state, ServerLevel serverWorld, BlockPos pos, RandomSource random) {
        WarpPipeBlockEntity pipeBlockEntity = (WarpPipeBlockEntity)serverWorld.getBlockEntity(pos);
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (pipeBlockEntity != null) {
            if (facing == Direction.UP) {
                PipeBubblesBlock.repeatColumnUp((LevelAccessor)serverWorld, pos, state, serverWorld.getBlockState(pos.below()), pipeBlockEntity.bubblesDistance);
            } else if (facing == Direction.DOWN) {
                PipeBubblesBlock.repeatColumnDown((LevelAccessor)serverWorld, pos, state, serverWorld.getBlockState(pos.above()), pipeBlockEntity.bubblesDistance);
            } else if (facing == Direction.NORTH) {
                PipeBubblesBlock.repeatColumnNorth((LevelAccessor)serverWorld, pos, state, serverWorld.getBlockState(pos.south()), pipeBlockEntity.bubblesDistance);
            } else if (facing == Direction.SOUTH) {
                PipeBubblesBlock.repeatColumnSouth((LevelAccessor)serverWorld, pos, state, serverWorld.getBlockState(pos.north()), pipeBlockEntity.bubblesDistance);
            } else if (facing == Direction.EAST) {
                PipeBubblesBlock.repeatColumnEast((LevelAccessor)serverWorld, pos, state, serverWorld.getBlockState(pos.west()), pipeBlockEntity.bubblesDistance);
            } else if (facing == Direction.WEST) {
                PipeBubblesBlock.repeatColumnWest((LevelAccessor)serverWorld, pos, state, serverWorld.getBlockState(pos.east()), pipeBlockEntity.bubblesDistance);
            }
        } else {
            PipeBubblesBlock.repeatColumnUp((LevelAccessor)serverWorld, pos, state, serverWorld.getBlockState(pos.below()), 0);
        }
    }

    public static void repeatColumnUp(LevelAccessor worldAccessor, BlockPos pos, BlockState state, int bubblesDistance) {
        PipeBubblesBlock.repeatColumnUp(worldAccessor, pos, worldAccessor.getBlockState(pos), state, bubblesDistance);
    }

    public static void repeatColumnDown(LevelAccessor worldAccessor, BlockPos pos, BlockState state, int bubblesDistance) {
        PipeBubblesBlock.repeatColumnDown(worldAccessor, pos, worldAccessor.getBlockState(pos), state, bubblesDistance);
    }

    public static void repeatColumnNorth(LevelAccessor worldAccessor, BlockPos pos, BlockState state, int bubblesDistance) {
        PipeBubblesBlock.repeatColumnNorth(worldAccessor, pos, worldAccessor.getBlockState(pos), state, bubblesDistance);
    }

    public static void repeatColumnSouth(LevelAccessor worldAccessor, BlockPos pos, BlockState state, int bubblesDistance) {
        PipeBubblesBlock.repeatColumnSouth(worldAccessor, pos, worldAccessor.getBlockState(pos), state, bubblesDistance);
    }

    public static void repeatColumnEast(LevelAccessor worldAccessor, BlockPos pos, BlockState state, int bubblesDistance) {
        PipeBubblesBlock.repeatColumnEast(worldAccessor, pos, worldAccessor.getBlockState(pos), state, bubblesDistance);
    }

    public static void repeatColumnWest(LevelAccessor worldAccessor, BlockPos pos, BlockState state, int bubblesDistance) {
        PipeBubblesBlock.repeatColumnWest(worldAccessor, pos, worldAccessor.getBlockState(pos), state, bubblesDistance);
    }

    public static void repeatColumnUp(LevelAccessor worldAccessor, BlockPos pos, BlockState state, BlockState neighborState, int bubblesDistance) {
        if (PipeBubblesBlock.canExistIn(worldAccessor, pos) && bubblesDistance != 0) {
            BlockPos.MutableBlockPos mutablePos = pos.mutable().move(Direction.UP);
            BlockState pipeColumnState = PipeBubblesBlock.setBlockState(neighborState, worldAccessor, pos);
            worldAccessor.setBlock(pos, pipeColumnState, 2);
            for (int initialDistance = 0; PipeBubblesBlock.canExistIn(worldAccessor, (BlockPos)mutablePos) && initialDistance < bubblesDistance - 1; ++initialDistance) {
                if (!worldAccessor.setBlock((BlockPos)mutablePos, pipeColumnState, 2)) {
                    return;
                }
                mutablePos.move(Direction.UP);
                pipeColumnState = PipeBubblesBlock.setBlockState(pipeColumnState, worldAccessor, (BlockPos)mutablePos);
            }
        }
    }

    public static void repeatColumnDown(LevelAccessor worldAccessor, BlockPos pos, BlockState state, BlockState neighborState, int bubblesDistance) {
        if (PipeBubblesBlock.canExistIn(worldAccessor, pos) && bubblesDistance != 0) {
            BlockPos.MutableBlockPos mutablePos = pos.mutable().move(Direction.DOWN);
            BlockState pipeColumnState = PipeBubblesBlock.setBlockState(neighborState, worldAccessor, pos);
            worldAccessor.setBlock(pos, pipeColumnState, 2);
            for (int initialDistance = 0; PipeBubblesBlock.canExistIn(worldAccessor, (BlockPos)mutablePos) && initialDistance < bubblesDistance - 1; ++initialDistance) {
                if (!worldAccessor.setBlock((BlockPos)mutablePos, pipeColumnState, 2)) {
                    return;
                }
                mutablePos.move(Direction.DOWN);
                pipeColumnState = PipeBubblesBlock.setBlockState(pipeColumnState, worldAccessor, (BlockPos)mutablePos);
            }
        }
    }

    public static void repeatColumnNorth(LevelAccessor worldAccessor, BlockPos pos, BlockState state, BlockState neighborState, int bubblesDistance) {
        if (PipeBubblesBlock.canExistIn(worldAccessor, pos) && bubblesDistance != 0) {
            BlockPos.MutableBlockPos mutablePos = pos.mutable().move(Direction.NORTH);
            BlockState pipeColumnState = PipeBubblesBlock.setBlockState(neighborState, worldAccessor, pos);
            worldAccessor.setBlock(pos, pipeColumnState, 2);
            for (int initialDistance = 0; PipeBubblesBlock.canExistIn(worldAccessor, (BlockPos)mutablePos) && initialDistance < bubblesDistance - 1; ++initialDistance) {
                if (!worldAccessor.setBlock((BlockPos)mutablePos, pipeColumnState, 2)) {
                    return;
                }
                mutablePos.move(Direction.NORTH);
                pipeColumnState = PipeBubblesBlock.setBlockState(pipeColumnState, worldAccessor, (BlockPos)mutablePos);
            }
        }
    }

    public static void repeatColumnSouth(LevelAccessor worldAccessor, BlockPos pos, BlockState state, BlockState neighborState, int bubblesDistance) {
        if (PipeBubblesBlock.canExistIn(worldAccessor, pos) && bubblesDistance != 0) {
            BlockPos.MutableBlockPos mutablePos = pos.mutable().move(Direction.SOUTH);
            BlockState pipeColumnState = PipeBubblesBlock.setBlockState(neighborState, worldAccessor, pos);
            worldAccessor.setBlock(pos, pipeColumnState, 2);
            for (int initialDistance = 0; PipeBubblesBlock.canExistIn(worldAccessor, (BlockPos)mutablePos) && initialDistance < bubblesDistance - 1; ++initialDistance) {
                if (!worldAccessor.setBlock((BlockPos)mutablePos, pipeColumnState, 2)) {
                    return;
                }
                mutablePos.move(Direction.SOUTH);
                pipeColumnState = PipeBubblesBlock.setBlockState(pipeColumnState, worldAccessor, (BlockPos)mutablePos);
            }
        }
    }

    public static void repeatColumnEast(LevelAccessor worldAccessor, BlockPos pos, BlockState state, BlockState neighborState, int bubblesDistance) {
        if (PipeBubblesBlock.canExistIn(worldAccessor, pos) && bubblesDistance != 0) {
            BlockPos.MutableBlockPos mutablePos = pos.mutable().move(Direction.EAST);
            BlockState pipeColumnState = PipeBubblesBlock.setBlockState(neighborState, worldAccessor, pos);
            worldAccessor.setBlock(pos, pipeColumnState, 2);
            for (int initialDistance = 0; PipeBubblesBlock.canExistIn(worldAccessor, (BlockPos)mutablePos) && initialDistance < bubblesDistance - 1; ++initialDistance) {
                if (!worldAccessor.setBlock((BlockPos)mutablePos, pipeColumnState, 2)) {
                    return;
                }
                mutablePos.move(Direction.EAST);
                pipeColumnState = PipeBubblesBlock.setBlockState(pipeColumnState, worldAccessor, (BlockPos)mutablePos);
            }
        }
    }

    public static void repeatColumnWest(LevelAccessor worldAccessor, BlockPos pos, BlockState state, BlockState neighborState, int bubblesDistance) {
        if (PipeBubblesBlock.canExistIn(worldAccessor, pos) && bubblesDistance != 0) {
            BlockPos.MutableBlockPos mutablePos = pos.mutable().move(Direction.WEST);
            BlockState pipeColumnState = PipeBubblesBlock.setBlockState(neighborState, worldAccessor, pos);
            worldAccessor.setBlock(pos, pipeColumnState, 2);
            for (int initialDistance = 0; PipeBubblesBlock.canExistIn(worldAccessor, (BlockPos)mutablePos) && initialDistance < bubblesDistance - 1; ++initialDistance) {
                if (!worldAccessor.setBlock((BlockPos)mutablePos, pipeColumnState, 2)) {
                    return;
                }
                mutablePos.move(Direction.WEST);
                pipeColumnState = PipeBubblesBlock.setBlockState(pipeColumnState, worldAccessor, (BlockPos)mutablePos);
            }
        }
    }
}

