/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.mixin;

import com.wenxin2.marioverse.blocks.entities.BaseWarpBlockEntity;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={HoneycombItem.class})
public class HoneycombItemMixin {
    @Inject(method={"useOn"}, at={@At(value="HEAD")}, cancellable=true)
    public void onUseOnBlock(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = world.getBlockState(pos);
        ItemStack itemStack = context.getItemInHand();
        Player player = context.getPlayer();
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BaseWarpBlockEntity) {
            BaseWarpBlockEntity warpBE = (BaseWarpBlockEntity)blockEntity;
            if ((((Boolean)ConfigRegistry.WAX_DISABLES_BUBBLES.get()).booleanValue() || ((Boolean)ConfigRegistry.WAX_DISABLES_CLOSING.get()).booleanValue() || ((Boolean)ConfigRegistry.WAX_DISABLES_RENAMING.get()).booleanValue() || ((Boolean)ConfigRegistry.WAX_DISABLES_WATER_SPOUTS.get()).booleanValue() || ((Boolean)ConfigRegistry.WAX_DISABLES_WARP_LINKING.get()).booleanValue()) && !warpBE.isWaxed()) {
                warpBE.setWaxed(true);
                world.playSound(player, pos, SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
                ParticleUtils.spawnParticlesOnBlockFaces((Level)world, (BlockPos)pos, (ParticleOptions)ParticleTypes.WAX_ON, (IntProvider)UniformInt.of((int)3, (int)5));
                if (state.getBlock() instanceof DoorBlock && state.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.LOWER) {
                    ParticleUtils.spawnParticlesOnBlockFaces((Level)world, (BlockPos)pos.above(), (ParticleOptions)ParticleTypes.WAX_ON, (IntProvider)UniformInt.of((int)3, (int)5));
                }
                if (state.getBlock() instanceof DoorBlock && state.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.UPPER) {
                    ParticleUtils.spawnParticlesOnBlockFaces((Level)world, (BlockPos)pos.below(), (ParticleOptions)ParticleTypes.WAX_ON, (IntProvider)UniformInt.of((int)3, (int)5));
                }
                warpBE.markUpdated();
                if (player != null) {
                    itemStack.shrink(1);
                }
                world.sendBlockUpdated(pos, state, state, 3);
                cir.setReturnValue((Object)InteractionResult.sidedSuccess((boolean)Boolean.TRUE));
            }
        }
    }
}

