/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.wenxin2.marioverse.MarioverseClient;
import com.wenxin2.marioverse.MarioverseCreativeTabs;
import com.wenxin2.marioverse.event_handlers.MarioverseEventHandlers;
import com.wenxin2.marioverse.event_handlers.RegistryEventHandlers;
import com.wenxin2.marioverse.integration.StoneZoneCompat;
import com.wenxin2.marioverse.integration.WoodGoodCompat;
import com.wenxin2.marioverse.registries.AttributesRegistry;
import com.wenxin2.marioverse.registries.BlockEntityRegistry;
import com.wenxin2.marioverse.registries.BlockRegistry;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.DataComponentRegistry;
import com.wenxin2.marioverse.registries.EntityRegistry;
import com.wenxin2.marioverse.registries.GameEventRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.MenuRegistry;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.slf4j.Logger;

@Mod(value="marioverse")
public class Marioverse {
    public static final String MOD_ID = "marioverse";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"marioverse");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"marioverse");
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"marioverse");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"marioverse");
    public static final DeferredRegister<DataComponentType<?>> COMPONENTS = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"marioverse");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"marioverse");
    public static final DeferredRegister<GameEvent> GAME_EVENTS = DeferredRegister.create((ResourceKey)Registries.GAME_EVENT, (String)"marioverse");
    public static final DeferredRegister<MapCodec<? extends IGlobalLootModifier>> GLOBAL_LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"marioverse");
    public static final DeferredRegister<MenuType<?>> MENUS = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"marioverse");
    public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((ResourceKey)Registries.PARTICLE_TYPE, (String)"marioverse");
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"marioverse");
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((ResourceKey)Registries.ATTRIBUTE, (String)"marioverse");
    public static GameRules.Key<GameRules.BooleanValue> ALL_MOBS_CAN_STOMP;
    public static GameRules.Key<GameRules.BooleanValue> DAMAGE_SHRINKS_ALL_MOBS;
    public static GameRules.Key<GameRules.BooleanValue> DAMAGE_SHRINKS_PLAYERS;
    public static GameRules.Key<GameRules.BooleanValue> STOMP_ALL_MOBS;

    public Marioverse(IEventBus bus, Dist dist, ModContainer container) {
        ATTACHMENT_TYPES.register(bus);
        COMPONENTS.register(bus);
        GAME_EVENTS.register(bus);
        BLOCKS.register(bus);
        ITEMS.register(bus);
        BLOCK_ENTITIES.register(bus);
        ENTITIES.register(bus);
        ATTRIBUTES.register(bus);
        PARTICLES.register(bus);
        MENUS.register(bus);
        SOUNDS.register(bus);
        GLOBAL_LOOT_MODIFIERS.register(bus);
        MarioverseCreativeTabs.TABS.register(bus);
        BlockRegistry.init();
        BlockEntityRegistry.init();
        ItemRegistry.init();
        EntityRegistry.init();
        GameEventRegistry.init();
        MenuRegistry.init();
        ParticleRegistry.init();
        SoundRegistry.init();
        DataAttachmentRegistry.init();
        DataComponentRegistry.init();
        AttributesRegistry.init();
        ConfigRegistry.register(container);
        Marioverse.everyCompatModule();
        Marioverse.stoneZoneModule();
        if (dist.isClient()) {
            ConfigRegistry.registerClient(container);
            bus.addListener(MarioverseClient::clientSetup);
            bus.addListener(MarioverseClient::addPackFinder);
        }
        NeoForge.EVENT_BUS.addListener(MarioverseEventHandlers::onJoinWorld);
        NeoForge.EVENT_BUS.addListener(MarioverseEventHandlers::onPlayerRightClick);
        bus.addListener(this::commonSetup);
        bus.addListener(RegistryEventHandlers::gatherData);
    }

    private static void everyCompatModule() {
        try {
            if (ModList.get().isLoaded("everycomp")) {
                WoodGoodCompat.init();
            } else {
                LOGGER.info("Every Compat module is not loaded");
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to start Wood Good module", (Throwable)e);
        }
    }

    private static void stoneZoneModule() {
        try {
            if (ModList.get().isLoaded("stonezone")) {
                StoneZoneCompat.init();
            } else {
                LOGGER.info("Stone Zone module is not loaded");
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to start Stone Zone module", (Throwable)e);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ALL_MOBS_CAN_STOMP = GameRules.register((String)"marioverse:all_mobs_can_stomp", (GameRules.Category)GameRules.Category.MOBS, (GameRules.Type)GameRules.BooleanValue.create((boolean)false));
            DAMAGE_SHRINKS_ALL_MOBS = GameRules.register((String)"marioverse:damage_shrinks_all_mobs", (GameRules.Category)GameRules.Category.MOBS, (GameRules.Type)GameRules.BooleanValue.create((boolean)false));
            DAMAGE_SHRINKS_PLAYERS = GameRules.register((String)"marioverse:damage_shrinks_players", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.create((boolean)false));
            STOMP_ALL_MOBS = GameRules.register((String)"marioverse:stomp_all_mobs", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.create((boolean)false));
        });
    }

    public static ResourceLocation id(String id) {
        return ResourceLocation.tryBuild((String)MOD_ID, (String)id);
    }
}

