/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.client.renderers.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.wenxin2.marioverse.client.models.entities.DryBonesPartModel;
import com.wenxin2.marioverse.entities.DryBonesPartEntity;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;

public class DryBonesPartRenderer
extends GeoEntityRenderer<DryBonesPartEntity> {
    private static final String HELMET = "armorHead";
    private static final String CHEST = "armorBody";
    private static final String LEFT_ARM = "armorLeftArm";
    private static final String RIGHT_ARM = "armorRightArm";
    private static final String LEFT_LEG = "armorLeftLeg";
    private static final String RIGHT_LEG = "armorRightLeg";
    private static final String LEFT_BOOT = "armorLeftBoot";
    private static final String RIGHT_BOOT = "armorRightBoot";
    protected ItemStack mainHandItem;
    protected ItemStack offhandItem;

    public DryBonesPartRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new DryBonesPartModel());
        this.shadowRadius = 0.15f;
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)this));
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<DryBonesPartEntity>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getArmorItemForBone(GeoBone bone, DryBonesPartEntity animatable) {
                return switch (bone.getName()) {
                    case DryBonesPartRenderer.HELMET -> this.helmetStack;
                    case DryBonesPartRenderer.CHEST, DryBonesPartRenderer.LEFT_ARM, DryBonesPartRenderer.RIGHT_ARM -> this.chestplateStack;
                    case DryBonesPartRenderer.LEFT_LEG, DryBonesPartRenderer.RIGHT_LEG -> this.leggingsStack;
                    case DryBonesPartRenderer.LEFT_BOOT, DryBonesPartRenderer.RIGHT_BOOT -> this.bootsStack;
                    default -> super.getArmorItemForBone(bone, (LivingEntity)animatable);
                };
            }

            @NotNull
            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, DryBonesPartEntity animatable) {
                return switch (bone.getName()) {
                    case DryBonesPartRenderer.HELMET -> EquipmentSlot.HEAD;
                    case DryBonesPartRenderer.CHEST -> EquipmentSlot.CHEST;
                    case DryBonesPartRenderer.RIGHT_ARM -> {
                        if (!animatable.isLeftHanded()) {
                            yield EquipmentSlot.MAINHAND;
                        }
                        yield EquipmentSlot.OFFHAND;
                    }
                    case DryBonesPartRenderer.LEFT_ARM -> {
                        if (animatable.isLeftHanded()) {
                            yield EquipmentSlot.OFFHAND;
                        }
                        yield EquipmentSlot.MAINHAND;
                    }
                    case DryBonesPartRenderer.LEFT_LEG, DryBonesPartRenderer.RIGHT_LEG -> EquipmentSlot.LEGS;
                    case DryBonesPartRenderer.LEFT_BOOT, DryBonesPartRenderer.RIGHT_BOOT -> EquipmentSlot.FEET;
                    default -> super.getEquipmentSlotForBone(bone, stack, (LivingEntity)animatable);
                };
            }

            @NotNull
            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, DryBonesPartEntity animatable, HumanoidModel<?> baseModel) {
                return switch (bone.getName()) {
                    case DryBonesPartRenderer.HELMET -> baseModel.head;
                    case DryBonesPartRenderer.CHEST -> baseModel.body;
                    case DryBonesPartRenderer.LEFT_ARM -> baseModel.leftArm;
                    case DryBonesPartRenderer.RIGHT_ARM -> baseModel.rightArm;
                    case DryBonesPartRenderer.LEFT_LEG, DryBonesPartRenderer.LEFT_BOOT -> baseModel.leftLeg;
                    case DryBonesPartRenderer.RIGHT_LEG, DryBonesPartRenderer.RIGHT_BOOT -> baseModel.rightLeg;
                    default -> super.getModelPartForBone(bone, slot, stack, (LivingEntity)animatable, baseModel);
                };
            }

            protected void renderSkullAsArmor(PoseStack poseStack, GeoBone bone, ItemStack stack, AbstractSkullBlock skullBlock, MultiBufferSource bufferSource, int packedLight) {
                poseStack.scale(1.0f, 1.0f, 1.0f);
                poseStack.mulPose(Axis.XP.rotationDegrees(-30.0f));
                poseStack.translate(0.0f, 0.0f, 0.25f);
                super.renderSkullAsArmor(poseStack, bone, stack, skullBlock, bufferSource, packedLight);
            }
        });
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<DryBonesPartEntity>((GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, DryBonesPartEntity animatable) {
                return switch (bone.getName()) {
                    case DryBonesPartRenderer.HELMET -> {
                        BlockItem blockItem;
                        Item var6_5;
                        if (!(animatable.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof ArmorItem || (var6_5 = animatable.getItemBySlot(EquipmentSlot.HEAD).getItem()) instanceof BlockItem && (blockItem = (BlockItem)var6_5).getBlock() instanceof SkullBlock)) {
                            yield animatable.getItemBySlot(EquipmentSlot.HEAD);
                        }
                        yield ItemStack.EMPTY;
                    }
                    case DryBonesPartRenderer.LEFT_ARM -> {
                        if (animatable.isLeftHanded()) {
                            yield DryBonesPartRenderer.this.mainHandItem;
                        }
                        yield DryBonesPartRenderer.this.offhandItem;
                    }
                    case DryBonesPartRenderer.RIGHT_ARM -> {
                        if (animatable.isLeftHanded()) {
                            yield DryBonesPartRenderer.this.offhandItem;
                        }
                        yield DryBonesPartRenderer.this.mainHandItem;
                    }
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, DryBonesPartEntity animatable) {
                return switch (bone.getName()) {
                    case DryBonesPartRenderer.HELMET -> ItemDisplayContext.HEAD;
                    case DryBonesPartRenderer.LEFT_ARM, DryBonesPartRenderer.RIGHT_ARM -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, DryBonesPartEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                if (stack == DryBonesPartRenderer.this.mainHandItem) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    poseStack.translate(0.0, 0.125, -0.5);
                    if (stack.getItem() instanceof ShieldItem) {
                        poseStack.translate(-0.05, 0.0, 0.4);
                    }
                } else if (stack == DryBonesPartRenderer.this.offhandItem) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    poseStack.translate(0.0, 0.125, -0.5);
                    if (stack.getItem() instanceof ShieldItem) {
                        poseStack.translate(-0.05, 0.0, 0.4);
                        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    }
                } else if (stack.getItem() instanceof BlockItem) {
                    poseStack.scale(0.85f, 0.85f, 0.85f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(-30.0f));
                    poseStack.translate(0.0f, 0.5f, 0.1f);
                } else {
                    poseStack.scale(0.6f, 0.6f, 0.6f);
                    poseStack.translate(0.0f, 0.5f, 0.0f);
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    public void preRender(PoseStack poseStack, DryBonesPartEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        this.mainHandItem = animatable.getMainHandItem();
        this.offhandItem = animatable.getOffhandItem();
    }

    protected float getDeathMaxRotation(DryBonesPartEntity animatable) {
        return 0.0f;
    }

    public int getPackedOverlay(DryBonesPartEntity animatable, float u, float partialTick) {
        return OverlayTexture.NO_OVERLAY;
    }

    protected float getShadowRadius(DryBonesPartEntity animatable) {
        if (animatable.getPartType().equals("head") || animatable.getPartType().equals("shell")) {
            return 0.5f;
        }
        return 0.15f;
    }
}

