/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.client.renderers.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wenxin2.marioverse.client.models.entities.MegaGoombaModel;
import com.wenxin2.marioverse.entities.MegaGoombaEntity;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;

public class MegaGoombaRenderer
extends GeoEntityRenderer<MegaGoombaEntity> {
    private static final String HELMET = "armorBipedHead";

    public MegaGoombaRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new MegaGoombaModel());
        this.shadowRadius = 2.0f;
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<MegaGoombaEntity>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getArmorItemForBone(GeoBone bone, MegaGoombaEntity animatable) {
                return switch (bone.getName()) {
                    case MegaGoombaRenderer.HELMET -> animatable.getItemBySlot(EquipmentSlot.HEAD);
                    default -> null;
                };
            }

            @NotNull
            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, MegaGoombaEntity animatable) {
                return switch (bone.getName()) {
                    case MegaGoombaRenderer.HELMET -> EquipmentSlot.HEAD;
                    default -> super.getEquipmentSlotForBone(bone, stack, (LivingEntity)animatable);
                };
            }

            @NotNull
            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, MegaGoombaEntity animatable, HumanoidModel<?> baseModel) {
                return switch (bone.getName()) {
                    case MegaGoombaRenderer.HELMET -> baseModel.head;
                    default -> super.getModelPartForBone(bone, slot, stack, (LivingEntity)animatable, baseModel);
                };
            }

            protected void renderSkullAsArmor(PoseStack poseStack, GeoBone bone, ItemStack stack, AbstractSkullBlock skullBlock, MultiBufferSource bufferSource, int packedLight) {
                poseStack.scale(4.01f, 4.0f, 3.95f);
                poseStack.translate(0.0f, -1.595f, 0.0f);
                super.renderSkullAsArmor(poseStack, bone, stack, skullBlock, bufferSource, packedLight);
            }
        });
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<MegaGoombaEntity>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, MegaGoombaEntity animatable) {
                BlockItem blockItem;
                Object object;
                if (!(animatable.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof ArmorItem || (object = animatable.getItemBySlot(EquipmentSlot.HEAD).getItem()) instanceof BlockItem && (blockItem = (BlockItem)object).getBlock() instanceof SkullBlock)) {
                    return switch (bone.getName()) {
                        case MegaGoombaRenderer.HELMET -> animatable.getItemBySlot(EquipmentSlot.HEAD);
                        default -> null;
                    };
                }
                return null;
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, MegaGoombaEntity animatable) {
                return switch (bone.getName()) {
                    case MegaGoombaRenderer.HELMET -> ItemDisplayContext.HEAD;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, MegaGoombaEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                poseStack.scale(2.6f, 2.4f, 2.37f);
                poseStack.translate(0.0f, 0.5f, 0.0f);
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    protected float getDeathMaxRotation(MegaGoombaEntity animatable) {
        return 0.0f;
    }
}

