/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.client.renderers.entities.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.wenxin2.marioverse.client.renderers.SuperStarRenderType;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class SuperStarLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public SuperStarLayer(RenderLayerParent<T, M> parentRenderer) {
        super(parentRenderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ShaderInstance shader = SuperStarRenderType.SUPER_STAR_SHADER;
        EntityModel model = this.getParentModel();
        if (!entity.isInvisible() && (((Boolean)entity.getData(DataAttachmentRegistry.HAS_SUPER_STAR)).booleanValue() || !((Boolean)ConfigRegistry.DISABLE_JEB_SHADER.get()).booleanValue() && entity.hasCustomName() && "jeb_".equals(entity.getName().getString()))) {
            if (shader != null) {
                float time = ((float)entity.level().getGameTime() + partialTicks) * 0.2f;
                shader.safeGetUniform("Time").set(time);
            }
            ResourceLocation texture = this.getTextureLocation((Entity)entity);
            VertexConsumer consumer = bufferSource.getBuffer(SuperStarRenderType.superStar(texture));
            poseStack.pushPose();
            model.renderToBuffer(poseStack, consumer, 0xF000F0, LivingEntityRenderer.getOverlayCoords(entity, (float)0.0f));
            poseStack.popPose();
        }
    }
}

