/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities;

import com.wenxin2.marioverse.entities.ai.goals.LookAtTagGoal;
import com.wenxin2.marioverse.registries.AttributesRegistry;
import com.wenxin2.marioverse.registries.BlockRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SplunkinEntity
extends Monster
implements GeoEntity,
NeutralMob {
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;
    public static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("splunkin.idle");
    public static final RawAnimation IDLE_SWIM_ANIM = RawAnimation.begin().thenLoop("splunkin.idle_swim");
    public static final RawAnimation RUN_ANIM = RawAnimation.begin().thenLoop("splunkin.run");
    public static final RawAnimation SIT_ANIM = RawAnimation.begin().thenLoop("splunkin.sit");
    public static final RawAnimation SWIM_ANIM = RawAnimation.begin().thenLoop("splunkin.swim");
    public static final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("splunkin.walk");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SplunkinEntity(EntityType<? extends SplunkinEntity> type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.DOOR_OPEN, 1.0f);
        this.xpReward = 4;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.SPLUNKIN_CRACKS.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.SPLUNKIN_DEATH.get();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.6, false));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.4));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new LookAtTagGoal((Mob)this, TagRegistry.SPLUNKIN_CAN_ATTACK, 8.0f, 1.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Idle", 5, this::walkAnimController));
        controllers.add(new AnimationController((GeoAnimatable)this, "Run", 5, this::walkAnimController));
        controllers.add(new AnimationController((GeoAnimatable)this, "Swim", 15, this::walkAnimController));
        controllers.add(new AnimationController((GeoAnimatable)this, "Walk", 5, this::walkAnimController));
        controllers.add(DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)DefaultAnimations.ATTACK_BITE).transitionLength(1));
        controllers.add(DefaultAnimations.genericWalkController((GeoAnimatable)this));
    }

    protected <E extends GeoAnimatable> PlayState walkAnimController(AnimationState<E> event) {
        if (this.isPassenger()) {
            event.setAndContinue(SIT_ANIM);
            return PlayState.CONTINUE;
        }
        if (this.isInWaterOrBubble()) {
            if (!this.isRunning() && !this.isWalking()) {
                event.setAndContinue(IDLE_SWIM_ANIM);
            } else {
                event.setAndContinue(SWIM_ANIM);
            }
            return PlayState.CONTINUE;
        }
        if (this.isRunning()) {
            event.setAndContinue(RUN_ANIM);
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.setAndContinue(WALK_ANIM);
            return PlayState.CONTINUE;
        }
        event.setAndContinue(IDLE_ANIM);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean isWalking() {
        return this.getDeltaMovement().horizontalDistance() >= 0.01 && this.getDeltaMovement().horizontalDistance() < 0.5 || this.goalSelector.getAvailableGoals().stream().anyMatch(goal -> goal.isRunning() && goal.getGoal() instanceof RandomStrollGoal || this.walkDist > 0.0f);
    }

    private boolean isRunning() {
        return this.isSprinting() || (double)this.getSpeed() >= 0.5 || this.getDeltaMovement().horizontalDistance() >= 0.5 || this.goalSelector.getAvailableGoals().stream().anyMatch(goal -> goal.isRunning() && goal.getGoal() instanceof MeleeAttackGoal) || this.targetSelector.getAvailableGoals().stream().anyMatch(goal -> goal.isRunning() && goal.getGoal() instanceof NearestAttackableTargetGoal);
    }

    public void tick() {
        super.tick();
        if (this.isInWaterOrBubble()) {
            this.ejectPassengers();
        }
    }

    public void baseTick() {
        int i = this.getAirSupply();
        super.baseTick();
        this.handleAirSupply(i);
        if (this.getTarget() != null) {
            this.setSpeed(0.8f);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean wasHurt = super.hurt(source, amount);
        if (wasHurt && !this.isNoAi() && !((Boolean)this.getData(DataAttachmentRegistry.CRACKED)).booleanValue()) {
            this.setData(DataAttachmentRegistry.CRACKED, true);
        }
        return wasHurt;
    }

    public void die(DamageSource source) {
        this.playDeathAnimation((Entity)this);
        super.die(source);
    }

    public boolean canTakeItem(ItemStack stack) {
        EquipmentSlot equipmentslot = this.getEquipmentSlotForItem(stack);
        return this.getItemBySlot(equipmentslot).isEmpty();
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        if (random.nextFloat() < 0.05f && this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.DIAMOND_HELMET));
        } else if (random.nextFloat() < 0.15f && this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.IRON_HELMET));
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverWorld, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        RandomSource random = serverWorld.getRandom();
        this.populateDefaultEquipmentSlots(random, difficulty);
        this.populateDefaultEquipmentEnchantments(serverWorld, random, difficulty);
        return super.finalizeSpawn(serverWorld, difficulty, spawnType, groupData);
    }

    public static boolean checkSplunkinSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor serverWorld, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return serverWorld.getDifficulty() != Difficulty.PEACEFUL && (MobSpawnType.ignoresLightRequirements((MobSpawnType)spawnType) || SplunkinEntity.isDarkEnoughToSpawn((ServerLevelAccessor)serverWorld, (BlockPos)pos, (RandomSource)random)) && SplunkinEntity.checkMobSpawnRules(entityType, (LevelAccessor)serverWorld, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    @NotNull
    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float height) {
        return new Vec3(0.0, (double)this.getBbHeight() - 0.1, 0.0);
    }

    public boolean checkSpawnObstruction(LevelReader worldReader) {
        return worldReader.isUnobstructed((Entity)this);
    }

    public int getAmbientSoundInterval() {
        return 120;
    }

    protected void handleAirSupply(int airSupplyAmount) {
        if (this.isAlive() && this.isInWaterOrBubble()) {
            this.setAirSupply(airSupplyAmount);
        }
    }

    public void stopBeingAngry() {
        if (!this.isNoAi()) {
            this.setData(DataAttachmentRegistry.CRACKED, false);
        }
        super.stopBeingAngry();
    }

    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    public void setRemainingPersistentAngerTime(int angerTime) {
        this.remainingPersistentAngerTime = angerTime;
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID angerTarget) {
        this.persistentAngerTarget = angerTarget;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @NotNull
    public BlockParticleOption getShatterParticle() {
        return new BlockParticleOption(ParticleTypes.BLOCK, ((Block)BlockRegistry.SPLUNKIN_O_LANTERN.get()).defaultBlockState());
    }

    public void playDeathAnimation(Entity entity) {
        float scale = (float)this.getAttributeValue(Attributes.SCALE);
        float heightScale = (float)this.getAttributeValue((Holder)AttributesRegistry.HEIGHT_SCALE);
        float widthScale = (float)this.getAttributeValue((Holder)AttributesRegistry.WIDTH_SCALE);
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            float height = this.getBbHeight() * scale * heightScale;
            float width = this.getBbWidth() * scale * widthScale;
            if (this.getBbHeight() >= this.getBbWidth() * 3.0f) {
                width *= 2.0f;
            }
            float scaleFactor = height * width * 1.2f;
            int numParticles = (int)(scaleFactor * 15.0f);
            for (int i = 0; i < numParticles; ++i) {
                ServerParticleUtils.spawnEntityBreakParticles((ParticleOptions)this.getShatterParticle(), serverWorld, entity, height * 1.55f + 0.1f, width * 1.55f);
            }
        }
    }
}

