/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities.ai.goals;

import com.wenxin2.marioverse.entities.GoombaEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;

public class GoombaSleepGoal
extends Goal {
    private final GoombaEntity goomba;
    private final float chanceToSleep;
    private final int ticksBeforeSleepingAgain;
    private int ticksSleeping;
    private int cooldown;
    private int sleepingTime;

    public GoombaSleepGoal(GoombaEntity goomba, float chanceToSleep, int ticksSleeping, int ticksBeforeSleepingAgain) {
        this.goomba = goomba;
        this.ticksBeforeSleepingAgain = ticksBeforeSleepingAgain;
        this.ticksSleeping = ticksSleeping;
        this.chanceToSleep = chanceToSleep;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.cooldown > 0 && !this.goomba.isSleeping()) {
            --this.cooldown;
        }
        if (this.cooldown == 0 && !this.goomba.isInWater() && !this.goomba.isSleeping()) {
            if ((float)this.goomba.getRandom().nextInt() < this.chanceToSleep) {
                this.cooldown = this.ticksBeforeSleepingAgain;
                return true;
            }
            this.cooldown = this.ticksBeforeSleepingAgain / 2;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return !this.goomba.isInWater() && this.ticksSleeping > 0;
    }

    public void start() {
        this.goomba.tryToSleep();
    }

    public void stop() {
        this.cooldown = this.ticksBeforeSleepingAgain;
        this.goomba.sleep(false);
    }

    public void tick() {
        if (this.cooldown > 0) {
            this.goomba.getNavigation().stop();
            this.goomba.setXxa(0.0f);
            this.goomba.setSpeed(0.0f);
        }
        if (!this.goomba.isSleeping()) {
            this.goomba.tryToSleep();
        } else {
            this.goomba.checkForCollisionsAndWakeUp();
        }
        if (this.sleepingTime >= this.ticksSleeping) {
            this.stop();
        } else {
            ++this.sleepingTime;
        }
    }
}

