/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities.ai.goals;

import com.wenxin2.marioverse.entities.KoopaShellEntity;
import com.wenxin2.marioverse.items.KoopaShellItem;
import com.wenxin2.marioverse.registries.TagRegistry;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class PickupAndThrowShellGoal
extends Goal {
    private ItemStack heldShell = ItemStack.EMPTY;
    private LivingEntity target;
    private final Mob mob;
    private int aimingTicks = 0;
    private int cooldown;

    public PickupAndThrowShellGoal(Mob mob) {
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        if (this.mob.getMainHandItem().getItem() instanceof KoopaShellItem || this.mob.getOffhandItem().getItem() instanceof KoopaShellItem || !this.heldShell.isEmpty()) {
            this.target = this.mob.getTarget();
            return true;
        }
        return this.findNearbyShell() != null;
    }

    public void tick() {
        boolean hasShellInMemory;
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        boolean hasShellInMainHand = this.mob.getMainHandItem().getItem() instanceof KoopaShellItem;
        boolean hasShellInOffHand = this.mob.getOffhandItem().getItem() instanceof KoopaShellItem;
        boolean bl = hasShellInMemory = !this.heldShell.isEmpty();
        if (hasShellInMainHand || hasShellInOffHand || hasShellInMemory) {
            if (this.target != null) {
                this.mob.getLookControl().setLookAt(this.target.getX(), this.target.getEyeY(), this.target.getZ());
            }
            this.mob.yRotO = this.mob.getYHeadRot();
            this.mob.setYRot(Mth.wrapDegrees((float)this.mob.getYHeadRot()));
            if (this.aimingTicks < 10) {
                ++this.aimingTicks;
                return;
            }
            if (!(this.mob instanceof Monster) && !(this.mob instanceof AbstractGolem)) {
                this.throwShellAt(hasShellInMainHand ? this.mob.getMainHandItem() : this.heldShell);
                this.throwShellAt(hasShellInOffHand ? this.mob.getOffhandItem() : this.heldShell);
                this.cooldown = 100;
            } else if (this.target != null && this.mob.distanceToSqr((Entity)this.target) < 256.0 && this.mob.getSensing().hasLineOfSight((Entity)this.target) && this.mob.getLookControl().isLookingAtTarget()) {
                this.throwShellAt(hasShellInMainHand ? this.mob.getMainHandItem() : this.heldShell);
                this.throwShellAt(hasShellInOffHand ? this.mob.getOffhandItem() : this.heldShell);
                this.cooldown = 100;
                this.aimingTicks = 0;
            }
        } else {
            this.aimingTicks = 0;
            Entity shell = this.findNearbyShell();
            if (shell != null) {
                this.mob.getNavigation().moveTo(shell, 1.0);
                if (this.mob.distanceToSqr(shell) < (double)this.mob.getBbWidth() + 2.5) {
                    this.pickUpShell(shell);
                }
            }
        }
    }

    private Entity findNearbyShell() {
        Level level = this.mob.level();
        AABB searchBox = this.mob.getBoundingBox().inflate(8.0);
        Optional<KoopaShellEntity> entityShell = level.getEntitiesOfClass(KoopaShellEntity.class, searchBox).stream().filter(e -> e.getDeltaMovement().lengthSqr() < 0.1 && e.isAlive()).min(Comparator.comparingDouble(arg_0 -> ((Mob)this.mob).distanceToSqr(arg_0)));
        if (entityShell.isPresent()) {
            return (Entity)entityShell.get();
        }
        Optional<ItemEntity> itemShell = level.getEntitiesOfClass(ItemEntity.class, searchBox).stream().filter(e -> e.getItem().getItem() instanceof KoopaShellItem).min(Comparator.comparingDouble(arg_0 -> ((Mob)this.mob).distanceToSqr(arg_0)));
        return itemShell.orElse(null);
    }

    private void pickUpShell(Entity entity) {
        KoopaShellEntity shell;
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            if (this.hasMainHandSlot((LivingEntity)this.mob) && this.mob.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                this.mob.setItemInHand(InteractionHand.MAIN_HAND, itemEntity.getItem());
            } else if (this.hasOffHandSlot((LivingEntity)this.mob) && this.mob.getItemInHand(InteractionHand.OFF_HAND).isEmpty()) {
                this.mob.setItemInHand(InteractionHand.OFF_HAND, itemEntity.getItem());
            }
            this.heldShell = itemEntity.getItem().copy();
            this.mob.swing(this.mob.getUsedItemHand());
            this.mob.level().playSound((Entity)this.mob, this.mob.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.NEUTRAL, 1.0f, 1.0f);
            itemEntity.discard();
        } else if (entity instanceof KoopaShellEntity && (shell = (KoopaShellEntity)entity).getPickResult() != null) {
            ItemStack shellItem = new ItemStack((ItemLike)shell.getPickResult().getItem());
            if (this.hasMainHandSlot((LivingEntity)this.mob) && this.mob.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                this.mob.setItemInHand(InteractionHand.MAIN_HAND, shellItem);
            } else if (this.hasOffHandSlot((LivingEntity)this.mob) && this.mob.getItemInHand(InteractionHand.OFF_HAND).isEmpty()) {
                this.mob.setItemInHand(InteractionHand.OFF_HAND, shellItem);
            }
            this.heldShell = shellItem;
            this.mob.swing(this.mob.getUsedItemHand());
            this.mob.level().playSound((Entity)this.mob, this.mob.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.NEUTRAL, 1.0f, 1.0f);
            shell.discard();
        }
    }

    private void throwShellAt(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof KoopaShellItem)) {
            return;
        }
        KoopaShellItem shellItem = (KoopaShellItem)item;
        EntityType type = this.heldShell.isEmpty() ? shellItem.getType(stack) : shellItem.getType(this.heldShell);
        Entity entity = type.create(this.mob.level());
        if (entity instanceof KoopaShellEntity) {
            KoopaShellEntity shell = (KoopaShellEntity)entity;
            shellItem.throwShell(this.mob.level(), (LivingEntity)this.mob, shell, stack);
            this.mob.yRotO = this.mob.getYRot();
            this.mob.setYRot(Mth.wrapDegrees((float)this.mob.getYRot()));
            this.mob.swing(this.mob.getUsedItemHand());
            if (!this.mob.getType().is(TagRegistry.HAS_INFINITE_SHELL_AMMO)) {
                this.heldShell = ItemStack.EMPTY;
            }
            this.cooldown = 100;
        }
    }

    private boolean hasMainHandSlot(LivingEntity entity) {
        try {
            entity.getItemBySlot(EquipmentSlot.MAINHAND);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private boolean hasOffHandSlot(LivingEntity entity) {
        try {
            entity.getItemBySlot(EquipmentSlot.OFFHAND);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

