/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities.ai.goals;

import com.wenxin2.marioverse.entities.projectiles.BouncingIceBallProjectile;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.EntityRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ShootBouncingIceBallGoal
extends Goal {
    private final LivingEntity livingEntity;
    private final int maxIceBalls;
    private final int addIceBallsWithIceFlower;
    private final boolean requireIceFlower;
    private static final int ICE_BALL_COOLDOWN = 5;

    public ShootBouncingIceBallGoal(LivingEntity entity, int maxIceBalls, int addIceBallsWithIceFlower, boolean requireIceFlower) {
        this.livingEntity = entity;
        this.maxIceBalls = maxIceBalls;
        this.addIceBallsWithIceFlower = addIceBallsWithIceFlower;
        this.requireIceFlower = requireIceFlower;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public void start() {
        super.start();
        LivingEntity livingEntity = this.livingEntity;
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            mob.setAggressive(true);
        }
    }

    public void stop() {
        super.stop();
        LivingEntity livingEntity = this.livingEntity;
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            mob.setAggressive(false);
        }
    }

    public boolean canUse() {
        AbilitiesHandler handler;
        LivingEntity livingEntity;
        boolean canShoot = !this.requireIceFlower || (livingEntity = this.livingEntity) instanceof AbilitiesHandler && (handler = (AbilitiesHandler)livingEntity).mv$hasIceFlower();
        return this.livingEntity.getDeltaMovement().horizontalDistance() > 0.0 && canShoot;
    }

    public void tick() {
        Mob mob;
        LivingEntity target;
        AbilitiesHandler handler;
        LivingEntity golem;
        Monster monster;
        LivingEntity livingEntity;
        if (this.canUse() && ((livingEntity = this.livingEntity) instanceof Monster && (monster = (Monster)livingEntity).getTarget() != null && monster.getSensing().hasLineOfSight((Entity)monster.getTarget()) || (livingEntity = this.livingEntity) instanceof AbstractGolem && (golem = (AbstractGolem)livingEntity).getTarget() != null && golem.getSensing().hasLineOfSight((Entity)golem.getTarget()) || !(this.livingEntity instanceof Monster) && !(this.livingEntity instanceof AbstractGolem))) {
            this.handleIceBallShooting();
        }
        if ((golem = this.livingEntity) instanceof AbilitiesHandler && (handler = (AbilitiesHandler)golem).mv$getIceBallCooldown() > 0) {
            handler.mv$setIceBallCooldown(handler.mv$getIceBallCooldown() - 1);
        }
        if ((golem = this.livingEntity) instanceof Mob && (target = (mob = (Mob)golem).getTarget()) != null) {
            mob.getNavigation().moveTo((Entity)target, 1.2);
            if (mob.getControlledVehicle() instanceof Mob) {
                mob.getLookControl().setLookAt(target.getX(), target.getEyeY(), target.getZ());
            }
            mob.getLookControl().setLookAt(target.getX(), target.getEyeY(), target.getZ());
        }
        super.tick();
    }

    public void handleIceBallShooting() {
        LivingEntity livingEntity = this.livingEntity;
        if (livingEntity instanceof AbilitiesHandler) {
            AbilitiesHandler handler = (AbilitiesHandler)livingEntity;
            if (!this.requireIceFlower && handler.mv$getIceBallCooldown() == 0 && handler.mv$getIceBallCount() < this.maxIceBalls + this.addIceBallsWithIceFlower) {
                this.shootIceBall();
                handler.mv$setIceBallCooldown(5);
                handler.mv$setIceBallCount(handler.mv$getIceBallCooldown() + 1);
            } else if (handler.mv$getIceBallCooldown() == 0 && handler.mv$getIceBallCount() < this.maxIceBalls + this.addIceBallsWithIceFlower && handler.mv$hasIceFlower()) {
                this.shootIceBall();
                handler.mv$setIceBallCooldown(5);
                handler.mv$setIceBallCount(handler.mv$getIceBallCooldown() + 1);
            } else if (!this.requireIceFlower && handler.mv$getIceBallCount() >= this.maxIceBalls + this.addIceBallsWithIceFlower) {
                handler.mv$setIceBallCooldown((Integer)ConfigRegistry.ICE_BALL_COOLDOWN.get());
                handler.mv$setIceBallCount(0);
            } else if (handler.mv$getIceBallCount() >= this.maxIceBalls) {
                handler.mv$setIceBallCooldown((Integer)ConfigRegistry.ICE_BALL_COOLDOWN.get());
                handler.mv$setIceBallCount(0);
            }
        }
    }

    public void shootIceBall() {
        Level world = this.livingEntity.level();
        BouncingIceBallProjectile iceBall = new BouncingIceBallProjectile((EntityType<? extends BouncingIceBallProjectile>)((EntityType)EntityRegistry.BOUNCING_ICE_BALL.get()), world);
        iceBall.setOwner((Entity)this.livingEntity);
        iceBall.setPos(this.livingEntity.getX(), this.livingEntity.getEyeY() - 0.5, this.livingEntity.getZ());
        iceBall.shootFromRotation((Entity)this.livingEntity, this.livingEntity.getXRot(), this.livingEntity.getYRot(), 0.0f, 1.2f, 1.0f);
        world.playSound(null, this.livingEntity.blockPosition(), (SoundEvent)SoundRegistry.ICE_BALL_THROWN.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        Vec3 look = this.livingEntity.getLookAngle();
        iceBall.setDeltaMovement(look.scale(0.5));
        iceBall.setYRot((float)Math.toDegrees(Math.atan2(look.z, look.x)) + 90.0f);
        iceBall.setXRot((float)Math.toDegrees(Math.atan2(look.y, Math.sqrt(look.x * look.x + look.z * look.z))));
        world.addFreshEntity((Entity)iceBall);
        this.livingEntity.swing(InteractionHand.MAIN_HAND);
    }
}

