/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.network.server_bound.handler;

import com.wenxin2.marioverse.entities.projectiles.BouncingFireballProjectile;
import com.wenxin2.marioverse.network.client_bound.data.SwingHandPayload;
import com.wenxin2.marioverse.network.server_bound.data.FireballShootPayload;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.EntityRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class FireballShootPacket {
    public static final FireballShootPacket INSTANCE = new FireballShootPacket();
    private static final int FIREBALL_COOLDOWN = 5;

    public static FireballShootPacket get() {
        return INSTANCE;
    }

    public void handle(FireballShootPayload payload, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> {
                AbilitiesHandler handler;
                Player player = context.player();
                if (player instanceof AbilitiesHandler && (handler = (AbilitiesHandler)player).mv$hasFireFlower()) {
                    this.handleFireballShooting(player);
                }
            });
        }
    }

    public void handleFireballShooting(Player player) {
        if (player instanceof AbilitiesHandler) {
            AbilitiesHandler handler = (AbilitiesHandler)player;
            if (handler.mv$getFireballCooldown() == 0 && handler.mv$getFireballCount() < (Integer)ConfigRegistry.MAX_PLAYER_FIREBALLS.get()) {
                FireballShootPacket.shootFireball(player);
                handler.mv$setFireballCooldown(5);
                handler.mv$setFireballCount(handler.mv$getFireballCount() + 1);
            } else if (handler.mv$getFireballCount() >= (Integer)ConfigRegistry.MAX_PLAYER_FIREBALLS.get()) {
                handler.mv$setFireballCooldown((Integer)ConfigRegistry.FIREBALL_COOLDOWN.get());
                handler.mv$setFireballCount(0);
            }
        }
    }

    public static void shootFireball(Player player) {
        Level world = player.level();
        SoundSource soundSource = SoundSource.PLAYERS;
        BouncingFireballProjectile fireball = new BouncingFireballProjectile((EntityType<? extends BouncingFireballProjectile>)((EntityType)EntityRegistry.BOUNCING_FIREBALL.get()), world);
        fireball.setOwner((Entity)player);
        fireball.setPos(player.getX(), player.getEyeY() - 0.5, player.getZ());
        fireball.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.2f, 1.0f);
        world.playSound(null, player.blockPosition(), (SoundEvent)SoundRegistry.FIREBALL_THROWN.get(), soundSource, 1.0f, 1.0f);
        Vec3 look = player.getLookAngle();
        fireball.setDeltaMovement(look.scale(0.5));
        fireball.setYRot((float)Math.toDegrees(Math.atan2(look.z, look.x)) + 90.0f);
        fireball.setXRot((float)Math.toDegrees(Math.atan2(look.y, Math.sqrt(look.x * look.x + look.z * look.z))));
        world.addFreshEntity((Entity)fireball);
        world.gameEvent((Entity)player, (Holder)GameEvent.PROJECTILE_SHOOT, player.position());
        if (!world.isClientSide() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SwingHandPayload(Boolean.TRUE), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

