/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.sounds;

import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FadingSoundInstance
extends AbstractTickableSoundInstance {
    private final LivingEntity entity;
    private final float fadeDuration;
    private float remainingTicks;

    public FadingSoundInstance(LivingEntity entity, SoundEvent soundEvent, SoundSource soundSource, RandomSource random, float totalDuration, float fadeDuration) {
        super(soundEvent, soundSource, random);
        this.entity = entity;
        this.fadeDuration = fadeDuration;
        this.remainingTicks = totalDuration;
        this.looping = true;
        this.delay = 0;
        this.volume = 1.0f;
    }

    public void tick() {
        this.volume = this.remainingTicks < this.fadeDuration ? Math.max(0.0f, this.remainingTicks / this.fadeDuration) : 1.0f;
        this.remainingTicks -= 1.0f;
        if (this.remainingTicks <= 0.0f) {
            this.stop();
        }
        this.x = this.entity.getX();
        this.y = this.entity.getY();
        this.z = this.entity.getZ();
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }
}

