/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.sounds;

import com.wenxin2.marioverse.blocks.PipeBubblesBlock;
import com.wenxin2.marioverse.registries.BlockRegistry;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AmbientSoundHandler;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PipeBubblesSoundHandler
implements AmbientSoundHandler {
    private final LocalPlayer player;
    private boolean wasInBubbleColumn;
    private boolean firstTick = true;

    public PipeBubblesSoundHandler(LocalPlayer player) {
        this.player = player;
    }

    public void tick() {
        Level world = this.player.level();
        BlockState stateLoaded = world.getBlockStatesIfLoaded(this.player.getBoundingBox().inflate(0.0, (double)-0.4f, 0.0).deflate(1.0E-6)).filter(state -> state.is((Block)BlockRegistry.PIPE_BUBBLES.get())).findFirst().orElse(null);
        if (stateLoaded != null) {
            if (!(this.wasInBubbleColumn || this.firstTick || this.player.isSpectator() || !stateLoaded.is((Block)BlockRegistry.PIPE_BUBBLES.get()) && !stateLoaded.is((Block)BlockRegistry.WATER_SPOUT.get()))) {
                boolean flag = (Boolean)stateLoaded.getValue((Property)PipeBubblesBlock.DRAG_DOWN);
                if (flag) {
                    this.player.playSound(SoundEvents.BUBBLE_COLUMN_WHIRLPOOL_INSIDE, 1.0f, 1.0f);
                } else {
                    this.player.playSound(SoundEvents.BUBBLE_COLUMN_UPWARDS_INSIDE, 1.0f, 1.0f);
                }
            }
            this.wasInBubbleColumn = true;
        } else {
            this.wasInBubbleColumn = false;
        }
        this.firstTick = false;
    }

    public static void init() {
    }
}

