/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.utils;

import com.wenxin2.marioverse.entities.WarpLinkableEntity;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public interface EntityWarpEntityHandler {
    public boolean mv$getEntityWarpTeleportConfig();

    public boolean mv$doPreventWarp();

    public void mv$setPreventWarp(boolean var1);

    public int mv$getPreventWarpCooldown();

    public void mv$setPreventWarpCooldown(int var1);

    public int mv$getWarpCooldown();

    public void mv$setWarpCooldown(int var1);

    default public void enterWarp(Entity entity, Level world) {
        block1: {
            WarpLinkableEntity linkableEntity;
            Painting painting;
            List nearbyPaintings = world.getEntitiesOfClass(Painting.class, entity.getBoundingBox());
            Iterator iterator = nearbyPaintings.iterator();
            if (!iterator.hasNext() || !((painting = (Painting)iterator.next()) instanceof WarpLinkableEntity) || (linkableEntity = (WarpLinkableEntity)painting).mv$getPreventWarp()) break block1;
            int entityId = entity.getId();
            if (WarpLinkableEntity.WARPED_ENTITIES.getOrDefault(entityId, false).booleanValue()) {
                WarpLinkableEntity.WARPED_ENTITIES.put(entityId, false);
            }
            this.enterWarpPainting(entity, world, linkableEntity, (Entity)painting);
        }
    }

    default public void enterWarpPainting(Entity entity, Level world, WarpLinkableEntity warpLinkableEntity, Entity warpEntity) {
        if (!this.mv$doPreventWarp() && this.mv$getEntityWarpTeleportConfig() && !entity.getType().is(TagRegistry.CANNOT_WARP)) {
            if (this.mv$getWarpCooldown() == 0 && !entity.isShiftKeyDown()) {
                this.warp(entity, world, warpLinkableEntity);
            } else if (entity instanceof Player) {
                Player player = (Player)entity;
                if (warpLinkableEntity.mv$hasDestinationPos()) {
                    this.displayCooldownMessage(player, warpEntity);
                }
            }
        }
    }

    default public void warp(Entity entity, Level world, WarpLinkableEntity warpLinkableEntity) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (warpLinkableEntity.mv$getWarpUUID() != null) {
                UUID warpUUID = warpLinkableEntity.mv$getWarpUUID();
                Entity warpEntity = serverWorld.getEntity(warpLinkableEntity.mv$getWarpUUID());
                if (warpEntity != null) {
                    if (warpEntity instanceof Painting) {
                        WarpLinkableEntity warpPainting;
                        Painting painting = (Painting)warpEntity;
                        int width = ((PaintingVariant)painting.getVariant().value()).width();
                        Direction direction = painting.getDirection();
                        BlockPos basePos = painting.getPos();
                        this.warpPaintingDirection(basePos, direction, width, entity, warpEntity, world);
                        if (painting instanceof WarpLinkableEntity && (warpPainting = (WarpLinkableEntity)painting).mv$isBreakPainting()) {
                            painting.kill();
                        }
                        entity.setXRot(direction.toYRot());
                        entity.setYRot(direction.toYRot());
                        entity.setYHeadRot(direction.toYRot());
                    } else {
                        BlockPos warpPos = warpEntity.blockPosition();
                        WarpLinkableEntity.warp(entity, warpPos.getX(), warpPos.getY(), warpPos.getZ(), world);
                    }
                } else {
                    WarpLinkableEntity.WarpTarget savedTarget = WarpLinkableEntity.getWarpPos(warpUUID);
                    if (savedTarget != null) {
                        BlockPos basePos = savedTarget.pos();
                        Direction direction = savedTarget.direction();
                        int width = savedTarget.width();
                        this.warpPaintingDirection(basePos, direction, width, entity, warpEntity, world);
                        entity.setXRot(direction.toYRot());
                        entity.setYRot(direction.toYRot());
                        entity.setYHeadRot(direction.toYRot());
                        List entitiesAtPos = world.getEntities(null, new AABB(basePos));
                        for (Entity targetEntity : entitiesAtPos) {
                            WarpLinkableEntity linkableEntity;
                            if (!targetEntity.getUUID().equals(warpUUID) || !(targetEntity instanceof WarpLinkableEntity) || !(linkableEntity = (WarpLinkableEntity)targetEntity).mv$isBreakPainting()) continue;
                            targetEntity.kill();
                            break;
                        }
                    }
                }
            }
        }
    }

    private void warpPaintingDirection(BlockPos basePos, Direction direction, double width, Entity entity, Entity warpEntity, Level world) {
        double centerX = basePos.getX();
        double centerY = basePos.getY();
        double centerZ = basePos.getZ();
        switch (direction) {
            case NORTH: {
                centerZ += 0.5;
                break;
            }
            case SOUTH: {
                centerX += width / 2.0;
                centerZ += 0.5;
                break;
            }
            case EAST: {
                centerX += 0.5;
                break;
            }
            case WEST: {
                centerZ += width / 2.0;
                centerX += 0.5;
            }
        }
        WarpLinkableEntity.warp(entity, centerX, centerY, centerZ, world);
    }

    private void displayCooldownMessage(Player player, Entity warpEntity) {
        if (this.mv$getWarpCooldown() >= 10 && warpEntity instanceof Painting && ((Boolean)ConfigRegistry.WARP_COOLDOWN_MESSAGE.get()).booleanValue()) {
            if (((Boolean)ConfigRegistry.WARP_COOLDOWN_MESSAGE_TICKS.get()).booleanValue()) {
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.warp_painting_cooldown.ticks", (Object[])new Object[]{this.mv$getWarpCooldown()}), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.warp_painting_cooldown"), true);
            }
        }
    }

    default public void displayEntityDestinationMissingMessage(Player player) {
        player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.warp_destination_missing"), true);
    }
}

