/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.utils;

import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeUtils {
    public static VoxelShape rotateShape(VoxelShape shape, Direction facing) {
        switch (facing) {
            case NORTH: {
                return VoxelShapeUtils.rotateShapeAxis(shape, Direction.Axis.Y, 270);
            }
            case SOUTH: {
                return VoxelShapeUtils.rotateShapeAxis(shape, Direction.Axis.Y, 90);
            }
            case EAST: {
                return VoxelShapeUtils.rotateShapeAxis(shape, Direction.Axis.Y, 0);
            }
            case WEST: {
                return VoxelShapeUtils.rotateShapeAxis(shape, Direction.Axis.Y, 180);
            }
        }
        return shape;
    }

    public static VoxelShape rotateShape(VoxelShape shape, Direction fromDirection, Direction toDirection) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        int times = (toDirection.get2DDataValue() - fromDirection.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.create((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }

    public static VoxelShape rotateShapeAxis(VoxelShape shape, Direction.Axis axis, int degrees) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        int times = degrees / 90 % 4;
        if (times < 0) {
            times += 4;
        }
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                if (axis == Direction.Axis.X) {
                    buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.create((double)minX, (double)(1.0 - maxY), (double)minZ, (double)maxX, (double)(1.0 - minY), (double)maxZ));
                } else if (axis == Direction.Axis.Y) {
                    buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.create((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
                } else if (axis == Direction.Axis.Z) {
                    buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.create((double)minY, (double)(1.0 - maxX), (double)minZ, (double)maxY, (double)(1.0 - minX), (double)maxZ));
                }
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }
}

