/*
 * Decompiled with CFR 0.152.
 */
package net.thestarsolver.mdabsoluteexecution.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.thestarsolver.mdabsoluteexecution.MdabsoluteexecutionMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MdabsoluteexecutionModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MdabsoluteexecutionMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.IsDrone = message.data.IsDrone;
                    variables.IsHuman = message.data.IsHuman;
                    variables.IsSolverInfected = message.data.IsSolverInfected;
                    variables.InfectTries = message.data.InfectTries;
                    variables.OSUpdateTimer = message.data.OSUpdateTimer;
                    variables.CBPTimer = message.data.CBPTimer;
                    variables.SolverPower1Cooldown = message.data.SolverPower1Cooldown;
                    variables.CanFly = message.data.CanFly;
                    variables.AbsoluteSolverPoints = message.data.AbsoluteSolverPoints;
                    variables.AbsoluteSolverLevel = message.data.AbsoluteSolverLevel;
                    variables.SolverPower2Cooldown = message.data.SolverPower2Cooldown;
                    variables.PlayerAlreadyChoseRole = message.data.PlayerAlreadyChoseRole;
                    variables.basicdroneuiupdatertime = message.data.basicdroneuiupdatertime;
                    variables.PlayerHealth = message.data.PlayerHealth;
                    variables.health100percentintegrity = message.data.health100percentintegrity;
                    variables.health75integrity = message.data.health75integrity;
                    variables.health50integrity = message.data.health50integrity;
                    variables.health25integrity = message.data.health25integrity;
                    variables.health10integrity = message.data.health10integrity;
                    variables.DeadDrone = message.data.DeadDrone;
                    variables.JCOSFIREWALLHEALTH = message.data.JCOSFIREWALLHEALTH;
                    variables.fwhholder1 = message.data.fwhholder1;
                    variables.fwhholder2 = message.data.fwhholder2;
                    variables.hasitemlockedindconverter = message.data.hasitemlockedindconverter;
                    variables.alreadyreceivednotavailablecpbmessage = message.data.alreadyreceivednotavailablecpbmessage;
                    variables.power3holding = message.data.power3holding;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean IsDrone = false;
        public boolean IsHuman = false;
        public boolean IsSolverInfected = false;
        public double InfectTries = 0.0;
        public double OSUpdateTimer = 0.0;
        public double CBPTimer = 0.0;
        public double SolverPower1Cooldown = 0.0;
        public boolean CanFly = false;
        public double AbsoluteSolverPoints = 0.0;
        public double AbsoluteSolverLevel = 0.0;
        public double SolverPower2Cooldown = 0.0;
        public boolean PlayerAlreadyChoseRole = false;
        public double basicdroneuiupdatertime = 0.0;
        public double PlayerHealth = 20.0;
        public boolean health100percentintegrity = true;
        public boolean health75integrity = false;
        public boolean health50integrity = false;
        public boolean health25integrity = false;
        public boolean health10integrity = false;
        public boolean DeadDrone = false;
        public double JCOSFIREWALLHEALTH = 100.0;
        public boolean fwhholder1 = false;
        public boolean fwhholder2 = false;
        public boolean hasitemlockedindconverter = false;
        public boolean alreadyreceivednotavailablecpbmessage = false;
        public boolean power3holding = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                MdabsoluteexecutionMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("IsDrone", this.IsDrone);
            nbt.m_128379_("IsHuman", this.IsHuman);
            nbt.m_128379_("IsSolverInfected", this.IsSolverInfected);
            nbt.m_128347_("InfectTries", this.InfectTries);
            nbt.m_128347_("OSUpdateTimer", this.OSUpdateTimer);
            nbt.m_128347_("CBPTimer", this.CBPTimer);
            nbt.m_128347_("SolverPower1Cooldown", this.SolverPower1Cooldown);
            nbt.m_128379_("CanFly", this.CanFly);
            nbt.m_128347_("AbsoluteSolverPoints", this.AbsoluteSolverPoints);
            nbt.m_128347_("AbsoluteSolverLevel", this.AbsoluteSolverLevel);
            nbt.m_128347_("SolverPower2Cooldown", this.SolverPower2Cooldown);
            nbt.m_128379_("PlayerAlreadyChoseRole", this.PlayerAlreadyChoseRole);
            nbt.m_128347_("basicdroneuiupdatertime", this.basicdroneuiupdatertime);
            nbt.m_128347_("PlayerHealth", this.PlayerHealth);
            nbt.m_128379_("health100percentintegrity", this.health100percentintegrity);
            nbt.m_128379_("health75integrity", this.health75integrity);
            nbt.m_128379_("health50integrity", this.health50integrity);
            nbt.m_128379_("health25integrity", this.health25integrity);
            nbt.m_128379_("health10integrity", this.health10integrity);
            nbt.m_128379_("DeadDrone", this.DeadDrone);
            nbt.m_128347_("JCOSFIREWALLHEALTH", this.JCOSFIREWALLHEALTH);
            nbt.m_128379_("fwhholder1", this.fwhholder1);
            nbt.m_128379_("fwhholder2", this.fwhholder2);
            nbt.m_128379_("hasitemlockedindconverter", this.hasitemlockedindconverter);
            nbt.m_128379_("alreadyreceivednotavailablecpbmessage", this.alreadyreceivednotavailablecpbmessage);
            nbt.m_128379_("power3holding", this.power3holding);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.IsDrone = nbt.m_128471_("IsDrone");
            this.IsHuman = nbt.m_128471_("IsHuman");
            this.IsSolverInfected = nbt.m_128471_("IsSolverInfected");
            this.InfectTries = nbt.m_128459_("InfectTries");
            this.OSUpdateTimer = nbt.m_128459_("OSUpdateTimer");
            this.CBPTimer = nbt.m_128459_("CBPTimer");
            this.SolverPower1Cooldown = nbt.m_128459_("SolverPower1Cooldown");
            this.CanFly = nbt.m_128471_("CanFly");
            this.AbsoluteSolverPoints = nbt.m_128459_("AbsoluteSolverPoints");
            this.AbsoluteSolverLevel = nbt.m_128459_("AbsoluteSolverLevel");
            this.SolverPower2Cooldown = nbt.m_128459_("SolverPower2Cooldown");
            this.PlayerAlreadyChoseRole = nbt.m_128471_("PlayerAlreadyChoseRole");
            this.basicdroneuiupdatertime = nbt.m_128459_("basicdroneuiupdatertime");
            this.PlayerHealth = nbt.m_128459_("PlayerHealth");
            this.health100percentintegrity = nbt.m_128471_("health100percentintegrity");
            this.health75integrity = nbt.m_128471_("health75integrity");
            this.health50integrity = nbt.m_128471_("health50integrity");
            this.health25integrity = nbt.m_128471_("health25integrity");
            this.health10integrity = nbt.m_128471_("health10integrity");
            this.DeadDrone = nbt.m_128471_("DeadDrone");
            this.JCOSFIREWALLHEALTH = nbt.m_128459_("JCOSFIREWALLHEALTH");
            this.fwhholder1 = nbt.m_128471_("fwhholder1");
            this.fwhholder2 = nbt.m_128471_("fwhholder2");
            this.hasitemlockedindconverter = nbt.m_128471_("hasitemlockedindconverter");
            this.alreadyreceivednotavailablecpbmessage = nbt.m_128471_("alreadyreceivednotavailablecpbmessage");
            this.power3holding = nbt.m_128471_("power3holding");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("mdabsoluteexecution", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.IsDrone = original.IsDrone;
            clone.IsHuman = original.IsHuman;
            clone.IsSolverInfected = original.IsSolverInfected;
            clone.CanFly = original.CanFly;
            clone.AbsoluteSolverPoints = original.AbsoluteSolverPoints;
            clone.AbsoluteSolverLevel = original.AbsoluteSolverLevel;
            clone.PlayerAlreadyChoseRole = original.PlayerAlreadyChoseRole;
            clone.basicdroneuiupdatertime = original.basicdroneuiupdatertime;
            clone.JCOSFIREWALLHEALTH = original.JCOSFIREWALLHEALTH;
            clone.fwhholder1 = original.fwhholder1;
            clone.fwhholder2 = original.fwhholder2;
            clone.alreadyreceivednotavailablecpbmessage = original.alreadyreceivednotavailablecpbmessage;
            if (!event.isWasDeath()) {
                clone.InfectTries = original.InfectTries;
                clone.OSUpdateTimer = original.OSUpdateTimer;
                clone.CBPTimer = original.CBPTimer;
                clone.SolverPower1Cooldown = original.SolverPower1Cooldown;
                clone.SolverPower2Cooldown = original.SolverPower2Cooldown;
                clone.PlayerHealth = original.PlayerHealth;
                clone.health100percentintegrity = original.health100percentintegrity;
                clone.health75integrity = original.health75integrity;
                clone.health50integrity = original.health50integrity;
                clone.health25integrity = original.health25integrity;
                clone.health10integrity = original.health10integrity;
                clone.DeadDrone = original.DeadDrone;
                clone.hasitemlockedindconverter = original.hasitemlockedindconverter;
                clone.power3holding = original.power3holding;
            }
        }
    }
}

