/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.handle;

import com.github.theword.queqiao.QueQiao;
import com.github.theword.queqiao.tool.handle.HandleApiService;
import com.github.theword.queqiao.tool.payload.MessageSegment;
import com.github.theword.queqiao.tool.payload.TitlePayload;
import com.github.theword.queqiao.tool.response.PrivateMessageResponse;
import com.github.theword.queqiao.tool.utils.Tool;
import com.github.theword.queqiao.utils.ParseJsonToEventImpl;
import com.github.theword.queqiao.utils.SpigotTool;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

public class HandleApiImpl
implements HandleApiService {
    private final ParseJsonToEventImpl parseJsonToEventImpl = new ParseJsonToEventImpl();

    @Override
    public void handleBroadcastMessage(List<MessageSegment> messageList) {
        TextComponent textComponent = this.parseJsonToEventImpl.parsePerMessageToComponent(Tool.getPrefixComponent());
        textComponent.addExtra((BaseComponent)this.parseJsonToEventImpl.parseMessageListToComponent(messageList));
        QueQiao.instance.getServer().spigot().broadcast((BaseComponent)textComponent);
    }

    @Override
    public void handleSendTitleMessage(TitlePayload titlePayload) {
        TextComponent title = this.parseJsonToEventImpl.parseMessageListToComponent(titlePayload.getTitle());
        String subtitleText = "";
        if (titlePayload.getSubtitle() != null) {
            subtitleText = this.parseJsonToEventImpl.parseMessageListToComponent(titlePayload.getSubtitle()).toLegacyText();
        }
        for (Player player : QueQiao.instance.getServer().getOnlinePlayers()) {
            player.sendTitle(title.toLegacyText(), subtitleText, titlePayload.getFadein(), titlePayload.getStay(), titlePayload.getFadeout());
        }
    }

    @Override
    public PrivateMessageResponse handleSendPrivateMessage(String nickname, UUID uuid, List<MessageSegment> messageList) {
        Player targetPlayer;
        if (uuid != null) {
            targetPlayer = QueQiao.instance.getServer().getPlayer(uuid);
        } else if (nickname != null && !nickname.isEmpty()) {
            targetPlayer = QueQiao.instance.getServer().getPlayer(nickname);
        } else {
            return PrivateMessageResponse.playerNotFound();
        }
        if (targetPlayer == null) {
            return PrivateMessageResponse.playerIsNull();
        }
        if (!targetPlayer.isOnline()) {
            return PrivateMessageResponse.playerNotOnline();
        }
        TextComponent textComponent = this.parseJsonToEventImpl.parsePerMessageToComponent(Tool.getPrefixComponent());
        textComponent.addExtra((BaseComponent)this.parseJsonToEventImpl.parseMessageListToComponent(messageList));
        targetPlayer.sendMessage(textComponent.toLegacyText());
        return PrivateMessageResponse.sendSuccess(SpigotTool.getSpigotPlayer(targetPlayer));
    }

    @Override
    public void handleSendActionBarMessage(List<MessageSegment> messageList) {
        TextComponent actionTextComponent = this.parseJsonToEventImpl.parseMessageListToComponent(messageList);
        for (Player player : QueQiao.instance.getServer().getOnlinePlayers()) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)actionTextComponent);
        }
    }
}

