/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.tool.deserializer;

import com.github.theword.queqiao.tool.payload.TitlePayload;
import com.github.theword.queqiao.tool.utils.PayloadUtils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;

public class TitlePayloadDeserializer
implements JsonDeserializer<TitlePayload> {
    public TitlePayload deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonElement subtitleElement;
        TitlePayload payload = new TitlePayload();
        JsonObject jsonObject = json.getAsJsonObject();
        JsonElement titleElement = jsonObject.get("title");
        if (titleElement != null) {
            payload.setTitle(PayloadUtils.deserializeMessageSegmentList(titleElement, context));
        }
        if ((subtitleElement = jsonObject.get("subtitle")) != null) {
            payload.setSubtitle(PayloadUtils.deserializeMessageSegmentList(subtitleElement, context));
        }
        if (jsonObject.has("fadein")) {
            payload.setFadein(jsonObject.get("fadein").getAsInt());
        }
        if (jsonObject.has("stay")) {
            payload.setStay(jsonObject.get("stay").getAsInt());
        }
        if (jsonObject.has("fadeout")) {
            payload.setFadeout(jsonObject.get("fadeout").getAsInt());
        }
        return payload;
    }
}

