/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.tool.handle;

import com.github.theword.queqiao.tool.payload.BasePayload;
import com.github.theword.queqiao.tool.payload.MessagePayload;
import com.github.theword.queqiao.tool.payload.PrivateMessagePayload;
import com.github.theword.queqiao.tool.payload.TitlePayload;
import com.github.theword.queqiao.tool.response.PrivateMessageResponse;
import com.github.theword.queqiao.tool.response.Response;
import com.github.theword.queqiao.tool.response.ResponseEnum;
import com.github.theword.queqiao.tool.utils.GsonUtils;
import com.github.theword.queqiao.tool.utils.Tool;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import org.java_websocket.WebSocket;

public class HandleProtocolMessage {
    public Response handleWebSocketJson(WebSocket webSocket, String message) {
        Tool.debugLog("\u6536\u5230\u6765\u81ea {} \u7684 WebSocket \u6d88\u606f\uff1a{}", webSocket.getRemoteSocketAddress(), message);
        Gson gson = GsonUtils.buildGson();
        BasePayload basePayload = (BasePayload)gson.fromJson(message, BasePayload.class);
        JsonElement data = basePayload.getData();
        Response response = new Response(200, ResponseEnum.SUCCESS, "success", "No data", basePayload.getEcho());
        try {
            switch (basePayload.getApi()) {
                case "broadcast": 
                case "send_msg": {
                    MessagePayload messageList = (MessagePayload)gson.fromJson(data, MessagePayload.class);
                    Tool.handleApiService.handleBroadcastMessage(messageList.getMessage());
                    break;
                }
                case "send_title": {
                    TitlePayload titlePayload = (TitlePayload)gson.fromJson(data, TitlePayload.class);
                    Tool.handleApiService.handleSendTitleMessage(titlePayload);
                    break;
                }
                case "send_actionbar": {
                    MessagePayload actionMessagePayload = (MessagePayload)gson.fromJson(data, MessagePayload.class);
                    Tool.handleApiService.handleSendActionBarMessage(actionMessagePayload.getMessage());
                    break;
                }
                case "send_private_msg": {
                    PrivateMessagePayload privateMessagePayload = (PrivateMessagePayload)gson.fromJson(data, PrivateMessagePayload.class);
                    if ((privateMessagePayload.getNickname() == null || privateMessagePayload.getNickname().isEmpty()) && privateMessagePayload.getUuid() == null) {
                        response.setStatus(ResponseEnum.FAILED);
                        response.setData(PrivateMessageResponse.playerIsNull());
                        response.setMessage(PrivateMessageResponse.playerIsNull().getMessage());
                        return response;
                    }
                    PrivateMessageResponse privateMessageResponse = Tool.handleApiService.handleSendPrivateMessage(privateMessagePayload.getNickname(), privateMessagePayload.getUuid(), privateMessagePayload.getMessage());
                    response.setData(privateMessageResponse);
                    break;
                }
                case "send_command": {
                    response.setCode(500);
                    response.setMessage(basePayload.getApi() + "is not supported now");
                    break;
                }
                default: {
                    Tool.logger.warn("\u672a\u77e5\u7684API\uff1a{}", (Object)basePayload.getApi());
                    response.setCode(404);
                    response.setMessage("\u672a\u77e5\u7684API\uff1a" + basePayload.getApi());
                    break;
                }
            }
        }
        catch (Exception e) {
            Tool.logger.warn(String.format("\u89e3\u6790\u6765\u81ea %s \u7684 WebSocket \u6d88\u606f\u65f6\u51fa\u73b0\u5f02\u5e38", webSocket.getRemoteSocketAddress()));
            if (Tool.config.isDebug()) {
                Tool.logger.error("Debug\u6a21\u5f0f\u5f02\u5e38\u8be6\u60c5", e);
            }
            Tool.logger.warn(e.getMessage());
            Tool.logger.warn(e.getCause().getMessage());
        }
        return response;
    }
}

