/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.tool.response;

import com.github.theword.queqiao.tool.event.base.BasePlayer;
import com.google.gson.annotations.SerializedName;

public class PrivateMessageResponse {
    @SerializedName(value="target_player")
    private BasePlayer player;
    private String message;

    public static PrivateMessageResponse of(BasePlayer player, String message) {
        return new PrivateMessageResponse(player, message);
    }

    public static PrivateMessageResponse playerNotFound() {
        return PrivateMessageResponse.of(null, "Target player not found.");
    }

    public static PrivateMessageResponse playerNotOnline() {
        return PrivateMessageResponse.of(null, "Target player is not online.");
    }

    public static PrivateMessageResponse playerIsNull() {
        return PrivateMessageResponse.of(null, "Target player is null.");
    }

    public static PrivateMessageResponse sendSuccess(BasePlayer player) {
        return PrivateMessageResponse.of(player, "Send private message success.");
    }

    public BasePlayer getPlayer() {
        return this.player;
    }

    public String getMessage() {
        return this.message;
    }

    public void setPlayer(BasePlayer player) {
        this.player = player;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrivateMessageResponse)) {
            return false;
        }
        PrivateMessageResponse other = (PrivateMessageResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BasePlayer this$player = this.getPlayer();
        BasePlayer other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !((Object)this$player).equals(other$player)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PrivateMessageResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BasePlayer $player = this.getPlayer();
        result = result * 59 + ($player == null ? 43 : ((Object)$player).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "PrivateMessageResponse(player=" + this.getPlayer() + ", message=" + this.getMessage() + ")";
    }

    public PrivateMessageResponse() {
    }

    public PrivateMessageResponse(BasePlayer player, String message) {
        this.player = player;
        this.message = message;
    }
}

