/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.tool.websocket;

import com.github.theword.queqiao.tool.handle.HandleProtocolMessage;
import com.github.theword.queqiao.tool.response.Response;
import com.github.theword.queqiao.tool.utils.Tool;
import java.net.ConnectException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Timer;
import java.util.TimerTask;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class WsClient
extends WebSocketClient {
    private final Timer timer = new Timer();
    private final HandleProtocolMessage handleProtocolMessage = new HandleProtocolMessage();
    private int reconnectTimes = 1;

    public WsClient(URI uri) {
        super(uri);
        this.addHeader("x-self-name", URLEncoder.encode(Tool.config.getServerName(), StandardCharsets.UTF_8.toString()));
        this.addHeader("x-client-origin", "minecraft");
        if (!Tool.config.getAccessToken().isEmpty()) {
            this.addHeader("Authorization", "Bearer " + Tool.config.getAccessToken());
        }
    }

    @Override
    public void onOpen(ServerHandshake serverHandshake) {
        Tool.logger.info(String.format("\u5df2\u6210\u529f\u8fde\u63a5\u81f3 %s \u7684 WebSocket \u670d\u52a1\u5668\uff01", this.getURI()));
        this.reconnectTimes = 1;
    }

    @Override
    public void onMessage(String message) {
        if (Tool.config.isEnable()) {
            Response response = this.handleProtocolMessage.handleWebSocketJson(this, message);
            this.send(response.getJson());
        }
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        if (remote && this.reconnectTimes <= Tool.config.getWebsocketClient().getReconnectMaxTimes()) {
            this.reconnectWebsocket();
        }
    }

    public void reconnectWebsocket() {
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                WsClient.this.reconnect();
            }
        };
        this.timer.schedule(timerTask, (long)Tool.config.getWebsocketClient().getReconnectInterval() * 1000L);
    }

    public void stopWithoutReconnect(int code, String reason) {
        this.timer.cancel();
        this.close(code, reason);
    }

    @Override
    public void reconnect() {
        Tool.debugLog(String.format("\u8fde\u63a5\u81f3\uff1a%s \u7684 WebSocket \u8fde\u63a5\u5df2\u65ad\u5f00\uff0c\u5c1d\u8bd5\u7b2c %s \u6b21\u91cd\u8fde...", this.getURI(), this.reconnectTimes));
        ++this.reconnectTimes;
        super.reconnect();
        if (this.reconnectTimes == Tool.config.getWebsocketClient().getReconnectMaxTimes() + 1) {
            Tool.logger.info(String.format("\u8fde\u63a5\u81f3\uff1a%s \u7684 \u91cd\u8fde\u6b21\u6570\u8fbe\u5230\u6700\u5927\u503c\uff0c\u5c06\u4e0d\u518d\u81ea\u52a8\u91cd\u8fde\uff0c\u8bf7\u4f7f\u7528\u547d\u4ee4\u624b\u52a8\u91cd\u8fde\uff01", this.getURI()));
        }
    }

    @Override
    public void onError(Exception exception) {
        Tool.logger.warn(String.format("\u8fde\u63a5\u81f3\uff1a%s \u7684 WebSocket \u8fde\u63a5\u51fa\u73b0\u5f02\u5e38\uff1a%s", this.getURI(), exception.getMessage()));
        if (exception instanceof ConnectException && exception.getMessage().equals("Connection refused: connect") && this.reconnectTimes <= Tool.config.getWebsocketClient().getReconnectMaxTimes()) {
            this.reconnectWebsocket();
        }
    }

    @Override
    public void send(String text) {
        if (this.isOpen()) {
            super.send(text);
            Tool.debugLog(String.format("\u53d1\u9001\u81f3 %s \u7684\u6d88\u606f\uff1a%s", this.getURI(), text));
        } else {
            Tool.debugLog("\u8fde\u63a5\u81f3\uff1a%s \u7684 WebSocket \u8fde\u63a5\u672a\u6253\u5f00\uff0c\u53d1\u9001\u6d88\u606f %s \u5931\u8d25", this.getURI(), text);
        }
    }

    public Timer getTimer() {
        return this.timer;
    }
}

