/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.utils;

import com.github.theword.queqiao.tool.handle.ParseJsonToEventService;
import com.github.theword.queqiao.tool.payload.MessageSegment;
import com.github.theword.queqiao.tool.payload.modle.component.CommonBaseComponent;
import com.github.theword.queqiao.tool.payload.modle.component.CommonTextComponent;
import com.github.theword.queqiao.tool.payload.modle.hover.CommonHoverEntity;
import com.github.theword.queqiao.tool.payload.modle.hover.CommonHoverItem;
import com.github.theword.queqiao.tool.utils.Tool;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.ItemTag;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Entity;
import net.md_5.bungee.api.chat.hover.content.Item;
import net.md_5.bungee.api.chat.hover.content.Text;

public class ParseJsonToEventImpl
implements ParseJsonToEventService {
    public TextComponent parsePerMessageToComponent(CommonBaseComponent commonBaseComponent) {
        TextComponent msgComponent = new TextComponent();
        msgComponent.setText(commonBaseComponent.getText());
        if (commonBaseComponent.getColor() != null && !commonBaseComponent.getColor().isEmpty()) {
            msgComponent.setColor(ChatColor.of((String)commonBaseComponent.getColor().toUpperCase()));
        } else {
            msgComponent.setColor(ChatColor.WHITE);
        }
        msgComponent.setBold(Boolean.valueOf(commonBaseComponent.isBold()));
        msgComponent.setItalic(Boolean.valueOf(commonBaseComponent.isItalic()));
        msgComponent.setUnderlined(Boolean.valueOf(commonBaseComponent.isUnderlined()));
        msgComponent.setStrikethrough(Boolean.valueOf(commonBaseComponent.isStrikethrough()));
        msgComponent.setObfuscated(Boolean.valueOf(commonBaseComponent.isObfuscated()));
        if (commonBaseComponent instanceof CommonTextComponent) {
            CommonTextComponent commonTextComponent = (CommonTextComponent)commonBaseComponent;
            if (commonTextComponent.getClickEvent() != null) {
                ClickEvent clickEvent = this.getClickEvent(commonTextComponent);
                msgComponent.setClickEvent(clickEvent);
            }
            if (commonTextComponent.getHoverEvent() != null) {
                HoverEvent hoverEvent = this.getHoverEvent(commonTextComponent);
                msgComponent.setHoverEvent(hoverEvent);
            }
        }
        return msgComponent;
    }

    private HoverEvent getHoverEvent(CommonTextComponent myTextComponent) {
        HoverEvent.Action action = HoverEvent.Action.valueOf((String)myTextComponent.getHoverEvent().getAction().toUpperCase());
        HoverEvent hoverEvent = null;
        switch (action) {
            case SHOW_TEXT: {
                TextComponent textComponent = this.parseCommonBaseComponentListToComponent(myTextComponent.getHoverEvent().getText());
                BaseComponent[] baseComponent = new BaseComponent[]{textComponent};
                hoverEvent = new HoverEvent(action, new Content[]{new Text(baseComponent)});
                break;
            }
            case SHOW_ITEM: {
                CommonHoverItem myHoverItem = myTextComponent.getHoverEvent().getItem();
                ItemTag itemTag = ItemTag.ofNbt((String)myHoverItem.getTag());
                Item item = new Item(String.valueOf(myHoverItem.getId()), myHoverItem.getCount().intValue(), itemTag);
                hoverEvent = new HoverEvent(action, new Content[]{item});
                break;
            }
            case SHOW_ENTITY: {
                CommonHoverEntity myHoverEntity = myTextComponent.getHoverEvent().getEntity();
                TextComponent nameComponent = this.parseCommonBaseComponentListToComponent(myHoverEntity.getName());
                Entity entity = new Entity(myHoverEntity.getType(), myHoverEntity.getId(), (BaseComponent)nameComponent);
                hoverEvent = new HoverEvent(action, new Content[]{entity});
                break;
            }
        }
        return hoverEvent;
    }

    private ClickEvent getClickEvent(CommonTextComponent myTextComponent) {
        ClickEvent.Action action = ClickEvent.Action.valueOf((String)myTextComponent.getClickEvent().getAction().toUpperCase());
        return new ClickEvent(action, myTextComponent.getClickEvent().getValue());
    }

    public TextComponent parseMessageListToComponent(List<MessageSegment> commonTextComponentList) {
        TextComponent component = new TextComponent();
        StringBuilder msgLogText = new StringBuilder();
        for (MessageSegment messageSegment : commonTextComponentList) {
            TextComponent msgComponent = this.parsePerMessageToComponent(messageSegment.getData());
            component.addExtra((BaseComponent)msgComponent);
            msgLogText.append(messageSegment.getData().getText());
        }
        Tool.logger.info(msgLogText.toString());
        return component;
    }

    public TextComponent parseCommonBaseComponentListToComponent(List<CommonBaseComponent> list) {
        TextComponent component = new TextComponent();
        for (CommonBaseComponent commonBaseComponent : list) {
            TextComponent msgComponent = this.parsePerMessageToComponent(commonBaseComponent);
            component.addExtra((BaseComponent)msgComponent);
        }
        return component;
    }
}

