/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.tool.rcon;

import java.io.IOException;
import org.glavo.rcon.AuthenticationException;
import org.glavo.rcon.Rcon;
import org.slf4j.Logger;

public class RconClient {
    private final Logger logger;
    public volatile Rcon client;
    private int port;
    private String password;

    public RconClient(Logger logger, int port, String password) {
        this.logger = logger;
        this.port = port;
        this.password = password;
    }

    public void connect() {
        if (this.isConnected()) {
            this.logger.warn("Rcon \u5df2\u8fde\u63a5\uff0c\u65e0\u9700\u91cd\u590d\u8fde\u63a5");
        }
        try {
            this.client = new Rcon("localhost", this.port, this.password);
            this.logger.info("Rcon \u8fde\u63a5\u6210\u529f\uff01[port: {}]", (Object)this.port);
        }
        catch (AuthenticationException e) {
            this.logger.error("Rcon \u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u9879\u662f\u5426\u6b63\u786e");
        }
        catch (IOException e) {
            this.logger.warn("Rcon \u8fde\u63a5\u5931\u8d25\uff1a", e);
        }
    }

    public String sendCommand(String command) throws IOException {
        if (!this.isConnected()) {
            throw new IllegalArgumentException("Rcon \u672a\u8fde\u63a5");
        }
        return this.client.command(command);
    }

    public void stop() {
        if (!this.isConnected()) {
            this.logger.info("Rcon \u672a\u8fde\u63a5\uff0c\u65e0\u9700\u5173\u95ed");
            return;
        }
        try {
            this.logger.info("\u6b63\u5728\u5173\u95ed Rcon \u5ba2\u6237\u7aef...");
            this.client.close();
            this.logger.info("Rcon \u5ba2\u6237\u7aef\u5df2\u5173\u95ed");
        }
        catch (IOException e) {
            this.logger.warn("Rcon \u5173\u95ed\u5931\u8d25", e);
        }
        catch (Exception e) {
            this.logger.warn("Rcon close() \u53d1\u751f\u672a\u77e5\u5f02\u5e38", e);
        }
        this.client = null;
        this.logger.info("Rcon \u5df2\u5173\u95ed");
    }

    public boolean isConnected() {
        return this.client != null;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

