/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao;

import com.github.theword.queqiao.event.neoforge.NeoForgeAdvancementEvent;
import com.github.theword.queqiao.event.neoforge.NeoForgeCommandEvent;
import com.github.theword.queqiao.event.neoforge.NeoForgePlayerDeathEvent;
import com.github.theword.queqiao.event.neoforge.NeoForgePlayerLoggedInEvent;
import com.github.theword.queqiao.event.neoforge.NeoForgePlayerLoggedOutEvent;
import com.github.theword.queqiao.event.neoforge.NeoForgeServerChatEvent;
import com.github.theword.queqiao.event.neoforge.NeoForgeServerPlayer;
import com.github.theword.queqiao.event.neoforge.dto.advancement.NeoForgeAdvancement;
import com.github.theword.queqiao.tool.event.base.BaseEvent;
import com.github.theword.queqiao.tool.utils.Tool;
import com.github.theword.queqiao.utils.NeoForgeTool;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.advancements.Advancement;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.CommandEvent;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.AdvancementEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class EventProcessor {
    @SubscribeEvent
    public void onServerChat(ServerChatEvent event) {
        if (event.isCanceled() || !Tool.config.getSubscribeEvent().isPlayerChat()) {
            return;
        }
        NeoForgeServerPlayer player = NeoForgeTool.getNeoForgePlayer(event.getPlayer());
        String message = event.getMessage().getString();
        NeoForgeServerChatEvent NeoForgeServerChatEvent2 = new NeoForgeServerChatEvent("", player, message);
        Tool.sendWebsocketMessage((BaseEvent)NeoForgeServerChatEvent2);
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!Tool.config.getSubscribeEvent().isPlayerJoin()) {
            return;
        }
        NeoForgeServerPlayer player = NeoForgeTool.getNeoForgePlayer((ServerPlayer)event.getEntity());
        NeoForgePlayerLoggedInEvent forgePlayerLoggedInEvent = new NeoForgePlayerLoggedInEvent(player);
        Tool.sendWebsocketMessage((BaseEvent)forgePlayerLoggedInEvent);
    }

    @SubscribeEvent
    public void onPlayerQuit(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!Tool.config.getSubscribeEvent().isPlayerQuit()) {
            return;
        }
        NeoForgeServerPlayer player = NeoForgeTool.getNeoForgePlayer((ServerPlayer)event.getEntity());
        NeoForgePlayerLoggedOutEvent forgePlayerLoggedOutEvent = new NeoForgePlayerLoggedOutEvent(player);
        Tool.sendWebsocketMessage((BaseEvent)forgePlayerLoggedOutEvent);
    }

    @SubscribeEvent
    public void onPlayerCommand(CommandEvent event) {
        NeoForgeServerPlayer player;
        if (event.isCanceled() || !Tool.config.getSubscribeEvent().isPlayerCommand()) {
            return;
        }
        if (!((CommandSourceStack)event.getParseResults().getContext().getSource()).isPlayer()) {
            return;
        }
        String command = Tool.isRegisterOrLoginCommand((String)event.getParseResults().getReader().getString());
        if (command.isEmpty()) {
            return;
        }
        try {
            player = NeoForgeTool.getNeoForgePlayer(((CommandSourceStack)event.getParseResults().getContext().getSource()).getPlayerOrException());
        }
        catch (CommandSyntaxException e) {
            return;
        }
        NeoForgeCommandEvent forgeCommandEvent = new NeoForgeCommandEvent("", player, command);
        Tool.sendWebsocketMessage((BaseEvent)forgeCommandEvent);
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.isCanceled() || !Tool.config.getSubscribeEvent().isPlayerDeath()) {
            return;
        }
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        NeoForgeServerPlayer player = NeoForgeTool.getNeoForgePlayer((ServerPlayer)event.getEntity());
        LivingEntity entity = event.getEntity();
        String message = event.getSource().getLocalizedDeathMessage(entity).getString();
        NeoForgePlayerDeathEvent forgeCommandEvent = new NeoForgePlayerDeathEvent("", player, message);
        Tool.sendWebsocketMessage((BaseEvent)forgeCommandEvent);
    }

    @SubscribeEvent
    public void onPlayerAdvancement(AdvancementEvent.AdvancementEarnEvent event) {
        if (!Tool.config.getSubscribeEvent().isPlayerAdvancement()) {
            return;
        }
        Advancement advancement = event.getAdvancement().value();
        NeoForgeAdvancement neoForgeAdvancement = NeoForgeTool.getNeoForgeAdvancement(advancement);
        NeoForgeAdvancementEvent forgeAdvancementEvent = new NeoForgeAdvancementEvent(NeoForgeTool.getNeoForgePlayer((ServerPlayer)event.getEntity()), neoForgeAdvancement);
        Tool.sendWebsocketMessage((BaseEvent)forgeAdvancementEvent);
    }
}

