/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao.utils;

import com.github.theword.queqiao.tool.handle.ParseJsonToEventService;
import com.github.theword.queqiao.tool.payload.MessageSegment;
import com.github.theword.queqiao.tool.payload.modle.component.CommonBaseComponent;
import com.github.theword.queqiao.tool.payload.modle.component.CommonTextComponent;
import com.github.theword.queqiao.tool.payload.modle.hover.CommonHoverEntity;
import com.github.theword.queqiao.tool.payload.modle.hover.CommonHoverItem;
import com.github.theword.queqiao.tool.utils.Tool;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ParseJsonToEventImpl
implements ParseJsonToEventService {
    public MutableComponent parseMessageListToComponent(List<MessageSegment> myBaseComponentList) {
        MutableComponent mutableComponent = MutableComponent.create((ComponentContents)new PlainTextContents.LiteralContents(""));
        StringBuilder msgLogText = new StringBuilder();
        for (MessageSegment messageSegment : myBaseComponentList) {
            MutableComponent tempMutableComponent = this.parsePerMessageToComponent((CommonBaseComponent)messageSegment.getData());
            mutableComponent.append((Component)tempMutableComponent);
            msgLogText.append(messageSegment.getData().getText());
        }
        Tool.logger.info(msgLogText.toString());
        return mutableComponent;
    }

    public MutableComponent parseCommonBaseComponentListToComponent(List<CommonBaseComponent> myBaseComponentList) {
        MutableComponent mutableComponent = MutableComponent.create((ComponentContents)new PlainTextContents.LiteralContents(""));
        for (CommonBaseComponent commonBaseComponent : myBaseComponentList) {
            MutableComponent tempMutableComponent = this.parsePerMessageToComponent(commonBaseComponent);
            mutableComponent.append((Component)tempMutableComponent);
        }
        return mutableComponent;
    }

    public MutableComponent parsePerMessageToComponent(CommonBaseComponent myBaseComponent) {
        PlainTextContents.LiteralContents tempMutableComponent = new PlainTextContents.LiteralContents(myBaseComponent.getText());
        Style style = this.getStyleFromBaseComponent(myBaseComponent);
        if (myBaseComponent instanceof CommonTextComponent) {
            CommonTextComponent commonTextComponent = (CommonTextComponent)myBaseComponent;
            if (commonTextComponent.getClickEvent() != null) {
                style = style.withClickEvent(this.getClickEventFromBaseComponent(commonTextComponent));
            }
            if (commonTextComponent.getHoverEvent() != null) {
                style = style.withHoverEvent(this.getHoverEventFromBaseComponent(commonTextComponent));
            }
        }
        MutableComponent mutableComponent = MutableComponent.create((ComponentContents)tempMutableComponent);
        mutableComponent.setStyle(style);
        return mutableComponent;
    }

    private Style getStyleFromBaseComponent(CommonBaseComponent myBaseComponent) {
        ResourceLocation font = null;
        if (myBaseComponent.getFont() != null) {
            font = ResourceLocation.parse((String)myBaseComponent.getFont());
        }
        Style style = Style.EMPTY.withBold(Boolean.valueOf(myBaseComponent.isBold())).withItalic(Boolean.valueOf(myBaseComponent.isItalic())).withInsertion(myBaseComponent.getInsertion()).withFont(font).withUnderlined(Boolean.valueOf(myBaseComponent.isUnderlined())).withStrikethrough(Boolean.valueOf(myBaseComponent.isStrikethrough())).withObfuscated(Boolean.valueOf(myBaseComponent.isObfuscated()));
        style = myBaseComponent.getColor() != null && !myBaseComponent.getColor().isEmpty() ? style.withColor((TextColor)TextColor.parseColor((String)myBaseComponent.getColor()).getOrThrow()) : style.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.WHITE));
        return style;
    }

    private ClickEvent getClickEventFromBaseComponent(CommonTextComponent myTextComponent) {
        if (myTextComponent.getClickEvent() != null) {
            ClickEvent.Action tempAction = ClickEvent.Action.valueOf((String)myTextComponent.getClickEvent().getAction().toUpperCase());
            return new ClickEvent(tempAction, myTextComponent.getClickEvent().getValue());
        }
        return null;
    }

    public HoverEvent getHoverEventFromBaseComponent(CommonTextComponent myTextComponent) {
        HoverEvent hoverEvent = null;
        HoverEvent.Action action = switch (myTextComponent.getHoverEvent().getAction().toLowerCase()) {
            case "show_text" -> HoverEvent.Action.SHOW_TEXT;
            case "show_item" -> HoverEvent.Action.SHOW_ITEM;
            case "show_entity" -> HoverEvent.Action.SHOW_ENTITY;
            default -> null;
        };
        assert (action != null);
        if (action.equals(HoverEvent.Action.SHOW_TEXT)) {
            if (myTextComponent.getHoverEvent().getText() != null && !myTextComponent.getHoverEvent().getText().isEmpty()) {
                MutableComponent textComponent = this.parseCommonBaseComponentListToComponent((List<CommonBaseComponent>)myTextComponent.getHoverEvent().getText());
                hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)textComponent);
            }
        } else if (action.equals(HoverEvent.Action.SHOW_ITEM)) {
            CommonHoverItem commonHoverItem = myTextComponent.getHoverEvent().getItem();
            Item item = Item.byId((int)Integer.parseInt(commonHoverItem.getId()));
            ItemStack itemStack = new ItemStack((ItemLike)item, commonHoverItem.getCount().intValue());
            HoverEvent.ItemStackInfo itemHover = new HoverEvent.ItemStackInfo(itemStack);
            hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)itemHover);
        } else {
            CommonHoverEntity commonHoverEntity = myTextComponent.getHoverEvent().getEntity();
            Optional entityType = EntityType.byString((String)commonHoverEntity.getType());
            if (entityType.isPresent()) {
                HoverEvent.EntityTooltipInfo entityTooltipInfo = new HoverEvent.EntityTooltipInfo((EntityType)entityType.get(), UUID.randomUUID(), (Component)this.parseCommonBaseComponentListToComponent((List<CommonBaseComponent>)commonHoverEntity.getName()));
                hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_ENTITY, (Object)entityTooltipInfo);
            }
        }
        return hoverEvent;
    }
}

