/*
 * Decompiled with CFR 0.152.
 */
package com.github.theword.queqiao;

import com.github.theword.queqiao.tool.GlobalContext;
import com.github.theword.queqiao.tool.event.PlayerAchievementEvent;
import com.github.theword.queqiao.tool.event.PlayerChatEvent;
import com.github.theword.queqiao.tool.event.PlayerCommandEvent;
import com.github.theword.queqiao.tool.event.PlayerDeathEvent;
import com.github.theword.queqiao.tool.event.PlayerJoinEvent;
import com.github.theword.queqiao.tool.event.PlayerQuitEvent;
import com.github.theword.queqiao.tool.event.model.achievement.AchievementModel;
import com.github.theword.queqiao.tool.event.model.death.DeathModel;
import com.github.theword.queqiao.tool.utils.Tool;
import com.github.theword.queqiao.utils.PaperTool;
import io.papermc.paper.event.player.AsyncChatEvent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import org.bukkit.advancement.Advancement;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

public class EventProcessor
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    void onPlayerChat(AsyncChatEvent event) {
        if (event.isCancelled() || !GlobalContext.getConfig().getSubscribeEvent().isPlayerChat()) {
            return;
        }
        PlayerChatEvent spigotAsyncPlayerChatEvent = new PlayerChatEvent(PaperTool.getPaperPlayer(event.getPlayer()), "", PaperTool.getComponentJson(event.originalMessage()), PaperTool.getComponentText(event.message()));
        GlobalContext.sendEvent(spigotAsyncPlayerChatEvent);
    }

    @EventHandler
    void onPlayerDeath(org.bukkit.event.entity.PlayerDeathEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerDeath()) {
            return;
        }
        DeathModel deathModel = new DeathModel();
        Component component = event.deathMessage();
        if (component instanceof TranslatableComponent) {
            TranslatableComponent translatableComponent = (TranslatableComponent)component;
            deathModel.setKey(translatableComponent.key());
            String[] args = (String[])translatableComponent.args().stream().map(arg -> {
                if (arg instanceof TextComponent) {
                    return ((TextComponent)arg).content();
                }
                return String.valueOf(arg);
            }).toArray(String[]::new);
            deathModel.setArgs(args);
        }
        deathModel.setText(PaperTool.getComponentText(component));
        PlayerDeathEvent spigotPlayerDeathEvent = new PlayerDeathEvent(PaperTool.getPaperPlayer(event.getEntity()), deathModel);
        GlobalContext.sendEvent(spigotPlayerDeathEvent);
    }

    @EventHandler
    void onPlayerJoin(org.bukkit.event.player.PlayerJoinEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerJoin()) {
            return;
        }
        PlayerJoinEvent spigotPlayerJoinEvent = new PlayerJoinEvent(PaperTool.getPaperPlayer(event.getPlayer()));
        GlobalContext.sendEvent(spigotPlayerJoinEvent);
    }

    @EventHandler
    void onPlayerQuit(org.bukkit.event.player.PlayerQuitEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerQuit()) {
            return;
        }
        PlayerQuitEvent spigotPlayerQuitEvent = new PlayerQuitEvent(PaperTool.getPaperPlayer(event.getPlayer()));
        GlobalContext.sendEvent(spigotPlayerQuitEvent);
    }

    @EventHandler
    void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerCommand()) {
            return;
        }
        String command = Tool.isRegisterOrLoginCommand(event.getMessage());
        if (command.isEmpty()) {
            return;
        }
        PlayerCommandEvent spigotPlayerCommandPreprocessEvent = new PlayerCommandEvent(PaperTool.getPaperPlayer(event.getPlayer()), "", command, command);
        GlobalContext.sendEvent(spigotPlayerCommandPreprocessEvent);
    }

    @EventHandler
    void onPlayerAdvancement(PlayerAdvancementDoneEvent event) {
        if (!GlobalContext.getConfig().getSubscribeEvent().isPlayerAdvancement()) {
            return;
        }
        Advancement advancement = event.getAdvancement();
        if (advancement.getDisplay() == null || !advancement.getDisplay().doesAnnounceToChat() || event.message() == null) {
            return;
        }
        AchievementModel achievementModel = PaperTool.getPaperAdvancement(advancement);
        achievementModel.setText(PaperTool.getComponentText(event.message()));
        PlayerAchievementEvent spigotPlayerAdvancementDoneEvent = new PlayerAchievementEvent(PaperTool.getPaperPlayer(event.getPlayer()), achievementModel);
        GlobalContext.sendEvent(spigotPlayerAdvancementDoneEvent);
    }
}

